/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFileDomainObject$callable$createFromTreasuryDocumentTemplateFile;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFileDomainObject$callable$delete;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFileDomainObject$callable$edit;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFileDomainObject_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryDocumentTemplateFileDomainObject
extends TreasuryDocumentTemplateFileDomainObject_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "application/vnd.oasis.opendocument.text";
    public static final String FILE_EXTENSION = ".odt";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createFromTreasuryDocumentTemplateFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected TreasuryDocumentTemplateFileDomainObject() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    private void checkRules() {
        if (this.getTreasuryDocumentTemplate() == null) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplateFileDomainObject.documentTemplate.required", new String[0]);
        }
    }

    public void edit(TreasuryDocumentTemplate treasuryDocumentTemplate, boolean bl) {
        Object object = advice$edit.perform((Callable)new TreasuryDocumentTemplateFileDomainObject$callable$edit(this, treasuryDocumentTemplate, bl));
    }

    static /* synthetic */ void advised$edit(TreasuryDocumentTemplateFileDomainObject this_, TreasuryDocumentTemplate documentTemplate, boolean active) {
        this_.setTreasuryDocumentTemplate(documentTemplate);
        this_.setActive(active);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryDocumentTemplateFileDomainObject$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryDocumentTemplateFileDomainObject this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplateFileDomainObject.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTreasuryDocumentTemplate(null);
        super.deleteDomainObject();
    }

    public static TreasuryDocumentTemplateFileDomainObject createFromTreasuryDocumentTemplateFile(TreasuryDocumentTemplateFile treasuryDocumentTemplateFile) {
        return (TreasuryDocumentTemplateFileDomainObject)advice$createFromTreasuryDocumentTemplateFile.perform((Callable)new TreasuryDocumentTemplateFileDomainObject$callable$createFromTreasuryDocumentTemplateFile(treasuryDocumentTemplateFile));
    }

    static /* synthetic */ TreasuryDocumentTemplateFileDomainObject advised$createFromTreasuryDocumentTemplateFile(TreasuryDocumentTemplateFile file) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        TreasuryDocumentTemplateFileDomainObject result = new TreasuryDocumentTemplateFileDomainObject();
        result.setActive(file.getActive());
        result.setTreasuryDocumentTemplate(file.getTreasuryDocumentTemplate());
        result.setCreationDate(file.getCreationDate());
        result.setCreator(services.versioningCreatorUsername(file));
        result.setTreasuryFile((TreasuryFile)((Object)file));
        result.setFileId(file.getExternalId());
        result.checkRules();
        return result;
    }

    public static Stream<TreasuryDocumentTemplateFileDomainObject> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryDocumentTemplateFileDomainObjectsSet().stream();
    }

    public static Stream<TreasuryDocumentTemplateFile> findByDocumentTemplate(TreasuryDocumentTemplate documentTemplate) {
        return documentTemplate.getTreasuryDocumentTemplateFilesSet().stream();
    }

    public static Optional<TreasuryDocumentTemplateFileDomainObject> findUniqueByTreasuryDocumentTemplateFile(TreasuryDocumentTemplateFile file) {
        return TreasuryDocumentTemplateFileDomainObject.findAll().filter(o -> o.getTreasuryFile() == file).findFirst();
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username, this.getTreasuryDocumentTemplate().getFinantialEntity());
    }
}

