/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile$callable$create;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile$callable$delete;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile$callable$edit;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFileDomainObject;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryDocumentTemplateFile
extends TreasuryDocumentTemplateFile_Base {
    public static final String CONTENT_TYPE = "application/vnd.oasis.opendocument.text";
    public static final String FILE_EXTENSION = ".odt";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected TreasuryDocumentTemplateFile() {
        this.setBennu(Bennu.getInstance());
    }

    protected TreasuryDocumentTemplateFile(TreasuryDocumentTemplate documentTemplate, boolean active, String displayName, String fileName, byte[] content) {
        this();
        this.init(displayName, fileName, content);
        this.setTreasuryDocumentTemplate(documentTemplate);
        this.setActive(active);
        documentTemplate.activateFile(this);
        this.checkRules();
        TreasuryDocumentTemplateFileDomainObject.createFromTreasuryDocumentTemplateFile(this);
    }

    private void checkRules() {
        if (this.getTreasuryDocumentTemplate() == null) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplateFile.documentTemplate.required", new String[0]);
        }
    }

    public void edit(TreasuryDocumentTemplate treasuryDocumentTemplate, boolean bl) {
        Object object = advice$edit.perform((Callable)new TreasuryDocumentTemplateFile$callable$edit(this, treasuryDocumentTemplate, bl));
    }

    static /* synthetic */ void advised$edit(TreasuryDocumentTemplateFile this_, TreasuryDocumentTemplate documentTemplate, boolean active) {
        this_.setTreasuryDocumentTemplate(documentTemplate);
        this_.setActive(active);
        this_.checkRules();
        TreasuryDocumentTemplateFileDomainObject.findAll().filter(o -> this == o.getTreasuryFile()).findFirst().get().edit(documentTemplate, active);
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryDocumentTemplateFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryDocumentTemplateFile this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.TreasuryDocumentTemplateFile.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        this_.setTreasuryDocumentTemplate(null);
        super.delete();
        TreasuryDocumentTemplateFileDomainObject.findAll().filter(o -> this == o.getTreasuryFile()).findFirst().get().delete();
    }

    static TreasuryDocumentTemplateFile create(TreasuryDocumentTemplate treasuryDocumentTemplate, String string, String string2, byte[] byArray) {
        return (TreasuryDocumentTemplateFile)((Object)advice$create.perform((Callable)new TreasuryDocumentTemplateFile$callable$create(treasuryDocumentTemplate, string, string2, byArray)));
    }

    static /* synthetic */ TreasuryDocumentTemplateFile advised$create(TreasuryDocumentTemplate documentTemplate, String displayName, String fileName, byte[] content) {
        TreasuryDocumentTemplateFile documentTemplateFile = new TreasuryDocumentTemplateFile(documentTemplate, false, displayName, fileName, content);
        return documentTemplateFile;
    }

    public static Stream<TreasuryDocumentTemplateFile> findAll() {
        return Bennu.getInstance().getTreasuryDocumentTemplateFilesSet().stream();
    }

    public static Stream<TreasuryDocumentTemplateFile> findByDocumentTemplate(TreasuryDocumentTemplate documentTemplate) {
        return documentTemplate.getTreasuryDocumentTemplateFilesSet().stream();
    }

    public boolean isAccessible(User user) {
        return user != null;
    }
}

