/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;

public interface IFiscalContributor {
    public String getFiscalNumber();

    public static IFiscalContributor findByFiscalNumber(String fiscalNumber) {
        IFiscalContributor result = null;
        for (IFiscalContributor it : IFiscalContributor.findAll()) {
            if (!it.getFiscalNumber().equalsIgnoreCase(fiscalNumber)) continue;
            if (result != null && !fiscalNumber.equals("999999990")) {
                throw new TreasuryDomainException("error.IFiscalContributor.duplicate.fiscal.number", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static Set<IFiscalContributor> findAll() {
        HashSet iterable = Sets.newHashSet((Iterable)FinantialInstitution.findAll().collect(Collectors.toList()));
        Customer.findAll().forEach(x -> iterable.add(x));
        return iterable;
    }
}

