/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.managetreasuryexemption;

import java.math.BigDecimal;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.dto.TreasuryExemptionBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.util.Constants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/managetreasuryexemption/treasuryexemption"})
public class TreasuryExemptionController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/managetreasuryexemption/treasuryexemption";
    private static final String JSP_PATH = "treasury/managetreasuryexemption/treasuryexemption";
    private static final String _CREATE_URI = "/create/";
    public static final String CREATE_URL = "/treasury/managetreasuryexemption/treasuryexemption/create/";
    private static final String _CREATEPOSTBACK_URI = "/createPostBack/";
    public static final String CREATEPOSTBACK_URL = "/treasury/managetreasuryexemption/treasuryexemption/createPostBack/";

    private TreasuryExemptionBean getTreasuryExemptionBean(Model model) {
        return (TreasuryExemptionBean)model.asMap().get("treasuryExemptionBean");
    }

    private void setTreasuryExemptionBean(TreasuryExemptionBean bean, Model model) {
        model.addAttribute("treasuryExemptionBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("treasuryExemptionBean", (Object)bean);
    }

    private TreasuryExemption getTreasuryExemption(Model m) {
        return (TreasuryExemption)((Object)m.asMap().get("treasuryExemption"));
    }

    private void setTreasuryExemption(TreasuryExemption treasuryExemption, Model m) {
        m.addAttribute("treasuryExemption", (Object)treasuryExemption);
    }

    private TreasuryEvent getTreasuryEvent(Model m) {
        return (TreasuryEvent)((Object)m.asMap().get("treasuryEvent"));
    }

    private void setTreasuryEvent(TreasuryEvent treasuryEvent, Model m) {
        m.addAttribute("treasuryEvent", (Object)treasuryEvent);
    }

    private String treasuryEventUrl(DebtAccount debtAccount, TreasuryEvent treasuryEvent) {
        return String.format("%s/%s/%s", "/treasury/accounting/managecustomer/treasuryevent/read/", debtAccount.getExternalId(), treasuryEvent.getExternalId());
    }

    @RequestMapping(value={"/create/{debtAccountId}/{treasuryEventId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="treasuryEventId") TreasuryEvent treasuryEvent, Model model) {
        this.setTreasuryEvent(treasuryEvent, model);
        this.setTreasuryExemptionBean(new TreasuryExemptionBean(treasuryEvent), model);
        model.addAttribute("debtAccount", (Object)debtAccount);
        return this.jspPage("create");
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=true) TreasuryExemptionBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setTreasuryExemptionBean(bean, model);
        try {
            this.assertUserIsFrontOfficeMember(model);
            TreasuryExemption.create(bean.getTreasuryExemptionType(), bean.getTreasuryEvent(), bean.getReason(), bean.getValuetoexempt(), bean.getDebitEntry());
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.create", (String[])new String[0]), model);
            return this.redirect(this.treasuryEventUrl(debtAccount, bean.getTreasuryEvent()), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(debtAccount, bean.getTreasuryEvent(), model);
    }

    @RequestMapping(value={"/createPostBack/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=true) TreasuryExemptionBean bean, Model model) {
        if (bean.getDebitEntry() != null && bean.getTreasuryExemptionType() != null) {
            BigDecimal amount = bean.getDebitEntry().getAmountWithVat().multiply(bean.getTreasuryExemptionType().getDefaultExemptionPercentage().divide(BigDecimal.valueOf(100L)));
            amount = bean.getDebitEntry().getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(amount);
            bean.setValuetoexempt(amount);
            bean.setCurrencySymbol(bean.getDebitEntry().getDebtAccount().getFinantialInstitution().getCurrency().getSymbol());
        }
        this.setTreasuryExemptionBean(bean, model);
        return this.getBeanJson(bean);
    }

    private String jspPage(String page) {
        return "treasury/managetreasuryexemption/treasuryexemption/" + page;
    }
}

