/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.forwardpayments;

import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentConfigurationBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=FinantialInstitutionController.class)
@RequestMapping(value={"/treasury/administration/manageforwardpaymentconfiguration"})
public class ManageForwardPaymentConfigurationController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/manageforwardpaymentconfiguration";
    private static final String JSP_PATH = "/treasury/administration/manageforwardpaymentconfiguration";
    private static final String VIEW_URI = "/view";
    public static final String VIEW_URL = "/treasury/administration/manageforwardpaymentconfiguration/view";
    private static final String EDIT_URI = "/edit";
    public static final String EDIT_URL = "/treasury/administration/manageforwardpaymentconfiguration/edit";
    private static final String UPLOAD_VIRTUAL_TPA_CERTIFICATE_URI = "/uploadvirtualtpacertificate";
    public static final String UPLOAD_VIRTUAL_TPA_CERTIFICATE_URL = "/treasury/administration/manageforwardpaymentconfiguration/uploadvirtualtpacertificate";
    private static final String DOWNLOAD_VIRTUAL_TPA_CERTIFICATE_URI = "/downloadvirtualtpacertificate";
    public static final String DOWNLOAD_VIRTUAL_TPA_CERTIFICATE_URL = "/treasury/administration/manageforwardpaymentconfiguration/downloadvirtualtpacertificate";

    @RequestMapping(value={"/view/{finantialInstitutionId}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="finantialInstitutionId") FinantialInstitution finantialInstitution, Model model) {
        model.addAttribute("finantialInstitution", (Object)finantialInstitution);
        if (finantialInstitution.getForwardPaymentConfigurationsSet().size() > 0) {
            model.addAttribute("forwardPaymentConfiguration", finantialInstitution.getForwardPaymentConfigurationsSet().iterator().next());
        }
        return this.jspPage(VIEW_URI);
    }

    @RequestMapping(value={"/edit/{finantialInstitutionId}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="finantialInstitutionId") FinantialInstitution finantialInstitution, Model model) {
        return this._edit(finantialInstitution, model, new ForwardPaymentConfigurationBean(finantialInstitution));
    }

    private String _edit(FinantialInstitution finantialInstitution, Model model, ForwardPaymentConfigurationBean bean) {
        model.addAttribute("finantialInstitution", (Object)finantialInstitution);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("series_options", Series.findAll());
        model.addAttribute("paymentMethod_options", PaymentMethod.findAll().collect(Collectors.toSet()));
        return this.jspPage(EDIT_URI);
    }

    @RequestMapping(value={"/edit/{finantialInstitutionId}"}, method={RequestMethod.POST})
    public String editpost(@PathVariable(value="finantialInstitutionId") FinantialInstitution finantialInstitution, ForwardPaymentConfigurationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.editOrCreateForwardPaymentConfiguration(finantialInstitution, bean);
            return String.format("redirect:%s/%s", VIEW_URL, finantialInstitution.getExternalId());
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.jspPage(EDIT_URI);
        }
    }

    private void editOrCreateForwardPaymentConfiguration(FinantialInstitution finantialInstitution, ForwardPaymentConfigurationBean bean) {
        if (!finantialInstitution.getForwardPaymentConfigurationsSet().isEmpty()) {
            ((ForwardPaymentConfiguration)((Object)finantialInstitution.getForwardPaymentConfigurationsSet().iterator().next())).edit(bean);
            return;
        }
        ForwardPaymentConfiguration.create(finantialInstitution, bean);
    }

    @RequestMapping(value={"/uploadvirtualtpacertificate/{finantialInstitutionId}"}, method={RequestMethod.POST})
    public String uploadvirtualtpacertificatepost(@PathVariable(value="finantialInstitutionId") FinantialInstitution finantialInstitution, @RequestParam(value="certificateFile", required=true) MultipartFile certificateFile, Model model, RedirectAttributes redirectAttributes) {
        try {
            ForwardPaymentConfiguration forwardPaymentConfiguration = (ForwardPaymentConfiguration)((Object)finantialInstitution.getForwardPaymentConfigurationsSet().iterator().next());
            forwardPaymentConfiguration.saveVirtualTPACertificate(certificateFile.getOriginalFilename(), certificateFile.getBytes());
            return String.format("redirect:%s/%s", VIEW_URL, finantialInstitution.getExternalId());
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.jspPage(VIEW_URI);
        }
    }

    @RequestMapping(value={"/downloadvirtualtpacertificate/{finantialInstitutionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Object downloadvirtualtpacertificate(FinantialInstitution finantialInstitution, Model model) {
        if (!finantialInstitution.getForwardPaymentConfigurationsSet().isEmpty()) {
            return ((ForwardPaymentConfiguration)((Object)finantialInstitution.getForwardPaymentConfigurationsSet().iterator().next())).getVirtualTPACertificate().getContent();
        }
        return null;
    }

    private String jspPage(String page) {
        return "/treasury/administration/manageforwardpaymentconfiguration" + page;
    }
}

