/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.manageproduct;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.VatExemptionReason;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.manageproduct.ProductController$callable$createProduct;
import org.fenixedu.treasury.ui.administration.base.manageproduct.ProductController$callable$deleteProduct;
import org.fenixedu.treasury.ui.administration.base.manageproduct.ProductController$callable$updateProduct;
import org.fenixedu.treasury.util.Constants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageProduct", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/manageproduct/product"})
public class ProductController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/manageproduct/product";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/manageproduct/product/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/manageproduct/product/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/manageproduct/product/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/manageproduct/product/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/manageproduct/product/delete/";
    public static final Advice advice$deleteProduct = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createProduct = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateProduct = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/manageproduct/product/";
    }

    private Product getProduct(Model m) {
        return (Product)((Object)m.asMap().get("product"));
    }

    private void setProduct(Product product, Model m) {
        m.addAttribute("product", (Object)product);
    }

    public void deleteProduct(Product product) {
        Object object = advice$deleteProduct.perform((Callable)new ProductController$callable$deleteProduct(this, product));
    }

    static /* synthetic */ void advised$deleteProduct(ProductController this_, Product product) {
        product.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="productgroup", required=false) ProductGroup productGroup, Model model) {
        List<Product> searchproductResultsDataSet = this.filterSearchProduct(productGroup);
        model.addAttribute("searchproductResultsDataSet", searchproductResultsDataSet);
        model.addAttribute("Product_productGroup_options", ProductGroup.readAll());
        return "treasury/administration/base/manageproduct/product/search";
    }

    private List<Product> getSearchUniverseSearchProductDataSet() {
        return Product.findAll().sorted((x, y) -> x.getName().getContent().compareTo(y.getName().getContent())).collect(Collectors.toList());
    }

    private List<Product> filterSearchProduct(ProductGroup productGroup) {
        return this.getSearchUniverseSearchProductDataSet().stream().filter(product -> productGroup == null || productGroup == product.getProductGroup()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") Product product, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + product.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") Product product, Model model) {
        this.setProduct(product, model);
        return "treasury/administration/base/manageproduct/product/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") Product product, Model model, RedirectAttributes redirectAttributes) {
        this.setProduct(product, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deleteProduct(product);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getProduct(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("productGroupList", ProductGroup.readAll());
        model.addAttribute("vattype_options", VatType.findAll().collect(Collectors.toList()));
        model.addAttribute("finantial_institutions_options", FinantialInstitution.findAll().collect(Collectors.toList()));
        model.addAttribute("vatExemptionReasonList", VatExemptionReason.findAll().sorted((x, y) -> x.getCode().compareTo(y.getCode())).collect(Collectors.toList()));
        return "treasury/administration/base/manageproduct/product/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="productGroup", required=false) ProductGroup productGroup, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="unitofmeasure", required=false) LocalizedString unitOfMeasure, @RequestParam(value="active", required=false) boolean active, @RequestParam(value="legacy", required=false) boolean legacy, @RequestParam(value="tuitionInstallmentOrder", required=false) int tuitionInstallmentOrder, @RequestParam(value="vatExemptionReason", required=false) VatExemptionReason vatExemptionReason, @RequestParam(value="vattype", required=false) VatType vatType, @RequestParam(value="finantialInstitution", required=false) List<FinantialInstitution> finantialInstitutions, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            Product product = this.createProduct(productGroup, code, name, unitOfMeasure, active, legacy, tuitionInstallmentOrder, vatType, finantialInstitutions, vatExemptionReason);
            model.addAttribute("product", (Object)product);
            return this.redirect(READ_URL + this.getProduct(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
        }
        catch (Exception tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public Product createProduct(ProductGroup productGroup, String string, LocalizedString localizedString, LocalizedString localizedString2, boolean bl, boolean bl2, int n, VatType vatType, List<FinantialInstitution> list, VatExemptionReason vatExemptionReason) {
        return (Product)((Object)advice$createProduct.perform((Callable)new ProductController$callable$createProduct(this, productGroup, string, localizedString, localizedString2, bl, bl2, n, vatType, list, vatExemptionReason)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ Product advised$createProduct(ProductController this_, ProductGroup productGroup, String code, LocalizedString name, LocalizedString unitOfMeasure, boolean active, boolean legacy, int tuitionInstallmentOrder, VatType vatType, List finantialInstitutions, VatExemptionReason vatExemptionReason) {
        Product product = Product.create(productGroup, code, name, unitOfMeasure, active, legacy, tuitionInstallmentOrder, vatType, finantialInstitutions, vatExemptionReason);
        return product;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") Product product, Model model) {
        this.setProduct(product, model);
        model.addAttribute("productGroupList", ProductGroup.readAll());
        model.addAttribute("finantial_institutions_options", FinantialInstitution.findAll().collect(Collectors.toList()));
        model.addAttribute("vattype_options", VatType.findAll().collect(Collectors.toList()));
        model.addAttribute("vatExemptionReasonList", VatExemptionReason.findAll().sorted((x, y) -> x.getCode().compareTo(y.getCode())).collect(Collectors.toList()));
        return "treasury/administration/base/manageproduct/product/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@RequestParam(value="productGroup", required=false) ProductGroup productGroup, @PathVariable(value="oid") Product product, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="unitofmeasure", required=false) LocalizedString unitOfMeasure, @RequestParam(value="vatExemptionReason", required=false) VatExemptionReason vatExemptionReason, @RequestParam(value="active", required=false) boolean active, @RequestParam(value="legacy", required=false) boolean legacy, @RequestParam(value="tuitionInstallmentOrder", required=false) int tuitionInstallmentOrder, @RequestParam(value="vatType", required=false) VatType vatType, @RequestParam(value="finantialInstitution", required=false) List<FinantialInstitution> finantialInstitutions, Model model, RedirectAttributes redirectAttributes) {
        this.setProduct(product, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updateProduct(productGroup, code, name, unitOfMeasure, active, legacy, tuitionInstallmentOrder, finantialInstitutions, vatType, vatExemptionReason, model);
            return this.redirect(READ_URL + this.getProduct(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(product, model);
    }

    @RequestMapping(value={"/deleteorphanproducts"}, method={RequestMethod.POST})
    public String processSearchToDeleteOrphanProducts(Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            int deletedCount = Product.deleteOrphanProducts();
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.info.administration.base.manageproduct.product.deleteorphanproducts", (String[])new String[0]) + deletedCount, model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.deleteorphanproducts", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
    }

    public void updateProduct(ProductGroup productGroup, String string, LocalizedString localizedString, LocalizedString localizedString2, boolean bl, boolean bl2, int n, List<FinantialInstitution> list, VatType vatType, VatExemptionReason vatExemptionReason, Model model) {
        Object object = advice$updateProduct.perform((Callable)new ProductController$callable$updateProduct(this, productGroup, string, localizedString, localizedString2, bl, bl2, n, list, vatType, vatExemptionReason, model));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$updateProduct(ProductController this_, ProductGroup productGroup, String code, LocalizedString name, LocalizedString unitOfMeasure, boolean active, boolean legacy, int tuitionInstallmentOrder, List finantialInstitutions, VatType vatType, VatExemptionReason vatExemptionReason, Model m) {
        this_.getProduct(m).edit(code, name, unitOfMeasure, active, legacy, tuitionInstallmentOrder, vatType, productGroup, finantialInstitutions, vatExemptionReason);
    }
}

