/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.AdhocCustomer;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.dto.AdhocCustomerBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.AdhocCustomerController$callable$deleteAdhocCustomer;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/accounting/managecustomer/adhoccustomer"})
public class AdhocCustomerController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/accounting/managecustomer/adhoccustomer";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/accounting/managecustomer/adhoccustomer/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/accounting/managecustomer/adhoccustomer/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/accounting/managecustomer/adhoccustomer/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/accounting/managecustomer/adhoccustomer/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/accounting/managecustomer/adhoccustomer/delete/";
    private static final String SEARCH_VIEW_URI = "/search/view/";
    public static final String SEARCH_VIEW_URL = "/treasury/accounting/managecustomer/adhoccustomer/search/view/";
    public static final Advice advice$deleteAdhocCustomer = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private Customer getAdhocCustomer(Model model) {
        return (Customer)model.asMap().get("adhocCustomer");
    }

    private void setAdhocCustomer(Customer adhocCustomer, Model model) {
        model.addAttribute("adhocCustomer", (Object)adhocCustomer);
    }

    public void deleteAdhocCustomer(Customer customer) {
        Object object = advice$deleteAdhocCustomer.perform((Callable)new AdhocCustomerController$callable$deleteAdhocCustomer(this, customer));
    }

    static /* synthetic */ void advised$deleteAdhocCustomer(AdhocCustomerController this_, Customer adhocCustomer) {
    }

    private Customer getAdhocCustomerBean(Model model) {
        return (Customer)model.asMap().get("adhocCustomerBean");
    }

    private void setAdhocCustomerBean(AdhocCustomerBean bean, Model model) {
        model.addAttribute("adhocCustomerBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("adhocCustomerBean", (Object)bean);
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        List<Customer> searchadhoccustomerResultsDataSet = this.filterSearchAdhocCustomer();
        model.addAttribute("searchadhoccustomerResultsDataSet", searchadhoccustomerResultsDataSet);
        return "treasury/accounting/managecustomer/adhoccustomer/search";
    }

    private List<Customer> getSearchUniverseSearchAdhocCustomerDataSet() {
        return Customer.findAll().collect(Collectors.toList());
    }

    private List<Customer> filterSearchAdhocCustomer() {
        return this.getSearchUniverseSearchAdhocCustomerDataSet().stream().collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") Customer adhocCustomer, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + adhocCustomer.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return this._create(new AdhocCustomerBean(), model);
    }

    private String _create(AdhocCustomerBean bean, Model model) {
        this.setAdhocCustomerBean(bean, model);
        return "treasury/accounting/managecustomer/adhoccustomer/create";
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpostback(@RequestParam(value="bean", required=false) AdhocCustomerBean bean, Model model) {
        this.setAdhocCustomerBean(bean, model);
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=false) AdhocCustomerBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            if (bean.getFinantialInstitutions() == null || bean.getFinantialInstitutions().isEmpty()) {
                throw new TreasuryDomainException("error.AdhocCustomer.specify.at.least.one.finantial.instituition", new String[0]);
            }
            Customer adhocCustomer = this.createAdhocCustomer(bean.getCustomerType(), bean.getName(), bean.getFiscalNumber(), bean.getIdentificationNumber(), bean.getAddress(), bean.getDistrictSubdivision(), bean.getZipCode(), bean.getAddressCountryCode(), bean.getCountryCode(), bean.getFinantialInstitutions());
            this.setAdhocCustomer(adhocCustomer, model);
            return this.redirect("/treasury/accounting/managecustomer/customer/read/" + this.getAdhocCustomer(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this._create(bean, model);
        }
    }

    public Customer createAdhocCustomer(CustomerType customerType, String name, String fiscalNumber, String identificationNumber, String address, String districtSubdivision, String zipCode, String addressCountryCode, String countryCode, List<FinantialInstitution> newFinantialInstitutions) {
        AdhocCustomer adhocCustomer = AdhocCustomer.create(customerType, fiscalNumber, name, address, districtSubdivision, zipCode, addressCountryCode, countryCode, identificationNumber, newFinantialInstitutions);
        return adhocCustomer;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") Customer adhocCustomer, Model model) {
        this.setAdhocCustomer(adhocCustomer, model);
        this.setAdhocCustomerBean(new AdhocCustomerBean(adhocCustomer), model);
        return "treasury/accounting/managecustomer/adhoccustomer/update";
    }

    @RequestMapping(value={"/updatepostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updatepostback(@PathVariable(value="oid") Customer adhocCustomer, @RequestParam(value="bean", required=false) AdhocCustomerBean bean, Model model) {
        this.setAdhocCustomerBean(bean, model);
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") Customer adhocCustomer, @RequestParam(value="bean", required=false) AdhocCustomerBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setAdhocCustomer(adhocCustomer, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updateAdhocCustomer(this.getAdhocCustomer(model), bean.getCustomerType(), bean.getName(), bean.getIdentificationNumber(), bean.getAddress(), bean.getDistrictSubdivision(), bean.getZipCode(), bean.getAddressCountryCode(), bean.getFinantialInstitutions(), model);
            return this.redirect("/treasury/accounting/managecustomer/customer/read/" + this.getAdhocCustomer(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.update(adhocCustomer, model);
    }

    public void updateAdhocCustomer(Customer customer, CustomerType customerType, String name, String identificationNumber, String address, String districtSubdivision, String zipCode, String addressCountryCode, List<FinantialInstitution> finantialInstitutions, Model model) {
        if (customer.isAdhocCustomer()) {
            ((AdhocCustomer)((Object)customer)).edit(customerType, name, address, districtSubdivision, zipCode, addressCountryCode, identificationNumber, finantialInstitutions);
        } else if (customer.isPersonCustomer()) {
            customer.registerFinantialInstitutions(finantialInstitutions);
        }
    }
}

