/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationFileDTO;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter$callable$processCode;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileDetailLine;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SIBSPaymentsImporter {
    private static final String PAYMENT_FILE_EXTENSION = "INP";
    public static final Advice advice$processCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult processSIBSPaymentFiles(SibsInputFile inputFile) throws IOException {
        Class<SIBSPaymentsImporter> clazz = SIBSPaymentsImporter.class;
        synchronized (SIBSPaymentsImporter.class) {
            ProcessResult result;
            block10: {
                result = new ProcessResult();
                if (StringUtils.endsWithIgnoreCase((String)inputFile.getFilename(), (String)PAYMENT_FILE_EXTENSION)) {
                    result.addMessage("label.manager.SIBS.processingFile", inputFile.getFilename());
                    try {
                        this.processFile(inputFile, result);
                        break block10;
                    }
                    catch (FileNotFoundException e) {
                        throw new TreasuryDomainException("error.manager.SIBS.zipException", this.getMessage(e));
                    }
                    catch (IOException e) {
                        throw new TreasuryDomainException("error.manager.SIBS.IOException", this.getMessage(e));
                    }
                    catch (Exception e) {
                        throw new TreasuryDomainException("error.manager.SIBS.fileException", this.getMessage(e));
                    }
                }
                throw new TreasuryDomainException("error.manager.SIBS.notSupportedExtension", inputFile.getFilename());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    protected String getMessage(Exception ex) {
        String message = ex.getMessage() == null ? ex.getClass().getSimpleName() : ex.getMessage();
        message = message + "\n";
        for (StackTraceElement el : ex.getStackTrace()) {
            message = message + el.toString() + "\n";
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(SibsInputFile inputFile, ProcessResult processResult) throws IOException {
        processResult.addMessage("label.manager.SIBS.processingFile", inputFile.getFilename());
        try (InputStream fileInputStream = null;){
            fileInputStream = inputFile.getStream();
            User person = Authenticate.getUser();
            SibsIncommingPaymentFile sibsFile = SibsIncommingPaymentFile.parse(inputFile.getFilename(), fileInputStream);
            processResult.addMessage("label.manager.SIBS.linesFound", String.valueOf(sibsFile.getDetailLines().size()));
            processResult.addMessage("label.manager.SIBS.startingProcess", new String[0]);
            processResult.addMessage("label.manager.SIBS.creatingReport", new String[0]);
            SibsReportFile reportFile = null;
            try {
                SIBSImportationFileDTO reportDTO = new SIBSImportationFileDTO(sibsFile, inputFile.getFinantialInstitution());
                reportFile = SibsReportFile.processSIBSIncommingFile(reportDTO);
                processResult.addMessage("label.manager.SIBS.reportCreated", new String[0]);
                processResult.setReportFile(reportFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                processResult.addError("error.manager.SIBS.reportException", this.getMessage(ex));
            }
            if (reportFile == null) {
                processResult.addError("error.manager.SIBS.report.not.created", new String[0]);
                return;
            }
            for (SibsIncommingPaymentFileDetailLine detailLine : sibsFile.getDetailLines()) {
                try {
                    SettlementNote settlementNote = this.processCode(detailLine, person, processResult, inputFile.getFinantialInstitution(), inputFile.getFilename().replace("\\.inp", ""), sibsFile.getWhenProcessedBySibs(), reportFile);
                    if (settlementNote == null) continue;
                    processResult.addMessage(detailLine.getCode() + " [" + inputFile.getFinantialInstitution().getCurrency().getValueFor(detailLine.getAmount()) + "] => " + settlementNote.getUiDocumentNumber(), new String[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    processResult.addError("error.manager.SIBS.processException", detailLine.getCode(), this.getMessage(e));
                }
            }
            if (processResult.hasFailed()) {
                processResult.addError("error.manager.SIBS.nonProcessedCodes", new String[0]);
            }
            processResult.addMessage("label.manager.SIBS.done", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult processSIBSPaymentFiles(SibsIncommingPaymentFile sibsFile, FinantialInstitution finantialInstitution) throws IOException {
        Class<SIBSPaymentsImporter> clazz = SIBSPaymentsImporter.class;
        synchronized (SIBSPaymentsImporter.class) {
            ProcessResult result;
            block8: {
                result = new ProcessResult();
                if (StringUtils.endsWithIgnoreCase((String)sibsFile.getFilename(), (String)PAYMENT_FILE_EXTENSION)) {
                    result.addMessage("label.manager.SIBS.processingFile", sibsFile.getFilename());
                    try {
                        this.processFile(sibsFile, finantialInstitution, result);
                        break block8;
                    }
                    catch (Exception e) {
                        throw new TreasuryDomainException("error.manager.SIBS.fileException", this.getMessage(e));
                    }
                }
                throw new TreasuryDomainException("error.manager.SIBS.notSupportedExtension", sibsFile.getFilename());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    private void processFile(SibsIncommingPaymentFile sibsFile, FinantialInstitution finantialInstitution, ProcessResult processResult) {
        User person = Authenticate.getUser();
        processResult.addMessage("label.manager.SIBS.linesFound", String.valueOf(sibsFile.getDetailLines().size()));
        processResult.addMessage("label.manager.SIBS.startingProcess", new String[0]);
        processResult.addMessage("label.manager.SIBS.creatingReport", new String[0]);
        SibsReportFile reportFile = null;
        try {
            SIBSImportationFileDTO reportDTO = new SIBSImportationFileDTO(sibsFile, finantialInstitution);
            reportFile = SibsReportFile.processSIBSIncommingFile(reportDTO);
            processResult.addMessage("label.manager.SIBS.reportCreated", new String[0]);
            processResult.setReportFile(reportFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            processResult.addError("error.manager.SIBS.reportException", this.getMessage(ex));
        }
        if (reportFile == null) {
            processResult.addError("error.manager.SIBS.report.not.created", new String[0]);
            return;
        }
        for (SibsIncommingPaymentFileDetailLine detailLine : sibsFile.getDetailLines()) {
            try {
                SettlementNote settlementNote = this.processCode(detailLine, person, processResult, finantialInstitution, sibsFile.getFilename().replace("\\.inp", ""), sibsFile.getWhenProcessedBySibs(), reportFile);
                if (settlementNote == null) continue;
                processResult.addMessage(detailLine.getCode() + " [" + finantialInstitution.getCurrency().getValueFor(detailLine.getAmount()) + "] => " + settlementNote.getUiDocumentNumber(), new String[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                processResult.addError("error.manager.SIBS.processException", detailLine.getCode(), this.getMessage(e));
            }
        }
        if (processResult.hasFailed()) {
            processResult.addError("error.manager.SIBS.nonProcessedCodes", new String[0]);
        }
        processResult.addMessage("label.manager.SIBS.done", new String[0]);
    }

    protected SettlementNote processCode(SibsIncommingPaymentFileDetailLine sibsIncommingPaymentFileDetailLine, User user, ProcessResult processResult, FinantialInstitution finantialInstitution, String string, YearMonthDay yearMonthDay, SibsReportFile sibsReportFile) throws Exception {
        return (SettlementNote)((Object)advice$processCode.perform((Callable)new SIBSPaymentsImporter$callable$processCode(this, sibsIncommingPaymentFileDetailLine, user, processResult, finantialInstitution, string, yearMonthDay, sibsReportFile)));
    }

    protected static /* synthetic */ SettlementNote advised$processCode(SIBSPaymentsImporter this_, SibsIncommingPaymentFileDetailLine detailLine, User person, ProcessResult result, FinantialInstitution finantialInstitution, String sibsImportationFile, YearMonthDay whenProcessedBySibs, SibsReportFile reportFile) throws Exception {
        SettlementNote settlementNote;
        PaymentReferenceCode paymentCode = this_.getPaymentCode(detailLine.getCode(), finantialInstitution);
        if (paymentCode == null) {
            result.addMessage("error.manager.SIBS.codeNotFound", detailLine.getCode());
            return null;
        }
        PaymentReferenceCode codeToProcess = this_.getPaymentCodeToProcess(paymentCode, result);
        if (codeToProcess.getState() == PaymentReferenceCodeStateType.ANNULLED) {
            result.addMessage("warning.manager.SIBS.anulledCode", codeToProcess.getReferenceCode());
        }
        if (!codeToProcess.isNew()) {
            if (SibsTransactionDetail.isReferenceProcessingDuplicate(codeToProcess.getReferenceCode(), codeToProcess.getPaymentCodePool().getEntityReferenceCode(), detailLine.getWhenOccuredTransaction())) {
                result.addMessage("error.manager.SIBS.codeAlreadyProcessed.duplicated", codeToProcess.getReferenceCode());
                return null;
            }
            if (codeToProcess.isProcessed()) {
                result.addMessage("warning.manager.SIBS.codeAlreadyProcessed", codeToProcess.getReferenceCode());
            }
        }
        if (codeToProcess.getTargetPayment() == null) {
            result.addMessage("error.manager.SIBS.code.exists.but.not.attributed.to.any.target", detailLine.getCode());
            return null;
        }
        if (codeToProcess.getTargetPayment().getReferencedCustomers().size() > 1) {
            result.addMessage("warning.manager.SIBS.referenced.multiple.payor.entities", codeToProcess.getReferenceCode());
        }
        if ((settlementNote = codeToProcess.processPayment(person, detailLine.getAmount(), detailLine.getWhenOccuredTransaction(), detailLine.getSibsTransactionId(), sibsImportationFile, whenProcessedBySibs.toLocalDate().toDateTimeAtStartOfDay(), reportFile)) != null) {
            codeToProcess.getTargetPayment().addSettlementNotes(settlementNote);
        }
        return settlementNote;
    }

    private PaymentReferenceCode getPaymentCodeToProcess(PaymentReferenceCode paymentCode, ProcessResult result) {
        PaymentReferenceCode codeToProcess = paymentCode;
        return codeToProcess;
    }

    private PaymentReferenceCode getPaymentCode(String code, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.findByReferenceCode(code, finantialInstitution).filter(x -> x.getPaymentCodePool().getActive() == true).findFirst().orElse(null);
    }

    public class ProcessResult {
        List<String> actionMessages = new ArrayList<String>();
        List<String> errorMessages = new ArrayList<String>();
        SibsReportFile reportFile;
        private boolean processFailed = false;

        public List<String> getActionMessages() {
            return this.actionMessages;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }

        public void addMessage(String message, String ... args) {
            this.actionMessages.add(BundleUtil.getString((String)Constants.BUNDLE, (String)message, (String[])args));
        }

        public void addError(String message, String ... args) {
            this.errorMessages.add(BundleUtil.getString((String)Constants.BUNDLE, (String)message, (String[])args));
            this.reportFailure();
        }

        protected void reportFailure() {
            this.processFailed = true;
        }

        public boolean hasFailed() {
            return this.processFailed;
        }

        public void setReportFile(SibsReportFile reportFile) {
            this.reportFile = reportFile;
        }

        public SibsReportFile getReportFile() {
            return this.reportFile;
        }
    }
}

