/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paymentscodegenerator;

import java.math.BigDecimal;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.joda.time.LocalDate;

public abstract class PaymentCodeGenerator {
    public boolean canGenerateNewCode(boolean forceGeneration) {
        if (!this.getReferenceCodePool().isGenerateReferenceCodeOnDemand() && !forceGeneration) {
            return false;
        }
        return this.getReferenceCodePool().getNextReferenceCode() < this.getReferenceCodePool().getMaxReferenceCode();
    }

    public abstract PaymentReferenceCode generateNewCodeFor(BigDecimal var1, LocalDate var2, LocalDate var3, boolean var4);

    public abstract PaymentReferenceCode generateNewCodeFor(BigDecimal var1, LocalDate var2, LocalDate var3, boolean var4, boolean var5);

    public abstract boolean isCodeMadeByThisFactory(PaymentReferenceCode var1);

    public abstract PaymentCodePool getReferenceCodePool();
}

