/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.domain.tariff.Tariff$callable$delete;
import org.fenixedu.treasury.domain.tariff.Tariff$callable$edit;
import org.fenixedu.treasury.domain.tariff.Tariff_Base;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class Tariff
extends Tariff_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected Tariff() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public abstract LocalizedString getUiTariffDescription();

    protected void init(FinantialEntity finantialEntity, Product product, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        this.setFinantialEntity(finantialEntity);
        this.setProduct(product);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setDueDateCalculationType(dueDateCalculationType);
        this.setFixedDueDate(fixedDueDate);
        this.setNumberOfDaysAfterCreationForDueDate(numberOfDaysAfterCreationForDueDate);
        this.setApplyInterests(applyInterests);
        if (this.getApplyInterests()) {
            InterestRate.createForTariff(this, interestType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, maximumMonthsToApplyPenalty, interestFixedAmount, rate);
        }
    }

    protected void checkRules() {
        if (this.getProduct() == null) {
            throw new TreasuryDomainException("error.Tariff.product.required", new String[0]);
        }
        if (this.getBeginDate() == null) {
            throw new TreasuryDomainException("error.Tariff.beginDate.required", new String[0]);
        }
        if (this.getEndDate() != null && !this.getEndDate().isAfter((ReadableInstant)this.getBeginDate())) {
            throw new TreasuryDomainException("error.Tariff.endDate.must.be.after.beginDate", new String[0]);
        }
        if (this.getDueDateCalculationType() == null) {
            throw new TreasuryDomainException("error.Tariff.dueDateCalculationType.required", new String[0]);
        }
        if ((this.getDueDateCalculationType().isFixedDate() || this.getDueDateCalculationType().isBestOfFixedDateAndDaysAfterCreation()) && this.getFixedDueDate() == null) {
            throw new TreasuryDomainException("error.Tariff.fixedDueDate.required", new String[0]);
        }
        if (this.getFixedDueDate() != null && this.getFixedDueDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1).isBefore((ReadableInstant)this.getBeginDate())) {
            throw new TreasuryDomainException("error.Tariff.fixedDueDate.must.be.after.or.equal.beginDate", new String[0]);
        }
        if ((this.getDueDateCalculationType().isDaysAfterCreation() || this.getDueDateCalculationType().isBestOfFixedDateAndDaysAfterCreation()) && this.getNumberOfDaysAfterCreationForDueDate() < 0) {
            throw new TreasuryDomainException("error.Tariff.numberOfDaysAfterCreationForDueDate.must.be.positive", new String[0]);
        }
        if (this.isApplyInterests()) {
            if (this.getInterestRate() == null || this.getInterestRate().getInterestType() == null) {
                throw new TreasuryDomainException("error.Tariff.interestRate.required", new String[0]);
            }
            if (this.getInterestRate().getInterestType().isDaily()) {
                if (this.getInterestRate().getRate() == null || !this.isPositive(this.getInterestRate().getRate())) {
                    throw new TreasuryDomainException("error.Tariff.interestRate.invalid", new String[0]);
                }
                if (this.getInterestRate().getNumberOfDaysAfterDueDate() <= 0) {
                    throw new TreasuryDomainException("error.Tariff.interestRate.numberofdaysafterduedate.invalid", new String[0]);
                }
                if (this.getInterestRate().getMaximumDaysToApplyPenalty() < 0) {
                    throw new TreasuryDomainException("error.Tariff.interestRate.maximumdaystoapplypenalty.invalid", new String[0]);
                }
            }
            if (this.getInterestRate().getInterestType().isMonthly()) {
                if (this.getInterestRate().getRate() == null || BigDecimal.ZERO.compareTo(this.getInterestRate().getRate()) >= 0) {
                    throw new TreasuryDomainException("error.Tariff.interestRate.invalid", new String[0]);
                }
                if (this.getInterestRate().getMaximumMonthsToApplyPenalty() < 0) {
                    throw new TreasuryDomainException("error.Tariff.interestRate.maximummonthstoapplypenalty.invalid", new String[0]);
                }
            }
            if (this.getInterestRate().getInterestType() == InterestType.FIXED_AMOUNT && BigDecimal.ZERO.compareTo(this.getInterestRate().getInterestFixedAmount()) >= 0) {
                throw new TreasuryDomainException("error.Tariff.interestRate.interestfixedamount.invalid", new String[0]);
            }
        }
    }

    protected Interval getInterval() {
        return new Interval((ReadableInstant)this.getBeginDate(), (ReadableInstant)this.getEndDate());
    }

    public boolean isEndDateDefined() {
        return this.getEndDate() != null;
    }

    public boolean isActive(DateTime when) {
        return new Interval((ReadableInstant)this.getBeginDate(), (ReadableInstant)this.getEndDate()).contains((ReadableInstant)when);
    }

    public boolean isActive(Interval dateInterval) {
        return new Interval((ReadableInstant)this.getBeginDate(), (ReadableInstant)this.getEndDate()).overlaps((ReadableInterval)dateInterval);
    }

    public boolean isApplyInterests() {
        return this.getApplyInterests();
    }

    public void edit(DateTime dateTime, DateTime dateTime2) {
        Object object = advice$edit.perform((Callable)new Tariff$callable$edit(this, dateTime, dateTime2));
    }

    static /* synthetic */ void advised$edit(Tariff this_, DateTime beginDate, DateTime endDate) {
        super.setBeginDate(beginDate);
        super.setEndDate(endDate);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Tariff$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Tariff this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.Tariff.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setProduct(null);
        this_.setFinantialEntity(null);
        if (this_.getInterestRate() != null) {
            this_.getInterestRate().delete();
        }
        super.deleteDomainObject();
    }

    protected boolean isNegative(BigDecimal value) {
        return !this.isZero(value) && !this.isPositive(value);
    }

    protected boolean isZero(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) == 0;
    }

    protected boolean isPositive(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) < 0;
    }

    protected boolean isGreaterThan(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0;
    }

    public LocalDate dueDate(LocalDate requestDate) {
        if (this.getDueDateCalculationType().isFixedDate()) {
            return this.getFixedDueDate();
        }
        if (this.getDueDateCalculationType().isBestOfFixedDateAndDaysAfterCreation()) {
            LocalDate daysAfterCreation = requestDate.plusDays(this.getNumberOfDaysAfterCreationForDueDate());
            if (daysAfterCreation.isAfter((ReadablePartial)this.getFixedDueDate())) {
                return daysAfterCreation;
            }
            return this.getFixedDueDate();
        }
        return requestDate.plusDays(this.getNumberOfDaysAfterCreationForDueDate());
    }

    public static Stream<? extends Tariff> findAll() {
        return FenixFramework.getDomainRoot().getTariffsSet().stream();
    }

    public static Stream<? extends Tariff> find(Product product) {
        return product.getTariffSet().stream();
    }

    public static Stream<? extends Tariff> find(Product product, DateTime when) {
        return Tariff.find(product).filter(t -> t.isActive(when));
    }

    public static Stream<? extends Tariff> findInInterval(Product product, DateTime start, DateTime end) {
        Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
        return Tariff.find(product).filter(t -> t.isActive(interval));
    }
}

