/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.paymentcodes.PaymentCodeTarget$callable$internalProcessPayment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentCodeTarget_Base;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class PaymentCodeTarget
extends PaymentCodeTarget_Base {
    public static final Advice advice$internalProcessPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public abstract SettlementNote processPayment(User var1, BigDecimal var2, DateTime var3, String var4, String var5);

    public abstract String getDescription();

    public String getTargetPayorDescription() {
        if (this.getDebtAccount() != null) {
            return this.getDebtAccount().getCustomer().getBusinessIdentification() + "-" + this.getDebtAccount().getCustomer().getName();
        }
        return "----";
    }

    public abstract boolean isPaymentCodeFor(TreasuryEvent var1);

    public boolean isMultipleEntriesPaymentCode() {
        return false;
    }

    public boolean isFinantialDocumentPaymentCode() {
        return false;
    }

    protected SettlementNote internalProcessPayment(User user, BigDecimal bigDecimal, DateTime dateTime, String string, String string2, Set<InvoiceEntry> set) {
        return (SettlementNote)((Object)advice$internalProcessPayment.perform((Callable)new PaymentCodeTarget$callable$internalProcessPayment(this, user, bigDecimal, dateTime, string, string2, set)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected static /* synthetic */ SettlementNote advised$internalProcessPayment(PaymentCodeTarget this_, User user, BigDecimal amount, DateTime whenRegistered, String sibsTransactionId, String comments, Set invoiceEntriesToPay) {
        TreeSet sortedInvoiceEntriesToPay = Sets.newTreeSet(InvoiceEntry.COMPARE_BY_AMOUNT_AND_DUE_DATE);
        sortedInvoiceEntriesToPay.addAll(invoiceEntriesToPay);
        BigDecimal availableAmount = amount;
        ArrayList<DebitEntry> interestRateEntries = new ArrayList<DebitEntry>();
        DebtAccount referenceDebtAccount = this_.getDebtAccount();
        DocumentNumberSeries docNumberSeries = this_.getDocumentSeriesForPayments();
        SettlementNote settlementNote = SettlementNote.create(referenceDebtAccount, docNumberSeries, new DateTime(), whenRegistered, comments, null);
        if (this_.getReferencedCustomers().size() == 1) {
            SettlementEntry newSettlementEntry;
            for (Object entry : sortedInvoiceEntriesToPay) {
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal amountToPay = ((InvoiceEntry)((Object)entry)).getOpenAmount();
                if (amountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (((InvoiceEntry)((Object)entry)).isDebitNoteEntry()) {
                    InterestRateBean calculateUndebitedInterestValue;
                    DebitEntry debitEntry = (DebitEntry)((Object)entry);
                    if (debitEntry.getFinantialDocument() == null) {
                        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), this_.getPaymentReferenceCode().getPaymentCodePool().getFinantialInstitution()).get();
                        DebitNote debitNote = DebitNote.create(debitEntry.getDebtAccount(), documentNumberSeries, new DateTime());
                        debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
                    }
                    if (debitEntry.getFinantialDocument().isPreparing()) {
                        debitEntry.getFinantialDocument().closeDocument();
                    }
                    if (amountToPay.compareTo(availableAmount) > 0) {
                        amountToPay = availableAmount;
                    }
                    if (debitEntry.getOpenAmount().equals(amountToPay) && Constants.isPositive((calculateUndebitedInterestValue = debitEntry.calculateUndebitedInterestValue(whenRegistered.toLocalDate())).getInterestAmount())) {
                        DebitEntry interestDebitEntry = debitEntry.createInterestRateDebitEntry(calculateUndebitedInterestValue, whenRegistered, Optional.empty());
                        interestRateEntries.add(interestDebitEntry);
                    }
                    newSettlementEntry = SettlementEntry.create((InvoiceEntry)((Object)entry), settlementNote, amountToPay, entry.getDescription(), whenRegistered, true);
                    availableAmount = availableAmount.subtract(amountToPay);
                    continue;
                }
                if (!((InvoiceEntry)((Object)entry)).isCreditNoteEntry()) continue;
                SettlementEntry newSettlementEntry2 = SettlementEntry.create((InvoiceEntry)((Object)entry), settlementNote, ((InvoiceEntry)((Object)entry)).getOpenAmount(), entry.getDescription(), whenRegistered, true);
                availableAmount = availableAmount.add(amountToPay);
            }
            if (interestRateEntries.size() > 0) {
                DebitNote interestNote = DebitNote.create(referenceDebtAccount, this_.getDocumentSeriesInterestDebits(), whenRegistered);
                for (DebitEntry interestEntry : interestRateEntries) {
                    interestEntry.setFinantialDocument((FinantialDocument)((Object)interestNote));
                }
                interestNote.closeDocument();
                if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
                    for (DebitEntry interestEntry : interestRateEntries) {
                        if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                        BigDecimal amountToPay = interestEntry.getOpenAmount();
                        if (amountToPay.compareTo(availableAmount) > 0) {
                            amountToPay = availableAmount;
                        }
                        newSettlementEntry = SettlementEntry.create((InvoiceEntry)((Object)interestEntry), settlementNote, amountToPay, interestEntry.getDescription(), whenRegistered, true);
                        availableAmount = availableAmount.subtract(amountToPay);
                    }
                }
                interestRateEntries.clear();
            }
        }
        if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
            settlementNote.createAdvancedPaymentCreditNote(availableAmount, Constants.treasuryBundle("label.PaymentCodeTarget.advancedpayment", new String[0]) + comments + "-" + sibsTransactionId, sibsTransactionId);
        }
        Map<String, String> paymentEntryPropertiesMap = this_.fillPaymentEntryPropertiesMap(sibsTransactionId);
        PaymentEntry paymentEntry = PaymentEntry.create(this_.getPaymentReferenceCode().getPaymentCodePool().getPaymentMethod(), settlementNote, amount, this_.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
        settlementNote.closeDocument();
        this_.getPaymentReferenceCode().setState(PaymentReferenceCodeStateType.PROCESSED);
        return settlementNote;
    }

    private String fillPaymentEntryMethodId() {
        return String.format("COB PAG SERV %s", this.getPaymentReferenceCode().getPaymentCodePool().getEntityReferenceCode());
    }

    private Map<String, String> fillPaymentEntryPropertiesMap(String sibsTransactionId) {
        HashMap paymentEntryPropertiesMap = Maps.newHashMap();
        paymentEntryPropertiesMap.put("ReferenceCode", this.getPaymentReferenceCode().getReferenceCode());
        paymentEntryPropertiesMap.put("EntityReferenceCode", this.getPaymentReferenceCode().getPaymentCodePool().getEntityReferenceCode());
        if (!Strings.isNullOrEmpty((String)sibsTransactionId)) {
            paymentEntryPropertiesMap.put("SibsTransactionId", sibsTransactionId);
        }
        return paymentEntryPropertiesMap;
    }

    protected abstract DocumentNumberSeries getDocumentSeriesInterestDebits();

    protected abstract DocumentNumberSeries getDocumentSeriesForPayments();

    protected abstract Set<InvoiceEntry> getInvoiceEntries();

    public abstract LocalDate getDueDate();

    public Set<Customer> getReferencedCustomers() {
        HashSet result = Sets.newHashSet();
        for (InvoiceEntry entry : this.getInvoiceEntries()) {
            if (entry.getFinantialDocument() != null && ((Invoice)((Object)entry.getFinantialDocument())).isForPayorDebtAccount()) {
                result.add(((Invoice)((Object)entry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(entry.getDebtAccount().getCustomer());
        }
        return result;
    }
}

