/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.manageinvoice;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.accesscontrol.TreasuryAccessControl;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.ERPCustomerFieldsBean;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.manageinvoice.CreditNoteController$callable$anullCreditNote;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.document.manageCreditNote", accessGroup="treasuryFrontOffice")
@RequestMapping(value={"/treasury/document/manageinvoice/creditnote"})
public class CreditNoteController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/manageinvoice/creditnote";
    public static final long SEARCH_LIMIT_SIZE = 500L;
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/document/manageinvoice/creditnote/read/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/document/manageinvoice/creditnote/update/";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/document/manageinvoice/creditnote/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/document/manageinvoice/creditnote/search/view/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/document/manageinvoice/creditnote/create";
    private static final String _DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URI = "/downloadcertifieddocumentprint";
    public static final String DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URL = "/treasury/document/manageinvoice/creditnote/downloadcertifieddocumentprint";
    public static final Advice advice$anullCreditNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/document/manageinvoice/creditnote/";
    }

    private CreditNote getCreditNote(Model model) {
        return (CreditNote)((Object)model.asMap().get("creditNote"));
    }

    private void setCreditNote(CreditNote creditNote, Model model) {
        model.addAttribute("creditNote", (Object)creditNote);
    }

    public void anullCreditNote(CreditNote creditNote, String string) {
        Object object = advice$anullCreditNote.perform((Callable)new CreditNoteController$callable$anullCreditNote(this, creditNote, string));
    }

    static /* synthetic */ void advised$anullCreditNote(CreditNoteController this_, CreditNote creditNote, String reason) {
        creditNote.anullDocument(reason);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") CreditNote creditNote, Model model) {
        this.setCreditNote(creditNote, model);
        ArrayList errorMessages = Lists.newArrayList();
        boolean validAddress = ERPCustomerFieldsBean.validateAddress(creditNote.getDebtAccount().getCustomer(), errorMessages);
        if (creditNote.getPayorDebtAccount() != null) {
            validAddress = ERPCustomerFieldsBean.validateAddress(creditNote.getPayorDebtAccount().getCustomer(), errorMessages);
        }
        model.addAttribute("validAddress", (Object)validAddress);
        model.addAttribute("addressErrorMessages", (Object)errorMessages);
        return "treasury/document/manageinvoice/creditnote/read";
    }

    @RequestMapping(value={"/read/{oid}/closecreditnote"}, method={RequestMethod.POST})
    public String processReadToCloseCreditNote(@PathVariable(value="oid") CreditNote creditNote, Model model, RedirectAttributes redirectAttributes) {
        this.setCreditNote(creditNote, model);
        try {
            this.assertUserIsAllowToModifyInvoices(creditNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            creditNote.closeDocument();
            this.addInfoMessage(Constants.treasuryBundle("label.document.manageinvoice.CreditNote.document.closed.sucess", new String[0]), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getCreditNote(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/anull/{oid}"}, method={RequestMethod.POST})
    public String anull(@PathVariable(value="oid") CreditNote creditNote, @RequestParam(value="reason", required=false) String reason, Model model, RedirectAttributes redirectAttributes) {
        this.setCreditNote(creditNote, model);
        try {
            this.assertUserIsAllowToModifyInvoices(creditNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            if (!TreasuryAccessControl.getInstance().isManager(Authenticate.getUser())) {
                this.addErrorMessage(Constants.treasuryBundle("error.authorization.not.allow.to.modify.invoices", new String[0]), model);
                throw new SecurityException(Constants.treasuryBundle("error.authorization.not.allow.to.modify.invoices", new String[0]));
            }
            this.anullCreditNote(creditNote, reason);
            this.addInfoMessage(Constants.treasuryBundle("label.document.manageinvoice.CreditNote.document.anulled.sucess", new String[0]), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getCreditNote(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/addentry"})
    public String processReadToAddEntry(@PathVariable(value="oid") CreditNote creditNote, Model model, RedirectAttributes redirectAttributes) {
        this.setCreditNote(creditNote, model);
        return this.redirect("/treasury/document/manageinvoice/creditentry/create?creditnote=" + this.getCreditNote(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") CreditNote creditNote, Model model) {
        model.addAttribute("stateValues", (Object)FinantialDocumentStateType.values());
        this.setCreditNote(creditNote, model);
        return "treasury/document/manageinvoice/creditnote/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") CreditNote creditNote, @RequestParam(value="origindocumentnumber", required=false) String originDocumentNumber, @RequestParam(value="documentobservations", required=false) String documentObservations, Model model, RedirectAttributes redirectAttributes) {
        this.setCreditNote(creditNote, model);
        try {
            this.assertUserIsAllowToModifyInvoices(creditNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            this.getCreditNote(model).updateCreditNote(originDocumentNumber, documentObservations);
            return this.redirect(READ_URL + this.getCreditNote(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.update", new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.update", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(creditNote, model);
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="debtaccount", required=false) DebtAccount debtAccount, @RequestParam(value="documentnumber", required=false) String documentNumber, @RequestParam(value="documentdatefrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDateFrom, @RequestParam(value="documentdateto", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDateTo, @RequestParam(value="origindocumentnumber", required=false) String originDocumentNumber, @RequestParam(value="state", required=false) FinantialDocumentStateType state, Model model) {
        List<CreditNote> result = this.filterSearch(debtAccount, documentNumber, documentDateFrom, documentDateTo, originDocumentNumber, state);
        model.addAttribute("limit_exceeded", (Object)((long)result.size() > 500L ? 1 : 0));
        model.addAttribute("searchcreditnoteResultsDataSet_totalCount", (Object)result.size());
        model.addAttribute("searchcreditnoteResultsDataSet", result.stream().limit(500L).collect(Collectors.toList()));
        model.addAttribute("stateValues", FinantialDocumentStateType.findAll());
        return "treasury/document/manageinvoice/creditnote/search";
    }

    private List<CreditNote> getSearchUniverse(DebtAccount debtAccount) {
        Stream<CreditNote> result = debtAccount == null ? CreditNote.findAll() : CreditNote.find(debtAccount);
        return result.collect(Collectors.toList());
    }

    private List<CreditNote> filterSearch(DebtAccount debtAccount, String documentNumber, LocalDate documentDateFrom, LocalDate documentDateTo, String originDocumentNumber, FinantialDocumentStateType state) {
        ArrayList result = Lists.newArrayList();
        boolean search = false;
        Predicate<CreditNote> predicate = i -> true;
        if (debtAccount != null) {
            search = true;
        }
        if (!Strings.isNullOrEmpty((String)documentNumber)) {
            search = true;
            predicate = predicate.and(i -> !Strings.isNullOrEmpty((String)i.getDocumentNumber()) && i.getUiDocumentNumber().toLowerCase().contains(documentNumber.trim().toLowerCase()));
        }
        if (documentDateFrom != null) {
            search = true;
            predicate = predicate.and(i -> i.getDocumentDate().toLocalDate().isEqual((ReadablePartial)documentDateFrom) || i.getDocumentDate().toLocalDate().isAfter((ReadablePartial)documentDateFrom));
        }
        if (documentDateTo != null) {
            search = true;
            predicate = predicate.and(i -> i.getDocumentDate().toLocalDate().isEqual((ReadablePartial)documentDateTo) || i.getDocumentDate().toLocalDate().isBefore((ReadablePartial)documentDateTo));
        }
        if (!StringUtils.isEmpty((Object)originDocumentNumber)) {
            search = true;
            predicate = predicate.and(i -> !StringUtils.isEmpty((Object)i.getOriginDocumentNumber()) && i.getOriginDocumentNumber().toLowerCase().contains(originDocumentNumber.trim().toLowerCase()));
        }
        if (state != null) {
            search = true;
            predicate = predicate.and(i -> state == i.getState());
        }
        if (search) {
            this.getSearchUniverse(debtAccount).stream().filter(predicate).collect(Collectors.toCollection(() -> result));
        }
        return result;
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") CreditNote creditNote, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + creditNote.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(@RequestParam(value="debtaccount", required=false) DebtAccount debtAccount, @RequestParam(value="debitnote", required=false) DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        FinantialInstitution finantialInstitution = null;
        if (debtAccount == null && debitNote == null) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.document.manageinvoice.finantialinstitution.mismatch.debtaccount.series", new String[0]), model);
            return this.redirectToReferrer(model, redirectAttributes);
        }
        if (debitNote != null && debtAccount != null && !debitNote.getDebtAccount().equals((Object)debtAccount)) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.document.manageinvoice.finantialinstitution.mismatch.debtaccount.series", new String[0]), model);
            return this.redirectToReferrer(model, redirectAttributes);
        }
        if (debtAccount != null) {
            finantialInstitution = debtAccount.getFinantialInstitution();
        }
        if (debitNote != null) {
            finantialInstitution = debitNote.getDebtAccount().getFinantialInstitution();
            debtAccount = debitNote.getDebtAccount();
        }
        List availableSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), finantialInstitution).filter(x -> x.getSeries().getActive()).collect(Collectors.toList());
        if ((availableSeries = DocumentNumberSeries.applyActiveSelectableAndDefaultSorting(availableSeries.stream()).collect(Collectors.toList())).size() <= 0) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.document.manageinvoice.finantialinstitution.no.available.series.found", new String[0]), model);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        model.addAttribute("CreditNote_documentNumberSeries_options", availableSeries);
        model.addAttribute("debitNote", (Object)debitNote);
        model.addAttribute("debtAccount", (Object)debtAccount);
        if (debitNote == null) {
            this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.document.manageinvoice.creditnote.without.debitnote", (String[])new String[0]), model);
        }
        return "treasury/document/manageinvoice/creditnote/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="debitnote", required=false) DebitNote debitNote, @RequestParam(value="debtaccount", required=false) DebtAccount debtAccount, @RequestParam(value="documentnumberseries") DocumentNumberSeries documentNumberSeries, @RequestParam(value="documentdate") @DateTimeFormat(pattern="yyyy-MM-dd") DateTime documentDate, @RequestParam(value="origindocumentnumber", required=false) String originDocumentNumber, @RequestParam(value="documentobservations", required=false) String documentObservations, Model model, RedirectAttributes redirectAttributes, HttpServletRequest request) {
        if (debtAccount == null && debitNote == null) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.document.manageinvoice.finantialinstitution.mismatch.debtaccount.series", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        if (debtAccount == null) {
            debtAccount = debitNote.getDebtAccount();
        }
        if (documentNumberSeries != null && debtAccount != null && !documentNumberSeries.getSeries().getFinantialInstitution().equals(debtAccount.getFinantialInstitution())) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.document.manageinvoice.finantialinstitution.mismatch.debtaccount.series", new String[0]), model);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        try {
            this.assertUserIsAllowToModifyInvoices(documentNumberSeries.getSeries().getFinantialInstitution(), model);
            debitNote.createEquivalentCreditNote(documentDate, documentObservations, false);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.create", new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(Constants.treasuryBundle("label.error.create", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(debtAccount, debitNote, model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/exportintegrationfile"}, produces={"text/xml"})
    public String processReadToExportIntegrationFile(@PathVariable(value="oid") CreditNote creditNote, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            this.assertUserIsFrontOfficeMember(creditNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            String saftEncoding = ERPExporterManager.saftEncoding(creditNote.getDebtAccount().getFinantialInstitution());
            creditNote.recalculateAmountValues();
            String output = ERPExporterManager.exportFinantialDocumentToXML((FinantialDocument)((Object)creditNote));
            response.setContentType("text/xml");
            response.setCharacterEncoding(saftEncoding);
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)(creditNote.getDebtAccount().getFinantialInstitution().getFiscalNumber() + "_" + creditNote.getUiDocumentNumber() + ".xml").replaceAll(_SEARCH_URI, "_").replaceAll("\\s", "_").replaceAll(" ", "_")), saftEncoding);
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(output.getBytes(saftEncoding));
            return null;
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.read(creditNote, model);
        }
    }

    @RequestMapping(value={"/read/{oid}/exportintegrationonline"})
    public String processReadToExportIntegrationOnline(@PathVariable(value="oid") CreditNote creditNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(creditNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            try {
                IERPExporter erpExporter = creditNote.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
                erpExporter.checkIntegrationDocumentStatus((FinantialDocument)((Object)creditNote));
            }
            catch (Exception erpExporter) {
                // empty catch block
            }
            ERPExportOperation output = ERPExporterManager.exportSingleDocument((FinantialDocument)((Object)creditNote));
            if (output == null) {
                this.addInfoMessage(Constants.treasuryBundle("label.integration.erp.document.not.exported", new String[0]), model);
                return this.read(creditNote, model);
            }
            this.addInfoMessage(Constants.treasuryBundle("label.integration.erp.exportoperation.success", new String[0]), model);
            return this.redirect("/treasury/integration/erp/erpexportoperation/read/" + output.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(Constants.treasuryBundle("label.integration.erp.exportoperation.error", new String[0]) + ex.getLocalizedMessage(), model);
            return this.read(creditNote, model);
        }
    }

    @RequestMapping(value={"/read/{oid}/cleardocumenttoexport"}, method={RequestMethod.POST})
    public String cleardocumenttoexport(@PathVariable(value="oid") CreditNote creditNote, @RequestParam(value="reason", required=false) String reason, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (!creditNote.isDocumentToExport()) {
                this.addErrorMessage(Constants.treasuryBundle("error.FinantialDocument.document.not.marked.to.export", new String[0]), model);
                return this.redirect(READ_URL + creditNote.getExternalId(), model, redirectAttributes);
            }
            if (Strings.isNullOrEmpty((String)reason)) {
                this.addErrorMessage(Constants.treasuryBundle("error.FinantialDocument.clear.document.to.export.requires.reason", new String[0]), model);
                return this.redirect(READ_URL + creditNote.getExternalId(), model, redirectAttributes);
            }
            this.assertUserIsBackOfficeMember(model);
            creditNote.clearDocumentToExport(reason);
            return this.redirect(READ_URL + creditNote.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.read(creditNote, model);
        }
    }

    @RequestMapping(value={"/downloadcertifieddocumentprint/{oid}"}, method={RequestMethod.GET})
    public String downloadcertifieddocumentprint(@PathVariable(value="oid") CreditNote creditNote, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            byte[] contents = ERPExporterManager.downloadCertifiedDocumentPrint((FinantialDocument)((Object)creditNote));
            response.setContentType("application/pdf");
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)(creditNote.getDebtAccount().getFinantialInstitution().getFiscalNumber() + "_" + creditNote.getUiDocumentNumber() + ".pdf").replaceAll(_SEARCH_URI, "_").replaceAll("\\s", "_").replaceAll(" ", "_")), "Windows-1252");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(contents);
            return null;
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.read(creditNote, model);
        }
    }
}

