/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.forwardpayments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment_Base;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=TreasuryController.class, title="label.ManageForwardPayments.functionality", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/treasury/document/forwardpayments/management"})
public class ManageForwardPaymentsController
extends TreasuryBaseController {
    private static final int MAX_SEARCH_SIZE = 1000;
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/management";
    private static final String JSP_PATH = "/treasury/document/forwardpayments/management";
    public static final String SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/treasury/document/forwardpayments/management/search";
    public static final String VIEW_URI = "/view";
    public static final String VIEW_URL = "/treasury/document/forwardpayments/management/view";
    private static final String VERIFY_FORWARD_PAYMENT_URI = "/verifyforwardpayment";
    public static final String VERIFY_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/management/verifyforwardpayment";
    private static final String REGISTER_PAYMENT_URI = "/registerpayment";
    public static final String REGISTER_PAYMENT_URL = "/treasury/document/forwardpayments/management/registerpayment";
    public static final String EXPORT_URI = "/export";
    public static final String EXPORT_URL = "/treasury/document/forwardpayments/management/export";

    @RequestMapping
    public String home() {
        return "redirect:/treasury/document/forwardpayments/management/search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(@RequestParam(value="beginDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate beginDate, @RequestParam(value="endDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate endDate, @RequestParam(value="customerName", required=false) String customerName, @RequestParam(value="customerBusinessId", required=false) String customerBusinessId, @RequestParam(value="orderNumber", required=false) String orderNumber, @RequestParam(value="withPendingPlatformPayment", required=false) boolean withPendingPlatformPayment, @RequestParam(value="forwardPaymentStateType", required=false) ForwardPaymentStateType type, Model model) {
        boolean canLimitResults;
        Stream<ForwardPayment> stream = ForwardPayment.findAll();
        if (!Strings.isNullOrEmpty((String)orderNumber)) {
            stream = stream.filter(i -> orderNumber.trim().equals(String.valueOf(i.getOrderNumber())));
        } else {
            if (beginDate != null) {
                stream = stream.filter(i -> !i.getWhenOccured().isBefore((ReadableInstant)beginDate.toDateTimeAtStartOfDay()));
            }
            if (endDate != null) {
                stream = stream.filter(i -> !i.getWhenOccured().isAfter((ReadableInstant)endDate.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1)));
            }
            if (!Strings.isNullOrEmpty((String)customerName)) {
                stream = stream.filter(i -> Constants.stringNormalizedContains(i.getDebtAccount().getCustomer().getName(), customerName));
            }
            if (!Strings.isNullOrEmpty((String)customerBusinessId)) {
                stream = stream.filter(i -> i.getDebtAccount().getCustomer().getBusinessIdentification().equals(customerBusinessId));
            }
            if (type != null) {
                stream = stream.filter(i -> i.getCurrentState() == type);
            }
        }
        if (withPendingPlatformPayment) {
            List resultList = stream.collect(Collectors.toList());
            stream = resultList.stream();
            int MAX_PENDING_POSSIBLE_PAYMENTS = 500;
            if (resultList.stream().filter(i -> i.getCurrentState().isInStateToPostProcessPayment() || i.getCurrentState().isRequested()).count() > (long)MAX_PENDING_POSSIBLE_PAYMENTS) {
                this.addErrorMessage(Constants.treasuryBundle("error.ManageForwardPayments.search.withPendingPlatformPayment.limited.narrow.search", new String[0]), model);
            } else {
                stream = stream.filter(i -> i.getCurrentState().isInStateToPostProcessPayment() || i.getCurrentState().isRequested());
                stream = stream.filter(i -> i.getForwardPaymentConfiguration().implementation().paymentStatus((ForwardPayment)((Object)i)).isAbleToRegisterPostPayment((ForwardPayment)((Object)i)));
            }
        }
        List forwardPayments = stream.sorted(Collections.reverseOrder(Comparator.comparing(ForwardPayment_Base::getWhenOccured))).collect(Collectors.toList());
        boolean bl = canLimitResults = beginDate == null || endDate == null || Days.daysBetween((ReadablePartial)beginDate, (ReadablePartial)endDate).getDays() > 1;
        if (canLimitResults && forwardPayments.size() > 1000) {
            model.addAttribute("limitResults", (Object)true);
            model.addAttribute("limit", (Object)1000);
            model.addAttribute("total", (Object)forwardPayments.size());
            forwardPayments = forwardPayments.subList(0, 1000);
        }
        model.addAttribute("forwardPaymentStateTypes", Lists.newArrayList((Object[])ForwardPaymentStateType.values()).stream().sorted(ForwardPaymentStateType.COMPARE_BY_LOCALIZED_NAME).collect(Collectors.toList()));
        model.addAttribute("forwardPayments", forwardPayments);
        return this.jspPage(SEARCH_URI);
    }

    @RequestMapping(value={"/view/{forwardPaymentId}"})
    public String view(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, Model model) {
        model.addAttribute("forwardPayment", (Object)forwardPayment);
        return this.jspPage(VIEW_URI);
    }

    @RequestMapping(value={"/verifyforwardpayment/{forwardPaymentId}"})
    public String verifyforwardpayment(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, Model model, RedirectAttributes redirectAttributes) {
        try {
            ForwardPaymentStatusBean paymentStatusBean = forwardPayment.getForwardPaymentConfiguration().implementation().paymentStatus(forwardPayment);
            model.addAttribute("forwardPayment", (Object)forwardPayment);
            model.addAttribute("paymentStatusBean", (Object)paymentStatusBean);
            return this.jspPage(VERIFY_FORWARD_PAYMENT_URI);
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.redirect("/treasury/document/forwardpayments/management/view/" + forwardPayment.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/registerpayment/{forwardPaymentId}"}, method={RequestMethod.POST})
    public String registerPayment(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, @RequestParam(value="justification") String justification, Model model, RedirectAttributes redirectAttributes) {
        try {
            ForwardPaymentStatusBean paymentStatusBean = forwardPayment.getForwardPaymentConfiguration().implementation().paymentStatus(forwardPayment);
            if (!forwardPayment.getCurrentState().isInStateToPostProcessPayment() || !paymentStatusBean.isInPayedState()) {
                this.addErrorMessage(Constants.treasuryBundle("label.ManageForwardPayments.forwardPayment.not.created.nor.payed.in.platform", new String[0]), model);
                return String.format("redirect:%s/%s", VERIFY_FORWARD_PAYMENT_URL, forwardPayment.getExternalId());
            }
            IForwardPaymentImplementation implementation = forwardPayment.getForwardPaymentConfiguration().implementation();
            implementation.postProcessPayment(forwardPayment, justification);
            return String.format("redirect:%s/%s", VIEW_URL, forwardPayment.getExternalId());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.redirect(String.format("%s/%s", VERIFY_FORWARD_PAYMENT_URL, forwardPayment.getExternalId()), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    @ResponseBody
    public void export() {
    }

    private String jspPage(String mapping) {
        return "/treasury/document/forwardpayments/management" + mapping;
    }
}

