/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.managefinantialinstitution;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.DocumentNumberSeriesController$callable$createDocumentNumberSeries;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.DocumentNumberSeriesController$callable$deleteDocumentNumberSeries;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=FinantialInstitutionController.class)
@RequestMapping(value={"/treasury/administration/managefinantialinstitution/documentnumberseries"})
public class DocumentNumberSeriesController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/managefinantialinstitution/documentnumberseries";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/managefinantialinstitution/documentnumberseries/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/managefinantialinstitution/documentnumberseries/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/managefinantialinstitution/documentnumberseries/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/managefinantialinstitution/documentnumberseries/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/managefinantialinstitution/documentnumberseries/delete/";
    private static final String SEARCH_VIEW_URI = "/search/view/";
    public static final String SEARCH_VIEW_URL = "/treasury/administration/managefinantialinstitution/documentnumberseries/search/view/";
    public static final Advice advice$deleteDocumentNumberSeries = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDocumentNumberSeries = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/managefinantialinstitution/documentnumberseries/";
    }

    private DocumentNumberSeries getDocumentNumberSeries(Model model) {
        return (DocumentNumberSeries)((Object)model.asMap().get("documentNumberSeries"));
    }

    private void setDocumentNumberSeries(DocumentNumberSeries documentNumberSeries, Model model) {
        model.addAttribute("documentNumberSeries", (Object)documentNumberSeries);
    }

    public void deleteDocumentNumberSeries(DocumentNumberSeries documentNumberSeries) {
        Object object = advice$deleteDocumentNumberSeries.perform((Callable)new DocumentNumberSeriesController$callable$deleteDocumentNumberSeries(this, documentNumberSeries));
    }

    static /* synthetic */ void advised$deleteDocumentNumberSeries(DocumentNumberSeriesController this_, DocumentNumberSeries documentNumberSeries) {
        documentNumberSeries.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="series", required=false) Series series, Model model) {
        List<DocumentNumberSeries> searchdocumentnumberseriesResultsDataSet = this.filterSearchDocumentNumberSeries(series);
        model.addAttribute("searchdocumentnumberseriesResultsDataSet", searchdocumentnumberseriesResultsDataSet);
        return "treasury/administration/managefinantialinstitution/documentnumberseries/search";
    }

    private List<DocumentNumberSeries> getSearchUniverseSearchDocumentNumberSeriesDataSet() {
        return DocumentNumberSeries.findAll().collect(Collectors.toList());
    }

    private List<DocumentNumberSeries> filterSearchDocumentNumberSeries(Series series) {
        Stream<Object> result = this.getSearchUniverseSearchDocumentNumberSeriesDataSet().stream();
        if (series != null) {
            result = result.filter(documentNumberSeries -> documentNumberSeries.getSeries() == series);
        }
        return result.collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") DocumentNumberSeries documentNumberSeries, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + documentNumberSeries.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") DocumentNumberSeries documentNumberSeries, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(documentNumberSeries.getSeries().getFinantialInstitution(), model);
            this.setDocumentNumberSeries(documentNumberSeries, model);
            return "treasury/administration/managefinantialinstitution/documentnumberseries/read";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + documentNumberSeries.getSeries().getFinantialInstitution().getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") DocumentNumberSeries documentNumberSeries, Model model, RedirectAttributes redirectAttributes) {
        this.setDocumentNumberSeries(documentNumberSeries, model);
        try {
            this.assertUserIsBackOfficeMember(documentNumberSeries.getSeries().getFinantialInstitution(), model);
            String seriesExternalId = documentNumberSeries.getSeries().getExternalId();
            this.deleteDocumentNumberSeries(documentNumberSeries);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/series/read/" + seriesExternalId, model, redirectAttributes);
        }
        catch (TreasuryDomainException ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getDocumentNumberSeries(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create/series{oid}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="oid") Series series, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(series.getFinantialInstitution(), model);
            model.addAttribute("series", (Object)series);
            model.addAttribute("DocumentNumberSeries_finantialDocumentType_options", FinantialDocumentType.findAll().collect(Collectors.toList()));
            return "treasury/administration/managefinantialinstitution/documentnumberseries/create";
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/series/read/" + series.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="series", required=false) Series series, @RequestParam(value="finantialdocumenttype", required=false) FinantialDocumentType finantialDocumentType, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(series.getFinantialInstitution(), model);
            DocumentNumberSeries documentNumberSeries = this.createDocumentNumberSeries(series, finantialDocumentType);
            model.addAttribute("documentNumberSeries", (Object)documentNumberSeries);
            return this.redirect(READ_URL + this.getDocumentNumberSeries(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
            return this.create(series, model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.create(series, model, redirectAttributes);
        }
    }

    public DocumentNumberSeries createDocumentNumberSeries(Series series, FinantialDocumentType finantialDocumentType) {
        return (DocumentNumberSeries)((Object)advice$createDocumentNumberSeries.perform((Callable)new DocumentNumberSeriesController$callable$createDocumentNumberSeries(this, series, finantialDocumentType)));
    }

    static /* synthetic */ DocumentNumberSeries advised$createDocumentNumberSeries(DocumentNumberSeriesController this_, Series series, FinantialDocumentType finantialDocumentType) {
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.create(finantialDocumentType, series);
        return documentNumberSeries;
    }

    @RequestMapping(value={"/read/{oid}/closepreparingdocuments"}, method={RequestMethod.POST})
    public String processReadToCloseAllPreparingDocuments(@PathVariable(value="oid") DocumentNumberSeries documentNumberSeries, @RequestParam(value="referencedate", required=true) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate referenceDate, Model model, RedirectAttributes redirectAttributes) {
        this.setDocumentNumberSeries(documentNumberSeries, model);
        try {
            this.assertUserIsBackOfficeMember(documentNumberSeries.getSeries().getFinantialInstitution(), model);
            List preparingDocuments = documentNumberSeries.getFinantialDocumentsSet().stream().filter(x -> x.isPreparing()).filter(x -> !referenceDate.isAfter((ReadablePartial)x.getDocumentDate().toLocalDate())).sorted((x, y) -> {
                if (x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate()) == 0 && Strings.isNullOrEmpty((String)x.getOriginDocumentNumber()) && Strings.isNullOrEmpty((String)y.getOriginDocumentNumber())) {
                    return x.getOriginDocumentNumber().compareToIgnoreCase(y.getOriginDocumentNumber());
                }
                return x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate());
            }).collect(Collectors.toList());
            int maxClosingDocuments = 100;
            int count = 0;
            for (FinantialDocument document : preparingDocuments) {
                try {
                    document.closeDocument();
                }
                catch (Exception ex) {
                    this.addErrorMessage("O documento " + document.getUiDocumentNumber() + " n\u00e3o foi encerrado : " + ex.getLocalizedMessage(), model);
                }
                if (count++ < maxClosingDocuments) continue;
                this.addInfoMessage("Max of " + maxClosingDocuments + " documents closed. Retry for more...", model);
                break;
            }
            return this.redirect(READ_URL + this.getDocumentNumberSeries(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.close.preparing.documents", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.redirect(READ_URL + this.getDocumentNumberSeries(model).getExternalId(), model, redirectAttributes);
        }
    }
}

