/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.manageglobalinterestrate;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.manageglobalinterestrate.GlobalInterestRateController$callable$createGlobalInterestRate;
import org.fenixedu.treasury.ui.administration.base.manageglobalinterestrate.GlobalInterestRateController$callable$deleteGlobalInterestRate;
import org.fenixedu.treasury.ui.administration.base.manageglobalinterestrate.GlobalInterestRateController$callable$updateGlobalInterestRate;
import org.fenixedu.treasury.util.Constants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageGlobalInterestRate", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/treasury/administration/base/manageglobalinterestrate/globalinterestrate"})
public class GlobalInterestRateController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/manageglobalinterestrate/globalinterestrate";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/manageglobalinterestrate/globalinterestrate/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/administration/base/manageglobalinterestrate/globalinterestrate/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/manageglobalinterestrate/globalinterestrate/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/manageglobalinterestrate/globalinterestrate/delete/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/manageglobalinterestrate/globalinterestrate/create";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/manageglobalinterestrate/globalinterestrate/update/";
    public static final Advice advice$deleteGlobalInterestRate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createGlobalInterestRate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateGlobalInterestRate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/manageglobalinterestrate/globalinterestrate/";
    }

    private GlobalInterestRate getGlobalInterestRate(Model model) {
        return (GlobalInterestRate)((Object)model.asMap().get("globalInterestRate"));
    }

    private void setGlobalInterestRate(GlobalInterestRate globalInterestRate, Model model) {
        model.addAttribute("globalInterestRate", (Object)globalInterestRate);
    }

    public void deleteGlobalInterestRate(GlobalInterestRate globalInterestRate) {
        Object object = advice$deleteGlobalInterestRate.perform((Callable)new GlobalInterestRateController$callable$deleteGlobalInterestRate(this, globalInterestRate));
    }

    static /* synthetic */ void advised$deleteGlobalInterestRate(GlobalInterestRateController this_, GlobalInterestRate globalInterestRate) {
        globalInterestRate.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="description", required=false) LocalizedString description, @RequestParam(value="rate", required=false) BigDecimal rate, Model model) {
        List<GlobalInterestRate> searchglobalinterestrateResultsDataSet = this.filterSearchGlobalInterestRate(description, rate);
        model.addAttribute("searchglobalinterestrateResultsDataSet", searchglobalinterestrateResultsDataSet);
        return "treasury/administration/base/manageglobalinterestrate/globalinterestrate/search";
    }

    private Stream<GlobalInterestRate> getSearchUniverseSearchGlobalInterestRateDataSet() {
        return GlobalInterestRate.findAll();
    }

    private List<GlobalInterestRate> filterSearchGlobalInterestRate(LocalizedString description, BigDecimal rate) {
        return this.getSearchUniverseSearchGlobalInterestRateDataSet().filter(globalInterestRate -> description == null || description.isEmpty() || description.getLocales().stream().allMatch(locale -> globalInterestRate.getDescription().getContent(locale) != null && globalInterestRate.getDescription().getContent(locale).toLowerCase().contains(description.getContent(locale).toLowerCase()))).filter(globalInterestRate -> rate == null || rate.equals(globalInterestRate.getRate())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") GlobalInterestRate globalInterestRate, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + globalInterestRate.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") GlobalInterestRate globalInterestRate, Model model) {
        this.setGlobalInterestRate(globalInterestRate, model);
        return "treasury/administration/base/manageglobalinterestrate/globalinterestrate/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") GlobalInterestRate globalInterestRate, Model model, RedirectAttributes redirectAttributes) {
        this.setGlobalInterestRate(globalInterestRate, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deleteGlobalInterestRate(globalInterestRate);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getGlobalInterestRate(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/base/manageglobalinterestrate/globalinterestrate/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="year", required=false) int year, @RequestParam(value="description", required=false) LocalizedString description, @RequestParam(value="rate", required=false) BigDecimal rate, @RequestParam(value="applypaymentmonth", required=false) boolean applyPaymentMonth, @RequestParam(value="applyinfirstworkday", required=false) boolean applyInFirstWorkday, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            GlobalInterestRate globalInterestRate = this.createGlobalInterestRate(year, description, rate, applyPaymentMonth, applyInFirstWorkday);
            model.addAttribute("globalInterestRate", (Object)globalInterestRate);
            return this.redirect(READ_URL + this.getGlobalInterestRate(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public GlobalInterestRate createGlobalInterestRate(int n, LocalizedString localizedString, BigDecimal bigDecimal, boolean bl, boolean bl2) {
        return (GlobalInterestRate)((Object)advice$createGlobalInterestRate.perform((Callable)new GlobalInterestRateController$callable$createGlobalInterestRate(this, n, localizedString, bigDecimal, bl, bl2)));
    }

    static /* synthetic */ GlobalInterestRate advised$createGlobalInterestRate(GlobalInterestRateController this_, int year, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        GlobalInterestRate globalInterestRate = GlobalInterestRate.create(year, description, rate, applyPaymentMonth, applyInFirstWorkday);
        return globalInterestRate;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") GlobalInterestRate globalInterestRate, Model model) {
        this.setGlobalInterestRate(globalInterestRate, model);
        return "treasury/administration/base/manageglobalinterestrate/globalinterestrate/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") GlobalInterestRate globalInterestRate, @RequestParam(value="year", required=false) int year, @RequestParam(value="description", required=false) LocalizedString description, @RequestParam(value="rate", required=false) BigDecimal rate, @RequestParam(value="applypaymentmonth", required=false) boolean applyPaymentMonth, @RequestParam(value="applyinfirstworkday", required=false) boolean applyInFirstWorkday, Model model, RedirectAttributes redirectAttributes) {
        this.setGlobalInterestRate(globalInterestRate, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updateGlobalInterestRate(year, description, rate, applyPaymentMonth, applyInFirstWorkday, model);
            return this.redirect(READ_URL + this.getGlobalInterestRate(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(globalInterestRate, model);
    }

    public void updateGlobalInterestRate(int n, LocalizedString localizedString, BigDecimal bigDecimal, boolean bl, boolean bl2, Model model) {
        Object object = advice$updateGlobalInterestRate.perform((Callable)new GlobalInterestRateController$callable$updateGlobalInterestRate(this, n, localizedString, bigDecimal, bl, bl2, model));
    }

    static /* synthetic */ void advised$updateGlobalInterestRate(GlobalInterestRateController this_, int year, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday, Model model) {
        this_.getGlobalInterestRate(model).edit(year, description, rate, applyPaymentMonth, applyInFirstWorkday);
    }
}

