/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileDetailLine;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileFooter;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileHeader;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class SibsPaymentsBrokerService {
    public static final String ERROR_SIBS_PAYMENTS_BROKER_SERVICE_NO_PAYMENTS_TO_IMPORT = "error.SibsPaymentsBrokerService.no.payments.to.import";
    private static final String PAY_PREAMBLE = "E034";
    private static final String DATE_TIME_FORMAT = "yyyyMMddHHmm";
    private static final int[] FIELD_SIZES = new int[]{4, 2, 2, 4, 8, 5, 9, 10, 3, 12, 2, 10, 5, 15, 9, 8};
    private static final Integer DEFAULT_SIBS_VERSION = 1;

    public static String getPaymentsFromBroker(FinantialInstitution finantialInstitution, LocalDate fromDate, LocalDate toDate, boolean removeInexistentReferenceCodes, boolean removeAlreadyProcessedCodes) {
        if (!SibsPaymentsBrokerService.isSibsPaymentsBrokerActive(finantialInstitution)) {
            throw new TreasuryDomainException("error.SibsPaymentsBrokerService.not.active", new String[0]);
        }
        String url = finantialInstitution.getSibsConfiguration().getSibsPaymentsBrokerUrl();
        String key = finantialInstitution.getSibsConfiguration().getSibsPaymentsBrokerSharedKey();
        String dtInicio = fromDate.toString("yyyy-MM-dd");
        String dtFim = toDate.toString("yyyy-MM-dd");
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(url);
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"secret", (Object)key);
        formData.add((Object)"dt_inicio", (Object)dtInicio);
        formData.add((Object)"dt_fim", (Object)dtFim);
        formData.add((Object)"v", (Object)"2");
        Response response = target.request().post(Entity.form((MultivaluedMap)formData));
        String strResult = (String)response.readEntity(String.class);
        return strResult;
    }

    public static SibsIncommingPaymentFile readPaymentsFromBroker(FinantialInstitution finantialInstitution, LocalDate fromDate, LocalDate toDate, boolean removeInexistentReferenceCodes, boolean removeAlreadyProcessedCodes) {
        if (!SibsPaymentsBrokerService.isSibsPaymentsBrokerActive(finantialInstitution)) {
            throw new TreasuryDomainException("error.SibsPaymentsBrokerService.not.active", new String[0]);
        }
        String strResult = SibsPaymentsBrokerService.getPaymentsFromBroker(finantialInstitution, fromDate, toDate, removeInexistentReferenceCodes, removeAlreadyProcessedCodes);
        SibsPayments sibsPayments = (SibsPayments)new GsonBuilder().create().fromJson(strResult, SibsPayments.class);
        if (sibsPayments == null) {
            throw new TreasuryDomainException("error.SibsPaymentsBrokerService.unable.parse.information", new String[0]);
        }
        if (!Strings.isNullOrEmpty((String)sibsPayments.error)) {
            throw new TreasuryDomainException("error.SibsPaymentsBrokerService.error.returned.by.broker", sibsPayments.error);
        }
        return SibsPaymentsBrokerService.parsePayments(finantialInstitution, sibsPayments, removeInexistentReferenceCodes, removeAlreadyProcessedCodes);
    }

    private static SibsIncommingPaymentFile parsePayments(FinantialInstitution finantialInstitution, SibsPayments sibsPayments, boolean removeInexistentReferenceCodes, boolean removeAlreadyProcessedCodes) {
        ArrayList detailLines = Lists.newArrayList();
        BigDecimal transactionsTotalAmount = BigDecimal.ZERO;
        for (SibsPaymentEntry entry : sibsPayments.data) {
            String referenceCode = SibsPaymentsBrokerService.getCodeFrom(entry);
            String entityReferenceCode = SibsPaymentsBrokerService.getEntityCodeFrom(entry);
            DateTime whenOccuredTransactionFrom = SibsPaymentsBrokerService.getWhenOccuredTransactionFrom(entry);
            if (!finantialInstitution.getSibsConfiguration().getEntityReferenceCode().equals(entityReferenceCode) || removeInexistentReferenceCodes && PaymentReferenceCode.findByReferenceCode(referenceCode, finantialInstitution).count() == 0L) continue;
            SibsIncommingPaymentFileDetailLine line = new SibsIncommingPaymentFileDetailLine(whenOccuredTransactionFrom, SibsPaymentsBrokerService.getAmountFrom(entry), SibsPaymentsBrokerService.getSibsTransactionIdFrom(entry), referenceCode);
            if (removeAlreadyProcessedCodes && SibsTransactionDetail.isReferenceProcessingDuplicate(referenceCode, entityReferenceCode, whenOccuredTransactionFrom)) continue;
            detailLines.add(line);
            transactionsTotalAmount = transactionsTotalAmount.add(line.getAmount());
        }
        SibsIncommingPaymentFileHeader header = new SibsIncommingPaymentFileHeader(new YearMonthDay(), DEFAULT_SIBS_VERSION, finantialInstitution.getSibsConfiguration().getEntityReferenceCode());
        SibsIncommingPaymentFileFooter footer = new SibsIncommingPaymentFileFooter(transactionsTotalAmount, BigDecimal.ZERO);
        if (detailLines.isEmpty()) {
            throw new TreasuryDomainException(ERROR_SIBS_PAYMENTS_BROKER_SERVICE_NO_PAYMENTS_TO_IMPORT, new String[0]);
        }
        return new SibsIncommingPaymentFile(String.format("SIBS_%s.inp", new DateTime().toString("yyyyMMddHHmmss")), header, footer, detailLines);
    }

    public static String getEntityCodeFrom(SibsPaymentEntry entry) {
        return entry.entityReferenceCode;
    }

    private static String getCodeFrom(SibsPaymentEntry entry) {
        return entry.referenceCode;
    }

    private static String getSibsTransactionIdFrom(SibsPaymentEntry entry) {
        return entry.sibsTransactionId;
    }

    private static BigDecimal getAmountFrom(SibsPaymentEntry entry) {
        return BigDecimal.valueOf(Double.parseDouble(entry.amount.substring(0, 8) + "." + entry.amount.substring(8)));
    }

    private static DateTime getWhenOccuredTransactionFrom(SibsPaymentEntry entry) {
        try {
            return new DateTime((Object)new SimpleDateFormat(DATE_TIME_FORMAT).parse(entry.whenOccuredTransaction));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static final String[] splitLine(String line) {
        int lastIndex = 0;
        String[] result = new String[FIELD_SIZES.length];
        for (int i = 0; i < FIELD_SIZES.length; ++i) {
            result[i] = line.substring(lastIndex, lastIndex + FIELD_SIZES[i]);
            lastIndex += FIELD_SIZES[i];
        }
        return result;
    }

    public static boolean isSibsPaymentsBrokerActive(FinantialInstitution finantialInstitution) {
        return !Strings.isNullOrEmpty((String)finantialInstitution.getSibsConfiguration().getSibsPaymentsBrokerUrl());
    }

    private static class SibsPayments {
        private String error;
        private List<SibsPaymentEntry> data;

        private SibsPayments() {
        }
    }

    private static class SibsPaymentEntry {
        private String sibsTransactionId;
        private String entityReferenceCode;
        private String referenceCode;
        private String amount;
        private String whenOccuredTransaction;

        private SibsPaymentEntry() {
        }
    }
}

