/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationFileDTO;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileDetailLine;
import org.joda.time.DateTime;

public class SIBSImportationLineDTO {
    protected SibsIncommingPaymentFileDetailLine line;
    protected PaymentReferenceCode paymentCode;
    protected SibsReportFile report;
    private SIBSImportationFileDTO sibsImportationFileDTO;

    public SIBSImportationLineDTO(SIBSImportationFileDTO sibsImportationFileDTO, SibsIncommingPaymentFileDetailLine line) {
        this.line = line;
        this.paymentCode = PaymentReferenceCode.readByCode(line.getCode(), sibsImportationFileDTO.getFinantialInstitution());
        if (this.paymentCode != null) {
            this.report = this.paymentCode.getReportOnDate(this.getTransactionWhenRegistered());
        }
        this.setSibsImportationFileDTO(sibsImportationFileDTO);
    }

    public DateTime getWhenProcessedBySibs() {
        return this.getSibsImportationFileDTO().getWhenProcessedBySibs();
    }

    public String getFilename() {
        return this.getSibsImportationFileDTO().getFilename();
    }

    public BigDecimal getTransactionsTotalAmount() {
        return this.getSibsImportationFileDTO().getTransactionsTotalAmount();
    }

    public BigDecimal getTotalCost() {
        return this.getSibsImportationFileDTO().getTotalCost();
    }

    public Integer getFileVersion() {
        return this.getSibsImportationFileDTO().getFileVersion();
    }

    public String getSibsTransactionId() {
        return this.line.getSibsTransactionId();
    }

    public BigDecimal getTransactionTotalAmount() {
        return this.line.getAmount();
    }

    public DateTime getTransactionWhenRegistered() {
        return this.line.getWhenOccuredTransaction();
    }

    public String getCode() {
        return this.line.getCode();
    }

    public PaymentReferenceCode getPaymentCode() {
        return this.paymentCode;
    }

    public boolean hasPaymentCode() {
        return this.getPaymentCode() != null;
    }

    protected SibsReportFile getReport() {
        return this.report;
    }

    public Integer getNumberOfTransactions() {
        if (!this.hasPaymentCode()) {
            return 0;
        }
        if (this.getReport() == null) {
            return 0;
        }
        return this.getReport().getNumberOfTransactions();
    }

    public String getTransactionDescription(Integer index) {
        if (this.getReport() != null) {
            return this.getReport().getTransactionDescription(index);
        }
        return "";
    }

    public BigDecimal getTransactionAmount(Integer index) {
        if (this.getReport() != null) {
            return this.getReport().getTransactionAmount(index);
        }
        return BigDecimal.ZERO;
    }

    public String getPersonName() {
        if (!this.hasPaymentCode() || this.getPaymentCode().getTargetPayment() == null) {
            return null;
        }
        if (this.getPaymentCode().getTargetPayment().getDebtAccount() == null) {
            return "----";
        }
        return this.getPaymentCode().getTargetPayment().getDebtAccount().getCustomer().getName();
    }

    public String getStudentNumber() {
        if (!this.hasPaymentCode() || this.getPaymentCode().getTargetPayment() == null) {
            return null;
        }
        if (this.getPaymentCode().getTargetPayment().getDebtAccount() == null) {
            return "----";
        }
        return this.getPaymentCode().getTargetPayment().getDebtAccount().getCustomer().getBusinessIdentification();
    }

    public String getDescription() {
        Set noteSet;
        if (!this.hasPaymentCode() || this.getPaymentCode().getTargetPayment() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.getPaymentCode().getTargetPayment().getSettlementNotesSet() != null && !(noteSet = this.getPaymentCode().getTargetPayment().getSettlementNotesSet().stream().filter(x -> x.getDocumentDate().equals((Object)this.getTransactionWhenRegistered())).collect(Collectors.toSet())).isEmpty()) {
            sb.append("Nota de Pagamento: " + String.join((CharSequence)", ", noteSet.stream().map(s -> s.getUiDocumentNumber()).collect(Collectors.toSet())) + "\n");
        }
        sb.append(this.getPaymentCode().getTargetPayment().getDescription());
        return sb.toString();
    }

    public SIBSImportationFileDTO getSibsImportationFileDTO() {
        return this.sibsImportationFileDTO;
    }

    public void setSibsImportationFileDTO(SIBSImportationFileDTO sibsImportationFileDTO) {
        this.sibsImportationFileDTO = sibsImportationFileDTO;
    }
}

