/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paymentscodegenerator;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.CheckDigitGenerator;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.PaymentCodeGenerator;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SequentialPaymentWithCheckDigitCodeGenerator$callable$generateNewCodeFor;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SequentialPaymentWithCheckDigitCodeGenerator$callable$generateNewCodeFor$1;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SequentialPaymentWithCheckDigitCodeGenerator
extends PaymentCodeGenerator {
    private static final int NUM_CONTROL_DIGITS = 2;
    private final PaymentCodePool referenceCodePool;
    public static final Advice advice$generateNewCodeFor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$generateNewCodeFor$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @Override
    public PaymentCodePool getReferenceCodePool() {
        return this.referenceCodePool;
    }

    public SequentialPaymentWithCheckDigitCodeGenerator(PaymentCodePool pool) {
        this.referenceCodePool = pool;
    }

    @Override
    public PaymentReferenceCode generateNewCodeFor(BigDecimal bigDecimal, LocalDate localDate, LocalDate localDate2, boolean bl) {
        return (PaymentReferenceCode)((Object)advice$generateNewCodeFor.perform((Callable)new SequentialPaymentWithCheckDigitCodeGenerator$callable$generateNewCodeFor(this, bigDecimal, localDate, localDate2, bl)));
    }

    static /* synthetic */ PaymentReferenceCode advised$generateNewCodeFor(SequentialPaymentWithCheckDigitCodeGenerator this_, BigDecimal amount, LocalDate validFrom, LocalDate validTo, boolean useFixedAmount) {
        return this_.generateNewCodeFor(amount, validFrom, validTo, useFixedAmount, false);
    }

    @Override
    public PaymentReferenceCode generateNewCodeFor(BigDecimal bigDecimal, LocalDate localDate, LocalDate localDate2, boolean bl, boolean bl2) {
        return (PaymentReferenceCode)((Object)advice$generateNewCodeFor$1.perform((Callable)new SequentialPaymentWithCheckDigitCodeGenerator$callable$generateNewCodeFor$1(this, bigDecimal, localDate, localDate2, bl, bl2)));
    }

    static /* synthetic */ PaymentReferenceCode advised$generateNewCodeFor(SequentialPaymentWithCheckDigitCodeGenerator this_, BigDecimal amount, LocalDate validFrom, LocalDate validTo, boolean useFixedAmount, boolean forceGeneration) {
        Long nextReferenceCode;
        if (validFrom == null) {
            validFrom = this_.referenceCodePool.getValidFrom();
        }
        if (validTo == null) {
            validTo = this_.referenceCodePool.getValidTo();
        }
        if ((nextReferenceCode = this_.referenceCodePool.getAndIncrementNextReferenceCode()) > this_.referenceCodePool.getMaxReferenceCode()) {
            PaymentReferenceCode availableReferenceCode = this_.referenceCodePool.getPaymentReferenceCodesSet().stream().filter(x -> x.isAvailableForReuse()).findFirst().orElse(null);
            if (availableReferenceCode != null) {
                nextReferenceCode = Long.parseLong(availableReferenceCode.getReferenceCodeWithoutCheckDigits());
            } else {
                throw new TreasuryDomainException("error.PaymentCodeGenerator.not.paymentreferences.available.in.pool", new String[0]);
            }
        }
        String referenceCodeString = "";
        referenceCodeString = CheckDigitGenerator.generateReferenceCodeWithCheckDigit(this_.referenceCodePool.getEntityReferenceCode(), "" + nextReferenceCode, amount);
        BigDecimal minAmount = this_.referenceCodePool.getMinAmount();
        BigDecimal maxAmount = this_.referenceCodePool.getMaxAmount();
        if (useFixedAmount) {
            minAmount = amount;
            maxAmount = amount;
        }
        PaymentReferenceCode newPaymentReference = PaymentReferenceCode.create(referenceCodeString, validFrom, validTo, PaymentReferenceCodeStateType.UNUSED, this_.referenceCodePool, minAmount, maxAmount);
        newPaymentReference.setPayableAmount(amount);
        return newPaymentReference;
    }

    @Override
    public boolean isCodeMadeByThisFactory(PaymentReferenceCode paymentCode) {
        return paymentCode.getPaymentCodePool().equals(this);
    }

    protected Set<PaymentReferenceCode> allPaymentCodes(PaymentCodePool referenceCodePool) {
        return referenceCodePool.getPaymentReferenceCodesSet();
    }
}

