/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.singap.siag;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.qubit.solution.fenixedu.bennu.webservices.domain.webservice.WebServiceClientConfiguration;
import com.qubit.solution.fenixedu.bennu.webservices.domain.webservice.WebServiceConfiguration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.treasury.domain.AdhocCustomer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.AddressStructure;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.AddressStructurePT;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.AuditFile;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.Customer;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.Header;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.MovementTax;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.OrderReferences;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.PaymentMethod;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.SAFTPTMovementTaxType;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.SAFTPTSettlementType;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.SAFTPTSourceBilling;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.SAFTPTSourcePayment;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.SourceDocuments;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.Tax;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.TaxTable;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.TaxTableEntry;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.ReimbursementStateBean;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.SIAGExternalService;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.SINGAPWCFExternalService;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.SaftConfig;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagExporter$callable$createSaftExportOperation;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagExporter$callable$deprecated_retryExportToIntegration;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagExporter$callable$exportCustomersToIntegration;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagExporter$callable$exportFinantialDocumentToIntegration;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagExporter$callable$exportProductsToIntegration;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagExporter$callable$writeContentToExportOperation;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SingapSiagExporter
implements IERPExporter {
    private static final String WINDOWS_1252 = "Windows-1252";
    private static Logger logger;
    public static final String ERP_HEADER_VERSION_1_00_00 = "1.0.3";
    private static final String SAFT_PT_ENCODING = "Windows-1252";
    public static final Advice advice$createSaftExportOperation;
    public static final Advice advice$writeContentToExportOperation;
    public static final Advice advice$exportFinantialDocumentToIntegration;
    public static final Advice advice$exportCustomersToIntegration;
    public static final Advice advice$exportProductsToIntegration;
    public static final Advice advice$deprecated_retryExportToIntegration;

    private String generateERPFile(FinantialInstitution institution, DateTime fromDate, DateTime toDate, List<? extends FinantialDocument> allDocuments, Boolean generateAllCustomers, Boolean generateAllProducts, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        int i;
        SingapSiagExporter.checkForUnsetDocumentSeriesNumberInDocumentsToExport(allDocuments);
        AuditFile auditFile = new AuditFile();
        Header header = this.createSAFTHeader(fromDate, toDate, institution, ERP_HEADER_VERSION_1_00_00);
        auditFile.setHeader(header);
        AuditFile.MasterFiles masterFiles = new AuditFile.MasterFiles();
        auditFile.setMasterFiles(masterFiles);
        List<org.fenixedu.treasury.generated.sources.saft.singap.siag.Product> productList = masterFiles.getProduct();
        HashMap<String, org.fenixedu.treasury.generated.sources.saft.singap.siag.Product> productMap = new HashMap<String, org.fenixedu.treasury.generated.sources.saft.singap.siag.Product>();
        HashSet<String> productCodes = new HashSet<String>();
        List<Customer> customerList = masterFiles.getCustomer();
        HashMap<String, Customer> customerMap = new HashMap<String, Customer>();
        if (generateAllCustomers.booleanValue()) {
            logger.info("Reading all Customers in Institution " + institution.getCode());
            HashSet<org.fenixedu.treasury.domain.Customer> allCustomers = new HashSet<org.fenixedu.treasury.domain.Customer>();
            for (Object debt : institution.getDebtAccountsSet()) {
                allCustomers.add(debt.getCustomer());
            }
            i = 0;
            for (org.fenixedu.treasury.domain.Customer customer : allCustomers) {
                Customer saftCustomer = this.convertCustomerToSAFTCustomer(customer);
                customerMap.put(saftCustomer.getCustomerID(), saftCustomer);
                if (++i % 100 != 0) continue;
                logger.info("Processing " + i + "/" + allCustomers.size() + " Customers in Institution " + institution.getCode());
            }
        }
        if (generateAllProducts.booleanValue()) {
            logger.info("Reading all Customers in Institution " + institution.getCode());
            Set allProducts = institution.getAvailableProductsSet();
            i = 0;
            for (Product product : allProducts) {
                if (!productCodes.contains(product.getCode())) {
                    org.fenixedu.treasury.generated.sources.saft.singap.siag.Product saftProduct = this.convertProductToSAFTProduct(product);
                    productCodes.add(product.getCode());
                    productMap.put(saftProduct.getProductCode(), saftProduct);
                }
                if (++i % 100 != 0) continue;
                logger.info("Processing " + i + "/" + allProducts.size() + " Products in Institution " + institution.getCode());
            }
        }
        TaxTable taxTable = new TaxTable();
        masterFiles.setTaxTable(taxTable);
        for (Vat vat : institution.getVatsSet()) {
            if (!vat.isActiveNow()) continue;
            taxTable.getTaxTableEntry().add(this.convertVATtoTaxTableEntry(vat, institution));
        }
        SourceDocuments sourceDocuments = new SourceDocuments();
        auditFile.setSourceDocuments(sourceDocuments);
        SourceDocuments.SalesInvoices invoices = new SourceDocuments.SalesInvoices();
        SourceDocuments.WorkingDocuments workingDocuments = new SourceDocuments.WorkingDocuments();
        SourceDocuments.Payments paymentsDocuments = new SourceDocuments.Payments();
        BigInteger numberOfPaymentsDocuments = BigInteger.ZERO;
        BigDecimal totalDebitOfPaymentsDocuments = BigDecimal.ZERO;
        BigDecimal totalCreditOfPaymentsDocuments = BigDecimal.ZERO;
        BigInteger numberOfWorkingDocuments = BigInteger.ZERO;
        BigDecimal totalDebitOfWorkingDocuments = BigDecimal.ZERO;
        BigDecimal totalCreditOfWorkingDocuments = BigDecimal.ZERO;
        invoices.setNumberOfEntries(BigInteger.ZERO);
        invoices.setTotalCredit(BigDecimal.ZERO);
        invoices.setTotalDebit(BigDecimal.ZERO);
        for (FinantialDocument finantialDocument : allDocuments) {
            if ((finantialDocument.isCreditNote() || finantialDocument.isDebitNote()) && (finantialDocument.isClosed() || finantialDocument.isAnnulled())) {
                try {
                    SourceDocuments.WorkingDocuments.WorkDocument workDocument = this.convertToSAFTWorkDocument((Invoice)((Object)finantialDocument), customerMap, productMap);
                    workingDocuments.getWorkDocument().add(workDocument);
                    numberOfWorkingDocuments = numberOfWorkingDocuments.add(BigInteger.ONE);
                    if (finantialDocument.isAnnulled()) continue;
                    if (finantialDocument.isDebitNote()) {
                        totalDebitOfWorkingDocuments = totalDebitOfWorkingDocuments.add(workDocument.getDocumentTotals().getNetTotal());
                        continue;
                    }
                    if (!finantialDocument.isCreditNote()) continue;
                    totalCreditOfWorkingDocuments = totalCreditOfWorkingDocuments.add(workDocument.getDocumentTotals().getNetTotal());
                    continue;
                }
                catch (Exception ex) {
                    logger.error("Error processing document " + finantialDocument.getUiDocumentNumber() + ": " + ex.getLocalizedMessage());
                    throw ex;
                }
            }
            if (finantialDocument.isSettlementNote()) continue;
            logger.info("Ignoring document " + finantialDocument.getUiDocumentNumber() + " because is not closed yet.");
        }
        workingDocuments.setNumberOfEntries(numberOfWorkingDocuments);
        workingDocuments.setTotalCredit(totalCreditOfWorkingDocuments.setScale(2, RoundingMode.HALF_EVEN));
        workingDocuments.setTotalDebit(totalDebitOfWorkingDocuments.setScale(2, RoundingMode.HALF_EVEN));
        sourceDocuments.setWorkingDocuments(workingDocuments);
        paymentsDocuments.setNumberOfEntries(BigInteger.ZERO);
        paymentsDocuments.setTotalCredit(BigDecimal.ZERO);
        paymentsDocuments.setTotalDebit(BigDecimal.ZERO);
        for (FinantialDocument finantialDocument : allDocuments) {
            SingapSiagExporter.checkForUnsetDocumentSeriesNumberInDocumentsToExport(Lists.newArrayList((Object[])new FinantialDocument[]{finantialDocument}));
            if (finantialDocument.isSettlementNote() && (finantialDocument.isClosed() || finantialDocument.isAnnulled())) {
                try {
                    SourceDocuments.Payments.Payment paymentDocument = this.convertToSAFTPaymentDocument((SettlementNote)((Object)finantialDocument), customerMap, productMap);
                    paymentsDocuments.getPayment().add(paymentDocument);
                    numberOfPaymentsDocuments = numberOfPaymentsDocuments.add(BigInteger.ONE);
                    if (finantialDocument.isAnnulled()) continue;
                    totalCreditOfPaymentsDocuments = totalCreditOfPaymentsDocuments.add(((SettlementNote)((Object)finantialDocument)).getTotalCreditAmount());
                    totalDebitOfPaymentsDocuments = totalDebitOfPaymentsDocuments.add(((SettlementNote)((Object)finantialDocument)).getTotalDebitAmount());
                    continue;
                }
                catch (Exception ex) {
                    logger.error("Error processing document " + finantialDocument.getUiDocumentNumber() + ": " + ex.getLocalizedMessage());
                    throw ex;
                }
            }
            if (!finantialDocument.isSettlementNote()) continue;
            logger.info("Ignoring document " + finantialDocument.getUiDocumentNumber() + " because is not closed yet.");
        }
        paymentsDocuments.setNumberOfEntries(numberOfPaymentsDocuments);
        paymentsDocuments.setTotalCredit(totalCreditOfPaymentsDocuments.setScale(2, RoundingMode.HALF_EVEN));
        paymentsDocuments.setTotalDebit(totalDebitOfPaymentsDocuments.setScale(2, RoundingMode.HALF_EVEN));
        sourceDocuments.setPayments(paymentsDocuments);
        for (Customer customer : customerMap.values()) {
            customerList.add(customer);
        }
        for (org.fenixedu.treasury.generated.sources.saft.singap.siag.Product product : productMap.values()) {
            productList.add(product);
        }
        if (preProcessFunctionBeforeSerialize != null) {
            auditFile = (AuditFile)preProcessFunctionBeforeSerialize.apply(auditFile);
        }
        String xml = this.exportAuditFileToXML(auditFile);
        logger.info("SAFT File export concluded with success.");
        return xml;
    }

    private SourceDocuments.Payments.Payment convertToSAFTPaymentDocument(SettlementNote document, Map<String, Customer> baseCustomers, Map<String, org.fenixedu.treasury.generated.sources.saft.singap.siag.Product> productMap) {
        SourceDocuments.Payments.Payment payment = new SourceDocuments.Payments.Payment();
        Customer customer = null;
        if (baseCustomers.containsKey(document.getDebtAccount().getCustomer().getCode())) {
            customer = baseCustomers.get(document.getDebtAccount().getCustomer().getCode());
        } else {
            customer = this.convertCustomerToSAFTCustomer(document.getDebtAccount().getCustomer());
            baseCustomers.put(customer.getCustomerID(), customer);
        }
        try {
            PaymentMethod method;
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = document.getDocumentDate();
            payment.setSystemEntryDate(this.convertToXMLDateTime(dataTypeFactory, documentDate));
            payment.setTransactionDate(this.convertToXMLDate(dataTypeFactory, documentDate));
            payment.setPaymentRefNo(document.getUiDocumentNumber());
            payment.setSourceID(document.getOriginDocumentNumber());
            payment.setCustomerID(document.getDebtAccount().getCustomer().getCode());
            SourceDocuments.Payments.Payment.DocumentStatus status = new SourceDocuments.Payments.Payment.DocumentStatus();
            if (document.isAnnulled()) {
                status.setPaymentStatus("A");
            } else {
                status.setPaymentStatus("N");
            }
            if (document.getVersioningUpdateDate() != null) {
                status.setPaymentStatusDate(this.convertToXMLDateTime(dataTypeFactory, document.getVersioningUpdateDate().getDate()));
                status.setSourceID(document.getVersioningUpdatedBy().getUsername());
            } else {
                status.setPaymentStatusDate(payment.getSystemEntryDate());
                status.setSourceID("");
            }
            status.setReason(document.getDocumentObservations());
            if (Boolean.TRUE.equals(document.getDocumentNumberSeries().getSeries().getExternSeries()) || Boolean.TRUE.equals(document.getDocumentNumberSeries().getSeries().getLegacy())) {
                status.setSourcePayment(SAFTPTSourcePayment.I);
            } else {
                status.setSourcePayment(SAFTPTSourcePayment.P);
            }
            payment.setDocumentStatus(status);
            if (Constants.isPositive(document.getTotalPayedAmount())) {
                for (PaymentEntry paymentEntry : document.getPaymentEntriesSet()) {
                    method = new PaymentMethod();
                    method.setPaymentAmount(paymentEntry.getPayedAmount().setScale(2, RoundingMode.HALF_EVEN));
                    method.setPaymentDate(this.convertToXMLDate(dataTypeFactory, document.getPaymentDate()));
                    method.setPaymentMechanism(this.convertToSAFTPaymentMechanism(paymentEntry.getPaymentMethod()));
                    payment.getPaymentMethod().add(method);
                }
                payment.setSettlementType(SAFTPTSettlementType.NL);
            } else if (Constants.isPositive(document.getTotalReimbursementAmount())) {
                for (ReimbursementEntry reimbursmentEntry : document.getReimbursementEntriesSet()) {
                    method = new PaymentMethod();
                    method.setPaymentAmount(reimbursmentEntry.getReimbursedAmount().setScale(2, RoundingMode.HALF_EVEN));
                    method.setPaymentDate(this.convertToXMLDate(dataTypeFactory, document.getPaymentDate()));
                    method.setPaymentMechanism(this.convertToSAFTPaymentMechanism(reimbursmentEntry.getPaymentMethod()));
                    payment.getPaymentMethod().add(method);
                    payment.setSettlementType(SAFTPTSettlementType.NR);
                }
            } else {
                PaymentMethod voidMethod = new PaymentMethod();
                voidMethod.setPaymentAmount(BigDecimal.ZERO);
                voidMethod.setPaymentDate(this.convertToXMLDate(dataTypeFactory, document.getPaymentDate()));
                voidMethod.setPaymentMechanism("OU");
                payment.getPaymentMethod().add(voidMethod);
                payment.setSettlementType(SAFTPTSettlementType.NN);
            }
            payment.setSourceID(document.getVersioningCreator());
            SourceDocuments.Payments.Payment.DocumentTotals docTotals = new SourceDocuments.Payments.Payment.DocumentTotals();
            List settlementEntriesList = document.getSettlemetEntriesSet().stream().sorted(SettlementEntry.COMPARATOR_BY_ENTRY_ORDER).collect(Collectors.toList());
            if (settlementEntriesList.size() != document.getSettlemetEntriesSet().size()) {
                throw new RuntimeException("error");
            }
            BigInteger i = BigInteger.ONE;
            for (SettlementEntry settlementEntry : settlementEntriesList) {
                SourceDocuments.Payments.Payment.Line line = new SourceDocuments.Payments.Payment.Line();
                line.setLineNumber(i);
                SourceDocuments.Payments.Payment.Line.SourceDocumentID sourceDocument = new SourceDocuments.Payments.Payment.Line.SourceDocumentID();
                sourceDocument.setLineNumber(BigInteger.valueOf(settlementEntry.getInvoiceEntry().getEntryOrder().intValue()));
                sourceDocument.setOriginatingON(settlementEntry.getInvoiceEntry().getFinantialDocument().getUiDocumentNumber());
                sourceDocument.setInvoiceDate(this.convertToXMLDate(dataTypeFactory, settlementEntry.getInvoiceEntry().getFinantialDocument().getDocumentDate()));
                sourceDocument.setDescription(settlementEntry.getDescription());
                line.getSourceDocumentID().add(sourceDocument);
                line.setSettlementAmount(BigDecimal.ZERO);
                if (settlementEntry.getInvoiceEntry().isDebitNoteEntry()) {
                    line.setDebitAmount(settlementEntry.getTotalAmount());
                } else if (settlementEntry.getInvoiceEntry().isCreditNoteEntry()) {
                    line.setCreditAmount(settlementEntry.getTotalAmount());
                }
                payment.getLine().add(line);
                i = i.add(BigInteger.ONE);
            }
            if (document.getAdvancedPaymentCreditNote() != null) {
                payment.setAdvancedPaymentCredit(new SourceDocuments.Payments.Payment.AdvancedPaymentCredit());
                payment.getAdvancedPaymentCredit().setCreditAmount(document.getAdvancedPaymentCreditNote().getTotalAmount().setScale(2, RoundingMode.HALF_EVEN));
                payment.getAdvancedPaymentCredit().setOriginatingON(document.getAdvancedPaymentCreditNote().getUiDocumentNumber());
                payment.getAdvancedPaymentCredit().setDescription(document.getAdvancedPaymentCreditNote().getDocumentObservations());
            }
            docTotals.setGrossTotal(document.getTotalAmount().setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setNetTotal(document.getTotalAmount().setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setTaxPayable(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_EVEN));
            payment.setDocumentTotals(docTotals);
            payment.setPeriod(document.getDocumentDate().getMonthOfYear());
            payment.setSourceID(document.getOriginDocumentNumber());
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return payment;
    }

    private XMLGregorianCalendar convertToXMLDateTime(DatatypeFactory dataTypeFactory, DateTime documentDate) {
        return dataTypeFactory.newXMLGregorianCalendar(documentDate.getYear(), documentDate.getMonthOfYear(), documentDate.getDayOfMonth(), documentDate.getHourOfDay(), documentDate.getMinuteOfHour(), documentDate.getSecondOfMinute(), 0, Integer.MIN_VALUE);
    }

    private XMLGregorianCalendar convertToXMLDate(DatatypeFactory dataTypeFactory, DateTime date) {
        return dataTypeFactory.newXMLGregorianCalendarDate(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), Integer.MIN_VALUE);
    }

    private String convertToSAFTPaymentMechanism(org.fenixedu.treasury.domain.PaymentMethod paymentMethod) {
        String code = paymentMethod.getCode();
        return paymentMethod.getCode();
    }

    private SourceDocuments.WorkingDocuments.WorkDocument convertToSAFTWorkDocument(Invoice document, Map<String, Customer> baseCustomers, Map<String, org.fenixedu.treasury.generated.sources.saft.singap.siag.Product> baseProducts) {
        SourceDocuments.WorkingDocuments.WorkDocument workDocument = new SourceDocuments.WorkingDocuments.WorkDocument();
        Customer customer = null;
        if (baseCustomers.containsKey(document.getDebtAccount().getCustomer().getCode())) {
            customer = baseCustomers.get(document.getDebtAccount().getCustomer().getCode());
        } else {
            customer = this.convertCustomerToSAFTCustomer(document.getDebtAccount().getCustomer());
            baseCustomers.put(customer.getCustomerID(), customer);
        }
        if (document instanceof AdvancedPaymentCreditNote && ((AdvancedPaymentCreditNote)((Object)document)).getAdvancedPaymentSettlementNote() != null) {
            SourceDocuments.WorkingDocuments.WorkDocument.AdvancedPayment advancedPayment = new SourceDocuments.WorkingDocuments.WorkDocument.AdvancedPayment();
            advancedPayment.setDescription("");
            advancedPayment.setOriginatingON(((AdvancedPaymentCreditNote)((Object)document)).getAdvancedPaymentSettlementNote().getUiDocumentNumber());
            workDocument.setAdvancedPayment(advancedPayment);
        }
        if (document.getPayorDebtAccount() != null && !baseCustomers.containsKey(document.getPayorDebtAccount().getCustomer().getCode())) {
            Customer payorCustomer = this.convertCustomerToSAFTCustomer(document.getPayorDebtAccount().getCustomer());
            baseCustomers.put(payorCustomer.getCustomerID(), payorCustomer);
        }
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = document.getDocumentDate();
            workDocument.setSystemEntryDate(this.convertToXMLDateTime(dataTypeFactory, documentDate));
            workDocument.setWorkDate(this.convertToXMLDate(dataTypeFactory, documentDate));
            workDocument.setDocumentNumber(document.getUiDocumentNumber());
            workDocument.setCustomerID(document.getDebtAccount().getCustomer().getCode());
            if (document.getPayorDebtAccount() != null) {
                workDocument.setPayorCustomerID(document.getPayorDebtAccount().getCustomer().getCode());
            }
            SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus status = new SourceDocuments.WorkingDocuments.WorkDocument.DocumentStatus();
            if (document.isAnnulled()) {
                status.setWorkStatus("A");
            } else {
                status.setWorkStatus("N");
            }
            if (document.getVersioningUpdateDate() != null) {
                status.setWorkStatusDate(this.convertToXMLDateTime(dataTypeFactory, document.getVersioningUpdateDate().getDate()));
                status.setSourceID(document.getVersioningUpdatedBy().getUsername());
            } else {
                status.setWorkStatusDate(workDocument.getSystemEntryDate());
                status.setSourceID("");
            }
            if (Boolean.TRUE.equals(document.getDocumentNumberSeries().getSeries().getExternSeries()) || Boolean.TRUE.equals(document.getDocumentNumberSeries().getSeries().getLegacy())) {
                status.setSourceBilling(SAFTPTSourceBilling.I);
            } else {
                status.setSourceBilling(SAFTPTSourceBilling.P);
            }
            workDocument.setDocumentStatus(status);
            SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals docTotals = new SourceDocuments.WorkingDocuments.WorkDocument.DocumentTotals();
            docTotals.setGrossTotal(document.getTotalAmount().setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setNetTotal(document.getTotalNetAmount().setScale(2, RoundingMode.HALF_EVEN));
            docTotals.setTaxPayable(document.getTotalAmount().subtract(document.getTotalNetAmount()).setScale(2, RoundingMode.HALF_EVEN));
            workDocument.setDocumentTotals(docTotals);
            workDocument.setWorkType("DC");
            workDocument.setPeriod(document.getDocumentDate().getMonthOfYear());
            workDocument.setSourceID(document.getOriginDocumentNumber());
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        List<SourceDocuments.WorkingDocuments.WorkDocument.Line> productLines = workDocument.getLine();
        BigInteger i = BigInteger.ONE;
        for (FinantialDocumentEntry docLine : document.getFinantialDocumentEntriesSet()) {
            InvoiceEntry orderNoteLine = (InvoiceEntry)((Object)docLine);
            SourceDocuments.WorkingDocuments.WorkDocument.Line line = this.convertToSAFTWorkDocumentLine(orderNoteLine, baseProducts);
            line.setLineNumber(BigInteger.valueOf(orderNoteLine.getEntryOrder().intValue()));
            i = i.add(BigInteger.ONE);
            productLines.add(line);
        }
        return workDocument;
    }

    private SourceDocuments.WorkingDocuments.WorkDocument.Line convertToSAFTWorkDocumentLine(InvoiceEntry entry, Map<String, org.fenixedu.treasury.generated.sources.saft.singap.siag.Product> baseProducts) {
        org.fenixedu.treasury.generated.sources.saft.singap.siag.Product currentProduct = null;
        Product product = entry.getProduct();
        if (product.getCode() != null && baseProducts.containsKey(product.getCode())) {
            currentProduct = baseProducts.get(product.getCode());
        } else {
            currentProduct = this.convertProductToSAFTProduct(product);
            baseProducts.put(currentProduct.getProductCode(), currentProduct);
        }
        XMLGregorianCalendar documentDateCalendar = null;
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            DateTime documentDate = entry.getFinantialDocument().getDocumentDate();
            documentDateCalendar = this.convertToXMLDate(dataTypeFactory, documentDate);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        SourceDocuments.WorkingDocuments.WorkDocument.Line line = new SourceDocuments.WorkingDocuments.WorkDocument.Line();
        if (entry.isCreditNoteEntry()) {
            line.setCreditAmount(entry.getAmount().setScale(2, RoundingMode.HALF_EVEN));
        } else if (entry.isDebitNoteEntry()) {
            line.setDebitAmount(entry.getAmount().setScale(2, RoundingMode.HALF_EVEN));
        }
        line.setDescription(entry.getDescription());
        List<OrderReferences> orderReferences = line.getOrderReferences();
        if (entry.isCreditNoteEntry()) {
            CreditEntry creditEntry = (CreditEntry)((Object)entry);
            if (creditEntry.getDebitEntry() != null) {
                SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata metadata = new SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata();
                metadata.setDescription(creditEntry.getDebitEntry().getERPIntegrationMetadata());
                line.setMetadata(metadata);
                OrderReferences reference = new OrderReferences();
                reference.setOriginatingON(creditEntry.getDebitEntry().getFinantialDocument().getUiDocumentNumber());
                reference.setOrderDate(documentDateCalendar);
                orderReferences.add(reference);
            }
        } else if (entry.isDebitNoteEntry()) {
            DebitEntry debitEntry = (DebitEntry)((Object)entry);
            SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata metadata = new SourceDocuments.WorkingDocuments.WorkDocument.Line.Metadata();
            metadata.setDescription(debitEntry.getERPIntegrationMetadata());
            line.setMetadata(metadata);
        }
        line.setProductCode(currentProduct.getProductCode());
        line.setProductDescription(currentProduct.getProductDescription());
        line.setQuantity(entry.getQuantity());
        line.setSettlementAmount(BigDecimal.ZERO);
        line.setTax(this.getSAFTWorkingDocumentsTax(product, entry));
        line.setTaxPointDate(documentDateCalendar);
        if (Constants.isEqual(line.getTax().getTaxPercentage(), BigDecimal.ZERO) || line.getTax().getTaxAmount() != null && Constants.isEqual(line.getTax().getTaxAmount(), BigDecimal.ZERO)) {
            if (product.getVatExemptionReason() != null) {
                line.setTaxExemptionReason(product.getVatExemptionReason().getCode() + "-" + product.getVatExemptionReason().getName().getContent());
            } else {
                line.setTaxExemptionReason(BundleUtil.getString((String)Constants.BUNDLE, (String)"warning.ERPExporter.vat.exemption.unknown", (String[])new String[0]));
            }
        }
        line.setUnitOfMeasure(product.getUnitOfMeasure().getContent());
        line.setUnitPrice(entry.getAmount().setScale(2, RoundingMode.HALF_EVEN));
        return line;
    }

    private Tax getSAFTWorkingDocumentsTax(Product product, InvoiceEntry entry) {
        Vat vat = entry.getVat();
        Tax tax = new Tax();
        tax.setTaxCode(vat.getVatType().getCode());
        tax.setTaxCountryRegion("PT");
        tax.setTaxPercentage(vat.getTaxRate());
        tax.setTaxType("IVA");
        return tax;
    }

    private TaxTableEntry convertVATtoTaxTableEntry(Vat vat, FinantialInstitution finantialInstitution) {
        TaxTableEntry entry = new TaxTableEntry();
        entry.setTaxType("IVA");
        entry.setTaxCode(vat.getVatType().getName().getContent());
        if (finantialInstitution.getFiscalNumber() != null) {
            entry.setTaxCountryRegion(finantialInstitution.getFiscalCountryRegion().getFiscalCode());
            entry.setDescription(finantialInstitution.getFiscalCountryRegion().getName().getContent() + "-" + vat.getVatType().getName().getContent());
        } else {
            entry.setTaxCountryRegion("PT");
            entry.setDescription("");
        }
        entry.setTaxCode(vat.getVatType().getCode());
        entry.setTaxPercentage(vat.getTaxRate());
        if (Strings.isNullOrEmpty((String)entry.getDescription())) {
            entry.setDescription(entry.getTaxCode() + "_" + entry.getTaxCountryRegion());
        }
        return entry;
    }

    private Header createSAFTHeader(DateTime startDate, DateTime endDate, FinantialInstitution finantialInstitution, String auditVersion) {
        Header header = new Header();
        try {
            DatatypeFactory dataTypeFactory = DatatypeFactory.newInstance();
            header.setAuditFileVersion(auditVersion);
            header.setBusinessName(finantialInstitution.getCompanyName());
            header.setCompanyName(finantialInstitution.getName());
            AddressStructurePT companyAddress = null;
            companyAddress = this.convertAddressToAddressPT(finantialInstitution.getAddress(), finantialInstitution.getZipCode(), finantialInstitution.getMunicipality() != null ? finantialInstitution.getMunicipality().getLocalizedName(new Locale("pt")) : "---", finantialInstitution.getAddress());
            header.setCompanyAddress(companyAddress);
            header.setCompanyID(finantialInstitution.getComercialRegistrationCode());
            header.setCurrencyCode(finantialInstitution.getCurrency().getCode());
            DateTime now = new DateTime();
            header.setDateCreated(this.convertToXMLDate(dataTypeFactory, now));
            header.setEndDate(this.convertToXMLDate(dataTypeFactory, endDate));
            header.setFiscalYear(endDate.getYear());
            header.setProductCompanyTaxID(SaftConfig.PRODUCT_COMPANY_TAX_ID());
            header.setProductID(SaftConfig.PRODUCT_ID());
            header.setProductVersion(SaftConfig.PRODUCT_VERSION());
            header.setSoftwareCertificateNumber(BigInteger.valueOf(SaftConfig.SOFTWARE_CERTIFICATE_NUMBER()));
            header.setStartDate(dataTypeFactory.newXMLGregorianCalendarDate(startDate.getYear(), startDate.getMonthOfYear(), startDate.getDayOfMonth(), Integer.MIN_VALUE));
            header.setTaxAccountingBasis("P");
            header.setTaxEntity("Global");
            try {
                header.setTaxRegistrationNumber(Integer.parseInt(finantialInstitution.getFiscalNumber()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid Fiscal Number.");
            }
            return header;
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private AddressStructurePT convertAddressToAddressPT(String addressDetail, String zipCode, String zipCodeRegion, String street) {
        AddressStructurePT companyAddress = new AddressStructurePT();
        companyAddress.setCountry("PT");
        companyAddress.setAddressDetail((String)Splitter.fixedLength((int)60).splitToList((CharSequence)addressDetail).get(0));
        companyAddress.setCity((String)Splitter.fixedLength((int)49).splitToList((CharSequence)zipCodeRegion).get(0));
        companyAddress.setPostalCode(zipCode);
        companyAddress.setRegion(zipCodeRegion);
        companyAddress.setStreetName((String)Splitter.fixedLength((int)49).splitToList((CharSequence)street).get(0));
        return companyAddress;
    }

    private String exportAuditFileToXML(AuditFile auditFile) {
        try {
            String cleanXMLAnotations = "xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"";
            String cleanXMLAnotations2 = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
            String cleanDateTimeMiliseconds = ".000<";
            String cleanStandaloneAnnotation = "standalone=\"yes\"";
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AuditFile.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"Windows-1252");
            marshaller.marshal((Object)auditFile, (Writer)writer);
            Charset charset = Charset.forName("Windows-1252");
            String xml = new String(charset.encode(writer.toString()).array(), "Windows-1252");
            xml = xml.replace("xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"", "");
            xml = xml.replace("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
            xml = xml.replace(".000<", "<");
            xml = xml.replace("standalone=\"yes\"", "");
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update(("SALTING WITH QUB:" + xml).getBytes("Windows-1252"));
                byte[] output = md.digest();
                String digestAscii = SingapSiagExporter.bytesToHex(output);
                xml = xml + "<!-- QUB-IT (remove this line,add the qubSALT, save with Windows-1252 encode): " + digestAscii + " -->\n";
            }
            catch (Exception exception) {
                // empty catch block
            }
            return xml;
        }
        catch (JAXBException e) {
            return "";
        }
        catch (UnsupportedEncodingException jex) {
            return "";
        }
    }

    public static String bytesToHex(byte[] b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buf = new StringBuffer();
        for (byte element : b) {
            buf.append(hexDigit[element >> 4 & 0xF]);
            buf.append(hexDigit[element & 0xF]);
        }
        return buf.toString();
    }

    private Customer convertCustomerToSAFTCustomer(org.fenixedu.treasury.domain.Customer customer) {
        Customer c = new Customer();
        if (customer.getCustomerType() != null) {
            c.setAccountID(customer.getCustomerType().getCode());
        } else if (customer instanceof AdhocCustomer) {
            c.setAccountID("ADHOC");
        } else {
            c.setAccountID("STUDENT");
        }
        c.setBillingAddress(this.convertAddressToSAFTAddress(customer.getCountryCode(), customer.getAddress(), customer.getZipCode(), customer.getDistrictSubdivision(), customer.getAddress()));
        c.setCompanyName(customer.getName());
        c.setContact(customer.getName());
        c.setCustomerID(customer.getCode());
        c.setCustomerBusinessID(customer.getBusinessIdentification());
        if (Strings.isNullOrEmpty((String)customer.getFiscalNumber())) {
            c.setCustomerTaxID("999999990");
        } else {
            c.setCustomerTaxID(customer.getFiscalNumber());
        }
        c.setSelfBillingIndicator(0);
        return c;
    }

    private AddressStructure convertAddressToSAFTAddress(String country, String addressDetail, String zipCode, String zipCodeRegion, String street) {
        AddressStructure companyAddress = new AddressStructure();
        if (Strings.isNullOrEmpty((String)country)) {
            companyAddress.setCountry("PT");
        } else {
            companyAddress.setCountry(country);
        }
        if (!Strings.isNullOrEmpty((String)addressDetail)) {
            companyAddress.setAddressDetail((String)Splitter.fixedLength((int)60).splitToList((CharSequence)addressDetail).get(0));
        } else {
            companyAddress.setAddressDetail(".");
        }
        if (!Strings.isNullOrEmpty((String)zipCodeRegion)) {
            companyAddress.setCity((String)Splitter.fixedLength((int)49).splitToList((CharSequence)zipCodeRegion).get(0));
        } else {
            companyAddress.setCity(".");
        }
        if (!Strings.isNullOrEmpty((String)zipCode)) {
            companyAddress.setPostalCode(zipCode);
        } else {
            companyAddress.setPostalCode(".");
        }
        if (!Strings.isNullOrEmpty((String)zipCodeRegion)) {
            companyAddress.setRegion(zipCodeRegion);
        } else {
            companyAddress.setRegion(".");
        }
        if (!Strings.isNullOrEmpty((String)street)) {
            companyAddress.setStreetName((String)Splitter.fixedLength((int)49).splitToList((CharSequence)street).get(0));
        } else {
            companyAddress.setStreetName(".");
        }
        return companyAddress;
    }

    private org.fenixedu.treasury.generated.sources.saft.singap.siag.Product convertProductToSAFTProduct(Product product) {
        org.fenixedu.treasury.generated.sources.saft.singap.siag.Product p = new org.fenixedu.treasury.generated.sources.saft.singap.siag.Product();
        p.setProductCode(product.getCode());
        p.setProductDescription(product.getName().getContent());
        if (product.getProductGroup() != null) {
            p.setProductGroup(product.getProductGroup().getName().getContent());
        }
        p.setProductNumberCode(p.getProductCode());
        p.setProductType("S");
        return p;
    }

    private MovementTax getSAFTMovementTax(Product product, Vat vat) {
        MovementTax tax = new MovementTax();
        tax.setTaxCode(vat.getVatType().getCode());
        tax.setTaxCountryRegion("PT");
        tax.setTaxPercentage(vat.getTaxRate());
        tax.setTaxType(SAFTPTMovementTaxType.IVA);
        return tax;
    }

    private Tax getSAFTInvoiceTax(Product product, Vat vat) {
        Tax tax = new Tax();
        tax.setTaxCode(vat.getVatType().getCode());
        tax.setTaxCountryRegion("PT");
        tax.setTaxPercentage(vat.getTaxRate());
        tax.setTaxType("IVA");
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ERPExportOperation exportFullToIntegration(FinantialInstitution institution, DateTime fromDate, DateTime toDate, String username, Boolean includeMovements) {
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this.createSaftExportOperation(null, institution, new DateTime());
        try {
            SingapSiagExporter saftExporter = new SingapSiagExporter();
            ArrayList<FinantialDocument> documents = new ArrayList<FinantialDocument>(institution.getExportableDocuments(fromDate, toDate));
            logger.info("Collecting " + documents.size() + " documents to export to institution " + institution.getCode());
            UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(institution);
            String xml = saftExporter.generateERPFile(institution, fromDate, toDate, documents, true, true, auditFilePreProcess);
            OperationFile operationFile = this.writeContentToExportOperation(xml, operation);
            boolean success = this.sendDocumentsInformationToIntegration(institution, operationFile, logBean);
            operation.getFinantialDocumentsSet().addAll(documents);
            operation.setSuccess(success);
        }
        catch (Throwable t) {
            this.writeError(operation, logBean, t);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    @Override
    public void requestPendingDocumentStatus(FinantialInstitution institution) {
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
        if (!erpIntegrationConfiguration.getActive()) {
            return;
        }
        IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
        List<String> documentNumbers = institution.getFinantialDocumentsPendingForExportationSet().stream().map(doc -> doc.getUiDocumentNumber()).collect(Collectors.toList());
        List<DocumentStatusWS> integrationStatusFor = service.getIntegrationStatusFor(institution.getFiscalNumber(), documentNumbers);
        for (DocumentStatusWS documentStatus : integrationStatusFor) {
            if (!documentStatus.isIntegratedWithSuccess()) continue;
            String message = Constants.treasuryBundle("info.ERPExporter.sucess.integrating.document", documentStatus.getDocumentNumber());
            FinantialDocument document = institution.getFinantialDocumentsPendingForExportationSet().stream().filter(x -> x.getUiDocumentNumber().equals(documentStatus.getDocumentNumber())).findFirst().orElse(null);
            if (document == null) continue;
            document.clearDocumentToExport(message);
        }
    }

    private boolean sendDocumentsInformationToIntegration(FinantialInstitution institution, OperationFile operationFile, IntegrationOperationLogBean logBean) throws MalformedURLException {
        DocumentsInformationOutput sendInfoOnlineResult;
        boolean success = true;
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
        if (!erpIntegrationConfiguration.getActive()) {
            logBean.appendErrorLog(Constants.treasuryBundle("info.ERPExporter.configuration.inactive", new String[0]));
            return false;
        }
        IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
        logBean.appendIntegrationLog(Constants.treasuryBundle("info.ERPExporter.sending.inforation", new String[0]));
        DocumentsInformationInput input = new DocumentsInformationInput();
        if (operationFile.getSize() <= erpIntegrationConfiguration.getMaxSizeBytesToExportOnline()) {
            input.setData(operationFile.getContent());
            sendInfoOnlineResult = service.sendInfoOnline(institution, input);
            logBean.appendIntegrationLog(Constants.treasuryBundle("info.ERPExporter.sucess.sending.inforation.online", sendInfoOnlineResult.getRequestId()));
            for (DocumentStatusWS status : sendInfoOnlineResult.getDocumentStatus()) {
                if (status.isIntegratedWithSuccess()) {
                    FinantialDocument document = FinantialDocument.findByUiDocumentNumber(institution, status.getDocumentNumber());
                    if (document != null) {
                        String message = Constants.treasuryBundle("info.ERPExporter.sucess.integrating.document", document.getUiDocumentNumber());
                        logBean.appendIntegrationLog(message);
                        document.clearDocumentToExport(message);
                        continue;
                    }
                    success = false;
                    logBean.appendIntegrationLog(Constants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                    logBean.appendErrorLog(Constants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                    continue;
                }
                success = false;
                logBean.appendIntegrationLog(Constants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
                logBean.appendErrorLog(Constants.treasuryBundle("info.ERPExporter.error.integrating.document", status.getDocumentNumber(), status.getErrorDescription()));
            }
        } else {
            throw new TreasuryDomainException("error.ERPExporter.sendDocumentsInformationToIntegration.maxSizeBytesToExportOnline.exceeded", new String[0]);
        }
        logBean.defineSoapInboundMessage(sendInfoOnlineResult.getSoapInboundMessage());
        logBean.defineSoapOutboundMessage(sendInfoOnlineResult.getSoapOutboundMessage());
        return success;
    }

    private void writeError(ERPExportOperation operation, IntegrationOperationLogBean logBean, Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        t.printStackTrace(writer);
        logBean.appendErrorLog(out.toString());
        operation.setProcessed(true);
    }

    private ERPExportOperation createSaftExportOperation(byte[] byArray, FinantialInstitution finantialInstitution, DateTime dateTime) {
        return (ERPExportOperation)((Object)advice$createSaftExportOperation.perform((Callable)new SingapSiagExporter$callable$createSaftExportOperation(this, byArray, finantialInstitution, dateTime)));
    }

    static /* synthetic */ ERPExportOperation advised$createSaftExportOperation(SingapSiagExporter this_, byte[] data, FinantialInstitution institution, DateTime when) {
        String filename = institution.getFiscalNumber() + "_" + when.toString() + ".xml";
        ERPExportOperation operation = ERPExportOperation.create(data, filename, institution, null, when, false, false, false);
        return operation;
    }

    private OperationFile writeContentToExportOperation(String string, ERPExportOperation eRPExportOperation) {
        return (OperationFile)((Object)advice$writeContentToExportOperation.perform((Callable)new SingapSiagExporter$callable$writeContentToExportOperation(this, string, eRPExportOperation)));
    }

    static /* synthetic */ OperationFile advised$writeContentToExportOperation(SingapSiagExporter this_, String content, ERPExportOperation operation) {
        byte[] bytes = null;
        try {
            bytes = content.getBytes("Windows-1252");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String fileName = operation.getFinantialInstitution().getFiscalNumber() + "_" + operation.getExecutionDate().toString("ddMMyyyy_hhmm") + ".xml";
        OperationFile binaryStream = new OperationFile(fileName, bytes);
        if (operation.getFile() != null) {
            operation.getFile().delete();
        }
        operation.setFile(binaryStream);
        return binaryStream;
    }

    @Override
    public String exportFinantialDocumentToXML(FinantialInstitution finantialInstitution, List<FinantialDocument> documents) {
        UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(finantialInstitution);
        return this.exportFinantialDocumentToXML(finantialInstitution, documents, auditFilePreProcess);
    }

    private String exportFinantialDocumentToXML(FinantialInstitution finantialInstitution, List<FinantialDocument> documents, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        SingapSiagExporter.checkForUnsetDocumentSeriesNumberInDocumentsToExport(documents);
        SingapSiagExporter saftExporter = new SingapSiagExporter();
        DateTime beginDate = ((FinantialDocument)((Object)documents.stream().min((x, y) -> x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate())).get())).getDocumentDate();
        DateTime endDate = ((FinantialDocument)((Object)documents.stream().max((x, y) -> x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate())).get())).getDocumentDate();
        return saftExporter.generateERPFile(finantialInstitution, beginDate, endDate, documents, false, false, preProcessFunctionBeforeSerialize);
    }

    private static void checkForUnsetDocumentSeriesNumberInDocumentsToExport(List<? extends FinantialDocument> documents) {
        for (FinantialDocument finantialDocument : documents) {
            if (finantialDocument.isDocumentSeriesNumberSet()) continue;
            throw new TreasuryDomainException("error.ERPExporter.document.without.number.series", new String[0]);
        }
    }

    @Override
    public String exportsProductsToXML(FinantialInstitution finantialInstitution) {
        UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(finantialInstitution);
        return this.exportsProductsToXML(finantialInstitution, auditFilePreProcess);
    }

    protected String exportsProductsToXML(FinantialInstitution finantialInstitution, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        SingapSiagExporter saftExporter = new SingapSiagExporter();
        return saftExporter.generateERPFile(finantialInstitution, new DateTime(), new DateTime(), new ArrayList(), false, true, preProcessFunctionBeforeSerialize);
    }

    @Override
    public String exportsCustomersToXML(FinantialInstitution finantialInstitution) {
        UnaryOperator<AuditFile> auditFilePreProcess = this.getAuditFilePreProcessOperator(finantialInstitution);
        return this.exportCustomersToXML(finantialInstitution, auditFilePreProcess);
    }

    protected String exportCustomersToXML(FinantialInstitution finantialInstitution, UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize) {
        SingapSiagExporter saftExporter = new SingapSiagExporter();
        return saftExporter.generateERPFile(finantialInstitution, new DateTime(), new DateTime(), new ArrayList(), true, false, preProcessFunctionBeforeSerialize);
    }

    @Override
    public ERPExportOperation exportFinantialDocumentToIntegration(FinantialInstitution finantialInstitution, List<FinantialDocument> list) {
        return (ERPExportOperation)((Object)advice$exportFinantialDocumentToIntegration.perform((Callable)new SingapSiagExporter$callable$exportFinantialDocumentToIntegration(this, finantialInstitution, list)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportFinantialDocumentToIntegration(SingapSiagExporter this_, FinantialInstitution institution, List documents) {
        SingapSiagExporter.checkForUnsetDocumentSeriesNumberInDocumentsToExport((List<? extends FinantialDocument>)documents);
        documents = documents.stream().filter(x -> x.isAnnulled() || x.isClosed()).collect(Collectors.toList());
        if (!institution.getErpIntegrationConfiguration().isIntegratedDocumentsExportationEnabled()) {
            documents = documents.stream().filter(x -> x.isDocumentToExport()).collect(Collectors.toList());
        }
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this_.createSaftExportOperation(null, institution, new DateTime());
        documents.forEach(document -> operation.addFinantialDocuments((FinantialDocument)((Object)document)));
        try {
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.starting.finantialdocuments.integration", new String[0]));
            UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize = this_.getAuditFilePreProcessOperator(institution);
            String xml = this_.exportFinantialDocumentToXML(institution, documents, preProcessFunctionBeforeSerialize);
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
            OperationFile operationFile = this_.writeContentToExportOperation(xml, operation);
            boolean success = this_.sendDocumentsInformationToIntegration(institution, operationFile, logBean);
            operation.getFinantialDocumentsSet().addAll(documents);
            operation.setSuccess(success);
        }
        catch (Exception ex) {
            this_.writeError(operation, logBean, ex);
        }
        finally {
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.finished.finantialdocuments.integration", new String[0]));
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    @Override
    public ERPExportOperation exportCustomersToIntegration(FinantialInstitution finantialInstitution) {
        return (ERPExportOperation)((Object)advice$exportCustomersToIntegration.perform((Callable)new SingapSiagExporter$callable$exportCustomersToIntegration(this, finantialInstitution)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportCustomersToIntegration(SingapSiagExporter this_, FinantialInstitution institution) {
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this_.createSaftExportOperation(null, institution, new DateTime());
        try {
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.starting.customers.integration", new String[0]));
            UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize = this_.getAuditFilePreProcessOperator(institution);
            String xml = this_.exportCustomersToXML(institution, preProcessFunctionBeforeSerialize);
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
            OperationFile operationFile = this_.writeContentToExportOperation(xml, operation);
            boolean success = this_.sendDocumentsInformationToIntegration(institution, operationFile, logBean);
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.finished.customers.integration", new String[0]));
            operation.setSuccess(success);
        }
        catch (Exception ex) {
            this_.writeError(operation, logBean, ex);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    @Override
    public ERPExportOperation exportProductsToIntegration(FinantialInstitution finantialInstitution) {
        return (ERPExportOperation)((Object)advice$exportProductsToIntegration.perform((Callable)new SingapSiagExporter$callable$exportProductsToIntegration(this, finantialInstitution)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$exportProductsToIntegration(SingapSiagExporter this_, FinantialInstitution institution) {
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPExportOperation operation = this_.createSaftExportOperation(null, institution, new DateTime());
        try {
            UnaryOperator<AuditFile> preProcessFunctionBeforeSerialize = this_.getAuditFilePreProcessOperator(institution);
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.starting.products.integration", new String[0]));
            String xml = this_.exportsProductsToXML(institution, preProcessFunctionBeforeSerialize);
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.erp.xml.content.generated", new String[0]));
            OperationFile operationFile = this_.writeContentToExportOperation(xml, operation);
            boolean success = this_.sendDocumentsInformationToIntegration(institution, operationFile, logBean);
            logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.finished.products.integration", new String[0]));
            operation.setSuccess(success);
        }
        catch (Exception ex) {
            this_.writeError(operation, logBean, ex);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return operation;
    }

    public ERPExportOperation deprecated_retryExportToIntegration(ERPExportOperation eRPExportOperation) {
        return (ERPExportOperation)((Object)advice$deprecated_retryExportToIntegration.perform((Callable)new SingapSiagExporter$callable$deprecated_retryExportToIntegration(this, eRPExportOperation)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ ERPExportOperation advised$deprecated_retryExportToIntegration(SingapSiagExporter this_, ERPExportOperation eRPExportOperation) {
        if (eRPExportOperation.getFinantialDocumentsSet().isEmpty()) {
            IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
            ERPExportOperation operation = this_.createSaftExportOperation(eRPExportOperation.getFile().getContent(), eRPExportOperation.getFinantialInstitution(), new DateTime());
            try {
                logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.starting.retry.integration", new String[0]));
                for (FinantialDocument document : eRPExportOperation.getFinantialDocumentsSet()) {
                    if (!eRPExportOperation.getFinantialInstitution().getErpIntegrationConfiguration().isIntegratedDocumentsExportationEnabled() && !document.isDocumentToExport()) continue;
                    operation.addFinantialDocuments(document);
                }
                boolean success = this_.sendDocumentsInformationToIntegration(eRPExportOperation.getFinantialInstitution(), eRPExportOperation.getFile(), logBean);
                operation.setSuccess(success);
            }
            catch (Exception ex) {
                this_.writeError(operation, logBean, ex);
            }
            finally {
                logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.finished.retry.integration", new String[0]));
                operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
            }
            return operation;
        }
        ArrayList<FinantialDocument> allDocuments = new ArrayList<FinantialDocument>(eRPExportOperation.getFinantialDocumentsSet());
        ERPExportOperation operation = this_.exportFinantialDocumentToIntegration(eRPExportOperation.getFinantialInstitution(), allDocuments);
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        logBean.appendIntegrationLog(Constants.treasuryBundle("label.ERPExporter.finished.retry.integration", new String[0]));
        operation.appendLog("", logBean.getIntegrationLog(), "", "");
        return operation;
    }

    @Override
    public void testExportToIntegration(FinantialInstitution institution) {
        ERPConfiguration erpIntegrationConfiguration = institution.getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
    }

    @Override
    public void checkIntegrationDocumentStatus(FinantialDocument document) {
        ERPConfiguration erpIntegrationConfiguration = document.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration();
        if (erpIntegrationConfiguration == null) {
            throw new TreasuryDomainException("error.ERPExporter.invalid.erp.configuration", new String[0]);
        }
        if (erpIntegrationConfiguration.getActive()) {
            return;
        }
        IERPExternalService service = erpIntegrationConfiguration.getERPExternalServiceImplementation();
        ArrayList<String> documentsList = new ArrayList<String>();
        documentsList.add(document.getUiDocumentNumber());
        List<DocumentStatusWS> integrationStatusFor = service.getIntegrationStatusFor(document.getDebtAccount().getFinantialInstitution().getFiscalNumber(), documentsList);
        for (DocumentStatusWS documentStatus : integrationStatusFor) {
            if (!documentStatus.getDocumentNumber().equals(document.getUiDocumentNumber()) || !documentStatus.isIntegratedWithSuccess()) continue;
            String message = Constants.treasuryBundle("info.ERPExporter.sucess.integrating.document", document.getUiDocumentNumber());
            document.clearDocumentToExport(message);
        }
    }

    private UnaryOperator<AuditFile> getAuditFilePreProcessOperator(FinantialInstitution finantialInstitution) {
        String className = finantialInstitution.getErpIntegrationConfiguration().getImplementationClassName();
        try {
            WebServiceClientConfiguration clientConfiguration = (WebServiceClientConfiguration)WebServiceConfiguration.readByImplementationClass((String)className);
            IERPExternalService client = (IERPExternalService)clientConfiguration.getClient();
            if (client instanceof SINGAPWCFExternalService) {
                return ((SINGAPWCFExternalService)client).getAuditFilePreProcessOperator();
            }
            if (client instanceof SIAGExternalService) {
                return ((SIAGExternalService)client).getAuditFilePreProcessOperator();
            }
            throw new RuntimeException("error");
        }
        catch (Exception e) {
            throw new TreasuryDomainException("error.ERPConfiguration.invalid.external.service", new String[0]);
        }
    }

    @Override
    public byte[] downloadCertifiedDocumentPrint(FinantialDocument finantialDocument) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ReimbursementStateBean checkReimbursementState(SettlementNote reimbursementNote) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String saftEncoding() {
        return "Windows-1252";
    }

    @Override
    public boolean isCustomerMaybeIntegratedWithSuccess(org.fenixedu.treasury.domain.Customer customer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean isCustomerWithFinantialDocumentsIntegratedInPreviousERP(org.fenixedu.treasury.domain.Customer customer) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public boolean isCustomerWithFinantialDocumentsIntegratedInERP(org.fenixedu.treasury.domain.Customer customer) {
        throw new RuntimeException("not implemented");
    }

    static {
        advice$createSaftExportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$writeContentToExportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$exportFinantialDocumentToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$exportCustomersToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$exportProductsToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$deprecated_retryExportToIntegration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(SingapSiagExporter.class);
    }
}

