/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.ReimbursementUtils;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.SettlementNote_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class SettlementNoteBean
implements ITreasuryBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean reimbursementNote;
    private DebtAccount debtAccount;
    private LocalDate date;
    private DocumentNumberSeries docNumSeries;
    private String originDocumentNumber;
    private List<CreditEntryBean> creditEntries = new ArrayList<CreditEntryBean>();
    private List<DebitEntryBean> debitEntries = new ArrayList<DebitEntryBean>();
    private List<InterestEntryBean> interestEntries = new ArrayList<InterestEntryBean>();
    private List<PaymentEntryBean> paymentEntries = new ArrayList<PaymentEntryBean>();
    private List<TreasuryTupleDataSourceBean> paymentMethods;
    private List<TreasuryTupleDataSourceBean> documentNumberSeries;
    private List<String> settlementNoteStateUrls;
    private Stack<Integer> previousStates;
    private String finantialTransactionReferenceYear;
    private String finantialTransactionReference;
    private boolean advancePayment;

    public SettlementNoteBean() {
        this.date = new LocalDate();
        this.previousStates = new Stack();
        this.setPaymentMethods(PaymentMethod.findAvailableForPaymentInApplication().collect(Collectors.toList()));
        this.advancePayment = false;
        this.finantialTransactionReferenceYear = String.valueOf(new LocalDate().getYear());
    }

    public SettlementNoteBean(DebtAccount debtAccount, boolean reimbursementNote, boolean excludeDebtsForPayorAccount) {
        this();
        this.debtAccount = debtAccount;
        this.reimbursementNote = reimbursementNote;
        for (InvoiceEntry invoiceEntry : debtAccount.getPendingInvoiceEntriesSet().stream().filter(ie -> !ie.hasPreparingSettlementEntries()).sorted((x, y) -> x.getDueDate().compareTo((ReadablePartial)y.getDueDate())).collect(Collectors.toList())) {
            if (invoiceEntry instanceof DebitEntry) {
                DebitEntry debitEntry = (DebitEntry)((Object)invoiceEntry);
                if (excludeDebtsForPayorAccount && debitEntry.getFinantialDocument() != null && ((Invoice)((Object)debitEntry.getFinantialDocument())).isForPayorDebtAccount()) continue;
                this.debitEntries.add(new DebitEntryBean(debitEntry));
                continue;
            }
            CreditEntry creditEntry = (CreditEntry)((Object)invoiceEntry);
            if (excludeDebtsForPayorAccount && creditEntry.getFinantialDocument() != null && ((Invoice)((Object)creditEntry.getFinantialDocument())).isForPayorDebtAccount()) continue;
            this.creditEntries.add(new CreditEntryBean((CreditEntry)((Object)invoiceEntry)));
        }
        this.setDocumentNumberSeries(debtAccount, reimbursementNote);
        this.settlementNoteStateUrls = Arrays.asList("/treasury/document/managepayments/settlementnote/chooseInvoiceEntries/" + debtAccount.getExternalId() + "/" + reimbursementNote, "/treasury/document/managepayments/settlementnote/chooseInvoiceEntries/", "/treasury/document/managepayments/settlementnote/calculateInterest/", "/treasury/document/managepayments/settlementnote/createDebitNote/", "/treasury/document/managepayments/settlementnote/insertpayment/", "/treasury/document/managepayments/settlementnote/summary/");
        this.advancePayment = false;
        this.finantialTransactionReferenceYear = String.valueOf(new LocalDate().getYear());
    }

    public Set<Customer> getReferencedCustomers() {
        HashSet result = Sets.newHashSet();
        for (DebitEntryBean debitEntryBean : this.debitEntries) {
            if (!debitEntryBean.isIncluded()) continue;
            DebitEntry debitEntry = debitEntryBean.getDebitEntry();
            if (debitEntry.getFinantialDocument() != null && ((Invoice)((Object)debitEntry.getFinantialDocument())).getPayorDebtAccount() != null) {
                result.add(((Invoice)((Object)debitEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(debitEntry.getDebtAccount().getCustomer());
        }
        for (CreditEntryBean creditEntryBean : this.creditEntries) {
            if (!creditEntryBean.isIncluded()) continue;
            CreditEntry creditEntry = creditEntryBean.getCreditEntry();
            if (creditEntry.getFinantialDocument() != null && ((Invoice)((Object)creditEntry.getFinantialDocument())).getPayorDebtAccount() != null) {
                result.add(((Invoice)((Object)creditEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(creditEntry.getDebtAccount().getCustomer());
        }
        return result;
    }

    public boolean isReimbursementWithCompensation() {
        if (!this.isReimbursementNote()) {
            return false;
        }
        if (this.getCreditEntries().stream().filter(ce -> ce.isIncluded()).count() > 1L) {
            throw new TreasuryDomainException("error.SettlementNote.reimbursement.supports.only.one.settlement.entry", new String[0]);
        }
        CreditEntry creditEntry = this.getCreditEntries().stream().filter(ce -> ce.isIncluded()).findFirst().get().getCreditEntry();
        return ReimbursementUtils.isCreditNoteForReimbursementMustBeClosedWithDebitNoteAndCreatedNew(creditEntry);
    }

    public boolean checkAdvancePaymentCreditsWithPaymentDate() {
        Optional<SettlementNote> lastAdvancedCreditSettlementNote = this.getLastPaidAdvancedCreditSettlementNote();
        if (!lastAdvancedCreditSettlementNote.isPresent()) {
            return true;
        }
        return !this.getDate().isBefore((ReadablePartial)lastAdvancedCreditSettlementNote.get().getPaymentDate().toLocalDate());
    }

    public Optional<SettlementNote> getLastPaidAdvancedCreditSettlementNote() {
        Optional<SettlementNote> lastAdvancedCreditSettlementNote = this.getCreditEntries().stream().filter(ce -> ce.isIncluded()).filter(ce -> ce.getCreditEntry().getFinantialDocument() != null && ((CreditNote)((Object)((Object)((Object)ce.getCreditEntry().getFinantialDocument())))).isAdvancePayment()).map(ce -> ce.getCreditEntry().getFinantialDocument()).map(AdvancedPaymentCreditNote.class::cast).filter(c -> c.getAdvancedPaymentSettlementNote() != null).map(c -> c.getAdvancedPaymentSettlementNote()).sorted(Comparator.comparing(SettlementNote_Base::getPaymentDate).reversed()).findFirst();
        return lastAdvancedCreditSettlementNote;
    }

    public List<ISettlementInvoiceEntryBean> getIncludedInvoiceEntryBeans() {
        int i;
        ArrayList invoiceEntriesList = Lists.newArrayList();
        for (i = 0; i < this.getDebitEntries().size(); ++i) {
            DebitEntryBean debitEntryBean = this.getDebitEntries().get(i);
            if (!debitEntryBean.isIncluded()) continue;
            invoiceEntriesList.add(debitEntryBean);
        }
        for (i = 0; i < this.getCreditEntries().size(); ++i) {
            CreditEntryBean creditEntryBean = this.getCreditEntries().get(i);
            if (!creditEntryBean.isIncluded()) continue;
            invoiceEntriesList.add(creditEntryBean);
        }
        for (InterestEntryBean interestEntryBean : this.getInterestEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            invoiceEntriesList.add(interestEntryBean);
        }
        return invoiceEntriesList;
    }

    public boolean isIncludedLegacyERPInvoiceEntryBeans() {
        for (ISettlementInvoiceEntryBean entryBean : this.getIncludedInvoiceEntryBeans()) {
            if (entryBean.getInvoiceEntry() == null || entryBean.getInvoiceEntry().getFinantialDocument() == null || !entryBean.getInvoiceEntry().getFinantialDocument().isExportedInLegacyERP()) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getFinantialTransactionReferenceYears() {
        List<Integer> years = GlobalInterestRate.findAll().map(g -> g.getYear()).sorted().collect(Collectors.toList());
        Collections.reverse(years);
        return years;
    }

    private void setDocumentNumberSeries(DebtAccount debtAccount, boolean reimbursementNote) {
        FinantialDocumentType finantialDocumentType = reimbursementNote ? FinantialDocumentType.findForReimbursementNote() : FinantialDocumentType.findForSettlementNote();
        List availableSeries = DocumentNumberSeries.find(finantialDocumentType, debtAccount.getFinantialInstitution()).collect(Collectors.toList());
        this.setDocumentNumberSeries(DocumentNumberSeries.applyActiveSelectableAndDefaultSorting(availableSeries.stream()).collect(Collectors.toList()));
    }

    public DebtAccount getDebtAccount() {
        return this.debtAccount;
    }

    public void setDebtAccount(DebtAccount debtAccount) {
        this.debtAccount = debtAccount;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public List<CreditEntryBean> getCreditEntries() {
        return this.creditEntries;
    }

    public void setCreditEntries(List<CreditEntryBean> creditEntries) {
        this.creditEntries = creditEntries;
    }

    public List<DebitEntryBean> getDebitEntries() {
        return this.debitEntries;
    }

    public void setDebitEntries(List<DebitEntryBean> debitEntries) {
        this.debitEntries = debitEntries;
    }

    public List<InterestEntryBean> getInterestEntries() {
        return this.interestEntries;
    }

    public void setInterestEntries(List<InterestEntryBean> interestEntries) {
        this.interestEntries = interestEntries;
    }

    public boolean isAdvancePayment() {
        return this.advancePayment;
    }

    public void setAdvancePayment(boolean advancePayment) {
        this.advancePayment = advancePayment;
    }

    public LocalDate getDebitNoteDate() {
        LocalDate lowerDate = new LocalDate();
        for (DebitEntryBean debitEntryBean : this.getDebitEntries()) {
            if (!debitEntryBean.isIncluded() || !debitEntryBean.getDocumentDueDate().isBefore((ReadablePartial)lowerDate)) continue;
            lowerDate = debitEntryBean.getDocumentDueDate();
        }
        for (InterestEntryBean interestEntryBean : this.getInterestEntries()) {
            if (!interestEntryBean.isIncluded() || !interestEntryBean.getDocumentDueDate().isBefore((ReadablePartial)lowerDate)) continue;
            lowerDate = interestEntryBean.getDocumentDueDate();
        }
        return lowerDate;
    }

    public BigDecimal getDebtAmount() {
        BigDecimal sum = BigDecimal.ZERO;
        for (DebitEntryBean debitEntryBean : this.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            sum = sum.add(debitEntryBean.getDebtAmount());
        }
        for (InterestEntryBean interestEntryBean : this.getInterestEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            sum = sum.add(interestEntryBean.getInterest().getInterestAmount());
        }
        for (CreditEntryBean creditEntryBean : this.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            sum = sum.subtract(creditEntryBean.getCreditAmount());
        }
        return sum;
    }

    public BigDecimal getDebtAmountWithVat() {
        BigDecimal sum = BigDecimal.ZERO;
        for (DebitEntryBean debitEntryBean : this.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            sum = sum.add(debitEntryBean.getDebtAmountWithVat());
        }
        for (InterestEntryBean interestEntryBean : this.getInterestEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            sum = sum.add(interestEntryBean.getInterest().getInterestAmount());
        }
        for (CreditEntryBean creditEntryBean : this.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            sum = sum.subtract(creditEntryBean.getCreditAmountWithVat());
        }
        return sum;
    }

    public BigDecimal getVatAmount() {
        return this.getDebtAmountWithVat().subtract(this.getDebtAmount());
    }

    public Map<String, VatAmountBean> getValuesByVat() {
        String vatType;
        HashMap<String, VatAmountBean> sumByVat = new HashMap<String, VatAmountBean>();
        for (VatType vatType2 : VatType.findAll().collect(Collectors.toList())) {
            sumByVat.put(vatType2.getName().getContent(), new VatAmountBean(BigDecimal.ZERO, BigDecimal.ZERO));
        }
        for (DebitEntryBean debitEntryBean : this.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            vatType = debitEntryBean.getDebitEntry().getVat().getVatType().getName().getContent();
            ((VatAmountBean)sumByVat.get(vatType)).addAmount(debitEntryBean.getDebtAmount());
            ((VatAmountBean)sumByVat.get(vatType)).addAmountWithVat(debitEntryBean.getDebtAmountWithVat());
        }
        for (InterestEntryBean interestEntryBean : this.getInterestEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            vatType = interestEntryBean.getDebitEntry().getVat().getVatType().getName().getContent();
            ((VatAmountBean)sumByVat.get(vatType)).addAmount(interestEntryBean.getInterest().getInterestAmount());
            ((VatAmountBean)sumByVat.get(vatType)).addAmountWithVat(interestEntryBean.getInterest().getInterestAmount());
        }
        for (CreditEntryBean creditEntryBean : this.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            vatType = creditEntryBean.getCreditEntry().getVat().getVatType().getName().getContent();
            ((VatAmountBean)sumByVat.get(vatType)).subtractAmount(creditEntryBean.getCreditAmount());
            ((VatAmountBean)sumByVat.get(vatType)).subtractAmountWithVat(creditEntryBean.getCreditAmountWithVat());
        }
        return sumByVat;
    }

    public List<PaymentEntryBean> getPaymentEntries() {
        return this.paymentEntries;
    }

    public void setPaymentEntries(List<PaymentEntryBean> paymentEntries) {
        this.paymentEntries = paymentEntries;
    }

    public List<TreasuryTupleDataSourceBean> getPaymentMethods() {
        return this.paymentMethods;
    }

    public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods.stream().map(paymentMethod -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setText(paymentMethod.getName().getContent());
            tuple.setId(paymentMethod.getExternalId());
            return tuple;
        }).collect(Collectors.toList());
    }

    public BigDecimal getPaymentAmount() {
        BigDecimal paymentAmount = BigDecimal.ZERO;
        for (PaymentEntryBean paymentEntryBean : this.getPaymentEntries()) {
            paymentAmount = paymentAmount.add(paymentEntryBean.getPaymentAmount());
        }
        return paymentAmount;
    }

    public DocumentNumberSeries getDocNumSeries() {
        return this.docNumSeries;
    }

    public void setDocNumSeries(DocumentNumberSeries docNumSeries) {
        this.docNumSeries = docNumSeries;
    }

    public List<TreasuryTupleDataSourceBean> getDocumentNumberSeries() {
        return this.documentNumberSeries;
    }

    public void setDocumentNumberSeries(List<DocumentNumberSeries> documentNumberSeries) {
        this.documentNumberSeries = documentNumberSeries.stream().map(docNumSeries -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setText(docNumSeries.getSeries().getCode() + " - " + docNumSeries.getSeries().getName().getContent());
            tuple.setId(docNumSeries.getExternalId());
            return tuple;
        }).collect(Collectors.toList());
    }

    public String getOriginDocumentNumber() {
        return this.originDocumentNumber;
    }

    public void setOriginDocumentNumber(String originDocumentNumber) {
        this.originDocumentNumber = originDocumentNumber;
    }

    public boolean isReimbursementNote() {
        return this.reimbursementNote;
    }

    public void setReimbursementNote(boolean reimbursementNote) {
        this.reimbursementNote = reimbursementNote;
    }

    public Stack<Integer> getPreviousStates() {
        return this.previousStates;
    }

    public void setPreviousStates(Stack<Integer> previousStates) {
        this.previousStates = previousStates;
    }

    public List<String> getSettlementNoteStateUrls() {
        return this.settlementNoteStateUrls;
    }

    public void setSettlementNoteStateUrls(List<String> settlementNoteStateUrls) {
        this.settlementNoteStateUrls = settlementNoteStateUrls;
    }

    public boolean hasEntriesWithoutDocument() {
        return this.debitEntries.stream().anyMatch(deb -> deb.isIncluded() && deb.getDebitEntry().getFinantialDocument() == null) || this.interestEntries.stream().anyMatch(deb -> deb.isIncluded());
    }

    public String getFinantialTransactionReference() {
        return this.finantialTransactionReference;
    }

    public void setFinantialTransactionReference(String finantialTransactionReference) {
        this.finantialTransactionReference = finantialTransactionReference;
    }

    public String getFinantialTransactionReferenceYear() {
        return this.finantialTransactionReferenceYear;
    }

    public void setFinantialTransactionReferenceYear(String finantialTransactionReferenceYear) {
        this.finantialTransactionReferenceYear = finantialTransactionReferenceYear;
    }

    public class VatAmountBean
    implements ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private BigDecimal amount;
        private BigDecimal amountWithVat;

        public VatAmountBean(BigDecimal amount, BigDecimal amountWithVat) {
            this.amount = amount;
            this.amountWithVat = amountWithVat;
        }

        public VatAmountBean() {
            this.amount = BigDecimal.ZERO;
            this.amountWithVat = BigDecimal.ZERO;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void addAmount(BigDecimal partialAmount) {
            this.amount = this.amount.add(partialAmount);
        }

        public void subtractAmount(BigDecimal partialAmount) {
            this.amount = this.amount.subtract(partialAmount);
        }

        public BigDecimal getAmountWithVat() {
            return this.amountWithVat;
        }

        public void setAmountWithVat(BigDecimal amountWithVat) {
            this.amountWithVat = amountWithVat;
        }

        public void addAmountWithVat(BigDecimal partialAmountWithVat) {
            this.amountWithVat = this.amountWithVat.add(partialAmountWithVat);
        }

        public void subtractAmountWithVat(BigDecimal partialAmountWithVat) {
            this.amountWithVat = this.amountWithVat.subtract(partialAmountWithVat);
        }
    }

    public class PaymentEntryBean
    implements ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private BigDecimal paymentAmount;
        private PaymentMethod paymentMethod;
        private String paymentMethodId;

        public PaymentEntryBean() {
            this.paymentAmount = BigDecimal.ZERO;
        }

        public PaymentEntryBean(BigDecimal paymentAmount, PaymentMethod paymentMethod) {
            this.paymentAmount = paymentAmount;
            this.paymentMethod = paymentMethod;
        }

        public BigDecimal getPaymentAmount() {
            return this.paymentAmount;
        }

        public void setPaymentAmount(BigDecimal paymentAmount) {
            this.paymentAmount = paymentAmount;
        }

        public PaymentMethod getPaymentMethod() {
            return this.paymentMethod;
        }

        public void setPaymentMethod(PaymentMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
        }

        public String getPaymentMethodId() {
            return this.paymentMethodId;
        }

        public void setPaymentMethodId(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }
    }

    public static class InterestEntryBean
    implements ISettlementInvoiceEntryBean,
    ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private DebitEntry debitEntry;
        private boolean isIncluded = false;
        private InterestRateBean interest;

        public InterestEntryBean() {
        }

        public InterestEntryBean(DebitEntry debitEntry, InterestRateBean interest) {
            this();
            this.debitEntry = debitEntry;
            this.interest = interest;
        }

        public InterestRateBean getInterest() {
            return this.interest;
        }

        public void setInterest(InterestRateBean interest) {
            this.interest = interest;
        }

        public DebitEntry getDebitEntry() {
            return this.debitEntry;
        }

        public void setDebitEntry(DebitEntry debitEntry) {
            this.debitEntry = debitEntry;
        }

        public LocalDate getDocumentDueDate() {
            return this.debitEntry.getFinantialDocument() != null ? this.debitEntry.getFinantialDocument().getDocumentDueDate() : this.debitEntry.getDueDate();
        }

        public boolean isIncluded() {
            return this.isIncluded;
        }

        public void setIncluded(boolean isIncluded) {
            this.isIncluded = isIncluded;
        }

        @Override
        public InvoiceEntry getInvoiceEntry() {
            return null;
        }
    }

    public class CreditEntryBean
    implements ISettlementInvoiceEntryBean,
    ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private CreditEntry creditEntry;
        private boolean isIncluded;
        private boolean isNotValid;
        private BigDecimal creditAmount;

        public CreditEntryBean() {
        }

        public CreditEntryBean(CreditEntry creditEntry) {
            this.creditEntry = creditEntry;
            this.isIncluded = false;
            this.isNotValid = false;
            this.creditAmount = creditEntry.getOpenAmount();
        }

        public CreditEntry getCreditEntry() {
            return this.creditEntry;
        }

        public void setCreditEntry(CreditEntry creditEntry) {
            this.creditEntry = creditEntry;
        }

        public String getDocumentNumber() {
            return this.creditEntry.getFinantialDocument() != null ? this.creditEntry.getFinantialDocument().getDocumentNumber() : null;
        }

        public LocalDate getDocumentDueDate() {
            return this.creditEntry.getFinantialDocument() != null ? this.creditEntry.getFinantialDocument().getDocumentDueDate() : this.creditEntry.getEntryDateTime().toLocalDate();
        }

        public boolean isIncluded() {
            return this.isIncluded;
        }

        public void setIncluded(boolean isIncluded) {
            this.isIncluded = isIncluded;
        }

        public BigDecimal getCreditAmount() {
            if (this.creditAmount == null) {
                return null;
            }
            return this.creditEntry.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(this.creditAmount);
        }

        public BigDecimal getCreditAmountWithVat() {
            if (this.creditAmount == null) {
                return null;
            }
            return this.creditEntry.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(this.creditAmount);
        }

        public void setCreditAmount(BigDecimal creditAmount) {
            this.creditAmount = creditAmount;
        }

        public boolean isNotValid() {
            return this.isNotValid;
        }

        public void setNotValid(boolean notValid) {
            this.isNotValid = notValid;
        }

        @Override
        public InvoiceEntry getInvoiceEntry() {
            return this.creditEntry;
        }
    }

    public class DebitEntryBean
    implements ISettlementInvoiceEntryBean,
    ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private DebitEntry debitEntry;
        private boolean isIncluded;
        private boolean isNotValid;
        private BigDecimal debtAmount;

        public DebitEntryBean() {
        }

        public DebitEntryBean(DebitEntry debitEntry) {
            this.debitEntry = debitEntry;
            this.isIncluded = false;
            this.isNotValid = false;
            this.debtAmount = debitEntry.getOpenAmount();
        }

        public DebitEntry getDebitEntry() {
            return this.debitEntry;
        }

        public void setDebitEntry(DebitEntry debitEntry) {
            this.debitEntry = debitEntry;
        }

        public String getDocumentNumber() {
            return this.debitEntry.getFinantialDocument() != null ? this.debitEntry.getFinantialDocument().getDocumentNumber() : null;
        }

        public LocalDate getDocumentDueDate() {
            return this.debitEntry.getDueDate();
        }

        public boolean isIncluded() {
            return this.isIncluded;
        }

        public void setIncluded(boolean isIncluded) {
            this.isIncluded = isIncluded;
        }

        public BigDecimal getDebtAmount() {
            if (this.debtAmount == null) {
                return null;
            }
            return this.debitEntry.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(this.debtAmount);
        }

        public BigDecimal getDebtAmountWithVat() {
            if (this.debtAmount == null) {
                return null;
            }
            return this.debitEntry.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(this.debtAmount);
        }

        public void setDebtAmount(BigDecimal debtAmount) {
            this.debtAmount = debtAmount;
        }

        public boolean isNotValid() {
            return this.isNotValid;
        }

        public void setNotValid(boolean notValid) {
            this.isNotValid = notValid;
        }

        @Override
        public InvoiceEntry getInvoiceEntry() {
            return this.debitEntry;
        }
    }
}

