/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$processSIBSIncommingFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile$callable$updateLogMessages;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsSpreadsheetRowReportBean;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationFileDTO;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationLineDTO;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter;
import org.fenixedu.treasury.util.Constants;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsReportFile
extends SibsReportFile_Base {
    public static final String CONTENT_TYPE = "text/plain";
    public static final String FILE_EXTENSION = ".idm";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$processSIBSIncommingFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateLogMessages = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected SibsReportFile() {
        this.setBennu(Bennu.getInstance());
    }

    protected SibsReportFile(DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost, String displayName, String fileName, byte[] content) {
        this();
        this.init(whenProcessedBySibs, transactionsTotalAmount, totalCost, displayName, fileName, content);
        this.checkRules();
    }

    protected void init(DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost, String displayName, String fileName, byte[] content) {
        super.init(displayName, fileName, content);
        this.setWhenProcessedBySibs(whenProcessedBySibs);
        this.setTransactionsTotalAmount(transactionsTotalAmount);
        this.setTotalCost(totalCost);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void edit(DateTime dateTime, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Object object = advice$edit.perform((Callable)new SibsReportFile$callable$edit(this, dateTime, bigDecimal, bigDecimal2));
    }

    static /* synthetic */ void advised$edit(SibsReportFile this_, DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost) {
        this_.setWhenProcessedBySibs(whenProcessedBySibs);
        this_.setTransactionsTotalAmount(transactionsTotalAmount);
        this_.setTotalCost(totalCost);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getReferenceCodesSet().isEmpty() && this.getSibsTransactionsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsReportFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsReportFile this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SibsReportFile.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        super.delete();
    }

    public static Stream<SibsReportFile> findAll() {
        return Bennu.getInstance().getSibsReportFilesSet().stream();
    }

    public static Stream<SibsReportFile> findByWhenProcessedBySibs(LocalDate whenProcessedBySibs) {
        return SibsReportFile.findAll().filter(i -> whenProcessedBySibs.equals((Object)i.getWhenProcessedBySibs()));
    }

    public static Stream<SibsReportFile> findByTransactionsTotalAmount(BigDecimal transactionsTotalAmount) {
        return SibsReportFile.findAll().filter(i -> transactionsTotalAmount.equals(i.getTransactionsTotalAmount()));
    }

    public static Stream<SibsReportFile> findByTotalCost(BigDecimal totalCost) {
        return SibsReportFile.findAll().filter(i -> totalCost.equals(i.getTotalCost()));
    }

    public boolean isAccessible(User arg0) {
        return true;
    }

    public static SibsReportFile create(DateTime dateTime, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string, String string2, byte[] byArray) {
        return (SibsReportFile)((Object)advice$create.perform((Callable)new SibsReportFile$callable$create(dateTime, bigDecimal, bigDecimal2, string, string2, byArray)));
    }

    static /* synthetic */ SibsReportFile advised$create(DateTime whenProcessedBySibs, BigDecimal transactionsTotalAmount, BigDecimal totalCost, String displayName, String fileName, byte[] content) {
        return new SibsReportFile(whenProcessedBySibs, transactionsTotalAmount, totalCost, displayName, fileName, content);
    }

    protected static byte[] buildContentFor(SIBSImportationFileDTO reportFileDTO) {
        final Stream<SibsSpreadsheetRowReportBean> lines = reportFileDTO.getLines().stream().map(l -> new SibsSpreadsheetRowReportBean((SIBSImportationLineDTO)l));
        return Spreadsheet.buildSpreadsheetContent(new Spreadsheet(){

            @Override
            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create(Constants.treasuryBundle("label.SibsReportFile.spreadsheet.name", new String[0]), SibsSpreadsheetRowReportBean.SPREADSHEET_HEADERS, lines)};
            }
        }, null);
    }

    protected static String filenameFor(SIBSImportationFileDTO reportFileDTO) {
        String date = new DateTime().toString("yyyyMMddHHmm");
        return "Relatorio-SIBS-" + date + ".xlsx";
    }

    protected static String displayNameFor(SIBSImportationFileDTO reportFileDTO) {
        String date = new DateTime().toString("yyyyMMddHHmm");
        return "Relatorio-SIBS-" + date;
    }

    public static SibsReportFile processSIBSIncommingFile(SIBSImportationFileDTO sIBSImportationFileDTO) {
        return (SibsReportFile)((Object)advice$processSIBSIncommingFile.perform((Callable)new SibsReportFile$callable$processSIBSIncommingFile(sIBSImportationFileDTO)));
    }

    static /* synthetic */ SibsReportFile advised$processSIBSIncommingFile(SIBSImportationFileDTO reportDTO) {
        byte[] content = SibsReportFile.buildContentFor(reportDTO);
        SibsReportFile result = SibsReportFile.create(reportDTO.getWhenProcessedBySibs(), reportDTO.getTransactionsTotalAmount(), reportDTO.getTotalCost(), SibsReportFile.displayNameFor(reportDTO), SibsReportFile.filenameFor(reportDTO), content);
        return result;
    }

    public Integer getNumberOfTransactions() {
        return this.getSibsTransactionsSet().size();
    }

    public String getTransactionDescription(Integer index) {
        if (this.getSibsTransactionsSet().size() > index) {
            if (index > 0) {
                return ((SibsTransactionDetail)((Object)this.getSibsTransactionsSet().stream().skip(index - 1).findFirst().get())).toString();
            }
            if (index == 0) {
                return ((SibsTransactionDetail)((Object)this.getSibsTransactionsSet().iterator().next())).toString();
            }
        }
        return "";
    }

    public BigDecimal getTransactionAmount(Integer index) {
        if (this.getSibsTransactionsSet().size() > index) {
            if (index > 0) {
                return ((SibsTransactionDetail)((Object)this.getSibsTransactionsSet().stream().skip(index - 1).findFirst().get())).getAmountPayed();
            }
            if (index == 0) {
                return ((SibsTransactionDetail)((Object)this.getSibsTransactionsSet().iterator().next())).getAmountPayed();
            }
        }
        return BigDecimal.ZERO;
    }

    public void updateLogMessages(SIBSPaymentsImporter.ProcessResult processResult) {
        Object object = advice$updateLogMessages.perform((Callable)new SibsReportFile$callable$updateLogMessages(this, processResult));
    }

    static /* synthetic */ void advised$updateLogMessages(SibsReportFile this_, SIBSPaymentsImporter.ProcessResult result) {
        StringBuilder build = new StringBuilder();
        for (String s : result.getErrorMessages()) {
            build.append(s + "\n");
        }
        this_.setErrorLog(build.toString());
        build = new StringBuilder();
        for (String s : result.getActionMessages()) {
            build.append(s + "\n");
        }
        this_.setInfoLog(build.toString());
    }
}

