/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments.implementations;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAInvocationUtil;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAVirtualImplementation$callable$postProcessPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAVirtualImplementation$callable$processPayment;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.ui.document.forwardpayments.IForwardPaymentController;
import org.fenixedu.treasury.ui.document.forwardpayments.implementations.TPAVirtualController;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TPAVirtualImplementation
implements IForwardPaymentImplementation {
    static final String A030 = "A030";
    static final String TPA_VIRTUAL_ID_FIELD = "A001";
    static final String REFERENCE_CODE_FIELD = "C007";
    static final String CURRENCY_FIELD = "A105";
    static final String AMOUNT_FIELD = "A061";
    static final String PAN_FIELD = "C003";
    static final String EXPIRATION_FIELD = "C004";
    static final String OPERATION_STATUS_FIELD = "C016";
    static final String SECURE_HASH_CODE_FIELD = "C013";
    static final String A037 = "A037";
    public static final String AUTHENTICATION_REQUEST_MESSAGE = "H3D0";
    static final String AUTHENTICATION_RESPONSE_MESSAGE = "MH05";
    static final String C016_AUTHENTICATION_REGISTERED_CODE = "01";
    static final String C016_AUTHORIZATION_ACCEPTED_CODE = "02";
    static final String C016_PAYMENT_ACCEPTED_CODE = "03";
    static final String C016_AUTHORIZATION_CANCELLED = "04";
    static final String C016_UNABLE_TO_CONTACT_HOST_RESPONSE_CODE = "99";
    static final String A038 = "A038";
    static final String A038_SUCCESS = "000";
    static final String M020 = "M020";
    static final String M120 = "M120";
    static final String C016 = "C016";
    static final String C016_POS_RESP = "0X";
    static final String C016_NEG_RESP = "99";
    static final int C016_AUTHENTICATED_STATE = 1;
    static final int C016_AUTHORIZED = 2;
    static final int C016_PAYED = 3;
    static final int C016_AUTHORIZED_CANCELLED = 4;
    static final String C026 = "C026";
    static final String M001 = "M001";
    static final String M101 = "M101";
    static final String M002 = "M002";
    static final String M102 = "M102";
    static final String A077 = "A077";
    static final String A078 = "A078";
    static final String A085 = "A085";
    static final String A086 = "A086";
    public static final String EURO_CODE = "9782";
    public static final Advice advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$postProcessPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @Override
    public IForwardPaymentController getForwardPaymentController(ForwardPayment forwardPayment) {
        return new TPAVirtualController();
    }

    public boolean processPayment(ForwardPayment forwardPayment, Map<String, String> map) {
        return (Boolean)advice$processPayment.perform((Callable)new TPAVirtualImplementation$callable$processPayment(this, forwardPayment, map));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ boolean advised$processPayment(TPAVirtualImplementation this_, ForwardPayment forwardPayment, Map responseMap) {
        LinkedHashMap requestMap = null;
        if (!this_.isAuthenticationResponseMessage(responseMap)) {
            String errorMessage = this_.errorMessage(responseMap);
            forwardPayment.reject((String)responseMap.get("C016"), errorMessage, null, this_.json(responseMap));
            return false;
        }
        TPAInvocationUtil tpa = new TPAInvocationUtil(forwardPayment);
        requestMap = Maps.newLinkedHashMap();
        responseMap = tpa.postPaymentStatus(requestMap);
        if (!this_.isPaymentStatusSuccess(responseMap)) {
            String responseCode = this_.responseCode(responseMap);
            forwardPayment.reject(responseCode, this_.errorMessage(responseMap), this_.json(requestMap), this_.json(responseMap));
            return false;
        }
        int resultCode = Integer.parseInt(responseMap.get("C016"));
        if (resultCode == 1) {
            requestMap = Maps.newLinkedHashMap();
            responseMap = tpa.postAuthorizationRequest(requestMap);
            if (!this_.isAuthorizationSuccess(responseMap)) {
                String responseCode = this_.responseCode(responseMap);
                forwardPayment.reject(responseCode, this_.errorMessage(responseMap), this_.json(requestMap), this_.json(responseMap));
                return false;
            }
            forwardPayment.advanceToAuthenticatedState(responseMap.get("C016"), Constants.treasuryBundle("label.TPAVirtualImplementation.authenticated", new String[0]), this_.json(requestMap), this_.json(responseMap));
            resultCode = Integer.parseInt(responseMap.get("C016"));
        }
        if (resultCode == 2) {
            requestMap = Maps.newLinkedHashMap();
            responseMap = tpa.postPaymentStatus(requestMap);
            if (!this_.isPaymentStatusSuccess(responseMap)) {
                String responseCode = this_.responseCode(responseMap);
                forwardPayment.reject(responseCode, this_.errorMessage(responseMap), this_.json(requestMap), this_.json(responseMap));
                return false;
            }
            forwardPayment.advanceToAuthorizedState(String.valueOf(resultCode), Constants.treasuryBundle("label.TPAVirtualImplementation.authorized", new String[0]), this_.json(requestMap), this_.json(responseMap));
            DateTime authorizationDate = this_.authorizationSibsDate(responseMap);
            forwardPayment.setAuthorizationDate(authorizationDate);
            requestMap = Maps.newLinkedHashMap();
            responseMap = tpa.postPayment(authorizationDate, requestMap);
            if (!this_.isPaymentSuccess(responseMap)) {
                String responseCode = this_.responseCode(responseMap);
                forwardPayment.reject(responseCode, this_.errorMessage(responseMap), this_.json(requestMap), this_.json(responseMap));
                return false;
            }
            String responseCode = this_.responseCode(responseMap);
            forwardPayment.log(responseCode, this_.errorMessage(responseMap), this_.json(requestMap), this_.json(responseMap));
            resultCode = Integer.parseInt(responseMap.get("C016"));
        }
        if (resultCode == 3) {
            requestMap = Maps.newLinkedHashMap();
            responseMap = tpa.postPaymentStatus(requestMap);
            if (!this_.isPaymentStatusSuccess(responseMap)) {
                String responseCode = this_.responseCode(responseMap);
                forwardPayment.reject(responseCode, this_.errorMessage(responseMap), this_.json(requestMap), this_.json(responseMap));
                return false;
            }
            String transactionId = this_.transactionId(responseMap);
            DateTime transactionDate = forwardPayment.getAuthorizationDate();
            BigDecimal payedAmount = this_.payedAmount(responseMap);
            forwardPayment.advanceToPayedState(String.valueOf(resultCode), Constants.treasuryBundle("label.TPAVirtualImplementation.payed", new String[0]), payedAmount, transactionDate, transactionId, null, this_.json(requestMap), this_.json(responseMap), null);
            return true;
        }
        forwardPayment.reject(String.valueOf(resultCode), this_.errorMessage(responseMap), this_.json(requestMap), this_.json(responseMap));
        return false;
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPayment forwardPayment) {
        LinkedHashMap requestMap = Maps.newLinkedHashMap();
        TPAInvocationUtil tpa = new TPAInvocationUtil(forwardPayment);
        Map<String, String> responseMap = tpa.postPaymentStatus(requestMap);
        String responseCode = this.responseCode(responseMap);
        if (!this.isPaymentStatusSuccess(responseMap)) {
            return new ForwardPaymentStatusBean(this.isPaymentStatusSuccess(responseMap), null, responseCode, this.errorMessage(responseMap), this.json(requestMap), this.json(responseMap));
        }
        ForwardPaymentStateType type = null;
        DateTime authorizationDate = null;
        String transactionId = null;
        DateTime transactionDate = null;
        BigDecimal payedAmount = null;
        int resultCode = Integer.parseInt(responseMap.get("C016"));
        if (resultCode == 1) {
            type = ForwardPaymentStateType.AUTHENTICATED;
        } else if (resultCode == 2) {
            type = ForwardPaymentStateType.AUTHORIZED;
            authorizationDate = this.authorizationSibsDate(responseMap);
        } else if (resultCode == 3) {
            type = ForwardPaymentStateType.PAYED;
            authorizationDate = this.authorizationSibsDate(responseMap);
            transactionId = this.transactionId(responseMap);
            transactionDate = forwardPayment.getAuthorizationDate();
            payedAmount = this.payedAmount(responseMap);
        } else if (resultCode == 4) {
            type = ForwardPaymentStateType.REJECTED;
        }
        ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(this.isPaymentStatusSuccess(responseMap), type, responseCode, this.errorMessage(responseMap), this.json(requestMap), this.json(responseMap));
        bean.editAuthorizationDetails(null, authorizationDate);
        bean.editTransactionDetails(transactionId, transactionDate, payedAmount);
        return bean;
    }

    private String errorMessage(Map<String, String> responseData) {
        if (responseData.containsKey(A086) && !Strings.isNullOrEmpty((String)responseData.get(A086))) {
            return responseData.get(A086);
        }
        StringBuilder sb = new StringBuilder();
        if (responseData.containsKey(A085) && !Strings.isNullOrEmpty((String)responseData.get(A085))) {
            sb.append(String.format("[%s: %s]", A085, responseData.get(A085)));
        }
        if (responseData.containsKey(A077) && !Strings.isNullOrEmpty((String)responseData.get(A077))) {
            sb.append(String.format("[%s: %s] ", A077, responseData.get(A077)));
        }
        if (responseData.containsKey(A078) && !Strings.isNullOrEmpty((String)responseData.get(A078))) {
            sb.append(String.format("[%s: %s] ", A078, responseData.get(A078)));
        }
        if (sb.length() == 0) {
            sb.append(Constants.treasuryBundle("label.TPAVirtualImplementation.error.not.available", new String[0]));
        }
        return sb.toString();
    }

    public Map<String, String> mapAuthenticationRequest(ForwardPayment forwardPayment) {
        TPAInvocationUtil tpa = new TPAInvocationUtil(forwardPayment);
        return tpa.mapAuthenticationRequest();
    }

    private BigDecimal payedAmount(Map<String, String> responseMap) {
        if (!Strings.isNullOrEmpty((String)responseMap.get(AMOUNT_FIELD))) {
            return new BigDecimal(responseMap.get(AMOUNT_FIELD));
        }
        return null;
    }

    private String transactionId(Map<String, String> responseMap) {
        if (!Strings.isNullOrEmpty((String)responseMap.get(C026))) {
            return responseMap.get(C026);
        }
        return null;
    }

    private DateTime authorizationSibsDate(Map<String, String> responseMap) {
        if (!responseMap.containsKey(A037)) {
            return null;
        }
        return DateTimeFormat.forPattern((String)"YYYYMMddHHmmss").parseDateTime(responseMap.get(A037));
    }

    private boolean isResponseSuccess(Map<String, String> responseMap) {
        if (responseMap.get(A038) == null) {
            return false;
        }
        try {
            return Integer.parseInt(responseMap.get(A038)) == 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPaymentStatusSuccess(Map<String, String> responseMap) {
        return this.isResponseSuccess(responseMap) && responseMap.get(A030) != null && M120.equals(responseMap.get(A030));
    }

    private boolean isAuthorizationSuccess(Map<String, String> responseMap) {
        return this.isResponseSuccess(responseMap) && responseMap.containsKey(A030) && M101.equals(responseMap.get(A030));
    }

    private boolean isPaymentSuccess(Map<String, String> responseMap) {
        return this.isResponseSuccess(responseMap) && responseMap.containsKey(A030) && M102.equals(responseMap.get(A030));
    }

    private boolean isAuthenticationResponseMessage(Map<String, String> responseMap) {
        return responseMap.containsKey(A030) && AUTHENTICATION_RESPONSE_MESSAGE.equals(responseMap.get(A030));
    }

    private String responseCode(Map<String, String> responseMap) {
        if (!responseMap.containsKey(A038)) {
            return null;
        }
        return responseMap.get(A038);
    }

    @Override
    public String getPaymentURL(ForwardPayment forwardPayment) {
        return forwardPayment.getForwardPaymentConfiguration().getPaymentURL();
    }

    public String getReturnURL(ForwardPayment forwardPayment) {
        return String.format("%s/%s", forwardPayment.getForwardPaymentConfiguration().getReturnURL(), forwardPayment.getExternalId());
    }

    @Override
    public String getFormattedAmount(ForwardPayment forwardPayment) {
        return forwardPayment.getAmount().toString();
    }

    private String json(Object obj) {
        GsonBuilder builder = new GsonBuilder();
        return builder.create().toJson(obj);
    }

    @Override
    public String getLogosJspPage() {
        return "implementations/tpavirtual/logos.jsp";
    }

    @Override
    public String getWarningBeforeRedirectionJspPage() {
        return null;
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPayment forwardPayment, String string) {
        return (PostProcessPaymentStatusBean)advice$postProcessPayment.perform((Callable)new TPAVirtualImplementation$callable$postProcessPayment(this, forwardPayment, string));
    }

    static /* synthetic */ PostProcessPaymentStatusBean advised$postProcessPayment(TPAVirtualImplementation this_, ForwardPayment forwardPayment, String justification) {
        throw new TreasuryDomainException("label.ManageForwardPayments.postProcessPayment.not.supported.yet", new String[0]);
    }
}

