/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment$callable$_postForwardPaymentProcessService;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentLog;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentLogFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment_Base;
import org.fenixedu.treasury.domain.forwardpayments.PostForwardPaymentsReportFile;
import org.fenixedu.treasury.domain.forwardpayments.exceptions.ForwardPaymentAlreadyPayedException;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.util.Constants;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ForwardPayment
extends ForwardPayment_Base {
    private static final Comparator<ForwardPayment> ORDER_COMPARATOR;
    private static final Comparator<DebitEntry> COMPARE_DEBIT_ENTRIES;
    public static final Advice advice$_postForwardPaymentProcessService;

    private ForwardPayment() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public ForwardPayment(ForwardPaymentConfiguration forwardPaymentConfiguration, DebtAccount debtAccount, Set<DebitEntry> debitEntriesSet) {
        this();
        this.setForwardPaymentConfiguration(forwardPaymentConfiguration);
        this.setDebtAccount(debtAccount);
        this.getDebitEntriesSet().addAll(debitEntriesSet);
        this.setCurrentState(ForwardPaymentStateType.CREATED);
        this.setWhenOccured(new DateTime());
        for (DebitEntry debitEntry : debitEntriesSet) {
            if (Constants.isPositive(debitEntry.getOpenAmount())) continue;
            throw new TreasuryDomainException("error.ForwardPayment.open.amount.debit.entry.not.positive", new String[0]);
        }
        BigDecimal amount = debitEntriesSet.stream().map(DebitEntry::getOpenAmountWithInterests).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        this.setAmount(debtAccount.getFinantialInstitution().getCurrency().getValueWithScale(amount));
        this.setOrderNumber(ForwardPayment.lastForwardPayment().isPresent() ? ForwardPayment.lastForwardPayment().get().getOrderNumber() + 1L : 1L);
        this.log();
        this.checkRules();
    }

    public void reject(String statusCode, String errorMessage, String requestBody, String responseBody) {
        this.setCurrentState(ForwardPaymentStateType.REJECTED);
        this.setRejectionCode(statusCode);
        this.setRejectionLog(errorMessage);
        this.log(statusCode, errorMessage, requestBody, responseBody);
        this.checkRules();
    }

    public void advanceToRequestState(String statusCode, String statusMessage, String requestBody, String responseBody) {
        this.setCurrentState(ForwardPaymentStateType.REQUESTED);
        this.log(statusCode, statusMessage, requestBody, responseBody);
        this.checkRules();
    }

    public void advanceToAuthenticatedState(String statusCode, String statusMessage, String requestBody, String responseBody) {
        this.setCurrentState(ForwardPaymentStateType.AUTHENTICATED);
        this.log(statusCode, statusMessage, requestBody, responseBody);
        this.checkRules();
    }

    public void advanceToAuthorizedState(String statusCode, String errorMessage, String requestBody, String responseBody) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.ForwardPayment.not.in.active.state", new String[0]);
        }
        if (this.isInAuthorizedState()) {
            throw new TreasuryDomainException("error.ForwardPayment.already.authorized", new String[0]);
        }
        if (this.isInPayedState()) {
            throw new ForwardPaymentAlreadyPayedException("error.ForwardPayment.already.payed", new String[0]);
        }
        this.setCurrentState(ForwardPaymentStateType.AUTHORIZED);
        this.log(statusCode, errorMessage, requestBody, responseBody);
        this.checkRules();
    }

    public void advanceToPayedState(String statusCode, String statusMessage, BigDecimal payedAmount, DateTime transactionDate, String transactionId, String authorizationNumber, String requestBody, String responseBody, String justification) {
        if (!this.isActive()) {
            throw new TreasuryDomainException("error.ForwardPayment.not.in.active.state", new String[0]);
        }
        if (this.isInPayedState()) {
            throw new ForwardPaymentAlreadyPayedException("error.ForwardPayment.already.payed", new String[0]);
        }
        if (this.getSettlementNote() != null) {
            throw new TreasuryDomainException("error.ForwardPayment.with.settlement.note.already.associated", new String[0]);
        }
        this.setTransactionId(transactionId);
        this.setAuthorizationId(authorizationNumber);
        this.setTransactionDate(transactionDate);
        this.setPayedAmount(payedAmount);
        this.setCurrentState(ForwardPaymentStateType.PAYED);
        this.log(statusCode, statusMessage, requestBody, responseBody);
        FinantialInstitution finantialInstitution = this.getDebtAccount().getFinantialInstitution();
        DocumentNumberSeries settlementSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForSettlementNote(), finantialInstitution).get();
        this.setSettlementNote(SettlementNote.create(this.getDebtAccount(), settlementSeries, new DateTime(), transactionDate, String.valueOf(this.getOrderNumber()), null));
        DocumentNumberSeries debitNoteSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), finantialInstitution).get();
        BigDecimal amountToConsume = payedAmount;
        ArrayList orderedEntries = Lists.newArrayList((Iterable)this.getDebitEntriesSet());
        Collections.sort(orderedEntries, COMPARE_DEBIT_ENTRIES);
        Map<String, String> paymentEntryPropertiesMap = this.fillPaymentEntryPropertiesMap(statusCode);
        PaymentEntry.create(this.getForwardPaymentConfiguration().getPaymentMethod(), this.getSettlementNote(), amountToConsume, null, paymentEntryPropertiesMap);
        if (this.referencedCustomers(orderedEntries).size() == 1) {
            for (DebitEntry debitEntry : orderedEntries) {
                if (debitEntry.isAnnulled() || !debitEntry.isInDebt()) continue;
                if (debitEntry.getFinantialDocument() == null) {
                    DebitNote debitNote = DebitNote.create(this.getDebtAccount(), debitNoteSeries, new DateTime());
                    debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
                }
                if (debitEntry.getFinantialDocument().isPreparing()) {
                    debitEntry.getFinantialDocument().closeDocument();
                }
                if (Constants.isGreaterThan(debitEntry.getOpenAmount(), amountToConsume)) break;
                amountToConsume = amountToConsume.subtract(debitEntry.getOpenAmount());
                SettlementEntry.create((InvoiceEntry)((Object)debitEntry), this.getSettlementNote(), debitEntry.getOpenAmount(), debitEntry.getDescription(), transactionDate, true);
            }
            block1: for (DebitEntry de : orderedEntries) {
                if (de.isAnnulled()) continue;
                for (DebitEntry interestDebitEntry : de.getInterestDebitEntriesSet()) {
                    if (interestDebitEntry.isAnnulled() || !interestDebitEntry.isInDebt()) continue;
                    if (Constants.isGreaterThan(interestDebitEntry.getOpenAmount(), amountToConsume)) continue block1;
                    if (interestDebitEntry.getFinantialDocument() == null) {
                        DebitNote debitNote = DebitNote.create(this.getDebtAccount(), debitNoteSeries, new DateTime());
                        debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{interestDebitEntry}));
                        debitNote.closeDocument();
                    }
                    amountToConsume = amountToConsume.subtract(interestDebitEntry.getOpenAmount());
                    SettlementEntry.create((InvoiceEntry)((Object)interestDebitEntry), this.getSettlementNote(), interestDebitEntry.getOpenAmount(), interestDebitEntry.getDescription(), transactionDate, true);
                }
            }
        }
        if (Constants.isPositive(amountToConsume)) {
            this.getSettlementNote().createAdvancedPaymentCreditNote(amountToConsume, Constants.treasuryBundle("label.ForwardPayment.advancedpayment", String.valueOf(this.getOrderNumber())), String.valueOf(this.getOrderNumber()));
        }
        this.getSettlementNote().closeDocument();
        this.setJustification(justification);
        this.checkRules();
    }

    private Map<String, String> fillPaymentEntryPropertiesMap(String statusCode) {
        HashMap paymentEntryPropertiesMap = Maps.newHashMap();
        paymentEntryPropertiesMap.put("OrderNumber", String.valueOf(this.getOrderNumber()));
        if (!Strings.isNullOrEmpty((String)this.getTransactionId())) {
            paymentEntryPropertiesMap.put("TransactionId", this.getTransactionId());
        }
        if (this.getTransactionDate() != null) {
            paymentEntryPropertiesMap.put("TransactionDate", this.getTransactionDate().toString("yyyy/MM/dd HH:mm:ss"));
        }
        if (!Strings.isNullOrEmpty((String)statusCode)) {
            paymentEntryPropertiesMap.put("StatusCode", statusCode);
        }
        return paymentEntryPropertiesMap;
    }

    private Set<Customer> referencedCustomers(List<DebitEntry> orderedEntries) {
        HashSet result = Sets.newHashSet();
        for (DebitEntry debitEntry : orderedEntries) {
            if (debitEntry.getFinantialDocument() != null && ((Invoice)((Object)debitEntry.getFinantialDocument())).isForPayorDebtAccount()) {
                result.add(((Invoice)((Object)debitEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(debitEntry.getDebtAccount().getCustomer());
        }
        return result;
    }

    public boolean isActive() {
        return this.getCurrentState() != ForwardPaymentStateType.REJECTED;
    }

    public boolean isInCreatedState() {
        return this.getCurrentState() == ForwardPaymentStateType.CREATED;
    }

    public boolean isInAuthorizedState() {
        return this.getCurrentState() == ForwardPaymentStateType.AUTHORIZED;
    }

    public boolean isInPayedState() {
        return this.getCurrentState() == ForwardPaymentStateType.PAYED;
    }

    public boolean isInAuthenticatedState() {
        return this.getCurrentState() == ForwardPaymentStateType.AUTHENTICATED;
    }

    public boolean isInRequestedState() {
        return this.getCurrentState() == ForwardPaymentStateType.REQUESTED;
    }

    public String getReferenceNumber() {
        return String.valueOf(this.getOrderNumber());
    }

    public List<ForwardPaymentLog> getOrderedForwardPaymentLogs() {
        return this.getForwardPaymentLogsSet().stream().sorted(ForwardPaymentLog.COMPARATOR_BY_ORDER).collect(Collectors.toList());
    }

    private void checkRules() {
        if (this.isInPayedState() && this.getSettlementNote() == null) {
            throw new TreasuryDomainException("error.ForwardPayment.settlementNote.required", new String[0]);
        }
        if (this.referencedCustomers().size() > 1) {
            throw new TreasuryDomainException("error.ForwardPayment.referencedCustomers.only.one.allowed", new String[0]);
        }
    }

    private Set<Customer> referencedCustomers() {
        HashSet result = Sets.newHashSet();
        for (DebitEntry debitEntry : this.getDebitEntriesSet()) {
            if (debitEntry.getFinantialDocument() != null && ((Invoice)((Object)debitEntry.getFinantialDocument())).isForPayorDebtAccount()) {
                result.add(((Invoice)((Object)debitEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(debitEntry.getDebtAccount().getCustomer());
        }
        return result;
    }

    public ForwardPaymentLog log(String statusCode, String statusMessage, String requestBody, String responseBody) {
        ForwardPaymentLog log = this.log();
        log.setStatusCode(statusCode);
        log.setStatusLog(statusMessage);
        if (!Strings.isNullOrEmpty((String)requestBody)) {
            ForwardPaymentLogFile.createForRequestBody(log, requestBody.getBytes());
        }
        if (!Strings.isNullOrEmpty((String)responseBody)) {
            ForwardPaymentLogFile.createForResponseBody(log, responseBody.getBytes());
        }
        return log;
    }

    private ForwardPaymentLog log() {
        return new ForwardPaymentLog(this, this.getCurrentState(), this.getWhenOccured());
    }

    public void delete() {
        this.setDebtAccount(null);
        this.setForwardPaymentConfiguration(null);
        this.setSettlementNote(null);
        this.setDomainRoot(null);
        this.getDebitEntriesSet().clear();
        while (!this.getForwardPaymentLogsSet().isEmpty()) {
            ((ForwardPaymentLog)((Object)this.getForwardPaymentLogsSet().iterator().next())).delete();
        }
        this.deleteDomainObject();
    }

    public static Stream<ForwardPayment> findAll() {
        return FenixFramework.getDomainRoot().getForwardPaymentsSet().stream();
    }

    public static Stream<ForwardPayment> findAllByStateType(ForwardPaymentStateType ... stateTypes) {
        ArrayList t = Lists.newArrayList((Object[])stateTypes);
        return ForwardPayment.findAll().filter(f -> t.contains((Object)f.getCurrentState()));
    }

    public static ForwardPayment create(ForwardPaymentConfiguration forwardPaymentConfiguration, DebtAccount debtAccount, Set<DebitEntry> debitEntriesToPay) {
        return new ForwardPayment(forwardPaymentConfiguration, debtAccount, debitEntriesToPay);
    }

    private static Optional<ForwardPayment> lastForwardPayment() {
        return FenixFramework.getDomainRoot().getForwardPaymentsSet().stream().max(ORDER_COMPARATOR);
    }

    public static void postForwardPaymentProcessService(final DateTime beginDate, final DateTime endDate, final Logger logger) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ForwardPayment._postForwardPaymentProcessService(beginDate, endDate, logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            t.start();
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void _postForwardPaymentProcessService(DateTime dateTime, DateTime dateTime2, Logger logger) throws IOException {
        Object object = advice$_postForwardPaymentProcessService.perform((Callable)new ForwardPayment$callable$_postForwardPaymentProcessService(dateTime, dateTime2, logger));
    }

    static /* synthetic */ void advised$_postForwardPaymentProcessService(DateTime beginDate, DateTime endDate, Logger logger) throws IOException {
        if (beginDate == null || endDate == null) {
            throw new TreasuryDomainException("error.ForwardPayment.postForwardPaymentProcessService.dates.required", new String[0]);
        }
        DateTime postForwardPaymentsExecutionDate = new DateTime();
        ArrayList reportBeans = Lists.newArrayList();
        ForwardPayment.findAllByStateType(ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED).filter(f -> f.getWhenOccured().compareTo((ReadableInstant)beginDate) >= 0 && f.getWhenOccured().compareTo((ReadableInstant)endDate) < 0).forEach(f -> {
            try {
                PostForwardPaymentReportBean reportBean = ForwardPayment.updateForwardPayment(f.getExternalId(), logger);
                if (reportBean != null) {
                    logger.info(String.format("C\tPAYMENT REQUEST\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n", reportBean.executionDate, reportBean.forwardPaymentExternalId, reportBean.forwardPaymentOrderNumber, reportBean.customerCode, reportBean.customerName, reportBean.previousStateDescription, reportBean.nextStateDescription, reportBean.paymentRegisteredWithSuccess, reportBean.settlementNote, reportBean.advancedPaymentCreditNote, reportBean.paymentDate, reportBean.paidAmount, reportBean.advancedCreditAmount != null ? reportBean.advancedCreditAmount.toString() : "", reportBean.transactionId, reportBean.statusCode, reportBean.statusMessage, reportBean.remarks));
                    reportBeans.add(reportBean);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        ForwardPayment.writeExcel(reportBeans, postForwardPaymentsExecutionDate, beginDate, endDate);
    }

    private static void writeExcel(final List<PostForwardPaymentReportBean> reportBeans, DateTime postForwardPaymentsExecutionDate, DateTime beginDate, DateTime endDate) {
        byte[] content = Spreadsheet.buildSpreadsheetContent(new Spreadsheet(){

            @Override
            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{new ExcelSheet(){

                    @Override
                    public String getName() {
                        return Constants.treasuryBundle("label.PostForwardPaymentReportBean.sheet.name", new String[0]);
                    }

                    @Override
                    public String[] getHeaders() {
                        return new String[]{Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.executionDate", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.forwardPaymentExternalId", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.forwardPaymentOrderNumber", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.forwardPaymentWhenOccured", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.customerCode", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.customerName", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.previousStateDescription", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.nextStateDescription", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.paymentRegisteredWithSuccess", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.settlementNote", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.advancedCreditSettlementNote", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.paymentDate", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.paidAmount", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.advancedCreditAmount", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.transactionId", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.statusCode", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.statusMessage", new String[0]), Constants.treasuryBundle("label.PostForwardPaymentReportBean.cell.remarks", new String[0])};
                    }

                    @Override
                    public Stream<? extends SpreadsheetRow> getRows() {
                        return reportBeans.stream();
                    }
                }};
            }
        }, null);
        String filename = Constants.treasuryBundle("label.PostForwardPaymentsReportFile.filename", postForwardPaymentsExecutionDate.toString("yyyy_MM_dd_HH_mm_ss"));
        PostForwardPaymentsReportFile.create(postForwardPaymentsExecutionDate, beginDate, endDate, filename, content);
    }

    private static PostForwardPaymentReportBean updateForwardPayment(final String forwardPaymentId, Logger logger) throws IOException {
        try {
            PostForwardPaymentReportBean reportBean = (PostForwardPaymentReportBean)FenixFramework.getTransactionManager().withTransaction((Callable)new Callable<PostForwardPaymentReportBean>(){

                @Override
                public PostForwardPaymentReportBean call() throws Exception {
                    ForwardPayment forwardPayment = (ForwardPayment)FenixFramework.getDomainObject((String)forwardPaymentId);
                    IForwardPaymentImplementation implementation = forwardPayment.getForwardPaymentConfiguration().implementation();
                    String justification = Constants.treasuryBundle("error.PostForwardPaymentsTask.post.payment.justification", new String[0]);
                    PostProcessPaymentStatusBean postProcessPaymentStatusBean = implementation.postProcessPayment(forwardPayment, justification);
                    return new PostForwardPaymentReportBean(forwardPayment, postProcessPaymentStatusBean);
                }
            });
            return reportBean;
        }
        catch (Exception e) {
            String message = e.getMessage();
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            String exceptionOutput = String.format("E\tERROR ON\t%s\t%s\n", forwardPaymentId, message);
            logger.error(exceptionOutput);
            logger.error(stackTrace + "\n");
            return null;
        }
    }

    static {
        advice$_postForwardPaymentProcessService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        ORDER_COMPARATOR = new Comparator<ForwardPayment>(){

            @Override
            public int compare(ForwardPayment o1, ForwardPayment o2) {
                return Long.valueOf(o1.getOrderNumber()).compareTo(o2.getOrderNumber());
            }
        };
        COMPARE_DEBIT_ENTRIES = new Comparator<DebitEntry>(){

            @Override
            public int compare(DebitEntry o1, DebitEntry o2) {
                Product interestProduct = TreasurySettings.getInstance().getInterestProduct();
                if (o1.getProduct() == interestProduct && o2.getProduct() != interestProduct) {
                    return -1;
                }
                if (o1.getProduct() != interestProduct && o2.getProduct() == interestProduct) {
                    return 1;
                }
                int compareByOpenAmount = o1.getOpenAmount().compareTo(o2.getOpenAmount());
                if (compareByOpenAmount != 0) {
                    return compareByOpenAmount * -1;
                }
                return o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }

    private static class PostForwardPaymentReportBean
    implements SpreadsheetRow {
        private String executionDate = new DateTime().toString("yyyy/MM/dd HH:mm:ss");
        private String forwardPaymentExternalId;
        private String forwardPaymentOrderNumber;
        private String forwardPaymentWhenOccured;
        private String customerCode;
        private String customerName;
        private String previousStateDescription;
        private String nextStateDescription;
        private boolean paymentRegisteredWithSuccess;
        private String settlementNote = "";
        private String advancedPaymentCreditNote = "";
        private String paymentDate = "";
        private String paidAmount = "";
        private BigDecimal advancedCreditAmount;
        private String transactionId = "";
        private String statusCode;
        private String statusMessage;
        private String remarks = "";

        private PostForwardPaymentReportBean(ForwardPayment forwardPayment, PostProcessPaymentStatusBean postProcessPaymentStatusBean) {
            this.forwardPaymentExternalId = forwardPayment.getExternalId();
            this.forwardPaymentOrderNumber = forwardPayment.getReferenceNumber();
            this.forwardPaymentWhenOccured = forwardPayment.getWhenOccured().toString("yyyy/MM/dd HH:mm:ss");
            this.customerCode = forwardPayment.getDebtAccount().getCustomer().getBusinessIdentification();
            this.customerName = forwardPayment.getDebtAccount().getCustomer().getName();
            this.previousStateDescription = postProcessPaymentStatusBean.getPreviousState().getLocalizedName().getContent();
            this.nextStateDescription = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStateType().getLocalizedName().getContent();
            this.paymentRegisteredWithSuccess = postProcessPaymentStatusBean.isSuccess();
            if (forwardPayment.getSettlementNote() != null) {
                this.settlementNote = forwardPayment.getSettlementNote().getUiDocumentNumber();
                this.paymentDate = forwardPayment.getSettlementNote().getPaymentDate().toString("yyyy/MM/dd HH:mm:ss");
                this.paidAmount = forwardPayment.getSettlementNote().getTotalPayedAmount().toString();
                this.transactionId = forwardPayment.getTransactionId();
                if (forwardPayment.getSettlementNote().getAdvancedPaymentCreditNote() != null) {
                    this.advancedPaymentCreditNote = forwardPayment.getSettlementNote().getAdvancedPaymentCreditNote().getUiDocumentNumber();
                    this.advancedCreditAmount = forwardPayment.getSettlementNote().getAdvancedPaymentCreditNote().getTotalAmount();
                }
                if (this.hasSettlementNotesOnSameDayForSameDebts(forwardPayment)) {
                    this.remarks = Constants.treasuryBundle("warn.PostForwardPaymentsTask.settlement.notes.on.same.day.for.same.debts", new String[0]);
                }
            }
            this.statusCode = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStatusCode();
            this.statusMessage = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStatusMessage();
        }

        private boolean hasSettlementNotesOnSameDayForSameDebts(ForwardPayment forwardPayment) {
            LocalDate paymentDate = forwardPayment.getSettlementNote().getPaymentDate().toLocalDate();
            Set forwardPaymentDebitEntriesSet = forwardPayment.getDebitEntriesSet();
            for (SettlementNote settlementNote : SettlementNote.findByDebtAccount(forwardPayment.getDebtAccount()).collect(Collectors.toSet())) {
                if (settlementNote == forwardPayment.getSettlementNote() || settlementNote.isAnnulled() || !settlementNote.getPaymentDate().toLocalDate().isEqual((ReadablePartial)paymentDate)) continue;
                for (SettlementEntry settlementEntry : settlementNote.getSettlemetEntriesSet()) {
                    if (!forwardPaymentDebitEntriesSet.contains((Object)settlementEntry.getInvoiceEntry())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void writeCellValues(Row row, IErrorsLog errorsLog) {
            int i = 0;
            row.createCell(i++).setCellValue(this.executionDate);
            row.createCell(i++).setCellValue(this.forwardPaymentExternalId);
            row.createCell(i++).setCellValue(this.forwardPaymentOrderNumber);
            row.createCell(i++).setCellValue(this.forwardPaymentWhenOccured);
            row.createCell(i++).setCellValue(this.customerCode);
            row.createCell(i++).setCellValue(this.customerName);
            row.createCell(i++).setCellValue(this.previousStateDescription);
            row.createCell(i++).setCellValue(this.nextStateDescription);
            row.createCell(i++).setCellValue(Constants.treasuryBundle("label." + this.paymentRegisteredWithSuccess, new String[0]));
            row.createCell(i++).setCellValue(this.settlementNote);
            row.createCell(i++).setCellValue(this.advancedPaymentCreditNote);
            row.createCell(i++).setCellValue(this.paymentDate);
            row.createCell(i++).setCellValue(this.paidAmount);
            row.createCell(i++).setCellValue(this.advancedCreditAmount != null ? this.advancedCreditAmount.toString() : "");
            row.createCell(i++).setCellValue(this.transactionId);
            row.createCell(i++).setCellValue(this.statusCode);
            row.createCell(i++).setCellValue(this.statusMessage);
            row.createCell(i++).setCellValue(this.remarks);
        }
    }
}

