/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.event.TreasuryEvent$callable$annulAllDebitEntries;
import org.fenixedu.treasury.domain.event.TreasuryEvent$callable$delete;
import org.fenixedu.treasury.domain.event.TreasuryEvent_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class TreasuryEvent
extends TreasuryEvent_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$annulAllDebitEntries = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public abstract String getERPIntegrationMetadata();

    protected TreasuryEvent() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(Product product, LocalizedString description) {
        this.setProduct(product);
        this.setDescription(description);
    }

    protected void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.TreasuryEvent.bennu.required", new String[0]);
        }
    }

    public boolean isExempted(Product product) {
        return TreasuryExemption.findUnique(this, product).isPresent();
    }

    public boolean isChargedWithDebitEntry() {
        return this.isChargedWithDebitEntry(null);
    }

    public boolean isChargedWithDebitEntry(Product product) {
        if (product != null) {
            return DebitEntry.findActive(this, product).count() > 0L;
        }
        return DebitEntry.findActive(this).filter(d -> !d.isEventAnnuled()).count() > 0L;
    }

    public BigDecimal getAmountToPay() {
        return this.getAmountToPay(null, null);
    }

    public BigDecimal getAmountToPay(Customer customer, Product product) {
        BigDecimal result;
        Stream<? extends DebitEntry> s;
        Stream<? extends DebitEntry> stream = s = product != null ? DebitEntry.findActive(this, product) : DebitEntry.findActive(this);
        if (customer != null) {
            s = s.filter(d -> d.getDebtAccount().getCustomer() == customer);
        }
        return Constants.isPositive(result = s.map(d -> d.getTotalAmount()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO).subtract(this.getCreditAmount(customer, product))) ? result : BigDecimal.ZERO;
    }

    public BigDecimal getInterestsAmountToPay() {
        return this.getInterestsAmountToPay(null, null);
    }

    public BigDecimal getInterestsAmountToPay(Customer customer) {
        return this.getInterestsAmountToPay(customer, null);
    }

    public BigDecimal getInterestsAmountToPay(Customer customer, Product product) {
        BigDecimal result;
        Product interestProduct = TreasurySettings.getInstance().getInterestProduct();
        Stream<DebitEntry> s = DebitEntry.findActive(this).filter(d -> d.getProduct() == interestProduct).filter(d -> product == null || d.getDebitEntry() != null && d.getDebitEntry().getProduct() == product);
        if (customer != null) {
            s = s.filter(d -> d.getDebtAccount().getCustomer() == customer);
        }
        return Constants.isPositive(result = s.map(d -> d.getTotalAmount()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO).subtract(this.getInterestsCreditAmount(product))) ? result : BigDecimal.ZERO;
    }

    public BigDecimal getCreditAmount() {
        return this.getCreditAmount(null, null);
    }

    public BigDecimal getCreditAmount(Customer customer, Product product) {
        Stream<? extends CreditEntry> s;
        Stream<? extends CreditEntry> stream = s = product != null ? CreditEntry.findActive(this, product) : CreditEntry.findActive(this);
        if (customer != null) {
            s = s.filter(d -> d.getDebtAccount().getCustomer() == customer);
        }
        return s.map(c -> c.getAmountWithVat()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getInterestsCreditAmount() {
        return this.getInterestsCreditAmount(null);
    }

    public BigDecimal getInterestsCreditAmount(Product product) {
        Product interestProduct = TreasurySettings.getInstance().getInterestProduct();
        return CreditEntry.findActive(this).filter(c -> c.getDebitEntry().getProduct() == interestProduct).filter(c -> product == null || c.getDebitEntry().getDebitEntry() != null && c.getDebitEntry().getDebitEntry().getProduct() == product).map(c -> c.getAmountWithVat()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getPayedAmount() {
        return this.getAmountToPay().subtract(this.getRemainingAmountToPay());
    }

    public BigDecimal getRemainingAmountToPay() {
        return this.getRemainingAmountToPay(null);
    }

    public BigDecimal getRemainingAmountToPay(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        for (DebitEntry debitEntry : DebitEntry.findActive(this).collect(Collectors.toSet())) {
            result = result.add(debitEntry.getOpenAmount());
        }
        return Constants.isPositive(result) ? result : BigDecimal.ZERO;
    }

    public BigDecimal getExemptedAmount() {
        BigDecimal result = DebitEntry.findActive(this).map(l -> l.getExemptedAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        result = result.add(CreditEntry.findActive(this).filter(l -> l.isFromExemption()).map(l -> l.getAmountWithVat()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
        return result;
    }

    public Map<String, String> getPropertiesMap() {
        return Constants.propertiesJsonToMap(this.getPropertiesJsonMap());
    }

    public Set<Product> getPossibleProductsToExempt() {
        return Sets.newHashSet((Object[])new Product[]{this.getProduct()});
    }

    public boolean isDeletable() {
        return true;
    }

    public abstract LocalDate getTreasuryEventDate();

    public abstract String getDegreeCode();

    public abstract String getDegreeName();

    public abstract String getExecutionYearName();

    public abstract void copyDebitEntryInformation(DebitEntry var1, DebitEntry var2);

    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryEvent$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryEvent this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.TreasuryEvent.cannot.delete", new String[0]);
        }
        this_.setDebtAccount(null);
        this_.setProduct(null);
        this_.setDomainRoot(null);
        super.deleteDomainObject();
    }

    public void annulAllDebitEntries(String string) {
        Object object = advice$annulAllDebitEntries.perform((Callable)new TreasuryEvent$callable$annulAllDebitEntries(this, string));
    }

    static /* synthetic */ void advised$annulAllDebitEntries(TreasuryEvent this_, String reason) {
        while (DebitEntry.findActive(this_).map(DebitEntry.class::cast).count() > 0L) {
            DebitEntry debitEntry = DebitEntry.findActive(this_).map(DebitEntry.class::cast).findFirst().get();
            if (debitEntry.isProcessedInClosedDebitNote() && Constants.isEqual(debitEntry.getAvailableAmountForCredit(), BigDecimal.ZERO)) {
                debitEntry.annulOnEvent();
                continue;
            }
            if (debitEntry.isAnnulled()) continue;
            if (!debitEntry.isProcessedInDebitNote()) {
                DebitNote debitNote = DebitNote.create(debitEntry.getDebtAccount(), DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), debitEntry.getDebtAccount().getFinantialInstitution()).get(), new DateTime());
                debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
            }
            if (!debitEntry.isProcessedInClosedDebitNote()) {
                ((DebitNote)((Object)debitEntry.getFinantialDocument())).anullDebitNoteWithCreditNote(reason, false);
            }
            for (DebitEntry debitEntry2 : ((DebitNote)((Object)debitEntry.getFinantialDocument())).getDebitEntriesSet()) {
                for (DebitEntry interestDebitEntry : debitEntry2.getInterestDebitEntriesSet()) {
                    if (interestDebitEntry.isAnnulled()) continue;
                    if (!interestDebitEntry.isProcessedInDebitNote()) {
                        DebitNote debitNoteForUnprocessedEntries = DebitNote.create(debitEntry.getDebtAccount(), DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), debitEntry.getDebtAccount().getFinantialInstitution()).get(), new DateTime());
                        interestDebitEntry.setFinantialDocument((FinantialDocument)((Object)debitNoteForUnprocessedEntries));
                    }
                    if (interestDebitEntry.isProcessedInClosedDebitNote()) continue;
                    ((DebitNote)((Object)interestDebitEntry.getFinantialDocument())).anullDebitNoteWithCreditNote(reason, false);
                }
            }
            if (debitEntry.isProcessedInClosedDebitNote()) {
                ((DebitNote)((Object)debitEntry.getFinantialDocument())).anullDebitNoteWithCreditNote(reason, false);
            }
            for (DebitEntry debitEntry3 : ((DebitNote)((Object)debitEntry.getFinantialDocument())).getDebitEntriesSet()) {
                for (DebitEntry interestDebitEntry : debitEntry3.getInterestDebitEntriesSet()) {
                    interestDebitEntry.annulOnEvent();
                }
                debitEntry3.annulOnEvent();
            }
        }
        for (DebitEntry debitEntry : this_.getDebitEntriesSet()) {
            for (DebitEntry interestDebitEntry : debitEntry.getInterestDebitEntriesSet()) {
                interestDebitEntry.annulOnEvent();
            }
            debitEntry.annulOnEvent();
        }
    }

    public boolean isAbleToDeleteAllDebitEntries() {
        return DebitEntry.findActive(this).map(l -> l.isDeletable()).reduce((a, c) -> a != false && c != false).orElse(Boolean.TRUE);
    }

    public void invokeSettlementCallbacks() {
    }

    public Set<TreasuryExemption> getActiveTreasuryEvents() {
        return this.getTreasuryExemptionsSet().stream().filter(t -> !t.getDebitEntry().isEventAnnuled()).collect(Collectors.toSet());
    }

    public static Stream<? extends TreasuryEvent> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryEventsSet().stream();
    }

    public static Stream<? extends TreasuryEvent> find(Customer customer) {
        return customer.getTreasuryEventsSet().stream();
    }

    public static enum TreasuryEventKeys {
        EXECUTION_YEAR,
        EXECUTION_SEMESTER,
        DEGREE_CODE,
        COPIED_FROM_DEBIT_ENTRY_ID,
        COPY_DEBIT_ENTRY_RESPONSIBLE;


        public LocalizedString getDescriptionI18N() {
            return BundleUtil.getLocalizedString((String)Constants.BUNDLE, (String)("label." + TreasuryEvent.class.getSimpleName() + "." + this.name()), (String[])new String[0]);
        }
    }
}

