/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.document.ReimbursementEntry$callable$create;
import org.fenixedu.treasury.domain.document.ReimbursementEntry$callable$delete;
import org.fenixedu.treasury.domain.document.ReimbursementEntry$callable$edit;
import org.fenixedu.treasury.domain.document.ReimbursementEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReimbursementEntry
extends ReimbursementEntry_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ReimbursementEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ReimbursementEntry(SettlementNote settlementNote, PaymentMethod paymentMethod, BigDecimal reimbursedAmount, String reimbursementMethodId) {
        this();
        this.init(settlementNote, paymentMethod, reimbursedAmount, reimbursementMethodId);
    }

    protected void init(SettlementNote settlementNote, PaymentMethod paymentMethod, BigDecimal reimbursedAmount, String reimbursementMethodId) {
        this.setSettlementNote(settlementNote);
        this.setPaymentMethod(paymentMethod);
        this.setReimbursedAmount(reimbursedAmount);
        this.setReimbursementMethodId(reimbursementMethodId);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getSettlementNote() == null) {
            throw new TreasuryDomainException("error.ReimbursementEntry.settlementNote.required", new String[0]);
        }
        if (this.getPaymentMethod() == null) {
            throw new TreasuryDomainException("error.ReimbursementEntry.paymentMethod.required", new String[0]);
        }
    }

    public void edit(SettlementNote settlementNote, PaymentMethod paymentMethod, BigDecimal bigDecimal) {
        Object object = advice$edit.perform((Callable)new ReimbursementEntry$callable$edit(this, settlementNote, paymentMethod, bigDecimal));
    }

    static /* synthetic */ void advised$edit(ReimbursementEntry this_, SettlementNote settlementNote, PaymentMethod paymentMethod, BigDecimal reimbursedAmount) {
        this_.setSettlementNote(settlementNote);
        this_.setPaymentMethod(paymentMethod);
        this_.setReimbursedAmount(reimbursedAmount);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ReimbursementEntry$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ReimbursementEntry this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.ReimbursementEntry.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setPaymentMethod(null);
        this_.setSettlementNote(null);
        this_.deleteDomainObject();
    }

    public static ReimbursementEntry create(SettlementNote settlementNote, PaymentMethod paymentMethod, BigDecimal bigDecimal, String string) {
        return (ReimbursementEntry)((Object)advice$create.perform((Callable)new ReimbursementEntry$callable$create(settlementNote, paymentMethod, bigDecimal, string)));
    }

    static /* synthetic */ ReimbursementEntry advised$create(SettlementNote settlementNote, PaymentMethod paymentMethod, BigDecimal reimbursedAmount, String reimbursementMethodId) {
        return new ReimbursementEntry(settlementNote, paymentMethod, reimbursedAmount, reimbursementMethodId);
    }

    public static Stream<ReimbursementEntry> findAll() {
        return FenixFramework.getDomainRoot().getReimbursementEntriesSet().stream();
    }

    public static Stream<ReimbursementEntry> findBySettlementNote(SettlementNote settlementNote) {
        return settlementNote.getReimbursementEntriesSet().stream();
    }

    public static Stream<ReimbursementEntry> findByPaymentMethod(PaymentMethod paymentMethod) {
        return paymentMethod.getReimbursementEntriesSet().stream();
    }

    public static Stream<ReimbursementEntry> findByReimbursedAmount(BigDecimal reimbursedAmount) {
        return ReimbursementEntry.findAll().filter(i -> reimbursedAmount.equals(i.getReimbursedAmount()));
    }
}

