/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialEntryType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry$callable$recalculateAmountValues;
import org.fenixedu.treasury.domain.document.InvoiceEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class InvoiceEntry
extends InvoiceEntry_Base {
    public static final Comparator<InvoiceEntry> COMPARE_BY_DUE_DATE;
    public static final Comparator<InvoiceEntry> COMPARE_BY_ENTRY_DATE;
    public static final Comparator<InvoiceEntry> COMPARE_BY_AMOUNT_AND_DUE_DATE;
    public static final Comparator<InvoiceEntry> COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION;
    public static final Advice advice$recalculateAmountValues;

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getFinantialDocument() != null && !this.getFinantialDocument().isPreparing()) {
            blockers.add(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.invoiceentry.cannot.be.deleted.document.is.not.preparing", (String[])new String[0]));
        }
        if (!this.getSettlementEntriesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.invoiceentry.cannot.be.deleted.settlemententries.is.not.empty", (String[])new String[0]));
        }
    }

    public boolean isDebitNoteEntry() {
        return false;
    }

    public boolean isCreditNoteEntry() {
        return false;
    }

    public boolean isProcessedInDebitNote() {
        return this.getFinantialDocument() != null;
    }

    public boolean isProcessedInClosedDebitNote() {
        return this.isProcessedInDebitNote() && this.getFinantialDocument().isClosed();
    }

    public void delete() {
        TreasuryDomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setCurrency(null);
        this.setDebtAccount(null);
        this.setVat(null);
        this.setProduct(null);
        super.delete();
    }

    protected void init(FinantialDocument finantialDocument, FinantialEntryType finantialEntryType, BigDecimal amount, String description, DateTime entryDateTime) {
        throw new RuntimeException("error.InvoiceEntry.use.init.with.product");
    }

    protected void init(FinantialDocument finantialDocument, DebtAccount debtAccount, Product product, FinantialEntryType finantialEntryType, Vat vat, BigDecimal amount, String description, BigDecimal quantity, DateTime entryDateTime) {
        super.init(finantialDocument, finantialEntryType, amount, description, entryDateTime);
        if (debtAccount.getClosed()) {
            throw new TreasuryDomainException("error.InvoiceEntry.debtAccount.closed", new String[0]);
        }
        this.setQuantity(quantity);
        this.setCurrency(debtAccount.getFinantialInstitution().getCurrency());
        this.setDebtAccount(debtAccount);
        this.setProduct(product);
        this.setVat(vat);
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getQuantity() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.quantity.required", new String[0]);
        }
        if (this.getQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            throw new TreasuryDomainException("error.FinantialDocumentEntry.quantity.less.than.zero", new String[0]);
        }
        if (this.getFinantialDocument() != null && !(this.getFinantialDocument() instanceof Invoice)) {
            throw new TreasuryDomainException("error.InvoiceEntry.finantialDocument.not.invoice.type", new String[0]);
        }
        if (this.getProduct() == null) {
            throw new TreasuryDomainException("error.InvoiceEntry.product.required", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.InvoiceEntry.debtAccount.required", new String[0]);
        }
        if (this.getCurrency() == null) {
            throw new TreasuryDomainException("error.InvoiceEntry.currency.required", new String[0]);
        }
        if (this.getVat() == null) {
            throw new TreasuryDomainException("error.InvoiceEntry.vat.required", new String[0]);
        }
        if (this.getFinantialDocument() != null && this.getFinantialDocument().getDebtAccount() != this.getDebtAccount()) {
            throw new TreasuryDomainException("error.InvoiceEntry.invalidDebtAccount", new String[0]);
        }
        if (!this.checkAmountValues()) {
            throw new TreasuryDomainException("error.InvoiceEntry.amount.invalid.consistency", new String[0]);
        }
    }

    protected boolean checkAmountValues() {
        if (this.getNetAmount() != null && this.getVatAmount() != null && this.getAmountWithVat() != null) {
            BigDecimal netAmount = this.getCurrency().getValueWithScale(this.getQuantity().multiply(this.getAmount()));
            BigDecimal vatAmount = this.getCurrency().getValueWithScale(this.getNetAmount().multiply(Constants.rationalRatRate(this)));
            BigDecimal amountWithVat = this.getCurrency().getValueWithScale(this.getNetAmount().multiply(BigDecimal.ONE.add(Constants.rationalRatRate(this))));
            return netAmount.compareTo(this.getNetAmount()) == 0 && vatAmount.compareTo(this.getVatAmount()) == 0 && amountWithVat.compareTo(this.getTotalAmount()) == 0;
        }
        return true;
    }

    protected void recalculateAmountValues() {
        Object object = advice$recalculateAmountValues.perform((Callable)new InvoiceEntry$callable$recalculateAmountValues(this));
    }

    protected static /* synthetic */ void advised$recalculateAmountValues(InvoiceEntry this_) {
        if (this_.getVatRate() == null) {
            this_.setVatRate(super.getVat().getTaxRate());
        }
        this_.setNetAmount(this_.getCurrency().getValueWithScale(this_.getQuantity().multiply(this_.getAmount())));
        this_.setVatAmount(this_.getCurrency().getValueWithScale(this_.getNetAmount().multiply(Constants.rationalRatRate(this_))));
        this_.setAmountWithVat(this_.getCurrency().getValueWithScale(this_.getNetAmount().multiply(BigDecimal.ONE.add(Constants.rationalRatRate(this_)))));
    }

    public static Stream<? extends InvoiceEntry> findAll() {
        return FinantialDocumentEntry.findAll().filter(f -> f instanceof InvoiceEntry).map(InvoiceEntry.class::cast);
    }

    public boolean isPendingForPayment() {
        if (this.getFinantialDocument() != null && this.getFinantialDocument().getState().isAnnuled()) {
            return false;
        }
        return this.getOpenAmount().compareTo(BigDecimal.ZERO) != 0;
    }

    public boolean hasPreparingSettlementEntries() {
        return this.getSettlementEntriesSet().stream().anyMatch(se -> se.getFinantialDocument().isPreparing());
    }

    public BigDecimal getTotalAmount() {
        return this.getAmountWithVat();
    }

    public BigDecimal getPayedAmount() {
        BigDecimal amount = BigDecimal.ZERO;
        for (SettlementEntry entry : this.getSettlementEntriesSet()) {
            if (entry.getFinantialDocument() == null || !entry.getFinantialDocument().isClosed()) continue;
            amount = amount.add(entry.getTotalAmount());
        }
        return amount;
    }

    public BigDecimal getOpenAmount() {
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        BigDecimal openAmount = this.getAmountWithVat().subtract(this.getPayedAmount());
        return this.getCurrency().getValueWithScale(this.isPositive(openAmount) ? openAmount : BigDecimal.ZERO);
    }

    public abstract BigDecimal getOpenAmountWithInterests();

    public abstract LocalDate getDueDate();

    public BigDecimal openAmountAtDate(DateTime when) {
        Currency currency = this.getDebtAccount().getFinantialInstitution().getCurrency();
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        BigDecimal openAmount = this.getAmountWithVat().subtract(this.payedAmountAtDate(when));
        return currency.getValueWithScale(this.isPositive(openAmount) ? openAmount : BigDecimal.ZERO);
    }

    public BigDecimal payedAmountAtDate(DateTime when) {
        BigDecimal amount = BigDecimal.ZERO;
        for (SettlementEntry entry : this.getSettlementEntriesSet()) {
            if (entry.getEntryDateTime().isAfter((ReadableInstant)when) || entry.getFinantialDocument() == null || !entry.getFinantialDocument().isClosed()) continue;
            amount = amount.add(entry.getTotalAmount());
        }
        return amount;
    }

    static {
        advice$recalculateAmountValues = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_DUE_DATE = new Comparator<InvoiceEntry>(){

            @Override
            public int compare(InvoiceEntry o1, InvoiceEntry o2) {
                int c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARE_BY_ENTRY_DATE = new Comparator<InvoiceEntry>(){

            @Override
            public int compare(InvoiceEntry o1, InvoiceEntry o2) {
                int c = o1.getEntryDateTime().compareTo((ReadableInstant)o2.getEntryDateTime());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARE_BY_AMOUNT_AND_DUE_DATE = new Comparator<InvoiceEntry>(){

            @Override
            public int compare(InvoiceEntry o1, InvoiceEntry o2) {
                int c = -o1.getOpenAmount().compareTo(o2.getOpenAmount());
                if (c != 0) {
                    return c;
                }
                c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
                if (c != 0) {
                    return c;
                }
                return o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION = new Comparator<InvoiceEntry>(){

            @Override
            public int compare(InvoiceEntry o1, InvoiceEntry o2) {
                if (o1.getProduct().getTuitionInstallmentOrder() != 0 && o2.getProduct().getTuitionInstallmentOrder() != 0) {
                    int c = Integer.compare(o1.getProduct().getTuitionInstallmentOrder(), o2.getProduct().getTuitionInstallmentOrder());
                    return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
                }
                if (o1.getProduct().getTuitionInstallmentOrder() != 0 && o2.getProduct().getTuitionInstallmentOrder() == 0) {
                    return -1;
                }
                if (o1.getProduct().getTuitionInstallmentOrder() == 0 && o2.getProduct().getTuitionInstallmentOrder() != 0) {
                    return 1;
                }
                int c = o1.getDescription().compareTo(o2.getDescription());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

