/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.util.Constants;

public enum FinantialDocumentStateType {
    PREPARING,
    CLOSED,
    ANNULED;


    public boolean isPreparing() {
        return this == PREPARING;
    }

    public boolean isClosed() {
        return this == CLOSED;
    }

    public boolean isAnnuled() {
        return this == ANNULED;
    }

    public LocalizedString getDescriptionI18N() {
        return BundleUtil.getLocalizedString((String)Constants.BUNDLE, (String)(((Object)((Object)this)).getClass().getSimpleName() + "." + this.name()), (String[])new String[0]);
    }

    public static List<FinantialDocumentStateType> findAll() {
        ArrayList<FinantialDocumentStateType> result = new ArrayList<FinantialDocumentStateType>();
        result.add(CLOSED);
        result.add(PREPARING);
        result.add(ANNULED);
        return result;
    }
}

