/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.text.Normalizer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer$callable$delete;
import org.fenixedu.treasury.domain.Customer$callable$registerFinantialInstitutions;
import org.fenixedu.treasury.domain.Customer_Base;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.IFiscalContributor;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.dto.AdhocCustomerBean;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.util.Constants;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class Customer
extends Customer_Base
implements IFiscalContributor {
    public static final String DEFAULT_FISCAL_NUMBER = "999999990";
    public static final int MAX_CODE_LENGHT = 20;
    public static final Comparator<Customer> COMPARE_BY_NAME_IGNORE_CASE;
    public static final Advice advice$delete;
    public static final Advice advice$registerFinantialInstitutions;

    protected Customer() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public abstract String getCode();

    @Override
    public abstract String getFiscalNumber();

    public abstract String getName();

    public abstract String getFirstNames();

    public abstract String getLastNames();

    public abstract String getIdentificationNumber();

    public abstract String getAddress();

    public abstract String getDistrictSubdivision();

    public abstract String getDistrict();

    public abstract String getZipCode();

    public abstract String getAddressCountryCode();

    public abstract String getCountryCode();

    public abstract String getNationalityCountryCode();

    public abstract String getFiscalCountry();

    public abstract String getPaymentReferenceBaseCode();

    public abstract String getBusinessIdentification();

    public abstract String getEmail();

    public abstract String getPhoneNumber();

    public abstract BigDecimal getGlobalBalance();

    public abstract Set<Customer> getAllCustomers();

    public boolean isDeletable() {
        return false;
    }

    public boolean isPersonCustomer() {
        return false;
    }

    public boolean isAdhocCustomer() {
        return false;
    }

    public abstract boolean isActive();

    public abstract Customer getActiveCustomer();

    public abstract void changeFiscalNumber(AdhocCustomerBean var1);

    public void delete() {
        Object object = advice$delete.perform((Callable)new Customer$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Customer this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.Customer.cannot.delete", new String[0]);
        }
        this_.setCustomerType(null);
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    protected void checkRules() {
        Set customers;
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.Customer.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.Customer.name.required", new String[0]);
        }
        if (Customer.findByCode(this.getCode()).count() > 1L) {
            throw new TreasuryDomainException("error.Customer.code.duplicated", new String[0]);
        }
        if (this.getCode().length() > 20) {
            throw new TreasuryDomainException("error.Customer.code.maxlenght", new String[0]);
        }
        if (!(Constants.isDefaultCountry(this.getFiscalCountry()) && DEFAULT_FISCAL_NUMBER.equals(this.getFiscalNumber()) || (customers = Customer.findByFiscalInformation(this.getFiscalCountry(), this.getFiscalNumber()).filter(c -> c.isActive()).collect(Collectors.toSet())).size() <= 1)) {
            Customer self = this;
            Set otherCustomers = customers.stream().filter(c -> c != self).map(c -> c.getName()).collect(Collectors.toSet());
            throw new TreasuryDomainException("error.Customer.customer.with.fiscal.information.exists", Joiner.on((String)", ").join(otherCustomers));
        }
    }

    public String getShortName() {
        return Constants.firstAndLastWords(this.getName());
    }

    public static Stream<? extends Customer> findAll() {
        return FenixFramework.getDomainRoot().getCustomersSet().stream();
    }

    public static Stream<? extends Customer> find(FinantialInstitution institution) {
        return institution.getDebtAccountsSet().stream().map(debtAccount -> debtAccount.getCustomer());
    }

    public static Stream<? extends Customer> findByCode(String code) {
        return Customer.findAll().filter(i -> code.equalsIgnoreCase(i.getCode()));
    }

    public static Stream<? extends Customer> findByFiscalInformation(String fiscalCountryCode, String fiscalNumber) {
        if (Strings.isNullOrEmpty((String)fiscalCountryCode)) {
            throw new TreasuryDomainException("error.Customer.findByFiscalCountryAndNumber.fiscalCountryCode.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new TreasuryDomainException("error.Customer.findByFiscalCountryAndNumber.fiscalNumber.required", new String[0]);
        }
        return Customer.findAll().filter(c -> !Strings.isNullOrEmpty((String)c.getFiscalCountry()) && Customer.lowerCase(c.getFiscalCountry()).equals(Customer.lowerCase(fiscalCountryCode)) && !Strings.isNullOrEmpty((String)c.getFiscalNumber()) && c.getFiscalNumber().equals(fiscalNumber));
    }

    public boolean matchesMultiFilter(String searchText) {
        if (searchText == null) {
            return false;
        }
        if (searchText.startsWith("#") && searchText.length() > 1) {
            String codeToSearch = searchText.replace("#", "");
            return this.getBusinessIdentification() != null && this.getBusinessIdentification().equals(codeToSearch);
        }
        String searchFieldClear = Normalizer.normalize(searchText.toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        String nameClear = Normalizer.normalize(this.getName().toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
        return Constants.matchNames(nameClear, searchFieldClear) || this.getIdentificationNumber() != null && this.getIdentificationNumber().contains(searchFieldClear) || this.getFiscalNumber() != null && this.getFiscalNumber().toLowerCase().contains(searchFieldClear) || this.getCode() != null && this.getCode().contains(searchFieldClear) || this.getBusinessIdentification() != null && this.getBusinessIdentification().contains(searchFieldClear);
    }

    public Set<FinantialInstitution> getFinantialInstitutions() {
        return this.getDebtAccountsSet().stream().map(x -> x.getFinantialInstitution()).collect(Collectors.toSet());
    }

    public DebtAccount getDebtAccountFor(FinantialInstitution institution) {
        return this.getDebtAccountsSet().stream().filter(x -> x.getFinantialInstitution().equals(institution)).findFirst().orElse(null);
    }

    public void registerFinantialInstitutions(List<FinantialInstitution> list) {
        Object object = advice$registerFinantialInstitutions.perform((Callable)new Customer$callable$registerFinantialInstitutions(this, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$registerFinantialInstitutions(Customer this_, List newFinantialInstitutions) {
        HashSet actualInstitutions = Sets.newHashSet(this_.getFinantialInstitutions());
        for (FinantialInstitution newInst : newFinantialInstitutions) {
            if (actualInstitutions.contains(newInst)) {
                this_.getDebtAccountFor(newInst).reopenDebtAccount();
                continue;
            }
            DebtAccount.create(newInst, this_);
        }
        for (FinantialInstitution actualInst : actualInstitutions) {
            if (newFinantialInstitutions.contains(actualInst)) continue;
            DebtAccount account = this_.getDebtAccountFor(actualInst);
            account.closeDebtAccount();
        }
    }

    public boolean isFiscalCodeValid() {
        return FiscalCodeValidation.isValidFiscalNumber(this.getCountryCode(), this.getFiscalNumber());
    }

    public boolean isFiscalValidated() {
        return FiscalCodeValidation.isValidationAppliedToFiscalCountry(this.getCountryCode());
    }

    public boolean isAbleToChangeFiscalNumber() {
        if (!Strings.isNullOrEmpty((String)this.getErpCustomerId())) {
            return false;
        }
        if (this.isWithFinantialDocumentsIntegratedInERP()) {
            return false;
        }
        return !this.isFiscalValidated() || !this.isFiscalCodeValid();
    }

    public boolean isWithFinantialDocumentsIntegratedInERP() {
        boolean checkedInAllFinantialInstitutions = true;
        for (DebtAccount debtAccount : this.getDebtAccountsSet()) {
            FinantialInstitution institution = debtAccount.getFinantialInstitution();
            if (institution.getErpIntegrationConfiguration() == null) {
                checkedInAllFinantialInstitutions = false;
                break;
            }
            if (Strings.isNullOrEmpty((String)institution.getErpIntegrationConfiguration().getImplementationClassName())) {
                checkedInAllFinantialInstitutions = false;
                break;
            }
            IERPExternalService erpService = institution.getErpIntegrationConfiguration().getERPExternalServiceImplementation();
            if (erpService == null) {
                checkedInAllFinantialInstitutions = false;
                break;
            }
            if (!erpService.getERPExporter().isCustomerWithFinantialDocumentsIntegratedInERP(this)) continue;
            return true;
        }
        return !checkedInAllFinantialInstitutions;
    }

    public boolean isCustomerInformationMaybeIntegratedWithSuccess() {
        boolean checkedInAllFinantialInstitutions = true;
        for (DebtAccount debtAccount : this.getDebtAccountsSet()) {
            FinantialInstitution institution = debtAccount.getFinantialInstitution();
            if (institution.getErpIntegrationConfiguration() == null) {
                checkedInAllFinantialInstitutions = false;
                break;
            }
            if (Strings.isNullOrEmpty((String)institution.getErpIntegrationConfiguration().getImplementationClassName())) {
                checkedInAllFinantialInstitutions = false;
                break;
            }
            IERPExternalService erpService = institution.getErpIntegrationConfiguration().getERPExternalServiceImplementation();
            if (erpService == null) {
                checkedInAllFinantialInstitutions = false;
                break;
            }
            if (!erpService.getERPExporter().isCustomerMaybeIntegratedWithSuccess(this)) continue;
            return true;
        }
        return !checkedInAllFinantialInstitutions;
    }

    public boolean isCustomerWithFinantialDocumentsIntegratedInPreviousERP() {
        boolean checkedInAllFinantialInstitutions = true;
        for (DebtAccount debtAccount : this.getDebtAccountsSet()) {
            FinantialInstitution institution = debtAccount.getFinantialInstitution();
            if (institution.getErpIntegrationConfiguration() == null) {
                checkedInAllFinantialInstitutions = false;
                continue;
            }
            if (Strings.isNullOrEmpty((String)institution.getErpIntegrationConfiguration().getImplementationClassName())) {
                checkedInAllFinantialInstitutions = false;
                break;
            }
            IERPExternalService erpService = institution.getErpIntegrationConfiguration().getERPExternalServiceImplementation();
            if (erpService == null) {
                checkedInAllFinantialInstitutions = false;
                break;
            }
            if (!erpService.getERPExporter().isCustomerWithFinantialDocumentsIntegratedInPreviousERP(this)) continue;
            throw new TreasuryDomainException("error.Customer.changeFiscalNumber.documents.integrated.in.previous.erp", new String[0]);
        }
        return !checkedInAllFinantialInstitutions;
    }

    public String getUiCompleteAddress() {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.getAddress())) {
            sb.append(this.getAddress()).append(", ");
        }
        if (!Strings.isNullOrEmpty((String)this.getZipCode())) {
            sb.append(this.getZipCode()).append(", ");
        }
        if (!Strings.isNullOrEmpty((String)this.getDistrictSubdivision())) {
            sb.append(this.getDistrictSubdivision()).append(", ");
        }
        if (!Strings.isNullOrEmpty((String)this.getDistrict())) {
            sb.append(this.getDistrict()).append(", ");
        }
        if (!Strings.isNullOrEmpty((String)this.getAddressCountryCode())) {
            sb.append(this.getAddressCountryCode()).append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public abstract Set<? extends TreasuryEvent> getTreasuryEventsSet();

    public abstract boolean isUiOtherRelatedCustomerActive();

    public abstract String uiRedirectToActiveCustomer(String var1);

    public String getUiFiscalNumber() {
        String fiscalCountry = !Strings.isNullOrEmpty((String)this.getFiscalCountry()) ? this.getFiscalCountry() : "";
        String fiscalNumber = !Strings.isNullOrEmpty((String)this.getFiscalNumber()) ? this.getFiscalNumber() : "";
        return (fiscalCountry + " " + fiscalNumber).trim();
    }

    public abstract LocalizedString getIdentificationTypeDesignation();

    public abstract String getIdentificationTypeCode();

    public abstract String getIban();

    public boolean isIbanDefined() {
        return !Strings.isNullOrEmpty((String)this.getIban());
    }

    protected static String lowerCase(String value) {
        if (value == null) {
            return null;
        }
        return value.toLowerCase();
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$registerFinantialInstitutions = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME_IGNORE_CASE = new Comparator<Customer>(){

            @Override
            public int compare(Customer o1, Customer o2) {
                int c = o1.getName().compareToIgnoreCase(o2.getName());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

