/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency$callable$create;
import org.fenixedu.treasury.domain.Currency$callable$delete;
import org.fenixedu.treasury.domain.Currency$callable$edit;
import org.fenixedu.treasury.domain.Currency$callable$initializeCurrency;
import org.fenixedu.treasury.domain.Currency_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.Constants;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Currency
extends Currency_Base {
    public static String EURO_CODE;
    public static final Advice advice$initializeCurrency;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    public static void initializeCurrency() {
        Object object = advice$initializeCurrency.perform((Callable)new Currency$callable$initializeCurrency());
    }

    static /* synthetic */ void advised$initializeCurrency() {
        if (Currency.findAll().count() == 0L) {
            Currency.create("EUR", new LocalizedString(Locale.getDefault(), BundleUtil.getString((String)Constants.BUNDLE, (String)"label.Currency.EUR", (String[])new String[0])), BundleUtil.getString((String)Constants.BUNDLE, (String)"label.Currency.EUR", (String[])new String[0]), "\u20ac");
        }
    }

    protected Currency() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected Currency(String code, LocalizedString name, String isoCode, String symbol) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setIsoCode(isoCode);
        this.setSymbol(symbol);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.Currency.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.Currency.name.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getIsoCode())) {
            throw new TreasuryDomainException("error.Currency.isoCode.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getSymbol())) {
            throw new TreasuryDomainException("error.Currency.symbol.required", new String[0]);
        }
        Currency.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> Currency.findByName(this.getName().getContent(l)));
    }

    public void edit(String string, LocalizedString localizedString, String string2, String string3) {
        Object object = advice$edit.perform((Callable)new Currency$callable$edit(this, string, localizedString, string2, string3));
    }

    static /* synthetic */ void advised$edit(Currency this_, String code, LocalizedString name, String isoCode, String symbol) {
        this_.setCode(code);
        this_.setName(name);
        this_.setIsoCode(isoCode);
        this_.setSymbol(symbol);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getFinantialDocumentsSet().isEmpty() && this.getFinantialInstitutionsSet().isEmpty() && this.getInvoiceEntrySet().isEmpty() && this.getTreasurySettings() == null;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Currency$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Currency this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.Currency.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Stream<Currency> findAll() {
        return FenixFramework.getDomainRoot().getCurrenciesSet().stream();
    }

    public static Currency findByCode(String code) {
        Currency result = null;
        for (Currency it : Currency.findAll().collect(Collectors.toList())) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.Currency.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static Currency findByName(String name) {
        Currency result = null;
        for (Currency it : Currency.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.Currency.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static Currency create(String string, LocalizedString localizedString, String string2, String string3) {
        return (Currency)((Object)advice$create.perform((Callable)new Currency$callable$create(string, localizedString, string2, string3)));
    }

    static /* synthetic */ Currency advised$create(String code, LocalizedString name, String isoCode, String symbol) {
        return new Currency(code, name, isoCode, symbol);
    }

    public String getValueFor(BigDecimal value) {
        return this.getValueWithScale(value) + " " + this.getSymbol();
    }

    public String getValueFor(BigDecimal value, int decimalsPlaces) {
        return this.getValueWithScale(value, decimalsPlaces) + " " + this.getSymbol();
    }

    public BigDecimal getValueWithScale(BigDecimal amount) {
        return this.getValueWithScale(amount, 2);
    }

    public BigDecimal getValueWithScale(BigDecimal amount, int decimalPlaces) {
        return amount.setScale(decimalPlaces, RoundingMode.HALF_EVEN);
    }

    static {
        advice$initializeCurrency = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        EURO_CODE = "EUR";
    }
}

