/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.managefinantialinstitution;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.domain.paymentcodes.SibsConfiguration;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate;
import org.fenixedu.treasury.dto.FinantialInstitutionBean;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController$callable$createFinantialInstitution;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController$callable$deleteFinantialInstitution;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController$callable$updateFinantialInstitution;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.LocalDate;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.manageFinantialInstitution", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/managefinantialinstitution/finantialinstitution"})
public class FinantialInstitutionController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution/delete/";
    private static final String SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution/search/view/";
    private static final String CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution/createpostback";
    private static final String UPDATEPOSTBACK_URI = "/updatepostback/";
    public static final String UPDATEPOSTBACK_URL = "/treasury/administration/managefinantialinstitution/finantialinstitution/updatepostback/";
    public static final Advice advice$deleteFinantialInstitution = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createFinantialInstitution = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateFinantialInstitution = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/managefinantialinstitution/finantialinstitution/";
    }

    private FinantialInstitutionBean getFinantialInstitutionBean(Model model) {
        return (FinantialInstitutionBean)model.asMap().get("finantialInstitutionBean");
    }

    private void setFinantialInstitutionBean(FinantialInstitutionBean bean, Model model) {
        bean.updateModelLists();
        model.addAttribute("finantialInstitutionBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("finantialInstitutionBean", (Object)bean);
    }

    private FinantialInstitution getFinantialInstitution(Model m) {
        return (FinantialInstitution)m.asMap().get("finantialInstitution");
    }

    private void setFinantialInstitution(FinantialInstitution finantialInstitution, Model m) {
        m.addAttribute("finantialInstitution", (Object)finantialInstitution);
    }

    public void deleteFinantialInstitution(FinantialInstitution finantialInstitution) {
        Object object = advice$deleteFinantialInstitution.perform((Callable)new FinantialInstitutionController$callable$deleteFinantialInstitution(this, finantialInstitution));
    }

    static /* synthetic */ void advised$deleteFinantialInstitution(FinantialInstitutionController this_, FinantialInstitution finantialInstitution) {
        finantialInstitution.delete();
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        List<FinantialInstitution> searchfinantialinstitutionResultsDataSet = this.getSearchUniverseSearchFinantialInstitutionDataSet();
        this.checkFinantialInstitutionData(model);
        model.addAttribute("searchfinantialinstitutionResultsDataSet", searchfinantialinstitutionResultsDataSet);
        return "treasury/administration/managefinantialinstitution/finantialinstitution/search";
    }

    private List<FinantialInstitution> getSearchUniverseSearchFinantialInstitutionDataSet() {
        return new ArrayList<FinantialInstitution>(FinantialInstitution.findAll().collect(Collectors.toSet()));
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model) {
        return "redirect:/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + finantialInstitution.getExternalId();
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.setFinantialInstitution(finantialInstitution, model);
            this.checkFinantialInstitutionData(model);
            model.addAttribute("finantialDocumentTypeSet", FinantialDocumentType.findAll().collect(Collectors.toList()));
            return "treasury/administration/managefinantialinstitution/finantialinstitution/read";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
    }

    private void checkFinantialInstitutionData(Model model) {
        LocalDate now = new LocalDate();
        if (GlobalInterestRate.findByYear(now.getYear()).count() == 0L) {
            this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"warning.GlobalInterestRate.no.interest.rate.for.current.year", (String[])new String[0]), model);
        }
        if (now.getMonthOfYear() == 12 && GlobalInterestRate.findByYear(now.getYear() + 1).count() == 0L) {
            this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"warning.GlobalInterestRate.no.interest.rate.for.next.year", (String[])new String[0]), model);
        }
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        this.setFinantialInstitution(finantialInstitution, model);
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.deleteFinantialInstitution(finantialInstitution);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getFinantialInstitution(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        if (this.getFinantialInstitutionBean(model) == null) {
            FinantialInstitutionBean bean = new FinantialInstitutionBean();
            this.setFinantialInstitutionBean(bean, model);
        }
        return "treasury/administration/managefinantialinstitution/finantialinstitution/create";
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpostback(@RequestParam(value="bean", required=true) FinantialInstitutionBean bean, Model model) {
        this.assertUserIsManager(model);
        this.setFinantialInstitutionBean(bean, model);
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=true) FinantialInstitutionBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsManager(model);
            this.setFinantialInstitutionBean(bean, model);
            FinantialInstitution finantialInstitution = this.createFinantialInstitution(bean);
            this.setFinantialInstitution(finantialInstitution, model);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.create", (String[])new String[0]), model);
            return this.redirect(READ_URL + this.getFinantialInstitution(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public FinantialInstitution createFinantialInstitution(FinantialInstitutionBean finantialInstitutionBean) {
        return (FinantialInstitution)advice$createFinantialInstitution.perform((Callable)new FinantialInstitutionController$callable$createFinantialInstitution(this, finantialInstitutionBean));
    }

    static /* synthetic */ FinantialInstitution advised$createFinantialInstitution(FinantialInstitutionController this_, FinantialInstitutionBean bean) {
        FinantialInstitution finantialInstitution = FinantialInstitution.create(bean.getFiscalcountryregion(), bean.getCurrency(), bean.getCode(), bean.getFiscalNumber(), bean.getCompanyId(), bean.getName(), bean.getCompanyName(), bean.getAddress(), bean.getCountry(), bean.getDistrict(), bean.getMunicipality(), bean.getLocality(), bean.getZipCode());
        finantialInstitution.setEmail(bean.getEmail());
        finantialInstitution.setTelephoneContact(bean.getTelephone());
        finantialInstitution.setWebAddress(bean.getWebAddress());
        return finantialInstitution;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model) {
        this.setFinantialInstitution(finantialInstitution, model);
        if (this.getFinantialInstitutionBean(model) == null) {
            this.setFinantialInstitutionBean(new FinantialInstitutionBean(finantialInstitution), model);
        }
        return "treasury/administration/managefinantialinstitution/finantialinstitution/update";
    }

    @RequestMapping(value={"/updatepostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updatepostback(@PathVariable(value="oid") FinantialInstitution finantialInstitution, @RequestParam(value="bean", required=true) FinantialInstitutionBean bean, Model model) {
        this.setFinantialInstitutionBean(bean, model);
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") FinantialInstitution finantialInstitution, @RequestParam(value="bean", required=true) FinantialInstitutionBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setFinantialInstitution(finantialInstitution, model);
        this.setFinantialInstitutionBean(bean, model);
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            this.updateFinantialInstitution(bean, model);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.edit", (String[])new String[0]), model);
            return this.redirect(READ_URL + this.getFinantialInstitution(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.edit", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.edit", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(finantialInstitution, model);
    }

    public void updateFinantialInstitution(FinantialInstitutionBean finantialInstitutionBean, Model model) {
        Object object = advice$updateFinantialInstitution.perform((Callable)new FinantialInstitutionController$callable$updateFinantialInstitution(this, finantialInstitutionBean, model));
    }

    static /* synthetic */ void advised$updateFinantialInstitution(FinantialInstitutionController this_, FinantialInstitutionBean bean, Model m) {
        FinantialInstitution finantialInstitution = this_.getFinantialInstitution(m);
        finantialInstitution.edit(bean.getFiscalcountryregion(), bean.getCurrency(), bean.getCode(), bean.getFiscalNumber(), bean.getCompanyId(), bean.getName(), bean.getCompanyName(), bean.getAddress(), bean.getCountry(), bean.getDistrict(), bean.getMunicipality(), bean.getLocality(), bean.getZipCode());
        finantialInstitution.setEmail(bean.getEmail());
        finantialInstitution.setTelephoneContact(bean.getTelephone());
        finantialInstitution.setWebAddress(bean.getWebAddress());
    }

    @RequestMapping(value={"/read/{oid}/exportproductsintegrationfile"}, produces={"text/xml;charset=Windows-1252"})
    public void processReadToExportProductIntegrationFile(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
            String output = erpExporter.exportsProductsToXML(finantialInstitution);
            response.setContentType("text/xml");
            response.setCharacterEncoding("Windows-1252");
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)("ERP_PRODUCTS_" + finantialInstitution.getFiscalNumber() + ".xml")).replaceAll("\\s", "_").replace(" ", "_"), "Windows-1252");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(output.getBytes("Windows-1252"));
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.upload", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + finantialInstitution.getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/read/{oid}/exportcustomersintegrationfile"})
    public void processReadToExportCustomerIntegrationFile(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
            String output = erpExporter.exportsCustomersToXML(finantialInstitution);
            response.setContentType("text/xml");
            response.setCharacterEncoding("Windows-1252");
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)("ERP_CUSTOMERS_" + finantialInstitution.getFiscalNumber() + ".xml")).replaceAll("\\s", "_").replace(" ", "_"), "Windows-1252");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(output.getBytes("Windows-1252"));
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.upload", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + finantialInstitution.getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/read/{oid}/exportproductsintegrationonline"})
    public String processReadToExportProductIntegrationOnline(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
            ERPExportOperation output = erpExporter.exportProductsToIntegration(finantialInstitution);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.integration.erp.exportoperation.success", (String[])new String[0]), model);
            return this.redirect("/treasury/integration/erp/erpexportoperation/read/" + output.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.integration.erp.exportoperation.error", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            this.setFinantialInstitution(finantialInstitution, model);
            return "treasury/administration/managefinantialinstitution/finantialinstitution/read";
        }
    }

    @RequestMapping(value={"/read/{oid}/exportcustomersintegrationonline"})
    public String processReadToExportCustomersIntegrationOnline(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
            ERPExportOperation output = erpExporter.exportCustomersToIntegration(finantialInstitution);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.integration.erp.exportoperation.success", (String[])new String[0]), model);
            return this.redirect("/treasury/integration/erp/erpexportoperation/read/" + output.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.integration.erp.exportoperation.error", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            this.setFinantialInstitution(finantialInstitution, model);
            return "treasury/administration/managefinantialinstitution/finantialinstitution/read";
        }
    }

    @RequestMapping(value={"/read/{oid}/erpconfigurationupdate"})
    public String processReadToERPConfigurationUpdate(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            if (finantialInstitution.getErpIntegrationConfiguration() == null) {
                DocumentNumberSeries paymentsIntegrationSeries = DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), finantialInstitution).filter(x -> x.getSeries().getExternSeries()).findFirst().orElse(null);
                if (paymentsIntegrationSeries == null) {
                    throw new TreasuryDomainException("error.ERPIntegrationConfiguration.invalid.external.payments.series", new String[0]);
                }
                ERPConfiguration erpIntegrationConfiguration = ERPConfiguration.create(paymentsIntegrationSeries.getSeries(), finantialInstitution, "", "", "", "", "", 1024L);
                finantialInstitution.setErpIntegrationConfiguration(erpIntegrationConfiguration);
            }
            return this.redirect("/treasury/integration/erp/erpconfiguration/read/" + finantialInstitution.getErpIntegrationConfiguration().getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.read(finantialInstitution, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/read/{oid}/sibsconfigurationupdate"})
    public String processReadToSibsConfigurationUpdate(@PathVariable(value="oid") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.assertUserIsBackOfficeMember(finantialInstitution, model);
            if (finantialInstitution.getSibsConfiguration() == null) {
                SibsConfiguration sibsConfiguration = SibsConfiguration.create(finantialInstitution, "00000", "000000000", "000000000");
                finantialInstitution.setSibsConfiguration(sibsConfiguration);
            }
            return this.redirect("/treasury/administration/sibs/managesibsconfiguration/sibsconfiguration/read/" + finantialInstitution.getSibsConfiguration().getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.read(finantialInstitution, model, redirectAttributes);
        }
    }
}

