/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.exporters;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.services.payments.exporters.IPaymentCodeGenerator;
import org.fenixedu.treasury.services.payments.exporters.PaymentCodeGeneratorsErrors;
import org.joda.time.DateTime;

public class PaymentCodeGeneratorsRegistry {
    protected static List<IPaymentCodeGenerator> generators = new ArrayList<IPaymentCodeGenerator>();
    final PaymentCodeGeneratorsErrors errors = new PaymentCodeGeneratorsErrors();

    public static PaymentCodeGeneratorsRegistry createInstance() {
        return new PaymentCodeGeneratorsRegistry();
    }

    public static void registerExporterAsFirst(IPaymentCodeGenerator generator) {
        generators.add(0, generator);
    }

    public static void registerExporter(IPaymentCodeGenerator generator) {
        generators.add(generator);
    }

    public void generate() {
        for (IPaymentCodeGenerator generator : generators) {
            generator.generate(this.errors);
        }
    }

    public Set<PaymentReferenceCode> findActivePaymentCodes(DateTime when) {
        HashSet result = Sets.newHashSet();
        for (IPaymentCodeGenerator generator : generators) {
            result.addAll(generator.findActivePaymentCodes(when));
        }
        return result;
    }

    public String getErrors() {
        return this.errors.toString();
    }
}

