/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.debt.balancetransfer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.debt.balancetransfer.BalanceTransferService$callable$transferBalance;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class BalanceTransferService {
    private DebtAccount objectDebtAccount;
    private DebtAccount destinyDebtAccount;
    public static final Advice advice$transferBalance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public BalanceTransferService(DebtAccount objectDebtAccount, DebtAccount destinyDebtAccount) {
        this.objectDebtAccount = objectDebtAccount;
        this.destinyDebtAccount = destinyDebtAccount;
    }

    public void transferBalance() {
        Object object = advice$transferBalance.perform((Callable)new BalanceTransferService$callable$transferBalance(this));
    }

    static /* synthetic */ void advised$transferBalance(BalanceTransferService this_) {
        BigDecimal initialGlobalBalance = this_.objectDebtAccount.getCustomer().getGlobalBalance();
        FinantialInstitution finantialInstitution = this_.objectDebtAccount.getFinantialInstitution();
        Currency currency = finantialInstitution.getCurrency();
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), finantialInstitution).get();
        DateTime now = new DateTime();
        HashSet pendingDebitNotes = Sets.newHashSet();
        for (InvoiceEntry invoiceEntry : this_.objectDebtAccount.getPendingInvoiceEntriesSet()) {
            if (!invoiceEntry.isDebitNoteEntry()) continue;
            DebitEntry debitEntry = (DebitEntry)((Object)invoiceEntry);
            if (debitEntry.getFinantialDocument() == null) {
                DebitNote debitNote = DebitNote.create(this_.objectDebtAccount, documentNumberSeries, now);
                debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
            }
            pendingDebitNotes.add((DebitNote)((Object)debitEntry.getFinantialDocument()));
        }
        for (DebitNote debitNote : pendingDebitNotes) {
            this_.transferDebitEntries(debitNote);
        }
        for (InvoiceEntry invoiceEntry : this_.objectDebtAccount.getPendingInvoiceEntriesSet()) {
            if (!invoiceEntry.isCreditNoteEntry()) continue;
            this_.transferCreditEntry((CreditEntry)((Object)invoiceEntry));
        }
        BigDecimal finalGlobalBalance = this_.objectDebtAccount.getCustomer().getGlobalBalance();
        if (!Constants.isEqual(initialGlobalBalance, finalGlobalBalance)) {
            throw new TreasuryDomainException("error.BalanceTransferService.initial.and.final.global.balance", currency.getValueFor(initialGlobalBalance), currency.getValueFor(finalGlobalBalance));
        }
    }

    private void transferCreditEntry(CreditEntry invoiceEntry) {
        FinantialInstitution finantialInstitution = this.objectDebtAccount.getFinantialInstitution();
        Series defaultSeries = Series.findUniqueDefault(finantialInstitution).get();
        DocumentNumberSeries settlementNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), defaultSeries);
        DateTime now = new DateTime();
        CreditEntry creditEntry = invoiceEntry;
        BigDecimal creditOpenAmount = creditEntry.getOpenAmount();
        String originNumber = creditEntry.getFinantialDocument() != null && invoiceEntry.getFinantialDocument().isClosed() ? creditEntry.getFinantialDocument().getUiDocumentNumber() : "";
        DebtAccount payorDebtAccount = creditEntry.getFinantialDocument() != null && ((Invoice)((Object)creditEntry.getFinantialDocument())).isForPayorDebtAccount() ? ((Invoice)((Object)creditEntry.getFinantialDocument())).getPayorDebtAccount() : null;
        DebitEntry regulationDebitEntry = DebitNote.createBalanceTransferDebit(this.objectDebtAccount, now, now.toLocalDate(), originNumber, creditEntry.getProduct(), creditOpenAmount, payorDebtAccount, creditEntry.getDescription(), null);
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (creditEntry.getFinantialDocument().isExportedInLegacyERP() || creditEntry.getFinantialDocument().getCloseDate() != null && creditEntry.getFinantialDocument().getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
            regulationDebitEntry.getFinantialDocument().setExportedInLegacyERP(true);
            regulationDebitEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        regulationDebitEntry.getFinantialDocument().closeDocument();
        CreditEntry regulationCreditEntry = CreditNote.createBalanceTransferCredit(this.destinyDebtAccount, now, originNumber, creditEntry.getProduct(), creditOpenAmount, payorDebtAccount, creditEntry.getDescription());
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (creditEntry.getFinantialDocument().isExportedInLegacyERP() || creditEntry.getFinantialDocument().getCloseDate() != null && creditEntry.getFinantialDocument().getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
            regulationCreditEntry.getFinantialDocument().setExportedInLegacyERP(true);
            regulationCreditEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        SettlementNote settlementNote = SettlementNote.create(this.objectDebtAccount, settlementNoteSeries, now, now, null, null);
        if (creditEntry.getFinantialDocument().isPreparing()) {
            creditEntry.getFinantialDocument().closeDocument();
        }
        SettlementEntry.create((InvoiceEntry)((Object)regulationDebitEntry), settlementNote, regulationDebitEntry.getOpenAmount(), regulationDebitEntry.getDescription(), now, false);
        SettlementEntry.create((InvoiceEntry)((Object)creditEntry), settlementNote, creditOpenAmount, creditEntry.getDescription(), now, false);
        settlementNote.markAsUsedInBalanceTransfer();
        settlementNote.closeDocument();
    }

    private void transferDebitEntries(DebitNote objectDebitNote) {
        FinantialInstitution finantialInstitution = objectDebitNote.getDebtAccount().getFinantialInstitution();
        DocumentNumberSeries settlementNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForSettlementNote(), finantialInstitution).get();
        DateTime now = new DateTime();
        if (objectDebitNote.isPreparing()) {
            this.anullPreparingDebitNote(objectDebitNote);
        } else if (objectDebitNote.isClosed()) {
            DebtAccount payorDebtAccount = objectDebitNote.isForPayorDebtAccount() ? objectDebitNote.getPayorDebtAccount() : null;
            DebitNote destinyDebitNote = DebitNote.create(this.destinyDebtAccount, payorDebtAccount, objectDebitNote.getDocumentNumberSeries(), now, now.toLocalDate(), objectDebitNote.getUiDocumentNumber());
            SettlementNote settlementNote = SettlementNote.create(this.objectDebtAccount, settlementNumberSeries, now, now, null, null);
            for (FinantialDocumentEntry objectEntry : objectDebitNote.getFinantialDocumentEntriesSet()) {
                if (!Constants.isPositive(((DebitEntry)((Object)objectEntry)).getOpenAmount())) continue;
                DebitEntry debitEntry = (DebitEntry)((Object)objectEntry);
                BigDecimal openAmount = debitEntry.getOpenAmount();
                BigDecimal availableCreditAmount = debitEntry.getAvailableAmountForCredit();
                if (!debitEntry.getFinantialDocument().getDocumentNumberSeries().getSeries().isRegulationSeries() && Constants.isGreaterOrEqualThan(availableCreditAmount, openAmount)) {
                    BigDecimal openAmountWithoutVat = debitEntry.getCurrency().getValueWithScale(Constants.divide(openAmount, BigDecimal.ONE.add(Constants.rationalRatRate((InvoiceEntry)((Object)debitEntry)))));
                    CreditEntry newCreditEntry = debitEntry.createCreditEntry(now, debitEntry.getDescription(), null, openAmountWithoutVat, null, null);
                    newCreditEntry.getFinantialDocument().closeDocument();
                    SettlementEntry.create((InvoiceEntry)((Object)debitEntry), settlementNote, openAmount, debitEntry.getDescription(), now, false);
                    SettlementEntry.create((InvoiceEntry)((Object)newCreditEntry), settlementNote, openAmount, newCreditEntry.getDescription(), now, false);
                    this.createDestinyDebitEntry(destinyDebitNote, debitEntry);
                    continue;
                }
                CreditEntry regulationCreditEntry = CreditNote.createBalanceTransferCredit(this.objectDebtAccount, now, objectDebitNote.getUiDocumentNumber(), debitEntry.getProduct(), openAmount, payorDebtAccount, null);
                if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (objectDebitNote.isExportedInLegacyERP() || objectDebitNote.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
                    regulationCreditEntry.getFinantialDocument().setExportedInLegacyERP(true);
                    regulationCreditEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                }
                regulationCreditEntry.getFinantialDocument().closeDocument();
                SettlementEntry.create((InvoiceEntry)((Object)debitEntry), settlementNote, openAmount, debitEntry.getDescription(), now, false);
                SettlementEntry.create((InvoiceEntry)((Object)regulationCreditEntry), settlementNote, openAmount, regulationCreditEntry.getDescription(), now, false);
                DebitEntry regulationDebitEntry = DebitNote.createBalanceTransferDebit(this.destinyDebtAccount, debitEntry.getEntryDateTime(), debitEntry.getDueDate(), regulationCreditEntry.getFinantialDocument().getUiDocumentNumber(), debitEntry.getProduct(), openAmount, payorDebtAccount, debitEntry.getDescription(), debitEntry.getInterestRate());
                if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && (objectDebitNote.isExportedInLegacyERP() || objectDebitNote.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE))) {
                    regulationDebitEntry.getFinantialDocument().setExportedInLegacyERP(true);
                    regulationDebitEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                }
                regulationDebitEntry.getFinantialDocument().closeDocument();
            }
            settlementNote.markAsUsedInBalanceTransfer();
            settlementNote.closeDocument();
        }
    }

    private DebitEntry createDestinyDebitEntry(DebitNote destinyDebitNote, DebitEntry debitEntry) {
        BigDecimal openAmountWithoutVat = Constants.divide(debitEntry.getOpenAmount(), BigDecimal.ONE.add(Constants.rationalRatRate((InvoiceEntry)((Object)debitEntry))));
        DebitEntry newDebitEntry = DebitEntry.create(Optional.of(destinyDebitNote), this.destinyDebtAccount, debitEntry.getTreasuryEvent(), debitEntry.getVat(), openAmountWithoutVat, debitEntry.getDueDate(), debitEntry.getPropertiesMap(), debitEntry.getProduct(), debitEntry.getDescription(), debitEntry.getQuantity(), debitEntry.getInterestRate(), debitEntry.getEntryDateTime());
        newDebitEntry.edit(newDebitEntry.getDescription(), newDebitEntry.getTreasuryEvent(), newDebitEntry.getDueDate(), debitEntry.isAcademicalActBlockingSuspension(), debitEntry.isBlockAcademicActsOnDebt());
        return newDebitEntry;
    }

    private void anullPreparingDebitNote(DebitNote objectDebitNote) {
        DateTime now = new DateTime();
        DebitNote newDebitNote = DebitNote.create(this.destinyDebtAccount, objectDebitNote.getPayorDebtAccount(), objectDebitNote.getDocumentNumberSeries(), now, now.toLocalDate(), "");
        for (FinantialDocumentEntry objectEntry : objectDebitNote.getFinantialDocumentEntriesSet()) {
            DebitEntry debitEntry = (DebitEntry)((Object)objectEntry);
            BigDecimal amountWithExemptedAmount = debitEntry.getAmount().add(debitEntry.getExemptedAmount());
            if (!Constants.isPositive(amountWithExemptedAmount)) continue;
            if (debitEntry.getTreasuryEvent() != null) {
                debitEntry.annulOnEvent();
            }
            DebitEntry newDebitEntry = DebitEntry.create(Optional.of(newDebitNote), this.destinyDebtAccount, debitEntry.getTreasuryEvent(), debitEntry.getVat(), amountWithExemptedAmount, debitEntry.getDueDate(), debitEntry.getPropertiesMap(), debitEntry.getProduct(), debitEntry.getDescription(), debitEntry.getQuantity(), debitEntry.getInterestRate(), debitEntry.getEntryDateTime());
            if (debitEntry.getTreasuryExemption() != null) {
                TreasuryExemption treasuryExemption = debitEntry.getTreasuryExemption();
                TreasuryExemption.create(treasuryExemption.getTreasuryExemptionType(), debitEntry.getTreasuryEvent(), treasuryExemption.getReason(), treasuryExemption.getValueToExempt(), newDebitEntry);
            }
            newDebitEntry.edit(newDebitEntry.getDescription(), newDebitEntry.getTreasuryEvent(), newDebitEntry.getDueDate(), debitEntry.isAcademicalActBlockingSuspension(), debitEntry.isBlockAcademicActsOnDebt());
        }
        objectDebitNote.anullDebitNoteWithCreditNote(Constants.treasuryBundle("label.BalanceTransferService.annuled.reason", new String[0]), false);
    }
}

