/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.manageinvoice;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.ERPCustomerFieldsBean;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitNoteController$callable$addDebitEntryToDebitNote;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitNoteController$callable$createDebitNote;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitNoteController$callable$createInterestDebitNoteForDebitNote;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitNoteController$callable$deleteDebitNote;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.document.manageInvoice.debitNote", accessGroup="treasuryFrontOffice")
@RequestMapping(value={"/treasury/document/manageinvoice/debitnote"})
public class DebitNoteController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/manageinvoice/debitnote";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/document/manageinvoice/debitnote/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/document/manageinvoice/debitnote/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/document/manageinvoice/debitnote/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/document/manageinvoice/debitnote/read/";
    public static final long SEARCH_LIMIT_SIZE = 75L;
    private static final String UPDATE_PAYOR_DEBT_ACCOUNT_URI = "/updatepayordebtaccount";
    public static final String UPDATE_PAYOR_DEBT_ACCOUNT_URL = "/treasury/document/manageinvoice/debitnote/updatepayordebtaccount";
    private static final String _DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URI = "/downloadcertifieddocumentprint";
    public static final String DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URL = "/treasury/document/manageinvoice/debitnote/downloadcertifieddocumentprint";
    public static final Advice advice$deleteDebitNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$addDebitEntryToDebitNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDebitNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createInterestDebitNoteForDebitNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/document/manageinvoice/debitnote/";
    }

    private DebitNote getDebitNote(Model model) {
        return (DebitNote)((Object)model.asMap().get("debitNote"));
    }

    private void setDebitNote(DebitNote debitNote, Model model) {
        model.addAttribute("debitNote", (Object)debitNote);
    }

    public void deleteDebitNote(DebitNote debitNote) {
        Object object = advice$deleteDebitNote.perform((Callable)new DebitNoteController$callable$deleteDebitNote(this, debitNote));
    }

    static /* synthetic */ void advised$deleteDebitNote(DebitNoteController this_, DebitNote debitNote) {
        debitNote.delete(false);
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitNote(debitNote, model);
        DebtAccount debtAccount = debitNote.getDebtAccount();
        try {
            this.assertUserIsFrontOfficeMember(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            this.deleteDebitNote(debitNote);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            this.setDebitNote(debitNote, model);
            if (debitNote.isClosed() && debitNote.getDocumentNumberSeries().getSeries().getCertificated()) {
                model.addAttribute("anullDebitNoteMessage", (Object)BundleUtil.getString((String)Constants.BUNDLE, (String)"label.document.manageInvoice.readDebitNote.confirmAnullWithCreditNote", (String[])new String[0]));
            }
            ArrayList errorMessages = Lists.newArrayList();
            boolean validAddress = ERPCustomerFieldsBean.validateAddress(debitNote.getDebtAccount().getCustomer(), errorMessages);
            if (debitNote.isForPayorDebtAccount()) {
                validAddress = ERPCustomerFieldsBean.validateAddress(debitNote.getPayorDebtAccount().getCustomer(), errorMessages);
            }
            model.addAttribute("validAddress", (Object)validAddress);
            model.addAttribute("addressErrorMessages", (Object)errorMessages);
            return "treasury/document/manageinvoice/debitnote/read";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/", model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="debtaccount", required=false) DebtAccount debtAccount, @RequestParam(value="documentnumber", required=false) String documentNumber, @RequestParam(value="documentdatefrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDateFrom, @RequestParam(value="documentdateto", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDateTo, @RequestParam(value="origindocumentnumber", required=false) String originDocumentNumber, @RequestParam(value="state", required=false) FinantialDocumentStateType state, Model model) {
        List<DebitNote> result = DebitNoteController.filterSearch(debtAccount, documentNumber, documentDateFrom, documentDateTo, originDocumentNumber, state);
        model.addAttribute("limit_exceeded", (Object)((long)result.size() > 75L ? 1 : 0));
        model.addAttribute("searchdebitnoteResultsDataSet_totalCount", (Object)result.size());
        model.addAttribute("searchdebitnoteResultsDataSet", result.stream().limit(75L).collect(Collectors.toList()));
        model.addAttribute("stateValues", FinantialDocumentStateType.findAll());
        return "treasury/document/manageinvoice/debitnote/search";
    }

    private static List<DebitNote> getSearchUniverse(DebtAccount debtAccount) {
        Stream<DebitNote> result = debtAccount == null ? DebitNote.findAll() : DebitNote.find(debtAccount);
        return result.collect(Collectors.toList());
    }

    private static List<DebitNote> filterSearch(DebtAccount debtAccount, String documentNumber, LocalDate documentDateFrom, LocalDate documentDateTo, String originDocumentNumber, FinantialDocumentStateType state) {
        ArrayList result = Lists.newArrayList();
        boolean search = false;
        Predicate<DebitNote> predicate = i -> true;
        if (debtAccount != null) {
            search = true;
        }
        if (!Strings.isNullOrEmpty((String)documentNumber)) {
            search = true;
            predicate = predicate.and(i -> !Strings.isNullOrEmpty((String)i.getDocumentNumber()) && i.getUiDocumentNumber().toLowerCase().contains(documentNumber.trim().toLowerCase()));
        }
        if (documentDateFrom != null) {
            search = true;
            predicate = predicate.and(i -> i.getDocumentDate().toLocalDate().isEqual((ReadablePartial)documentDateFrom) || i.getDocumentDate().toLocalDate().isAfter((ReadablePartial)documentDateFrom));
        }
        if (documentDateTo != null) {
            search = true;
            predicate = predicate.and(i -> i.getDocumentDate().toLocalDate().isEqual((ReadablePartial)documentDateTo) || i.getDocumentDate().toLocalDate().isBefore((ReadablePartial)documentDateTo));
        }
        if (!StringUtils.isEmpty((Object)originDocumentNumber)) {
            search = true;
            predicate = predicate.and(i -> !StringUtils.isEmpty((Object)i.getOriginDocumentNumber()) && i.getOriginDocumentNumber().toLowerCase().contains(originDocumentNumber.trim().toLowerCase()));
        }
        if (state != null) {
            search = true;
            predicate = predicate.and(i -> state == i.getState());
        }
        if (search) {
            DebitNoteController.getSearchUniverse(debtAccount).stream().filter(predicate).collect(Collectors.toCollection(() -> result));
        }
        return result;
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(@RequestParam(value="documentnumberseries", required=false) DocumentNumberSeries documentNumberSeries, @RequestParam(value="debtaccount", required=false) DebtAccount debtAccount, @RequestParam(value="debitEntry", required=false) DebitEntry debitEntry, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (debitEntry != null) {
                debtAccount = debitEntry.getDebtAccount();
                model.addAttribute("debitEntry", (Object)debitEntry);
            }
            FinantialInstitution finantialInstitution = null;
            if (documentNumberSeries == null && debtAccount == null) {
                this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.finantialinstitution.mismatch.debtaccount.series", (String[])new String[0]), model);
                return this.redirect(SEARCH_URL, model, redirectAttributes);
            }
            this.assertUserIsAllowToModifyInvoices(debtAccount.getFinantialInstitution(), model);
            if (documentNumberSeries != null && debtAccount != null && !documentNumberSeries.getSeries().getFinantialInstitution().getCode().equals(debtAccount.getFinantialInstitution().getCode())) {
                this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.finantialinstitution.mismatch.debtaccount.series", (String[])new String[0]), model);
                return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debtAccount.getExternalId(), model, redirectAttributes);
            }
            if (documentNumberSeries != null) {
                finantialInstitution = documentNumberSeries.getSeries().getFinantialInstitution();
            }
            if (debtAccount != null) {
                finantialInstitution = debtAccount.getFinantialInstitution();
            }
            model.addAttribute("DebitNote_payorDebtAccount_options", DebtAccount.findActiveAdhocDebtAccountsSortedByCustomerName(finantialInstitution));
            if (debtAccount != null) {
                model.addAttribute("DebitNote_debtAccount_options", Collections.singleton(debtAccount));
            } else {
                model.addAttribute("DebitNote_debtAccount_options", DebtAccount.find(finantialInstitution).collect(Collectors.toList()));
            }
            if (documentNumberSeries != null) {
                model.addAttribute("DebitNote_documentNumberSeries_options", Collections.singletonList(documentNumberSeries));
            } else {
                List availableSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), debtAccount.getFinantialInstitution()).collect(Collectors.toList());
                if (availableSeries.size() > 0) {
                    model.addAttribute("DebitNote_documentNumberSeries_options", DocumentNumberSeries.applyActiveSelectableAndDefaultSorting(availableSeries.stream()).collect(Collectors.toList()));
                } else {
                    this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.finantialinstitution.no.available.series.found", (String[])new String[0]), model);
                    return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debtAccount.getExternalId(), model, redirectAttributes);
                }
            }
            return "treasury/document/manageinvoice/debitnote/create";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/", model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="payordebtaccount", required=false) DebtAccount payorDebtAccount, @RequestParam(value="debtaccount") DebtAccount debtAccount, @RequestParam(value="debitentry") DebitEntry debitEntry, @RequestParam(value="documentnumberseries") DocumentNumberSeries documentNumberSeries, @RequestParam(value="documentdate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDate, @RequestParam(value="documentduedate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDueDate, @RequestParam(value="origindocumentnumber", required=false) String originDocumentNumber, @RequestParam(value="documentobservations", required=false) String documentObservations, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsAllowToModifyInvoices(documentNumberSeries.getSeries().getFinantialInstitution(), model);
            DebitNote debitNote = this.createDebitNote(payorDebtAccount, debtAccount, documentNumberSeries, documentDate, documentDueDate, originDocumentNumber, documentObservations);
            if (debitEntry != null && debitEntry.getFinantialDocument() == null) {
                this.addDebitEntryToDebitNote(debitEntry, debitNote);
            }
            model.addAttribute("debitNote", (Object)debitNote);
            return this.redirect(READ_URL + this.getDebitNote(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.create(documentNumberSeries, debtAccount, debitEntry, model, redirectAttributes);
    }

    private void addDebitEntryToDebitNote(DebitEntry debitEntry, DebitNote debitNote) {
        Object object = advice$addDebitEntryToDebitNote.perform((Callable)new DebitNoteController$callable$addDebitEntryToDebitNote(this, debitEntry, debitNote));
    }

    static /* synthetic */ void advised$addDebitEntryToDebitNote(DebitNoteController this_, DebitEntry debitEntry, DebitNote debitNote) {
        debitEntry.setFinantialDocument((FinantialDocument)((Object)debitNote));
    }

    public DebitNote createDebitNote(DebtAccount debtAccount, DebtAccount debtAccount2, DocumentNumberSeries documentNumberSeries, LocalDate localDate, LocalDate localDate2, String string, String string2) {
        return (DebitNote)((Object)advice$createDebitNote.perform((Callable)new DebitNoteController$callable$createDebitNote(this, debtAccount, debtAccount2, documentNumberSeries, localDate, localDate2, string, string2)));
    }

    static /* synthetic */ DebitNote advised$createDebitNote(DebitNoteController this_, DebtAccount payorDebtAccount, DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, LocalDate documentDate, LocalDate documentDueDate, String originDocumentNumber, String documentObservations) {
        DebitNote debitNote = DebitNote.create(debtAccount, payorDebtAccount, documentNumberSeries, documentDate.toDateTimeAtCurrentTime(), documentDueDate, originDocumentNumber);
        debitNote.setDocumentObservations(documentObservations);
        return debitNote;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsAllowToModifyInvoices(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            model.addAttribute("stateValues", (Object)FinantialDocumentStateType.values());
            this.setDebitNote(debitNote, model);
            return "treasury/document/manageinvoice/debitnote/update";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/", model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") DebitNote debitNote, @RequestParam(value="documentdate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDate, @RequestParam(value="documentduedate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDueDate, @RequestParam(value="origindocumentnumber", required=false) String originDocumentNumber, @RequestParam(value="documentobservations", required=false) String documentObservations, @RequestParam(value="legacyerpcertificatedocumentreference", required=false) String legacyERPCertificateDocumentReference, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitNote(debitNote, model);
        try {
            this.assertUserIsAllowToModifyInvoices(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            DebitNote note = this.getDebitNote(model);
            note.edit(note.getDocumentDate().toLocalDate(), note.getDocumentDueDate(), originDocumentNumber, documentObservations, legacyERPCertificateDocumentReference);
            return this.redirect(READ_URL + this.getDebitNote(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(debitNote, model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/addentry"})
    public String processReadToAddEntry(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitNote(debitNote, model);
        return this.redirect("/treasury/document/manageinvoice/debitentry/create/" + this.getDebitNote(model).getDebtAccount().getExternalId() + "?debitNote=" + debitNote.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/closedebitnote"}, method={RequestMethod.POST})
    public String processReadToCloseDebitNote(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitNote(debitNote, model);
        try {
            debitNote.closeDocument();
            this.addInfoMessage(Constants.treasuryBundle("label.document.manageinvoice.DebitNote.document.closed.sucess", new String[0]), model);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getDebitNote(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/anulldebitnote"}, method={RequestMethod.POST})
    public String processReadToAnullDebitNote(@PathVariable(value="oid") DebitNote debitNote, @RequestParam(value="reason") String anullReason, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitNote(debitNote, model);
        try {
            this.assertUserIsAllowToModifyInvoices(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            for (DebitEntry debitEntry : debitNote.getDebitEntriesSet()) {
                if (debitEntry.getInterestDebitEntriesSet().isEmpty() || !debitEntry.getInterestDebitEntriesSet().stream().anyMatch(x -> x.getFinantialDocument() == null || x.getFinantialDocument().isPreparing())) continue;
                throw new TreasuryDomainException("error.DebitNote.creating.credit.note.with.pending.interest.entries", new String[0]);
            }
            debitNote.anullDebitNoteWithCreditNote(anullReason, false);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.document.manageinvoice.DebitNote.document.anulled.sucess", (String[])new String[0]), model);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getDebitNote(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/addpendingentries"})
    public String processReadToAddPendingEntries(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitNote(debitNote, model);
        return this.redirect("/treasury/document/manageinvoice/debitentry/searchpendingentries/?debitnote=" + debitNote.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/createcreditnote"})
    public String processReadToCreateCreditNote(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitNote(debitNote, model);
        return this.redirect("/treasury/document/manageinvoice/creditnote/create?debitNote=" + debitNote.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/exportintegrationfile"}, produces={"text/xml;charset=Windows-1252"})
    public void processReadToExportIntegrationFile(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            this.assertUserIsFrontOfficeMember(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            String saftEncoding = ERPExporterManager.saftEncoding(debitNote.getDebtAccount().getFinantialInstitution());
            String output = ERPExporterManager.exportFinantialDocumentToXML((FinantialDocument)((Object)debitNote));
            response.setContentType("text/xml");
            response.setCharacterEncoding(saftEncoding);
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)(debitNote.getDebtAccount().getFinantialInstitution().getFiscalNumber() + "_" + debitNote.getUiDocumentNumber() + ".xml").replaceAll(SEARCH_URI, "_").replaceAll("\\s", "_").replaceAll(" ", "_")), saftEncoding);
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(output.getBytes(saftEncoding));
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/read/{oid}/calculateinterestvalue"}, method={RequestMethod.GET})
    public String processReadToCalculateInterestValue(@PathVariable(value="oid") DebitNote debitNote, @RequestParam(value="paymentdate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate paymentDate, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            if (paymentDate == null) {
                throw new TreasuryDomainException("error.label.DebitNote.create.interest.note.invalid.payment.date", new String[0]);
            }
            ArrayList<SettlementNoteBean.InterestEntryBean> allInterests = new ArrayList<SettlementNoteBean.InterestEntryBean>();
            for (DebitEntry debitEntry : debitNote.getDebitEntriesSet()) {
                InterestRateBean calculateUndebitedInterestValue = debitEntry.calculateUndebitedInterestValue(paymentDate);
                if (!Constants.isGreaterThan(calculateUndebitedInterestValue.getInterestAmount(), BigDecimal.ZERO)) continue;
                SettlementNoteBean.InterestEntryBean entryBean = new SettlementNoteBean.InterestEntryBean(debitEntry, calculateUndebitedInterestValue);
                allInterests.add(entryBean);
            }
            List availableSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution()).filter(x -> x.getSeries().getActive()).collect(Collectors.toList());
            if ((availableSeries = DocumentNumberSeries.applyActiveSelectableAndDefaultSorting(availableSeries.stream()).collect(Collectors.toList())).size() <= 0) {
                this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.finantialinstitution.no.available.series.found", (String[])new String[0]), model);
                return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
            }
            model.addAttribute("DebitNote_documentNumberSeries_options", availableSeries);
            this.setDebitNote(debitNote, model);
            model.addAttribute("interestRateValues", allInterests);
            this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.warning.document.manageinvoice.calculateinterestvalue.line1", (String[])new String[0]), model);
            this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.warning.document.manageinvoice.calculateinterestvalue.line2", (String[])new String[0]), model);
            return "treasury/document/manageinvoice/debitnote/calculateinterestvalue";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/read/{oid}/calculateinterestvalue"}, method={RequestMethod.POST})
    public String processReadToCalculateInterestValue(@PathVariable(value="oid") DebitNote debitNote, @RequestParam(value="paymentdate") @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate paymentDate, @RequestParam(value="documentnumberseries") DocumentNumberSeries documentNumberSeries, @RequestParam(value="documentobservations") String documentObservations, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            if (paymentDate == null) {
                throw new TreasuryDomainException("error.label.DebitNote.create.interest.note.invalid.payment.date", new String[0]);
            }
            if (debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution() != documentNumberSeries.getSeries().getFinantialInstitution()) {
                throw new TreasuryDomainException("error.DebitNote.invalid.series.for.interest.debit.note.creation", new String[0]);
            }
            DebitNote interestDebitNote = this.createInterestDebitNoteForDebitNote(debitNote, paymentDate, documentNumberSeries, documentObservations);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"info.document.manageinfoice.debitnote.success.calculate.interest.value", (String[])new String[0]), model);
            return this.redirect(READ_URL + interestDebitNote.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return "treasury/document/manageinvoice/debitnote/calculateinterestvalue";
        }
    }

    private DebitNote createInterestDebitNoteForDebitNote(DebitNote debitNote, LocalDate localDate, DocumentNumberSeries documentNumberSeries, String string) {
        return (DebitNote)((Object)advice$createInterestDebitNoteForDebitNote.perform((Callable)new DebitNoteController$callable$createInterestDebitNoteForDebitNote(this, debitNote, localDate, documentNumberSeries, string)));
    }

    static /* synthetic */ DebitNote advised$createInterestDebitNoteForDebitNote(DebitNoteController this_, DebitNote debitNote, LocalDate paymentDate, DocumentNumberSeries documentNumberSeries, String documentObservations) {
        DebitNote interestDebitNote = documentNumberSeries.getSeries().getCertificated() ? DebitNote.createInterestDebitNoteForDebitNote(debitNote, documentNumberSeries, new DateTime(), paymentDate) : DebitNote.createInterestDebitNoteForDebitNote(debitNote, documentNumberSeries, paymentDate.toDateTimeAtStartOfDay(), paymentDate);
        interestDebitNote.setDocumentObservations(documentObservations);
        return interestDebitNote;
    }

    @RequestMapping(value={"/read/{oid}/exportintegrationonline"})
    public String processReadToExportIntegrationOnline(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            try {
                IERPExporter erpExporter = debitNote.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
                erpExporter.checkIntegrationDocumentStatus((FinantialDocument)((Object)debitNote));
            }
            catch (Exception erpExporter) {
                // empty catch block
            }
            ERPExportOperation output = ERPExporterManager.exportSingleDocument((FinantialDocument)((Object)debitNote));
            if (output == null) {
                this.addInfoMessage(Constants.treasuryBundle("label.integration.erp.document.not.exported", new String[0]), model);
                this.setDebitNote(debitNote, model);
                return this.read(debitNote, model, redirectAttributes);
            }
            this.addInfoMessage(Constants.treasuryBundle("label.integration.erp.exportoperation.success", new String[0]), model);
            return this.redirect("/treasury/integration/erp/erpexportoperation/read/" + output.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(Constants.treasuryBundle("label.integration.erp.exportoperation.error", new String[0]) + ex.getLocalizedMessage(), model);
            this.setDebitNote(debitNote, model);
            return this.read(debitNote, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/read/{oid}/cleardocumenttoexport"}, method={RequestMethod.POST})
    public String cleardocumenttoexport(@PathVariable(value="oid") DebitNote debitNote, @RequestParam(value="reason", required=false) String reason, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (!debitNote.isDocumentToExport()) {
                this.addErrorMessage(Constants.treasuryBundle("error.FinantialDocument.document.not.marked.to.export", new String[0]), model);
                return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
            }
            if (Strings.isNullOrEmpty((String)reason)) {
                this.addErrorMessage(Constants.treasuryBundle("error.FinantialDocument.clear.document.to.export.requires.reason", new String[0]), model);
                return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
            }
            this.assertUserIsBackOfficeMember(model);
            debitNote.clearDocumentToExport(reason);
            return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/updatepayordebtaccount/{oid}"}, method={RequestMethod.GET})
    public String updatepayordebtaccount(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsAllowToModifyInvoices(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            if (!debitNote.isPreparing() && !debitNote.isClosed()) {
                this.addErrorMessage(Constants.treasuryBundle("error.DebitNote.updatePayorDebtAccount.not.preparing.nor.closed", new String[0]), model);
                return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
            }
            this.setDebitNote(debitNote, model);
            model.addAttribute("DebitNote_payorDebtAccount_options", DebtAccount.findActiveAdhocDebtAccountsSortedByCustomerName(debitNote.getDebtAccount().getFinantialInstitution()));
            model.addAttribute("stateValues", (Object)FinantialDocumentStateType.values());
            return "treasury/document/manageinvoice/debitnote/updatepayordebtaccount";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.redirect(READ_URL + debitNote.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/updatepayordebtaccount/{oid}"}, method={RequestMethod.POST})
    public String updatepayordebtaccount(@PathVariable(value="oid") DebitNote debitNote, @RequestParam(value="payordebtaccount", required=false) DebtAccount payorDebtAccount, Model model, RedirectAttributes redirectAttributes) {
        try {
            DebtAccount oldPayorDebtAccount = debitNote.getPayorDebtAccount();
            DebitNote newDebitNote = debitNote.updatePayorDebtAccount(payorDebtAccount);
            if (oldPayorDebtAccount != newDebitNote.getPayorDebtAccount()) {
                this.addInfoMessage(Constants.treasuryBundle("label.DebitNote.update.payorDebtAccount.success", new String[0]), model);
                return this.redirect(READ_URL + newDebitNote.getExternalId(), model, redirectAttributes);
            }
            this.addErrorMessage(Constants.treasuryBundle("error.DebitNote.updatePayorDebtAccount.payor.not.changed", new String[0]), model);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.updatepayordebtaccount(debitNote, model, redirectAttributes);
    }

    @RequestMapping(value={"/downloadcertifieddocumentprint/{oid}"}, method={RequestMethod.GET})
    public String downloadcertifieddocumentprint(@PathVariable(value="oid") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            byte[] contents = ERPExporterManager.downloadCertifiedDocumentPrint((FinantialDocument)((Object)debitNote));
            response.setContentType("application/pdf");
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)(debitNote.getDebtAccount().getFinantialInstitution().getFiscalNumber() + "_" + debitNote.getUiDocumentNumber() + ".pdf").replaceAll(SEARCH_URI, "_").replaceAll("\\s", "_").replaceAll(" ", "_")), "Windows-1252");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(contents);
            return null;
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.read(debitNote, model, redirectAttributes);
        }
    }
}

