/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.manageinvoice;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.tariff.FixedTariff;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.dto.DebitEntryBean;
import org.fenixedu.treasury.dto.FixedTariffInterestRateBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitEntryController$callable$createDebitEntry;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitEntryController$callable$deleteDebitEntry;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitEntryController$callable$removeFromDocument;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitEntryController$callable$updateDebitEntry;
import org.fenixedu.treasury.ui.document.manageinvoice.DebitNoteController;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=DebitNoteController.class)
@RequestMapping(value={"/treasury/document/manageinvoice/debitentry"})
public class DebitEntryController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/manageinvoice/debitentry";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/document/manageinvoice/debitentry/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/document/manageinvoice/debitentry/update/";
    private static final String CREATE_URI = "/create/";
    public static final String CREATE_URL = "/treasury/document/manageinvoice/debitentry/create/";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/document/manageinvoice/debitentry/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/document/manageinvoice/debitentry/delete/";
    private static final String _SEARCHPENDINGENTRIES_URI = "/searchpendingentries/";
    public static final String SEARCHPENDINGENTRIES_URL = "/treasury/document/manageinvoice/debitentry/searchpendingentries/";
    private static final String _SEARCHPENDINGENTRIES_TO_VIEW_ACTION_URI = "/searchpendingentries/view/";
    public static final String SEARCHPENDINGENTRIES_TO_VIEW_ACTION_URL = "/treasury/document/manageinvoice/debitentry/searchpendingentries/view/";
    private static final String _SEARCHPENDINGENTRIES_TO_ADDENTRIES_URI = "/searchpendingentries/addentries";
    public static final String SEARCHPENDINGENTRIES_TO_ADDENTRIES_URL = "/treasury/document/manageinvoice/debitentry/searchpendingentries/addentries";
    private static final String _READ_TO_REMOVEFROMDOCUMENT_URI = "/read/{oid}/removefromdocument";
    private static final String _ANNUL_DEBIT_ENTRY_URI = "/read/{oid}/annuldebitentry";
    public static final Advice advice$deleteDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeFromDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/document/manageinvoice/debitnote/";
    }

    private DebitEntryBean getDebitEntryBean(Model model) {
        return (DebitEntryBean)model.asMap().get("debitEntryBean");
    }

    private void setDebitEntryBean(DebitEntryBean bean, Model model) {
        model.addAttribute("debitEntryBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("debitEntryBean", (Object)bean);
    }

    private DebitEntry getDebitEntry(Model model) {
        return (DebitEntry)((Object)model.asMap().get("debitEntry"));
    }

    private void setDebitEntry(DebitEntry debitEntry, Model model) {
        model.addAttribute("debitEntry", (Object)debitEntry);
    }

    public void deleteDebitEntry(DebitEntry debitEntry) {
        Object object = advice$deleteDebitEntry.perform((Callable)new DebitEntryController$callable$deleteDebitEntry(this, debitEntry));
    }

    static /* synthetic */ void advised$deleteDebitEntry(DebitEntryController this_, DebitEntry debitEntry) {
        debitEntry.delete();
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") DebitEntry debitEntry, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(debitEntry.getDebtAccount().getFinantialInstitution(), model);
            this.setDebitEntry(debitEntry, model);
            return "treasury/document/manageinvoice/debitentry/read";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/", model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") DebitEntry debitEntry, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitEntry(debitEntry, model);
        DebitNote note = (DebitNote)((Object)debitEntry.getFinantialDocument());
        DebtAccount account = debitEntry.getDebtAccount();
        try {
            this.assertUserIsAllowToModifyInvoices(debitEntry.getDebtAccount().getFinantialInstitution(), model);
            this.deleteDebitEntry(debitEntry);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            if (note != null) {
                return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + note.getExternalId(), model, redirectAttributes);
            }
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + account.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            if (note != null) {
                return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + note.getExternalId(), model, redirectAttributes);
            }
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + account.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/create/{oid}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="oid") DebtAccount debtAccount, @RequestParam(value="debitNote", required=false) DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsAllowToModifyInvoices(debtAccount.getFinantialInstitution(), model);
            if (debitNote != null && !debitNote.isPreparing()) {
                this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.debitentry.invalid.state.add.debitentry", (String[])new String[0]), model);
                this.redirect("/treasury/document/manageinvoice/debitnote/read/" + debitNote.getExternalId(), model, redirectAttributes);
            }
            DebitEntryBean bean = new DebitEntryBean();
            bean.setProductDataSource(Product.findAllActive().filter(p -> p.getFinantialInstitutionsSet().contains(debtAccount.getFinantialInstitution())).collect(Collectors.toList()));
            bean.setDebtAccount(debtAccount);
            bean.setFinantialDocument(debitNote);
            bean.setCurrency(debtAccount.getFinantialInstitution().getCurrency());
            if (debitNote != null) {
                bean.setDueDate(debitNote.getDocumentDueDate());
                bean.setEntryDate(debitNote.getDocumentDate());
            } else {
                bean.setDueDate(new LocalDate());
                bean.setEntryDate(new DateTime());
            }
            this.setDebitEntryBean(bean, model);
            model.addAttribute("DebitEntry_event_options", TreasuryEvent.find(debtAccount.getCustomer()).collect(Collectors.toList()));
            if (debitNote == null) {
                this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.document.manageInvoice.createDebitEntry.entry.with.no.document", (String[])new String[0]), model);
            }
            return "treasury/document/manageinvoice/debitentry/create";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/", model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@RequestParam(value="bean", required=true) DebitEntryBean bean, Model model) {
        bean.refreshProductsDataSource(bean.getDebtAccount().getFinantialInstitution());
        Product product = bean.getProduct();
        if (product != null) {
            bean.setVat(bean.getDebtAccount().getFinantialInstitution().getActiveVat(product.getVatType(), new DateTime()));
            Tariff tariff = product.getActiveTariffs(bean.getDebtAccount().getFinantialInstitution(), new DateTime()).findFirst().orElse(null);
            if (tariff != null) {
                if (tariff instanceof FixedTariff) {
                    bean.setAmount(bean.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(((FixedTariff)((Object)tariff)).getAmount()));
                    bean.setDueDate(((FixedTariff)((Object)tariff)).calculateDueDate(bean.getFinantialDocument()));
                    if (tariff.getInterestRate() != null) {
                        bean.setApplyInterests(true);
                        bean.setInterestRate(new FixedTariffInterestRateBean(tariff.getInterestRate()));
                    } else {
                        bean.setApplyInterests(false);
                        bean.setInterestRate(new FixedTariffInterestRateBean());
                    }
                } else {
                    bean.setAmount(bean.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(BigDecimal.ZERO));
                    bean.setDueDate(new LocalDate());
                }
            } else {
                bean.setAmount(bean.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(BigDecimal.ZERO));
                bean.setDueDate(new LocalDate());
            }
            bean.setDescription(product.getName().getContent());
        }
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create/{oid}"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=false) DebitEntryBean bean, @PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsAllowToModifyInvoices(debtAccount.getFinantialInstitution(), model);
            if (bean.getFinantialDocument() != null && !bean.getFinantialDocument().isPreparing()) {
                this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.debitentry.invalid.state.add.debitentry", (String[])new String[0]), model);
                this.redirect("/treasury/document/manageinvoice/debitnote/read/" + bean.getFinantialDocument().getExternalId(), model, redirectAttributes);
            }
            DebitEntry debitEntry = this.createDebitEntry(bean.getFinantialDocument(), bean.getDebtAccount(), bean.getDescription(), bean.getProduct(), bean.getAmount(), bean.getDueDate(), bean.getEntryDate(), bean.getTreasuryEvent(), bean.isApplyInterests(), bean.getInterestRate());
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.create", (String[])new String[0]), model);
            this.setDebitEntry(debitEntry, model);
            if (this.getDebitEntry(model).getFinantialDocument() != null) {
                return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + this.getDebitEntry(model).getFinantialDocument().getExternalId(), model, redirectAttributes);
            }
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + this.getDebitEntry(model).getDebtAccount().getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
            this.setDebitEntryBean(bean, model);
            model.addAttribute("DebitEntry_event_options", TreasuryEvent.find(debtAccount.getCustomer()).collect(Collectors.toList()));
            return "treasury/document/manageinvoice/debitentry/create";
        }
    }

    public DebitEntry createDebitEntry(DebitNote debitNote, DebtAccount debtAccount, String string, Product product, BigDecimal bigDecimal, LocalDate localDate, DateTime dateTime, TreasuryEvent treasuryEvent, boolean bl, FixedTariffInterestRateBean fixedTariffInterestRateBean) {
        return (DebitEntry)((Object)advice$createDebitEntry.perform((Callable)new DebitEntryController$callable$createDebitEntry(this, debitNote, debtAccount, string, product, bigDecimal, localDate, dateTime, treasuryEvent, bl, fixedTariffInterestRateBean)));
    }

    static /* synthetic */ DebitEntry advised$createDebitEntry(DebitEntryController this_, DebitNote debitNote, DebtAccount debtAccount, String description, Product product, BigDecimal amount, LocalDate dueDate, DateTime entryDateTime, TreasuryEvent treasuryEvent, boolean applyInterests, FixedTariffInterestRateBean interestRateBean) {
        Optional<Vat> activeVat = Vat.findActiveUnique(product.getVatType(), debtAccount.getFinantialInstitution(), new DateTime());
        DebitEntry debitEntry = DebitEntry.create(Optional.ofNullable(debitNote), debtAccount, treasuryEvent, activeVat.orElse(null), amount, dueDate, null, product, description, BigDecimal.ONE, null, entryDateTime);
        if (applyInterests) {
            InterestRate interestRate = InterestRate.createForDebitEntry(debitEntry, interestRateBean.getInterestType(), interestRateBean.getNumberOfDaysAfterDueDate(), interestRateBean.getApplyInFirstWorkday(), interestRateBean.getMaximumDaysToApplyPenalty(), interestRateBean.getMaximumMonthsToApplyPenalty(), interestRateBean.getInterestFixedAmount(), interestRateBean.getRate());
            debitEntry.changeInterestRate(interestRate);
        }
        return debitEntry;
    }

    @RequestMapping(value={"/updatepostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updatepostback(@PathVariable(value="oid") DebitEntry debitEntry, @RequestParam(value="bean", required=false) DebitEntryBean bean, Model model) {
        this.setDebitEntryBean(bean, model);
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") DebitEntry debitEntry, Model model, RedirectAttributes redirectAttributes) {
        this.assertUserIsAllowToModifyInvoices(debitEntry.getDebtAccount().getFinantialInstitution(), model);
        if (debitEntry.getFinantialDocument() == null || !debitEntry.getFinantialDocument().isAnnulled()) {
            this.setDebitEntryBean(new DebitEntryBean(debitEntry), model);
            this.setDebitEntry(debitEntry, model);
            return "treasury/document/manageinvoice/debitentry/update";
        }
        return this.redirect(READ_URL + debitEntry.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") DebitEntry debitEntry, @RequestParam(value="bean", required=false) DebitEntryBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setDebitEntry(debitEntry, model);
        if (!debitEntry.equals((Object)bean.getDebitEntry())) {
            this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.debitentry.invalid.state.add.debitentry", (String[])new String[0]), model);
            this.redirect("/treasury/document/manageinvoice/debitnote/read/" + debitEntry.getFinantialDocument().getExternalId(), model, redirectAttributes);
        }
        try {
            this.assertUserIsAllowToModifyInvoices(debitEntry.getDebtAccount().getFinantialInstitution(), model);
            this.updateDebitEntry(debitEntry.getDescription(), bean.getTreasuryEvent(), bean.isApplyInterests(), bean.getInterestRate(), bean.getDueDate(), !bean.isAcademicalActBlockingSuspension(), bean.isBlockAcademicActsOnDebt(), model);
            if (debitEntry.getFinantialDocument() != null) {
                return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + debitEntry.getFinantialDocument().getExternalId(), model, redirectAttributes);
            }
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debitEntry.getDebtAccount().getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
            this.setDebitEntryBean(bean, model);
            this.setDebitEntry(debitEntry, model);
            return "treasury/document/manageinvoice/debitentry/update";
        }
    }

    public void updateDebitEntry(String string, TreasuryEvent treasuryEvent, boolean bl, FixedTariffInterestRateBean fixedTariffInterestRateBean, LocalDate localDate, boolean bl2, boolean bl3, Model model) {
        Object object = advice$updateDebitEntry.perform((Callable)new DebitEntryController$callable$updateDebitEntry(this, string, treasuryEvent, bl, fixedTariffInterestRateBean, localDate, bl2, bl3, model));
    }

    static /* synthetic */ void advised$updateDebitEntry(DebitEntryController this_, String description, TreasuryEvent treasuryEvent, boolean applyInterests, FixedTariffInterestRateBean interestRateBean, LocalDate dueDate, boolean academicalActBlockingSuspension, boolean blockAcademicActsOnDebt, Model model) {
        DebitEntry debitEntry = this_.getDebitEntry(model);
        debitEntry.edit(description, treasuryEvent, dueDate, academicalActBlockingSuspension, blockAcademicActsOnDebt);
        if (applyInterests) {
            if (debitEntry.getInterestRate() == null) {
                InterestRate interestRate = InterestRate.createForDebitEntry(debitEntry, interestRateBean.getInterestType(), interestRateBean.getNumberOfDaysAfterDueDate(), interestRateBean.getApplyInFirstWorkday(), interestRateBean.getMaximumDaysToApplyPenalty(), interestRateBean.getMaximumMonthsToApplyPenalty(), interestRateBean.getInterestFixedAmount(), interestRateBean.getRate());
            } else {
                InterestRate rate = debitEntry.getInterestRate();
                rate.edit(interestRateBean.getInterestType(), interestRateBean.getNumberOfDaysAfterDueDate(), interestRateBean.getApplyInFirstWorkday(), interestRateBean.getMaximumDaysToApplyPenalty(), interestRateBean.getMaximumMonthsToApplyPenalty(), interestRateBean.getInterestFixedAmount(), interestRateBean.getRate());
            }
        } else if (debitEntry.getInterestRate() != null) {
            debitEntry.getInterestRate().delete();
        }
    }

    @RequestMapping(value={"/searchpendingentries/"})
    public String searchPendingEntries(@RequestParam(value="debitnote") DebitNote debitNote, Model model) {
        List<DebitEntry> searchpendingentriesResultsDataSet = this.filterSearchPendingEntries(debitNote.getDebtAccount());
        model.addAttribute("searchpendingentriesResultsDataSet", searchpendingentriesResultsDataSet);
        if (debitNote != null) {
            model.addAttribute("debitNote", (Object)debitNote);
        }
        return "treasury/document/manageinvoice/debitentry/searchpendingentries";
    }

    private Stream<DebitEntry> getSearchUniverseSearchPendingEntriesDataSet(DebtAccount debtAccount) {
        return debtAccount.getInvoiceEntrySet().stream().filter(x -> x.isDebitNoteEntry()).filter(x -> x.getFinantialDocument() == null).map(DebitEntry.class::cast);
    }

    private List<DebitEntry> filterSearchPendingEntries(DebtAccount debtAccount) {
        return this.getSearchUniverseSearchPendingEntriesDataSet(debtAccount).collect(Collectors.toList());
    }

    @RequestMapping(value={"/searchpendingentries/view/{oid}"})
    public String processSearchPendingEntriesToViewAction(@PathVariable(value="oid") DebitEntry debitEntry, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + debitEntry.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/searchpendingentries/addentries"}, method={RequestMethod.POST})
    public String processSearchPendingEntriesToAddEntries(@RequestParam(value="debitNote") DebitNote debitNote, @RequestParam(value="debitEntrys") List<DebitEntry> debitEntries, Model model, RedirectAttributes redirectAttributes) {
        if (debitNote != null && !debitNote.isPreparing()) {
            this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.debitentry.invalid.state.add.debitentry", (String[])new String[0]), model);
            this.redirect("/treasury/document/manageinvoice/debitnote/read/" + debitNote.getExternalId(), model, redirectAttributes);
        }
        try {
            this.assertUserIsAllowToModifyInvoices(debitNote.getDebtAccount().getFinantialInstitution(), model);
            debitNote.addDebitNoteEntries(debitEntries);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.update", (String[])new String[0]), model);
        return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + debitNote.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/removefromdocument"}, method={RequestMethod.POST})
    public String processReadToRemoveFromDocument(@PathVariable(value="oid") DebitEntry debitEntry, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsAllowToModifyInvoices(debitEntry.getDebtAccount().getFinantialInstitution(), model);
            if (debitEntry.getFinantialDocument() != null && debitEntry.getFinantialDocument().isPreparing()) {
                this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.debitentry.sucess.remove.debitentry", (String[])new String[0]), model);
                FinantialDocument debitNote = debitEntry.getFinantialDocument();
                this.removeFromDocument(debitEntry);
                return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + debitNote.getExternalId(), model, redirectAttributes);
            }
            this.addWarningMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.document.manageinvoice.debitentry.invalid.state.remove.debitentry", (String[])new String[0]), model);
            return this.redirect(READ_URL + debitEntry.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(READ_URL + debitEntry.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/read/{oid}/annuldebitentry"}, method={RequestMethod.POST})
    public String annuldebitentry(@PathVariable(value="oid") DebitEntry debitEntry, @RequestParam(value="annulDebitEntryReason", required=false) String annulDebitEntryReason, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsAllowToModifyInvoices(debitEntry.getDebtAccount().getFinantialInstitution(), model);
            if (debitEntry.getFinantialDocument() == null) {
                debitEntry.annulDebitEntry(annulDebitEntryReason);
                return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + debitEntry.getFinantialDocument().getExternalId(), model, redirectAttributes);
            }
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + debitEntry.getExternalId(), model, redirectAttributes);
    }

    private void removeFromDocument(DebitEntry debitEntry) {
        Object object = advice$removeFromDocument.perform((Callable)new DebitEntryController$callable$removeFromDocument(this, debitEntry));
    }

    static /* synthetic */ void advised$removeFromDocument(DebitEntryController this_, DebitEntry debitEntry) {
        debitEntry.setFinantialDocument(null);
    }
}

