/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managesibsinputfile;

import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.accesscontrol.TreasuryAccessControl;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.payments.sibs.SIBSPaymentsImporter;
import org.fenixedu.treasury.services.payments.sibs.SibsPaymentsBrokerService;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.payments.sibs.managesibsinputfile.SibsInputFileController;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=SibsInputFileController.class)
@RequestMapping(value={"/treasury/administration/payments/sibs/sibspaymentsbroker"})
public class SibsPaymentsBrokerController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/payments/sibs/sibspaymentsbroker";
    private static final String JSP_PATH = "treasury/administration/payments/sibs/sibspaymentsbroker";
    private static final String INVOKEBROKER_URI = "invokebroker";
    public static final String INVOKEBROKER_URL = "/treasury/administration/payments/sibs/sibspaymentsbrokerinvokebroker";
    public static final String FORM_ACTION_IMPORT = "FORM_ACTION_IMPORT";
    public static final String FORM_ACTION_DEBUG = "FORM_ACTION_DEBUG";

    @RequestMapping
    public String home(Model model) {
        return "redirect:/treasury/administration/payments/sibs/sibspaymentsbroker/invokebroker";
    }

    @RequestMapping(value={"invokebroker"}, method={RequestMethod.GET})
    public String invokebroker(Model model) {
        model.addAttribute("paymentCodePoolList", PaymentCodePool.findAll().collect(Collectors.toList()));
        return this.jspPage(INVOKEBROKER_URI);
    }

    @RequestMapping(value={"invokebroker"}, method={RequestMethod.POST})
    public String invokebroker(@RequestParam(value="paymentCodePool", required=false) PaymentCodePool paymentCodePool, @RequestParam(value="fromDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate fromDate, @RequestParam(value="toDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate toDate, @RequestParam(value="removeInexistentReferenceCodes") boolean removeInexistentReferenceCodes, @RequestParam(value="removeAlreadyProcessedCodes") boolean removeAlreadyProcessedCodes, @RequestParam(value="formAction") String formAction, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            if (!paymentCodePool.getFinantialInstitution().getSibsConfiguration().isPaymentsBrokerActive()) {
                throw new TreasuryDomainException("error.SibsPaymentsBroker.broker.inactive", new String[0]);
            }
            this.assertUserIsFrontOfficeMember(paymentCodePool.getFinantialInstitution(), model);
            if (FORM_ACTION_DEBUG.equals(formAction)) {
                String sibsContentFile = SibsPaymentsBrokerService.getPaymentsFromBroker(paymentCodePool.getFinantialInstitution(), fromDate, toDate, removeInexistentReferenceCodes, removeAlreadyProcessedCodes);
                response.setContentType("text/plain");
                response.setHeader("Content-disposition", "attachment; filename=sibs_content_file.txt");
                response.getWriter().write(sibsContentFile);
                response.getOutputStream().flush();
                return null;
            }
            if (FORM_ACTION_IMPORT.equals(formAction)) {
                SibsIncommingPaymentFile sibsFile = SibsPaymentsBrokerService.readPaymentsFromBroker(paymentCodePool.getFinantialInstitution(), fromDate, toDate, removeInexistentReferenceCodes, removeAlreadyProcessedCodes);
                SIBSPaymentsImporter importer = new SIBSPaymentsImporter();
                SibsReportFile reportFile = null;
                try {
                    SIBSPaymentsImporter.ProcessResult result = importer.processSIBSPaymentFiles(sibsFile, paymentCodePool.getFinantialInstitution());
                    if (result.getErrorMessages().isEmpty()) {
                        this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.upload", (String[])new String[0]), model);
                    } else {
                        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.upload", (String[])new String[0]), model);
                    }
                    reportFile = result.getReportFile();
                    if (result.getReportFile() == null) {
                        return this.redirect(INVOKEBROKER_URI, model, redirectAttributes);
                    }
                    reportFile.updateLogMessages(result);
                }
                catch (IOException e) {
                    throw new TreasuryDomainException("error.SibsInputFile.error.processing.sibs.input.file", new String[0]);
                }
                return this.redirect("/treasury/administration/payments/sibs/managesibsreportfile/sibsreportfile/read/" + reportFile.getExternalId(), model, redirectAttributes);
            }
            throw new TreasuryDomainException("error.SibsPaymentsBroker.unknown.action", new String[0]);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(INVOKEBROKER_URI, model, redirectAttributes);
        }
    }

    private String jspPage(String page) {
        return "treasury/administration/payments/sibs/sibspaymentsbroker/" + page;
    }

    @Override
    protected void assertUserIsFrontOfficeMember(FinantialInstitution finantialInstitution, Model model) {
        if (TreasuryAccessControl.getInstance().isFrontOfficeMember(Authenticate.getUser(), finantialInstitution)) {
            return;
        }
        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.frontoffice", (String[])new String[0]), model);
        throw new SecurityException(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.frontoffice", (String[])new String[0]));
    }
}

