/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.exporters;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.payments.exporters.IPaymentCodeGenerator;
import org.fenixedu.treasury.services.payments.exporters.PaymentCodeGeneratorsErrors;
import org.fenixedu.treasury.services.payments.exporters.PooledPaymentCodesGenerator$callable$executeAsRead;
import org.fenixedu.treasury.services.payments.exporters.PooledPaymentCodesGenerator$callable$updatePool;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PooledPaymentCodesGenerator
implements IPaymentCodeGenerator {
    public static final Advice advice$executeAsRead = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$updatePool = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @Override
    public void generate(PaymentCodeGeneratorsErrors errors) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                PooledPaymentCodesGenerator.this.executeAsRead();
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void executeAsRead() {
        Object object = advice$executeAsRead.perform((Callable)new PooledPaymentCodesGenerator$callable$executeAsRead(this));
    }

    protected static /* synthetic */ void advised$executeAsRead(PooledPaymentCodesGenerator this_) {
        for (PaymentCodePool paymentCodePool : PaymentCodePool.findAll().filter(x -> x.getUseCheckDigit() == false).collect(Collectors.toList())) {
            this_.updatePool(paymentCodePool);
        }
    }

    private void updatePool(PaymentCodePool paymentCodePool) {
        Object object = advice$updatePool.perform((Callable)new PooledPaymentCodesGenerator$callable$updatePool(this, paymentCodePool));
    }

    static /* synthetic */ void advised$updatePool(PooledPaymentCodesGenerator this_, PaymentCodePool paymentCodePool) {
        paymentCodePool.updatePoolReferences();
    }

    @Override
    public Set<PaymentReferenceCode> findActivePaymentCodes(DateTime when) {
        HashSet result = Sets.newHashSet();
        for (PaymentCodePool paymentCodePool : PaymentCodePool.findAll().filter(x -> x.getUseCheckDigit() == false).collect(Collectors.toSet())) {
            result.addAll(paymentCodePool.getPaymentCodesToExport(when.toLocalDate()));
        }
        return result;
    }
}

