/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.tasks;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.fenixedu.bennu.io.domain.FileSupport;
import org.fenixedu.bennu.io.domain.FileSupportUtils;
import org.fenixedu.bennu.io.domain.LocalFileToDelete;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.domain.integration.IntegrationOperation_Base;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

@Task(englishTitle="Delete finantial exportation logs", readOnly=true)
public class DeleteFinantialIntegrationExportationLogsTask
extends CronTask {
    private int batchSize = 10;
    private int availableCPUs = Runtime.getRuntime().availableProcessors();
    private int numberOfAvailableThreads = Math.max(1, this.availableCPUs - 2);
    private static final int numberOfLocalFilesToDeletePerTx = 2500;
    Semaphore semaphore = new Semaphore(this.numberOfAvailableThreads);
    static boolean shouldRespawn = false;

    public void runTask() throws Exception {
        this.taskLog("NUM FIN DOCS PENDING: %d\n", new Object[]{((FinantialInstitution)FenixFramework.getDomainRoot().getFinantialInstitutionsSet().iterator().next()).getFinantialDocumentsPendingForExportationSet().size()});
        ArrayList domainObjects = new ArrayList(FenixFramework.getDomainRoot().getFinantialDocumentsSet());
        List<List<String>> workingBatches = DeleteFinantialIntegrationExportationLogsTask.breakIntoBatches(domainObjects, this.batchSize);
        this.taskLog("Created " + workingBatches.size() + " batches of " + this.batchSize + " documents each distributing to " + this.numberOfAvailableThreads + " threads", new Object[0]);
        AtomicInteger batchCount = new AtomicInteger(0);
        for (List<String> batch : workingBatches) {
            this.checkKillSwitch();
            this.semaphore.acquire();
            if (batchCount.incrementAndGet() % (this.numberOfAvailableThreads + 1) == 0) {
                shouldRespawn = false;
                boolean initial = true;
                while (initial || shouldRespawn) {
                    initial = false;
                    FileDeleterThread fileDeleterThread = new FileDeleterThread(this);
                    fileDeleterThread.start();
                    fileDeleterThread.join();
                }
            }
            DeleteFinantialDocumentThread t = new DeleteFinantialDocumentThread(this, batch, batchCount.get());
            this.taskLog("Starting batch: " + batchCount.get() + "", new Object[0]);
            t.start();
        }
    }

    private void checkKillSwitch() {
        if (new File("/tmp/stopTask").exists()) {
            this.taskLog("W: Exiting...", new Object[0]);
            throw new RuntimeException("ERROR");
        }
    }

    public static List<List<String>> breakIntoBatches(List<? extends DomainObject> domainObjects, int batchSize) {
        ArrayList<List<String>> workingBatches = new ArrayList<List<String>>();
        int start = 0;
        int end = start + batchSize;
        int totalSize = domainObjects.size();
        while (end < totalSize) {
            List subList = domainObjects.subList(start, Math.min(end, totalSize)).stream().map(DomainObject::getExternalId).collect(Collectors.toList());
            workingBatches.add(subList);
            start = end;
            end = start + batchSize;
        }
        return workingBatches;
    }

    protected static boolean deleteLogsFromFinantialDocumentExportedDocument(DeleteFinantialIntegrationExportationLogsTask task, String finantialDocumentId) {
        FinantialDocument doc = (FinantialDocument)FenixFramework.getDomainObject((String)finantialDocumentId);
        if (doc.isPreparing()) {
            return false;
        }
        ArrayList logs = new ArrayList(doc.getErpExportOperationsSet().stream().sorted(Comparator.comparing(IntegrationOperation_Base::getVersioningCreationDate).reversed()).collect(Collectors.toList()));
        if (logs.size() > 1) {
            TreeSet<? super ERPExportOperation> exportationByDateSet = new TreeSet<ERPExportOperation>(DeleteFinantialIntegrationExportationLogsTask.localDateComparator());
            int removedLogs = 0;
            for (ERPExportOperation log : logs) {
                try {
                    if (log.getSuccess() || exportationByDateSet.add(log)) continue;
                    ++removedLogs;
                    log.getLogFile().delete();
                    log.delete();
                }
                catch (Throwable e) {
                    task.taskLog("E\t%s\t%s\t%s\t%s\n", new Object[]{log.getExternalId(), e.getClass().getSimpleName(), e.getMessage()});
                }
            }
            task.taskLog("LOGS: %s\t%s\t%s\n", new Object[]{doc.getUiDocumentNumber(), logs.size(), removedLogs});
        }
        return true;
    }

    private static Comparator<? super ERPExportOperation> localDateComparator() {
        return new Comparator<ERPExportOperation>(){

            @Override
            public int compare(ERPExportOperation o1, ERPExportOperation o2) {
                return o1.getVersioningCreationDate().toLocalDate().compareTo((ReadablePartial)o2.getVersioningCreationDate().toLocalDate());
            }
        };
    }

    public Atomic.TxMode getTxMode() {
        return Atomic.TxMode.READ;
    }

    private static class DeleteFinantialDocumentThread
    extends Thread {
        DeleteFinantialIntegrationExportationLogsTask task;
        final List<String> finantialDocumentIds;
        private int batchID;

        public DeleteFinantialDocumentThread(DeleteFinantialIntegrationExportationLogsTask task, List<String> batch, int batchID) {
            this.task = task;
            this.finantialDocumentIds = batch;
            this.batchID = batchID;
        }

        @Override
        public void run() {
            try {
                FenixFramework.getTransactionManager().withTransaction(new Callable(){

                    public Object call() throws Exception {
                        String threadName = Thread.currentThread().getName();
                        int count = 0;
                        int total = finantialDocumentIds.size();
                        for (String finantialDocumentId : finantialDocumentIds) {
                            if (++count % 50 == 0) {
                                task.taskLog("[%s-batchID %s] : %s out of %s", new Object[]{threadName, batchID, count, total});
                            }
                            DeleteFinantialIntegrationExportationLogsTask.deleteLogsFromFinantialDocumentExportedDocument(task, finantialDocumentId);
                        }
                        return null;
                    }
                }, new Atomic(){

                    public Class<? extends Annotation> annotationType() {
                        return null;
                    }

                    public boolean flattenNested() {
                        return false;
                    }

                    public Atomic.TxMode mode() {
                        return Atomic.TxMode.WRITE;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                this.task.taskLog(Thread.currentThread().getName() + " releasing lock", new Object[0]);
                this.task.semaphore.release();
            }
        }
    }

    private static class FileDeleterThread
    extends Thread {
        DeleteFinantialIntegrationExportationLogsTask task;

        public FileDeleterThread(DeleteFinantialIntegrationExportationLogsTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                FenixFramework.getTransactionManager().withTransaction((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        List<Object> arrayList = new ArrayList<LocalFileToDelete>(FileSupportUtils.retrieveDeleteSet(FileSupport.getInstance()));
                        int totalSize = arrayList.size();
                        boolean bl = shouldRespawn = totalSize > 2500;
                        if (shouldRespawn) {
                            arrayList = arrayList.subList(0, 2500);
                        }
                        String threadName = Thread.currentThread().getName();
                        String date = new DateTime().toString();
                        task.taskLog("[" + threadName + "-Intermission-" + date + "] Deleting: " + arrayList.size() + " files out of " + totalSize + ". Will respawn: " + shouldRespawn + "\n", new Object[0]);
                        for (LocalFileToDelete localFileToDelete : arrayList) {
                            try {
                                localFileToDelete.delete();
                            }
                            catch (Exception exception) {}
                        }
                        return null;
                    }
                }, new Atomic(){

                    public Class<? extends Annotation> annotationType() {
                        return null;
                    }

                    public boolean flattenNested() {
                        return false;
                    }

                    public Atomic.TxMode mode() {
                        return Atomic.TxMode.WRITE;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

