/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail_Base;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsTransactionDetail
extends SibsTransactionDetail_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected SibsTransactionDetail() {
    }

    protected void init(SibsReportFile sibsReport, String comments, DateTime whenProcessed, DateTime whenRegistered, BigDecimal amountPayed, String sibsEntityReferenceCode, String sibsPaymentReferenceCode, String sibsTransactionId, String debtAccountId, String customerId, String businessIdentification, String fiscalNumber, String customerName, String settlementDocumentNumber) {
        this.setSibsReport(sibsReport);
        this.setComments(comments);
        this.setWhenProcessed(whenProcessed);
        this.setWhenRegistered(whenRegistered);
        this.setAmountPayed(amountPayed);
        this.setSibsEntityReferenceCode(sibsEntityReferenceCode);
        this.setSibsPaymentReferenceCode(sibsPaymentReferenceCode);
        this.setSibsTransactionId(sibsTransactionId);
        this.setDebtAccountId(debtAccountId);
        this.setCustomerId(customerId);
        this.setBusinessIdentification(businessIdentification);
        this.setFiscalNumber(fiscalNumber);
        this.setCustomerName(customerName);
        this.setSettlementDocumentNumber(settlementDocumentNumber);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getSibsReport() == null) {
            throw new TreasuryDomainException("error.SibsTransactionDetail.sibsReport.required", new String[0]);
        }
    }

    public void edit(SibsReportFile sibsReportFile, String string, DateTime dateTime, DateTime dateTime2, BigDecimal bigDecimal, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        Object object = advice$edit.perform((Callable)new SibsTransactionDetail$callable$edit(this, sibsReportFile, string, dateTime, dateTime2, bigDecimal, string2, string3, string4, string5, string6, string7, string8, string9, string10));
    }

    static /* synthetic */ void advised$edit(SibsTransactionDetail this_, SibsReportFile sibsReport, String comments, DateTime whenProcessed, DateTime whenRegistered, BigDecimal amountPayed, String sibsEntityReferenceCode, String sibsPaymentReferenceCode, String sibsTransactionId, String debtAccountId, String customerId, String businessIdentification, String fiscalNumber, String customerName, String settlementDocumentNumber) {
        this_.setSibsReport(sibsReport);
        this_.setComments(comments);
        this_.setWhenProcessed(whenProcessed);
        this_.setWhenRegistered(whenRegistered);
        this_.setAmountPayed(amountPayed);
        this_.setSibsEntityReferenceCode(sibsEntityReferenceCode);
        this_.setSibsPaymentReferenceCode(sibsPaymentReferenceCode);
        this_.setSibsTransactionId(sibsTransactionId);
        this_.setDebtAccountId(debtAccountId);
        this_.setCustomerId(customerId);
        this_.setBusinessIdentification(businessIdentification);
        this_.setFiscalNumber(fiscalNumber);
        this_.setCustomerName(customerName);
        this_.setSettlementDocumentNumber(settlementDocumentNumber);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsTransactionDetail$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsTransactionDetail this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        super.setSibsReport(null);
        this_.deleteDomainObject();
    }

    public static SibsTransactionDetail create(SibsReportFile sibsReportFile, String string, DateTime dateTime, DateTime dateTime2, BigDecimal bigDecimal, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        return (SibsTransactionDetail)((Object)advice$create.perform((Callable)new SibsTransactionDetail$callable$create(sibsReportFile, string, dateTime, dateTime2, bigDecimal, string2, string3, string4, string5, string6, string7, string8, string9, string10)));
    }

    static /* synthetic */ SibsTransactionDetail advised$create(SibsReportFile sibsReport, String comments, DateTime whenProcessed, DateTime whenRegistered, BigDecimal amountPayed, String sibsEntityReferenceCode, String sibsPaymentReferenceCode, String sibsTransactionId, String debtAccountId, String customerId, String businessIdentification, String fiscalNumber, String customerName, String settlementDocumentNumber) {
        SibsTransactionDetail sibsTransactionDetail = new SibsTransactionDetail();
        sibsTransactionDetail.init(sibsReport, comments, whenProcessed, whenRegistered, amountPayed, sibsEntityReferenceCode, sibsPaymentReferenceCode, sibsTransactionId, debtAccountId, customerId, businessIdentification, fiscalNumber, customerName, settlementDocumentNumber);
        return sibsTransactionDetail;
    }

    public static Stream<SibsTransactionDetail> findAll() {
        ArrayList allDetails = new ArrayList();
        List reports = SibsReportFile.findAll().collect(Collectors.toList());
        for (SibsReportFile report : reports) {
            allDetails.addAll(report.getSibsTransactionsSet());
        }
        return allDetails.stream();
    }

    public static Stream<SibsTransactionDetail> findBySibsReport(SibsReportFile sibsReport) {
        return sibsReport.getSibsTransactionsSet().stream();
    }

    public static Stream<SibsTransactionDetail> findByComments(String comments) {
        return SibsTransactionDetail.findAll().filter(i -> comments.equalsIgnoreCase(i.getComments()));
    }

    public static Stream<SibsTransactionDetail> findByWhenProcessed(DateTime whenProcessed) {
        return SibsTransactionDetail.findAll().filter(i -> whenProcessed.equals((Object)i.getWhenProcessed()));
    }

    public static Stream<SibsTransactionDetail> findByWhenRegistered(DateTime whenRegistered) {
        return SibsTransactionDetail.findAll().filter(i -> whenRegistered.equals((Object)i.getWhenRegistered()));
    }

    public static Stream<SibsTransactionDetail> findByAmountPayed(BigDecimal amountPayed) {
        return SibsTransactionDetail.findAll().filter(i -> amountPayed.equals(i.getAmountPayed()));
    }

    public static Stream<SibsTransactionDetail> findBySibsEntityReferenceCode(String sibsEntityReferenceCode) {
        return SibsTransactionDetail.findAll().filter(i -> sibsEntityReferenceCode.equalsIgnoreCase(i.getSibsEntityReferenceCode()));
    }

    public static Stream<SibsTransactionDetail> findBySibsPaymentReferenceCode(String sibsPaymentReferenceCode) {
        return SibsTransactionDetail.findAll().filter(i -> sibsPaymentReferenceCode.equalsIgnoreCase(i.getSibsPaymentReferenceCode()));
    }

    public static Stream<SibsTransactionDetail> findBySibsTransactionId(String sibsTransactionId) {
        return SibsTransactionDetail.findAll().filter(i -> sibsTransactionId.equalsIgnoreCase(i.getSibsTransactionId()));
    }

    public static Stream<SibsTransactionDetail> findBySibsEntityAndReferenceCode(String sibsEntityReferenceCode, String sibsPaymentReferenceCode) {
        return SibsTransactionDetail.findBySibsEntityReferenceCode(sibsEntityReferenceCode).filter(i -> sibsPaymentReferenceCode.equalsIgnoreCase(i.getSibsPaymentReferenceCode()));
    }

    public static boolean isReferenceProcessingDuplicate(String referenceCode, String entityReferenceCode, DateTime whenRegistered) {
        return SibsTransactionDetail.findAll().anyMatch(x -> x.getSibsEntityReferenceCode().equals(entityReferenceCode) && x.getSibsPaymentReferenceCode().equals(referenceCode) && x.getWhenRegistered().equals((Object)whenRegistered));
    }
}

