/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode_Base;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FinantialDocumentPaymentCode
extends FinantialDocumentPaymentCode_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public Set<SettlementNote> processPayment(User person, BigDecimal amountToPay, DateTime whenRegistered, String sibsTransactionId, String comments) {
        Set invoiceEntriesToPay = this.getInvoiceEntries().stream().sorted((x, y) -> y.getOpenAmount().compareTo(x.getOpenAmount())).collect(Collectors.toSet());
        return this.internalProcessPayment(person, amountToPay, whenRegistered, sibsTransactionId, comments, invoiceEntriesToPay);
    }

    public boolean isFinantialDocumentPaymentCode() {
        return true;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        for (FinantialDocumentEntry entry : this.getFinantialDocument().getFinantialDocumentEntriesSet()) {
            builder.append(entry.getDescription()).append("\n");
        }
        return builder.toString();
    }

    public boolean isPaymentCodeFor(TreasuryEvent event) {
        if (this.getFinantialDocument().isDebitNote()) {
            DebitNote debitNote = (DebitNote)((Object)this.getFinantialDocument());
            return debitNote.getDebitEntries().anyMatch(x -> x.getTreasuryEvent() != null && x.getTreasuryEvent().equals((Object)event));
        }
        return false;
    }

    protected FinantialDocumentPaymentCode() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(FinantialDocument finantialDocument, PaymentReferenceCode paymentReferenceCode, Boolean valid) {
        this.setFinantialDocument(finantialDocument);
        this.setDebtAccount(finantialDocument.getDebtAccount());
        this.setPaymentReferenceCode(paymentReferenceCode);
        this.setValid(valid);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialDocument() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentPaymentCode.finantialDocument.required", new String[0]);
        }
        if (this.getPaymentReferenceCode() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentPaymentCode.paymentReferenceCode.required", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.FinantialDocumentPaymentCode.debtAccount.required", new String[0]);
        }
        long activePaymentCodesOnFinantialDocumentCount = FinantialDocumentPaymentCode.findNewByFinantialDocument(this.getFinantialDocument()).count() + FinantialDocumentPaymentCode.findUsedByFinantialDocument(this.getFinantialDocument()).count();
        if (activePaymentCodesOnFinantialDocumentCount > 1L) {
            throw new TreasuryDomainException("error.FinantialDocumentPaymentCode.finantial.with.active.payment.code", new String[0]);
        }
        for (FinantialDocumentEntry finantialDocumentEntry : this.getFinantialDocument().getFinantialDocumentEntriesSet()) {
            DebitEntry debitEntry;
            if (!(finantialDocumentEntry instanceof DebitEntry) || MultipleEntriesPaymentCode.findNewByDebitEntry(debitEntry = (DebitEntry)((Object)finantialDocumentEntry)).count() <= 0L && MultipleEntriesPaymentCode.findUsedByDebitEntry(debitEntry).count() <= 0L) continue;
            throw new TreasuryDomainException("error.FinantialDocumentPaymentCode.debit.entry.with.active.payment.code", debitEntry.getDescription());
        }
    }

    public void edit(FinantialDocument finantialDocument, PaymentReferenceCode paymentReferenceCode, Boolean bl) {
        Object object = advice$edit.perform((Callable)new FinantialDocumentPaymentCode$callable$edit(this, finantialDocument, paymentReferenceCode, bl));
    }

    static /* synthetic */ void advised$edit(FinantialDocumentPaymentCode this_, FinantialDocument finantialDocument, PaymentReferenceCode paymentReferenceCode, Boolean valid) {
        this_.setFinantialDocument(finantialDocument);
        this_.setPaymentReferenceCode(paymentReferenceCode);
        this_.setValid(valid);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new FinantialDocumentPaymentCode$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(FinantialDocumentPaymentCode this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.FinantialDocumentPaymentCode.cannot.delete", new String[0]);
        }
        this_.deleteDomainObject();
    }

    private boolean isDeletable() {
        return false;
    }

    public static FinantialDocumentPaymentCode create(FinantialDocument finantialDocument, PaymentReferenceCode paymentReferenceCode, Boolean bl) {
        return (FinantialDocumentPaymentCode)((Object)advice$create.perform((Callable)new FinantialDocumentPaymentCode$callable$create(finantialDocument, paymentReferenceCode, bl)));
    }

    static /* synthetic */ FinantialDocumentPaymentCode advised$create(FinantialDocument finantialDocument, PaymentReferenceCode paymentReferenceCode, Boolean valid) {
        FinantialDocumentPaymentCode finantialDocumentPaymentCode = new FinantialDocumentPaymentCode();
        finantialDocumentPaymentCode.init(finantialDocument, paymentReferenceCode, valid);
        paymentReferenceCode.setState(PaymentReferenceCodeStateType.USED);
        return finantialDocumentPaymentCode;
    }

    public static Stream<FinantialDocumentPaymentCode> findAll(FinantialInstitution finantialInstitution) {
        HashSet<FinantialDocumentPaymentCode> entries = new HashSet<FinantialDocumentPaymentCode>();
        for (PaymentCodePool pool : finantialInstitution.getPaymentCodePoolsSet()) {
            for (PaymentReferenceCode code : pool.getPaymentReferenceCodesSet()) {
                if (code.getTargetPayment() == null || !(code.getTargetPayment() instanceof FinantialDocumentPaymentCode)) continue;
                entries.add((FinantialDocumentPaymentCode)((Object)code.getTargetPayment()));
            }
        }
        return entries.stream();
    }

    public static Stream<FinantialDocumentPaymentCode> findByFinantialDocument(FinantialInstitution finantialInstitution, FinantialDocument finantialDocument) {
        return finantialDocument.getPaymentCodesSet().stream().filter(i -> finantialDocument.equals((Object)i.getFinantialDocument()));
    }

    public static Stream<FinantialDocumentPaymentCode> findNewByFinantialDocument(FinantialDocument finantialDocument) {
        return FinantialDocumentPaymentCode.findByFinantialDocument(finantialDocument.getDebtAccount().getFinantialInstitution(), finantialDocument).filter(p -> p.getPaymentReferenceCode().isNew());
    }

    public static Stream<FinantialDocumentPaymentCode> findUsedByFinantialDocument(FinantialDocument finantialDocument) {
        return FinantialDocumentPaymentCode.findByFinantialDocument(finantialDocument.getDebtAccount().getFinantialInstitution(), finantialDocument).filter(p -> p.getPaymentReferenceCode().isUsed());
    }

    public static Stream<FinantialDocumentPaymentCode> findByValid(FinantialInstitution finantialInstitution, Boolean valid) {
        return FinantialDocumentPaymentCode.findAll(finantialInstitution).filter(i -> valid.equals(i.getValid()));
    }

    protected DocumentNumberSeries getDocumentSeriesForPayments() {
        return this.getPaymentReferenceCode().getPaymentCodePool().getDocumentSeriesForPayments();
    }

    protected DocumentNumberSeries getDocumentSeriesInterestDebits() {
        return DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), this.getPaymentReferenceCode().getPaymentCodePool().getDocumentSeriesForPayments().getSeries());
    }

    public LocalDate getDueDate() {
        return this.getFinantialDocument().getDocumentDueDate();
    }

    protected Set<InvoiceEntry> getInvoiceEntries() {
        HashSet result = Sets.newHashSet();
        for (FinantialDocumentEntry entry : this.getFinantialDocument().getFinantialDocumentEntriesSet()) {
            if (!(entry instanceof InvoiceEntry)) continue;
            result.add((InvoiceEntry)((Object)entry));
        }
        return result;
    }

    public Set<Product> getReferencedProducts() {
        return this.getFinantialDocument().getFinantialDocumentEntriesSet().stream().map(DebitEntry.class::cast).map(d -> d.getProduct()).collect(Collectors.toSet());
    }
}

