/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import eu.europa.ec.taxud.tin.algorithm.TINValid;
import java.util.List;
import org.fenixedu.treasury.util.Constants;

public class FiscalCodeValidation {
    private static final List<String> VALIDATED_COUNTRIES = Lists.newArrayList((Object[])new String[]{"PT", "AT", "BE", "BG", "CY", "DE", "DK", "EE", "ES", "FI", "FR", "HR", "HU", "IE", "IT", "LT", "LU", "NL", "PL", "SE", "SI", "GB"});

    public static boolean isValidationAppliedToFiscalCountry(String countryCode) {
        return VALIDATED_COUNTRIES.contains(countryCode.toUpperCase());
    }

    public static boolean isValidFiscalNumber(String countryCode, String fiscalNumber) {
        if (Strings.isNullOrEmpty((String)countryCode)) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)fiscalNumber)) {
            return false;
        }
        if (!Constants.isDefaultCountry(countryCode) && "999999990".equals(fiscalNumber)) {
            return false;
        }
        if (Constants.isDefaultCountry(countryCode)) {
            boolean functionReturnValue = false;
            functionReturnValue = false;
            int i = 0;
            long checkDigit = 0L;
            if (fiscalNumber.length() == 9) {
                int numericValue = Character.getNumericValue(fiscalNumber.charAt(0));
                if (fiscalNumber.charAt(0) == '1' || fiscalNumber.charAt(0) == '2' || fiscalNumber.charAt(0) == '5' || fiscalNumber.charAt(0) == '6' || fiscalNumber.charAt(0) == '9') {
                    checkDigit = numericValue * 9;
                    for (i = 2; i <= 8; ++i) {
                        checkDigit += (long)(Character.getNumericValue(fiscalNumber.charAt(i - 1)) * (10 - i));
                    }
                    if ((checkDigit = 11L - checkDigit % 11L) >= 10L) {
                        checkDigit = 0L;
                    }
                    if (checkDigit == (long)Character.getNumericValue(fiscalNumber.charAt(8))) {
                        functionReturnValue = true;
                    }
                }
            }
            return functionReturnValue;
        }
        if (VALIDATED_COUNTRIES.contains(countryCode.toUpperCase())) {
            return TINValid.checkTIN((String)FiscalCodeValidation.translateCountry(countryCode.toUpperCase()), (String)fiscalNumber) == 0;
        }
        return true;
    }

    private static String translateCountry(String countryCode) {
        if ("GB".equals(countryCode)) {
            return "UK";
        }
        return countryCode;
    }
}

