/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.managepayments;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.TreasuryOperationLog;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentTypeEnum;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.ui.document.managepayments.PaymentReferenceCodeController$callable$createPaymentReferenceCode;
import org.fenixedu.treasury.ui.document.managepayments.PaymentReferenceCodeController$callable$deletePaymentReferenceCode;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/document/managepayments/paymentreferencecode"})
public class PaymentReferenceCodeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/managepayments/paymentreferencecode";
    private static final String _CREATEPAYMENTCODEINDEBITNOTE_URI = "/createpaymentcodeindebitnote";
    public static final String CREATEPAYMENTCODEINDEBITNOTE_URL = "/treasury/document/managepayments/paymentreferencecode/createpaymentcodeindebitnote";
    private static final String _CREATEPAYMENTCODEINDEBITNOTEPOSTBACK_URI = "/createpaymentcodeindebitnotepostback";
    public static final String CREATEPAYMENTCODEINDEBITNOTEPOSTBACK_URL = "/treasury/document/managepayments/paymentreferencecode/createpaymentcodeindebitnotepostback";
    private static final String _CREATEPAYMENTCODEINSERIES_URI = "/createpaymentcodeinseries";
    public static final String CREATEPAYMENTCODEINSERIES_URL = "/treasury/document/managepayments/paymentreferencecode/createpaymentcodeinseries";
    private static final String _CREATEPAYMENTCODEINSERIESPOSTBACK_URI = "/createpaymentcodeinseriespostback";
    public static final String CREATEPAYMENTCODEINSERIESPOSTBACK_URL = "/treasury/document/managepayments/paymentreferencecode/createpaymentcodeinseriespostback";
    public static final Advice advice$deletePaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createPaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/document/managepayments/paymentreferencecode/";
    }

    private void setPaymentReferenceCodeBean(PaymentReferenceCodeBean bean, Model model) {
        model.addAttribute("paymentReferenceCodeBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("paymentReferenceCodeBean", (Object)bean);
    }

    public void deletePaymentReferenceCode(PaymentReferenceCode paymentReferenceCode) {
        Object object = advice$deletePaymentReferenceCode.perform((Callable)new PaymentReferenceCodeController$callable$deletePaymentReferenceCode(this, paymentReferenceCode));
    }

    static /* synthetic */ void advised$deletePaymentReferenceCode(PaymentReferenceCodeController this_, PaymentReferenceCode paymentReferenceCode) {
    }

    @RequestMapping(value={"/createpaymentcodeindebitnote"}, method={RequestMethod.GET})
    public String createpaymentcodeindebitnote(@RequestParam(value="debitnote") DebitNote debitNote, Model model, RedirectAttributes redirectAttributes) {
        if (debitNote.getPaymentCodesSet().stream().anyMatch(pc -> pc.getPaymentReferenceCode().getState().isUsed())) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.paymentreferencecode.already.has.one", (String[])new String[0]), model);
            return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + debitNote.getExternalId(), model, redirectAttributes);
        }
        try {
            this.assertUserIsFrontOfficeMember(debitNote.getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            PaymentReferenceCodeBean bean = new PaymentReferenceCodeBean();
            bean.setDebitNote(debitNote);
            bean.setPaymentAmount(debitNote.getOpenAmount());
            bean.setPaymentAmountWithInterst(debitNote.getOpenAmountWithInterests());
            bean.setUsePaymentAmountWithInterests(false);
            List<PaymentCodePool> activePools = debitNote.getDebtAccount().getFinantialInstitution().getPaymentCodePoolsSet().stream().filter(x -> Boolean.TRUE.equals(x.getActive())).collect(Collectors.toList());
            bean.setPaymentCodePoolDataSource(activePools);
            bean.setBeginDate(new LocalDate());
            if (debitNote.getDocumentDueDate().isBefore((ReadablePartial)bean.getBeginDate())) {
                bean.setEndDate(new LocalDate());
            } else {
                bean.setEndDate(debitNote.getDocumentDueDate());
            }
            this.setPaymentReferenceCodeBean(bean, model);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return "treasury/document/managepayments/paymentreferencecode/createpaymentcodeindebitnote";
    }

    @RequestMapping(value={"/createpaymentcodeindebitnotepostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpaymentcodeindebitnotepostback(@RequestParam(value="bean", required=false) PaymentReferenceCodeBean bean, Model model) {
        this.setPaymentReferenceCodeBean(bean, model);
        bean.setPoolWithFixedAmount(bean.getPaymentCodePool().getIsFixedAmount());
        bean.setPoolVariableTimeWindow(bean.getPaymentCodePool().getIsVariableTimeWindow());
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/createpaymentcodeindebitnote"}, method={RequestMethod.POST})
    public String createpaymentcodeindebitnote(@RequestParam(value="bean", required=false) PaymentReferenceCodeBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(bean.getDebitNote().getDocumentNumberSeries().getSeries().getFinantialInstitution(), model);
            BigDecimal payableAmount = bean.getDebitNote().getOpenAmount();
            if (!Constants.isEqual(bean.getPaymentAmount(), payableAmount)) {
                throw new TreasuryDomainException("error.PaymentReferenceCode.error.in.payment.amount.not.consistent", new String[0]);
            }
            if (bean.isUsePaymentAmountWithInterests()) {
                payableAmount = bean.getDebitNote().getOpenAmount();
                if (!Constants.isEqual(bean.getPaymentAmountWithInterst(), payableAmount)) {
                    throw new TreasuryDomainException("error.PaymentReferenceCode.error.in.payment.amount.with.interests.not.consistent", new String[0]);
                }
            }
            PaymentReferenceCode paymentReferenceCode = this.createPaymentReferenceCode(bean, payableAmount);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.document.managepayments.success.create.reference.code.debitnote", (String[])new String[0]), model);
            model.addAttribute("paymentReferenceCode", (Object)paymentReferenceCode);
            return this.redirect("/treasury/document/manageinvoice/debitnote/read/" + bean.getDebitNote().getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        this.setPaymentReferenceCodeBean(bean, model);
        return "treasury/document/managepayments/paymentreferencecode/createpaymentcodeindebitnote";
    }

    private PaymentReferenceCode createPaymentReferenceCode(PaymentReferenceCodeBean paymentReferenceCodeBean, BigDecimal bigDecimal) {
        return (PaymentReferenceCode)((Object)advice$createPaymentReferenceCode.perform((Callable)new PaymentReferenceCodeController$callable$createPaymentReferenceCode(this, paymentReferenceCodeBean, bigDecimal)));
    }

    static /* synthetic */ PaymentReferenceCode advised$createPaymentReferenceCode(PaymentReferenceCodeController this_, PaymentReferenceCodeBean bean, BigDecimal payableAmount) {
        PaymentReferenceCode paymentReferenceCode = bean.getPaymentCodePool().getReferenceCodeGenerator().generateNewCodeFor(payableAmount, bean.getBeginDate(), bean.getEndDate(), bean.getPaymentCodePool().getIsFixedAmount());
        paymentReferenceCode.createPaymentTargetTo((FinantialDocument)((Object)bean.getDebitNote()));
        return paymentReferenceCode;
    }

    @RequestMapping(value={"/createpaymentcodeinseries"}, method={RequestMethod.GET})
    public String createpaymentcodeInSeries(@RequestParam(value="series") Series series, Model model, RedirectAttributes redirectAttributes) {
        PaymentReferenceCodeBean paymentReferenceCodeBean = new PaymentReferenceCodeBean();
        paymentReferenceCodeBean.setMinAmount(BigDecimal.valueOf(5.0));
        paymentReferenceCodeBean.setPaymentCodePoolDataSource(series.getFinantialInstitution().getPaymentCodePoolsSet().stream().filter(x -> x.getActive()).collect(Collectors.toList()));
        paymentReferenceCodeBean.setBeginDate(new LocalDate());
        paymentReferenceCodeBean.setEndDate(new LocalDate());
        this.setPaymentReferenceCodeBean(paymentReferenceCodeBean, model);
        model.addAttribute("series", (Object)series);
        return "treasury/document/managepayments/paymentreferencecode/createpaymentcodeinseries";
    }

    @RequestMapping(value={"/createpaymentcodeinseriespostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpaymentcodeinseriespostback(@RequestParam(value="bean", required=false) PaymentReferenceCodeBean bean, Model model) {
        this.setPaymentReferenceCodeBean(bean, model);
        bean.setPoolWithFixedAmount(bean.getPaymentCodePool().getIsFixedAmount());
        bean.setPoolVariableTimeWindow(bean.getPaymentCodePool().getIsVariableTimeWindow());
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/createpaymentcodeinseries"}, method={RequestMethod.POST})
    public String createpaymentcodeinseries(@RequestParam(value="series") Series series, @RequestParam(value="bean", required=false) PaymentReferenceCodeBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(series.getFinantialInstitution(), model);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Creating references for Series =>" + series.getCode() + "-" + series.getName().getContent()).append("\n");
            stringBuilder.append("Using Pool =>[" + bean.getPaymentCodePool().getEntityReferenceCode() + "] " + bean.getPaymentCodePool().getName()).append("\n");
            stringBuilder.append("Min amount =>" + series.getFinantialInstitution().getCurrency().getValueFor(bean.getMinAmount())).append("\n");
            int count = 0;
            for (DocumentNumberSeries dns : series.getDocumentNumberSeriesSet()) {
                if (!dns.getFinantialDocumentType().getType().equals((Object)FinantialDocumentTypeEnum.DEBIT_NOTE)) continue;
                for (FinantialDocument document : dns.getFinantialDocumentsSet()) {
                    if (!document.isClosed() || !document.getPaymentCodesSet().isEmpty() && !document.getPaymentCodesSet().stream().allMatch(x -> x.getPaymentReferenceCode().isAnnulled()) || !Constants.isGreaterThan(document.getOpenAmount(), bean.getMinAmount().subtract(BigDecimal.valueOf(0.01)))) continue;
                    PaymentReferenceCode newReferenceCode = bean.getPaymentCodePool().getReferenceCodeGenerator().generateNewCodeFor(document.getOpenAmount(), bean.getPaymentCodePool().getValidFrom(), bean.getPaymentCodePool().getValidTo(), bean.getPaymentCodePool().getIsFixedAmount());
                    FinantialDocumentPaymentCode code = FinantialDocumentPaymentCode.create(document, newReferenceCode, true);
                    stringBuilder.append(document.getUiDocumentNumber() + "=>" + newReferenceCode.getFormattedCode() + " ( " + series.getFinantialInstitution().getCurrency().getValueFor(document.getOpenAmount()) + " )").append("\n");
                    ++count;
                }
            }
            stringBuilder.append("\n").append("#Refs=" + count).append("\n");
            TreasuryOperationLog log = TreasuryOperationLog.create(stringBuilder.toString(), series.getExternalId(), "TREASURY_OPERATION_LOG_TYPE");
            return this.redirect("/treasury/administration/base/managetreasuryoperationlog/treasuryoperationlog/read/" + series.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        this.setPaymentReferenceCodeBean(bean, model);
        model.addAttribute("series", (Object)series);
        return "treasury/document/managepayments/paymentreferencecode/createpaymentcodeinseries";
    }
}

