/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managefixedtariff;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.FixedTariff;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.dto.FixedTariffBean;
import org.fenixedu.treasury.dto.FixedTariffInterestRateBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.base.managefixedtariff.FixedTariffController$callable$createFixedTariff;
import org.fenixedu.treasury.ui.administration.base.managefixedtariff.FixedTariffController$callable$deleteFixedTariff;
import org.fenixedu.treasury.ui.administration.base.managefixedtariff.FixedTariffController$callable$updateFixedTariff;
import org.fenixedu.treasury.ui.administration.base.manageproduct.ProductController;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=ProductController.class)
@RequestMapping(value={"/treasury/administration/base/managefixedtariff/fixedtariff"})
public class FixedTariffController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managefixedtariff/fixedtariff";
    protected static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/managefixedtariff/fixedtariff/delete/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managefixedtariff/fixedtariff/read/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/managefixedtariff/fixedtariff/create";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/treasury/administration/base/managefixedtariff/fixedtariff/createpostback";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/managefixedtariff/fixedtariff/update/";
    private static final String _UPDATEPOSTBACK_URI = "/updatepostback/";
    public static final String UPDATEPOSTBACK_URL = "/treasury/administration/base/managefixedtariff/fixedtariff/updatepostback/";
    public static final Advice advice$deleteFixedTariff = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createFixedTariff = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateFixedTariff = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/managefixedtariff/fixedtariff/";
    }

    private FixedTariffBean getFixedTariffBean(Model model) {
        return (FixedTariffBean)model.asMap().get("fixedTariffBean");
    }

    private void setFixedTariffBean(FixedTariffBean bean, Model model) {
        model.addAttribute("fixedTariffBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("fixedTariffBean", (Object)bean);
    }

    private FixedTariff getFixedTariff(Model model) {
        return (FixedTariff)((Object)model.asMap().get("fixedTariff"));
    }

    private void setFixedTariff(FixedTariff fixedTariff, Model model) {
        model.addAttribute("fixedTariff", (Object)fixedTariff);
    }

    public void deleteFixedTariff(FixedTariff fixedTariff) {
        Object object = advice$deleteFixedTariff.perform((Callable)new FixedTariffController$callable$deleteFixedTariff(this, fixedTariff));
    }

    static /* synthetic */ void advised$deleteFixedTariff(FixedTariffController this_, FixedTariff fixedTariff) {
        fixedTariff.delete();
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") FixedTariff fixedTariff, Model model, RedirectAttributes redirectAttributes) {
        String productId = fixedTariff.getProduct().getExternalId();
        this.setFixedTariff(fixedTariff, model);
        try {
            this.assertUserIsBackOfficeMember(fixedTariff.getFinantialEntity().getFinantialInstitution(), model);
            this.deleteFixedTariff(fixedTariff);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect("/treasury/administration/base/manageproduct/product/read/" + productId, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect("/treasury/administration/base/manageproduct/product/read/" + productId, model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") FixedTariff fixedTariff, Model model) {
        this.setFixedTariff(fixedTariff, model);
        return "treasury/administration/base/managefixedtariff/fixedtariff/read";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(@RequestParam(value="product", required=true) Product product, @RequestParam(value="finantialInstitution", required=true) FinantialInstitution finantialInstitution, Model model) {
        FixedTariffBean bean = new FixedTariffBean();
        bean.setProduct(product);
        bean.setFinantialEntityDataSource(finantialInstitution.getFinantialEntitiesSet().stream().collect(Collectors.toList()));
        bean.setFinantialInstitution(finantialInstitution);
        this.setFixedTariffBean(bean, model);
        return "treasury/administration/base/managefixedtariff/fixedtariff/create";
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpostback(@RequestParam(value="bean", required=false) FixedTariffBean bean, Model model) {
        this.setFixedTariffBean(bean, model);
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=false) FixedTariffBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(bean.getFinantialInstitution(), model);
            FixedTariff fixedTariff = this.createFixedTariff(bean.getAmount(), bean.getApplyInterests(), bean.getBeginDate(), bean.getDueDateCalculationType(), bean.getEndDate(), bean.getFinantialEntity(), bean.getFixedDueDate(), bean.getNumberOfDaysAfterCreationForDueDate(), bean.getInterestRate(), bean.getProduct());
            this.setFixedTariff(fixedTariff, model);
            return this.redirect(READ_URL + this.getFixedTariff(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
            this.setFixedTariffBean(bean, model);
            return "treasury/administration/base/managefixedtariff/fixedtariff/create";
        }
    }

    public FixedTariff createFixedTariff(BigDecimal bigDecimal, boolean bl, LocalDate localDate, DueDateCalculationType dueDateCalculationType, LocalDate localDate2, FinantialEntity finantialEntity, LocalDate localDate3, int n, FixedTariffInterestRateBean fixedTariffInterestRateBean, Product product) {
        return (FixedTariff)((Object)advice$createFixedTariff.perform((Callable)new FixedTariffController$callable$createFixedTariff(this, bigDecimal, bl, localDate, dueDateCalculationType, localDate2, finantialEntity, localDate3, n, fixedTariffInterestRateBean, product)));
    }

    static /* synthetic */ FixedTariff advised$createFixedTariff(FixedTariffController this_, BigDecimal amount, boolean applyInterests, LocalDate beginDate, DueDateCalculationType dueDateCalculationType, LocalDate endDate, FinantialEntity finantialEntity, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, FixedTariffInterestRateBean interestRateBean, Product product) {
        InterestRate interestRate = null;
        FixedTariff fixedTariff = FixedTariff.create(product, interestRate, finantialEntity, amount, beginDate.toDateTimeAtStartOfDay(), endDate.toDateTimeAtStartOfDay(), dueDateCalculationType, fixedDueDate, numberOfDaysAfterCreationForDueDate, false);
        if (applyInterests) {
            interestRate = InterestRate.createForTariff((Tariff)((Object)fixedTariff), interestRateBean.getInterestType(), interestRateBean.getNumberOfDaysAfterDueDate(), interestRateBean.getApplyInFirstWorkday(), interestRateBean.getMaximumDaysToApplyPenalty(), interestRateBean.getMaximumMonthsToApplyPenalty(), interestRateBean.getInterestFixedAmount(), interestRateBean.getRate());
            fixedTariff.setInterestRate(interestRate);
            fixedTariff.setApplyInterests(true);
        }
        fixedTariff.checkRules();
        return fixedTariff;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") FixedTariff fixedTariff, Model model) {
        this.setFixedTariff(fixedTariff, model);
        FixedTariffBean bean = new FixedTariffBean(fixedTariff);
        this.setFixedTariffBean(bean, model);
        return "treasury/administration/base/managefixedtariff/fixedtariff/update";
    }

    @RequestMapping(value={"/updatepostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updatepostback(@PathVariable(value="oid") FixedTariff fixedTariff, @RequestParam(value="bean", required=false) FixedTariffBean bean, Model model) {
        this.setFixedTariffBean(bean, model);
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") FixedTariff fixedTariff, @RequestParam(value="bean", required=false) FixedTariffBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setFixedTariff(fixedTariff, model);
        try {
            this.assertUserIsBackOfficeMember(bean.getFinantialInstitution(), model);
            this.updateFixedTariff(bean.getAmount(), bean.getApplyInterests(), bean.getBeginDate().toDateTimeAtStartOfDay(), bean.getDueDateCalculationType(), bean.getEndDate().toDateTimeAtStartOfDay(), bean.getFinantialEntity(), bean.getFixedDueDate(), bean.getNumberOfDaysAfterCreationForDueDate(), bean.getInterestRate(), bean.getProduct(), model);
            return this.redirect(READ_URL + this.getFixedTariff(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception tde) {
            this.setFixedTariffBean(bean, model);
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
            return "treasury/administration/base/managefixedtariff/fixedtariff/update";
        }
    }

    public void updateFixedTariff(BigDecimal bigDecimal, boolean bl, DateTime dateTime, DueDateCalculationType dueDateCalculationType, DateTime dateTime2, FinantialEntity finantialEntity, LocalDate localDate, int n, FixedTariffInterestRateBean fixedTariffInterestRateBean, Product product, Model model) {
        Object object = advice$updateFixedTariff.perform((Callable)new FixedTariffController$callable$updateFixedTariff(this, bigDecimal, bl, dateTime, dueDateCalculationType, dateTime2, finantialEntity, localDate, n, fixedTariffInterestRateBean, product, model));
    }

    static /* synthetic */ void advised$updateFixedTariff(FixedTariffController this_, BigDecimal amount, boolean applyInterests, DateTime beginDate, DueDateCalculationType dueDateCalculationType, DateTime endDate, FinantialEntity finantialEntity, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, FixedTariffInterestRateBean rateBean, Product product, Model model) {
        this_.getFixedTariff(model).edit(product, finantialEntity, amount, beginDate, endDate, dueDateCalculationType, fixedDueDate, numberOfDaysAfterCreationForDueDate, applyInterests, rateBean);
    }
}

