/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.tasks;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.ERPCustomerFieldsBean;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;

@Task(englishTitle="Export All Pending Documents to ERP Integration", readOnly=true)
public class ERPExportAllPendingDocumentsTask
extends CronTask {
    private static final int LIMIT = 5000;

    public void runTask() throws Exception {
        ExportThread e2;
        this.taskLog("Start", new Object[0]);
        try {
            e2 = new ExportThread(this, false);
            e2.start();
            e2.join();
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        try {
            e2 = new ExportThread(this, true);
            e2.start();
            e2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.taskLog("End", new Object[0]);
    }

    public static List<ERPExportOperation> exportPendingDocumentsForFinantialInstitution(ERPExportAllPendingDocumentsTask task, boolean exportSettlementNotes) {
        try {
            FinantialInstitution finantialInstitution = FinantialInstitution.findAll().findFirst().orElse(null);
            if (finantialInstitution == null) {
                return Lists.newArrayList();
            }
            ArrayList<ERPExportOperation> result = new ArrayList<ERPExportOperation>();
            if (!finantialInstitution.getErpIntegrationConfiguration().getActive()) {
                return result;
            }
            List sortedDocuments = ERPExporterManager.filterDocumentsToExport(finantialInstitution.getFinantialDocumentsPendingForExportationSet().stream()).stream().filter(x -> x.isSettlementNote() == exportSettlementNotes).collect(Collectors.toList());
            int count = 0;
            if (!sortedDocuments.isEmpty() && finantialInstitution.getErpIntegrationConfiguration().getExportOnlyRelatedDocumentsPerExport()) {
                while (!sortedDocuments.isEmpty()) {
                    ERPExportOperation exportFinantialDocumentToIntegration2;
                    ArrayList errorMessages;
                    Customer customer;
                    FinantialDocument doc = (FinantialDocument)((Object)sortedDocuments.iterator().next());
                    sortedDocuments.remove((Object)doc);
                    if (++count % 100 == 0) {
                        task.taskLog("Read %d\n", new Object[]{count});
                    }
                    if (!ERPCustomerFieldsBean.validateAddress(customer = doc.getDebtAccount().getCustomer(), errorMessages = Lists.newArrayList()) && !doc.getErpExportOperationsSet().isEmpty() || (exportFinantialDocumentToIntegration2 = ERPExporterManager.exportSingleDocument(doc)) == null) continue;
                    result.add(exportFinantialDocumentToIntegration2);
                }
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static class ExportThread
    extends Thread {
        ERPExportAllPendingDocumentsTask task;
        boolean exportSettlementNotes = false;

        public ExportThread(ERPExportAllPendingDocumentsTask task, boolean exportSettlementNotes) {
            this.task = task;
            this.exportSettlementNotes = exportSettlementNotes;
        }

        @Override
        public void run() {
            try {
                FenixFramework.getTransactionManager().withTransaction(new Callable(){

                    public Object call() throws Exception {
                        ERPExportAllPendingDocumentsTask.exportPendingDocumentsForFinantialInstitution(task, exportSettlementNotes);
                        return null;
                    }
                }, new Atomic(){

                    public Class<? extends Annotation> annotationType() {
                        return null;
                    }

                    public boolean flattenNested() {
                        return false;
                    }

                    public Atomic.TxMode mode() {
                        return Atomic.TxMode.READ;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

