/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.FixedTariff$callable$create;
import org.fenixedu.treasury.domain.tariff.FixedTariff$callable$delete;
import org.fenixedu.treasury.domain.tariff.FixedTariff$callable$edit;
import org.fenixedu.treasury.domain.tariff.FixedTariff_Base;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.dto.FixedTariffInterestRateBean;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FixedTariff
extends FixedTariff_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected FixedTariff(FinantialEntity finantialEntity, Product product, DateTime beginDate, DateTime endDate, BigDecimal amount, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        this.init(finantialEntity, product, beginDate, endDate, amount, dueDateCalculationType, fixedDueDate, numberOfDaysAfterCreationForDueDate, applyInterests, interestType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, maximumMonthsToApplyPenalty, interestFixedAmount, rate);
    }

    protected void init(FinantialEntity finantialEntity, Product product, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        throw new RuntimeException("error.FixedTariff.use.init.with.amount");
    }

    protected void init(FinantialEntity finantialEntity, Product product, DateTime beginDate, DateTime endDate, BigDecimal amount, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        super.init(finantialEntity, product, beginDate, endDate, dueDateCalculationType, fixedDueDate, numberOfDaysAfterCreationForDueDate, applyInterests, interestType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, maximumMonthsToApplyPenalty, interestFixedAmount, rate);
        this.setAmount(amount);
        this.checkRules();
    }

    protected FixedTariff() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(Product product, InterestRate interestRate, FinantialEntity finantialEntity, BigDecimal amount, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests) {
        this.setProduct(product);
        this.setInterestRate(interestRate);
        this.setFinantialEntity(finantialEntity);
        this.setAmount(amount);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setDueDateCalculationType(dueDateCalculationType);
        this.setFixedDueDate(fixedDueDate);
        this.setNumberOfDaysAfterCreationForDueDate(numberOfDaysAfterCreationForDueDate);
        this.setApplyInterests(applyInterests);
        this.checkRules();
    }

    public void checkRules() {
        super.checkRules();
        if (this.getProduct() == null) {
            throw new TreasuryDomainException("error.FixedTariff.product.required", new String[0]);
        }
        if (this.getFinantialEntity() == null) {
            throw new TreasuryDomainException("error.FixedTariff.finantialEntity.required", new String[0]);
        }
        if (this.getAmount() == null || this.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new TreasuryDomainException("error.FixedTariff.amount.invalid", new String[0]);
        }
    }

    public void edit(Product product, FinantialEntity finantialEntity, BigDecimal bigDecimal, DateTime dateTime, DateTime dateTime2, DueDateCalculationType dueDateCalculationType, LocalDate localDate, int n, boolean bl, FixedTariffInterestRateBean fixedTariffInterestRateBean) {
        Object object = advice$edit.perform((Callable)new FixedTariff$callable$edit(this, product, finantialEntity, bigDecimal, dateTime, dateTime2, dueDateCalculationType, localDate, n, bl, fixedTariffInterestRateBean));
    }

    static /* synthetic */ void advised$edit(FixedTariff this_, Product product, FinantialEntity finantialEntity, BigDecimal amount, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, FixedTariffInterestRateBean rateBean) {
        this_.setProduct(product);
        this_.setFinantialEntity(finantialEntity);
        this_.setAmount(amount);
        this_.setBeginDate(beginDate);
        this_.setEndDate(endDate);
        this_.setDueDateCalculationType(dueDateCalculationType);
        this_.setFixedDueDate(fixedDueDate);
        this_.setNumberOfDaysAfterCreationForDueDate(numberOfDaysAfterCreationForDueDate);
        this_.setApplyInterests(applyInterests);
        if (applyInterests) {
            if (this_.getInterestRate() == null) {
                InterestRate rate = InterestRate.createForTariff((Tariff)((Object)this_), rateBean.getInterestType(), rateBean.getNumberOfDaysAfterDueDate(), rateBean.getApplyInFirstWorkday(), rateBean.getMaximumDaysToApplyPenalty(), rateBean.getMaximumMonthsToApplyPenalty(), rateBean.getInterestFixedAmount(), rateBean.getRate());
                this_.setInterestRate(rate);
            } else {
                InterestRate rate = this_.getInterestRate();
                rate.setApplyInFirstWorkday(rateBean.getApplyInFirstWorkday());
                rate.setInterestFixedAmount(rateBean.getInterestFixedAmount());
                rate.setInterestType(rateBean.getInterestType());
                rate.setMaximumDaysToApplyPenalty(rateBean.getMaximumDaysToApplyPenalty());
                rate.setMaximumMonthsToApplyPenalty(rateBean.getMaximumDaysToApplyPenalty());
                rate.setNumberOfDaysAfterDueDate(rateBean.getNumberOfDaysAfterDueDate());
                rate.setRate(rateBean.getRate());
            }
        } else {
            this_.getInterestRate().delete();
        }
        this_.checkRules();
    }

    public boolean isDeletable() {
        return super.isDeletable();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new FixedTariff$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(FixedTariff this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.FixedTariff.cannot.delete", new String[0]);
        }
        super.delete();
    }

    public static FixedTariff create(Product product, InterestRate interestRate, FinantialEntity finantialEntity, BigDecimal bigDecimal, DateTime dateTime, DateTime dateTime2, DueDateCalculationType dueDateCalculationType, LocalDate localDate, int n, boolean bl) {
        return (FixedTariff)((Object)advice$create.perform((Callable)new FixedTariff$callable$create(product, interestRate, finantialEntity, bigDecimal, dateTime, dateTime2, dueDateCalculationType, localDate, n, bl)));
    }

    static /* synthetic */ FixedTariff advised$create(Product product, InterestRate interestRate, FinantialEntity finantialEntity, BigDecimal amount, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests) {
        FixedTariff fixedTariff = new FixedTariff();
        fixedTariff.init(product, interestRate, finantialEntity, amount, beginDate, endDate, dueDateCalculationType, fixedDueDate, numberOfDaysAfterCreationForDueDate, applyInterests);
        return fixedTariff;
    }

    public static Stream<FixedTariff> findAll(FinantialInstitution institution) {
        HashSet result = new HashSet();
        FenixFramework.getDomainRoot().getFinantialInstitutionsSet().forEach(x -> x.getFinantialEntitiesSet().stream().forEach(y -> result.addAll(y.getFixedTariffSet())));
        return result.stream();
    }

    public static Stream<FixedTariff> findByProduct(FinantialInstitution institution, Product product) {
        return FixedTariff.findAll(institution).filter(i -> product.equals((Object)i.getProduct()));
    }

    public static Stream<FixedTariff> findByInterestRate(FinantialInstitution institution, InterestRate InterestRate2) {
        return FixedTariff.findAll(institution).filter(i -> InterestRate2.equals((Object)i.getInterestRate()));
    }

    public static Stream<FixedTariff> findByFinantialEntity(FinantialInstitution institution, FinantialEntity finantialEntity) {
        return FixedTariff.findAll(institution).filter(i -> finantialEntity.equals((Object)i.getFinantialEntity()));
    }

    public static Stream<FixedTariff> findByAmount(FinantialInstitution institution, BigDecimal amount) {
        return FixedTariff.findAll(institution).filter(i -> amount.equals(i.getAmount()));
    }

    public static Stream<FixedTariff> findByBeginDate(FinantialInstitution institution, DateTime beginDate) {
        return FixedTariff.findAll(institution).filter(i -> beginDate.equals((Object)i.getBeginDate()));
    }

    public static Stream<FixedTariff> findByEndDate(FinantialInstitution institution, DateTime endDate) {
        return FixedTariff.findAll(institution).filter(i -> endDate.equals((Object)i.getEndDate()));
    }

    public static Stream<FixedTariff> findByDueDateCalculationType(FinantialInstitution institution, DueDateCalculationType dueDateCalculationType) {
        return FixedTariff.findAll(institution).filter(i -> dueDateCalculationType.equals((Object)i.getDueDateCalculationType()));
    }

    public static Stream<FixedTariff> findByFixedDueDate(FinantialInstitution institution, LocalDate fixedDueDate) {
        return FixedTariff.findAll(institution).filter(i -> fixedDueDate.equals((Object)i.getFixedDueDate()));
    }

    public static Stream<FixedTariff> findByNumberOfDaysAfterCreationForDueDate(FinantialInstitution institution, int numberOfDaysAfterCreationForDueDate) {
        return FixedTariff.findAll(institution).filter(i -> numberOfDaysAfterCreationForDueDate == i.getNumberOfDaysAfterCreationForDueDate());
    }

    public static Stream<FixedTariff> findByApplyInterests(FinantialInstitution institution, boolean applyInterests) {
        return FixedTariff.findAll(institution).filter(i -> applyInterests == i.getApplyInterests());
    }

    public LocalizedString getUiTariffDescription() {
        return new LocalizedString(I18N.getLocale(), this.getFinantialEntity().getFinantialInstitution().getCurrency().getValueFor(this.getAmount().setScale(3)));
    }

    public LocalDate calculateDueDate(DebitNote finantialDocument) {
        if (this.getDueDateCalculationType().equals((Object)DueDateCalculationType.DAYS_AFTER_CREATION)) {
            if (finantialDocument != null) {
                return finantialDocument.getDocumentDueDate().plusDays(this.getNumberOfDaysAfterCreationForDueDate());
            }
            return new DateTime().plusDays(this.getNumberOfDaysAfterCreationForDueDate()).toLocalDate();
        }
        if (this.getDueDateCalculationType().equals((Object)DueDateCalculationType.FIXED_DATE)) {
            return this.getFixedDueDate();
        }
        if (finantialDocument != null) {
            if (finantialDocument.getDocumentDueDate() != null) {
                return finantialDocument.getDocumentDueDate();
            }
            return finantialDocument.getDocumentDate().toLocalDate();
        }
        return new LocalDate();
    }
}

