/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationLineDTO;
import org.fenixedu.treasury.util.Constants;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;

public class SibsSpreadsheetRowReportBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_HEADERS = new String[]{Constants.treasuryBundle("label.SibsReportFile.whenProcessedBySibs", new String[0]), Constants.treasuryBundle("label.SibsReportFile.filename", new String[0]), Constants.treasuryBundle("label.SibsReportFile.transactionsTotalAmount", new String[0]), Constants.treasuryBundle("label.SibsReportFile.totalCost", new String[0]), Constants.treasuryBundle("label.SibsReportFile.fileVersion", new String[0]), Constants.treasuryBundle("label.SibsReportFile.sibsTransactionId", new String[0]), Constants.treasuryBundle("label.SibsReportFile.transactionTotalAmount", new String[0]), Constants.treasuryBundle("label.SibsReportFile.paymentCode", new String[0]), Constants.treasuryBundle("label.SibsReportFile.transactionWhenRegistered", new String[0]), Constants.treasuryBundle("label.SibsReportFile.studentNumber", new String[0]), Constants.treasuryBundle("label.SibsReportFile.personName", new String[0]), Constants.treasuryBundle("label.SibsReportFile.description", new String[0])};
    private SIBSImportationLineDTO line;

    public SibsSpreadsheetRowReportBean(SIBSImportationLineDTO line) {
        this.line = line;
    }

    @Override
    public void writeCellValues(Row row, IErrorsLog errorsLog) {
        int i = 0;
        try {
            row.createCell(i++).setCellValue(this.line.getWhenProcessedBySibs().toString("yyyy-MM-dd HH:mm:ss"));
            row.createCell(i++).setCellValue(this.line.getFilename());
            row.createCell(i++).setCellValue(this.line.getTransactionsTotalAmount().toPlainString());
            row.createCell(i++).setCellValue(this.line.getTotalCost().toPlainString());
            row.createCell(i++).setCellValue((double)this.line.getFileVersion().intValue());
            row.createCell(i++).setCellValue(this.line.getSibsTransactionId());
            row.createCell(i++).setCellValue(this.line.getTransactionTotalAmount().toPlainString());
            row.createCell(i++).setCellValue(this.line.getCode());
            row.createCell(i++).setCellValue(this.line.getTransactionWhenRegistered().toString("yyyy-MM-dd HH:mm:ss"));
            row.createCell(i++).setCellValue(this.line.getStudentNumber());
            row.createCell(i++).setCellValue(this.line.getPersonName());
            row.createCell(i++).setCellValue(this.line.getDescription());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            row.createCell(i++).setCellValue(Constants.treasuryBundle("error.SibsSpreadsheetRowReportBean.report.generation.verify.line", new String[0]));
            return;
        }
    }
}

