/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments.implementations;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.qubit.solution.fenixedu.bennu.webservices.services.client.BennuWebServiceClient;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpSession;
import javax.xml.ws.BindingProvider;
import org.apache.commons.validator.routines.EmailValidator;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineImplementation$callable$doWebPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineImplementation$callable$postProcessPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineImplementation$callable$processPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Address;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Buyer;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Details;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.DoWebPaymentRequest;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.DoWebPaymentResponse;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.GetWebPaymentDetailsRequest;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.GetWebPaymentDetailsResponse;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Order;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.OrderDetail;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.Payment;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.WebPaymentAPI;
import org.fenixedu.treasury.services.integration.forwardpayments.payline.WebPaymentAPI_Service;
import org.fenixedu.treasury.ui.document.forwardpayments.IForwardPaymentController;
import org.fenixedu.treasury.ui.document.forwardpayments.implementations.PaylineController;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaylineImplementation
extends BennuWebServiceClient<WebPaymentAPI>
implements IForwardPaymentImplementation {
    private static final int PAYLINE_MAX_PHONE_SIZE = 14;
    private static final DateTimeFormatter DATE_TIME_PATTERN;
    private static final String SECURITY_MODE = "SSL";
    private static final String PT = "PT";
    private static final String EURO_CURRENCY = "978";
    private static final String ACTION_AUTHORIZATION_AND_VALIDATION = "101";
    private static final String MODE_CPT = "CPT";
    private static final String TRANSACTION_APPROVED_CODE = "00000";
    private static final String TRANSACTION_PENDING_FORM_FILL = "02306";
    public static final String ACTION_RETURN_URL = "return";
    public static final String ACTION_CANCEL_URL = "cancel";
    public static final String LANG_PT = "pt";
    public static final String LANG_EN = "en";
    public static final Advice advice$doWebPayment;
    public static final Advice advice$processPayment;
    public static final Advice advice$postProcessPayment;

    @Override
    public String getPaymentURL(ForwardPayment forwardPayment) {
        throw new RuntimeException("not applied");
    }

    public String getReturnURL(ForwardPayment forwardPayment, String returnControllerURL) {
        return String.format("%s%s/%s/%s/%s", forwardPayment.getForwardPaymentConfiguration().getReturnURL(), returnControllerURL, forwardPayment.getExternalId(), ACTION_RETURN_URL, forwardPayment.getReturnForwardPaymentUrlChecksum());
    }

    private void saveReturnUrlChecksum(ForwardPayment forwardPayment, String returnControllerURL, HttpSession session) {
        String returnUrlToChecksum = String.format("%s%s/%s", forwardPayment.getForwardPaymentConfiguration().getReturnURL(), returnControllerURL, forwardPayment.getExternalId());
        forwardPayment.setReturnForwardPaymentUrlChecksum(GenericChecksumRewriter.calculateChecksum((String)returnUrlToChecksum, (HttpSession)session));
    }

    public String getCancelURL(ForwardPayment forwardPayment, String returnControllerURL) {
        return String.format("%s%s/%s/%s/%s", forwardPayment.getForwardPaymentConfiguration().getReturnURL(), returnControllerURL, forwardPayment.getExternalId(), ACTION_CANCEL_URL, forwardPayment.getReturnForwardPaymentUrlChecksum());
    }

    @Override
    public String getFormattedAmount(ForwardPayment forwardPayment) {
        return forwardPayment.getAmount().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_EVEN).toString();
    }

    @Override
    public IForwardPaymentController getForwardPaymentController(ForwardPayment forwardPayment) {
        return new PaylineController();
    }

    public boolean isActionReturn(String action) {
        return ACTION_RETURN_URL.equals(action);
    }

    public boolean isActionCancel(String action) {
        return ACTION_CANCEL_URL.equals(action);
    }

    public boolean doWebPayment(ForwardPayment forwardPayment, String string, HttpSession httpSession) {
        return (Boolean)advice$doWebPayment.perform((Callable)new PaylineImplementation$callable$doWebPayment(this, forwardPayment, string, httpSession));
    }

    static /* synthetic */ boolean advised$doWebPayment(PaylineImplementation this_, ForwardPayment forwardPayment, String returnControllerURL, HttpSession session) {
        boolean success;
        this_.saveReturnUrlChecksum(forwardPayment, returnControllerURL, session);
        Payment paymentDetails = new Payment();
        paymentDetails.setAmount(this_.getFormattedAmount(forwardPayment));
        paymentDetails.setCurrency(EURO_CURRENCY);
        paymentDetails.setAction(ACTION_AUTHORIZATION_AND_VALIDATION);
        paymentDetails.setMode(MODE_CPT);
        paymentDetails.setContractNumber(forwardPayment.getForwardPaymentConfiguration().getPaylineContractNumber());
        Order order = new Order();
        order.setRef(String.valueOf(forwardPayment.getOrderNumber()));
        order.setAmount(this_.getFormattedAmount(forwardPayment));
        order.setCurrency(EURO_CURRENCY);
        order.setDate(forwardPayment.getVersioningCreationDate().toString("dd/MM/yyyy HH:mm"));
        order.setCountry(PT);
        Customer customer = forwardPayment.getDebtAccount().getCustomer();
        Buyer buyerDetails = new Buyer();
        buyerDetails.setFirstName(customer.getFirstNames());
        buyerDetails.setLastName(customer.getLastNames());
        if (!Strings.isNullOrEmpty((String)customer.getEmail()) && EmailValidator.getInstance().isValid(customer.getEmail())) {
            buyerDetails.setEmail(customer.getEmail());
        }
        if (!Strings.isNullOrEmpty((String)customer.getPhoneNumber())) {
            String phone = customer.getPhoneNumber().replaceAll("[^\\d]", "");
            if (phone.length() > 14) {
                phone = phone.substring(0, 14);
            }
            buyerDetails.setMobilePhone(phone);
        }
        DoWebPaymentRequest request = new DoWebPaymentRequest();
        request.setPayment(paymentDetails);
        request.setOrder(order);
        request.setReturnURL(this_.getReturnURL(forwardPayment, returnControllerURL));
        request.setCancelURL(this_.getCancelURL(forwardPayment, returnControllerURL));
        String languageToUse = LANG_EN.equals(I18N.getLocale().getLanguage()) ? LANG_EN : LANG_PT;
        request.setLanguageCode(languageToUse);
        request.setBuyer(buyerDetails);
        request.setSecurityMode(SECURITY_MODE);
        DoWebPaymentResponse response = ((WebPaymentAPI)this_.getClient()).doWebPayment(request);
        boolean bl = success = response != null && response.getResult() != null && TRANSACTION_APPROVED_CODE.equals(response.getResult().getCode());
        if (!success) {
            forwardPayment.reject(response.getResult().getCode(), response.getResult().getLongMessage(), this_.json(request), this_.json(response));
            return false;
        }
        String code = response.getResult().getCode();
        String longMessage = response.getResult().getLongMessage();
        forwardPayment.advanceToRequestState(code, longMessage, this_.json(request), this_.json(response));
        forwardPayment.setPaylineToken(response.getToken());
        forwardPayment.setPaylineRedirectUrl(response.getRedirectURL());
        return true;
    }

    private String json(Object obj) {
        GsonBuilder builder = new GsonBuilder();
        builder.addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes arg0) {
                return false;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz == Class.class;
            }
        });
        return builder.create().toJson(obj);
    }

    public boolean processPayment(ForwardPayment forwardPayment, String string) {
        return (Boolean)advice$processPayment.perform((Callable)new PaylineImplementation$callable$processPayment(this, forwardPayment, string));
    }

    static /* synthetic */ boolean advised$processPayment(PaylineImplementation this_, ForwardPayment forwardPayment, String action) {
        if (!this_.isActionReturn(action)) {
            GetWebPaymentDetailsRequest request = new GetWebPaymentDetailsRequest();
            request.setToken(forwardPayment.getPaylineToken());
            GetWebPaymentDetailsResponse response = ((WebPaymentAPI)this_.getClient()).getWebPaymentDetails(request);
            forwardPayment.reject(response.getResult().getCode(), Constants.treasuryBundle("label.PaylineImplementation.cancelled", new String[0]) + ": " + response.getResult().getLongMessage(), this_.json(request), this_.json(response));
            return false;
        }
        GetWebPaymentDetailsRequest request = new GetWebPaymentDetailsRequest();
        request.setToken(forwardPayment.getPaylineToken());
        GetWebPaymentDetailsResponse response = ((WebPaymentAPI)this_.getClient()).getWebPaymentDetails(request);
        boolean success = TRANSACTION_APPROVED_CODE.equals(response.getResult().getCode());
        if (!success) {
            forwardPayment.reject(response.getResult().getCode(), response.getResult().getLongMessage(), this_.json(request), this_.json(response));
            return false;
        }
        String transactionId = response.getTransaction().getId();
        String authorizationNumber = response.getAuthorization().getNumber();
        DateTime transactionDate = DATE_TIME_PATTERN.parseDateTime(response.getTransaction().getDate());
        BigDecimal payedAmount = new BigDecimal(response.getPayment().getAmount()).divide(new BigDecimal("100"));
        forwardPayment.advanceToPayedState(response.getResult().getCode(), response.getResult().getLongMessage(), payedAmount, transactionDate, transactionId, authorizationNumber, this_.json(request), this_.json(response), null);
        return true;
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPayment forwardPayment) {
        GetWebPaymentDetailsRequest request = new GetWebPaymentDetailsRequest();
        request.setToken(forwardPayment.getPaylineToken());
        GetWebPaymentDetailsResponse response = ((WebPaymentAPI)this.getClient()).getWebPaymentDetails(request);
        ForwardPaymentStateType type = null;
        String authorizationNumber = null;
        DateTime authorizationDate = null;
        String transactionId = null;
        DateTime transactionDate = null;
        BigDecimal payedAmount = null;
        boolean success = TRANSACTION_APPROVED_CODE.equals(response.getResult().getCode());
        if (!success) {
            type = TRANSACTION_PENDING_FORM_FILL.equals(response.getResult().getCode()) ? ForwardPaymentStateType.REQUESTED : ForwardPaymentStateType.REJECTED;
        } else {
            authorizationNumber = response.getAuthorization().getNumber();
            if (response.getAuthorization() != null && !Strings.isNullOrEmpty((String)response.getAuthorization().getDate())) {
                authorizationDate = DATE_TIME_PATTERN.parseDateTime(response.getAuthorization().getDate());
            }
            transactionId = response.getTransaction().getId();
            if (response.getPayment() != null && !Strings.isNullOrEmpty((String)response.getPayment().getAmount())) {
                payedAmount = new BigDecimal(response.getPayment().getAmount()).divide(new BigDecimal("100"));
            }
            if (response.getPayment() != null && !Strings.isNullOrEmpty((String)response.getTransaction().getDate())) {
                transactionDate = DATE_TIME_PATTERN.parseDateTime(response.getTransaction().getDate());
            }
            type = ForwardPaymentStateType.PAYED;
        }
        ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(true, type, response.getResult().getCode(), response.getResult().getLongMessage(), this.json(request), this.json(response));
        bean.editAuthorizationDetails(authorizationNumber, authorizationDate);
        bean.editTransactionDetails(transactionId, transactionDate, payedAmount);
        return bean;
    }

    private void fillAddress(Customer customer, Buyer buyerDetails) {
        Address address = new Address();
        address.setStreet1(customer.getAddress());
        address.setZipCode(customer.getZipCode());
        address.setCountry(customer.getCountryCode());
        buyerDetails.setShippingAdress(address);
    }

    private void fillOrderDetails(ForwardPayment forwardPayment, Order order) {
        Currency currency = forwardPayment.getDebtAccount().getFinantialInstitution().getCurrency();
        Details details = new Details();
        for (DebitEntry debitEntry : forwardPayment.getDebitEntriesSet()) {
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setRef(debitEntry.getExternalId());
            orderDetail.setPrice(currency.getValueWithScale(debitEntry.getOpenAmount()).multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_EVEN).toString());
            orderDetail.setQuantity("1");
            orderDetail.setComment(debitEntry.getDescription());
            details.getDetails().add(orderDetail);
        }
        order.setDetails(details);
    }

    protected BindingProvider getService() {
        BindingProvider bindingProvider = (BindingProvider)new WebPaymentAPI_Service().getWebPaymentAPI();
        return bindingProvider;
    }

    @Override
    public String getLogosJspPage() {
        return "implementations/payline/logos.jsp";
    }

    @Override
    public String getWarningBeforeRedirectionJspPage() {
        return "implementations/payline/warning.jsp";
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPayment forwardPayment, String string) {
        return (PostProcessPaymentStatusBean)advice$postProcessPayment.perform((Callable)new PaylineImplementation$callable$postProcessPayment(this, forwardPayment, string));
    }

    static /* synthetic */ PostProcessPaymentStatusBean advised$postProcessPayment(PaylineImplementation this_, ForwardPayment forwardPayment, String justification) {
        ForwardPaymentStateType previousState = forwardPayment.getCurrentState();
        ForwardPaymentStatusBean paymentStatusBean = forwardPayment.getForwardPaymentConfiguration().implementation().paymentStatus(forwardPayment);
        if (!forwardPayment.getCurrentState().isInStateToPostProcessPayment()) {
            throw new TreasuryDomainException("error.ManageForwardPayments.forwardPayment.not.created.nor.requested", String.valueOf(forwardPayment.getOrderNumber()));
        }
        if (Strings.isNullOrEmpty((String)justification)) {
            throw new TreasuryDomainException("label.ManageForwardPayments.postProcessPayment.justification.required", new String[0]);
        }
        if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains((Object)paymentStatusBean.getStateType())) {
            return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, false);
        }
        boolean success = TRANSACTION_APPROVED_CODE.equals(paymentStatusBean.getStatusCode());
        if (!paymentStatusBean.isInvocationSuccess()) {
            throw new TreasuryDomainException("error.ManageForwardPayments.postProcessPayment.invocation.unsucessful", String.valueOf(forwardPayment.getOrderNumber()));
        }
        if (!success) {
            forwardPayment.reject(paymentStatusBean.getStatusCode(), paymentStatusBean.getStatusMessage(), paymentStatusBean.getRequestBody(), paymentStatusBean.getResponseBody());
            return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, false);
        }
        forwardPayment.advanceToPayedState(paymentStatusBean.getStatusCode(), paymentStatusBean.getStatusMessage(), paymentStatusBean.getPayedAmount(), paymentStatusBean.getTransactionDate(), paymentStatusBean.getTransactionId(), paymentStatusBean.getAuthorizationNumber(), paymentStatusBean.getRequestBody(), paymentStatusBean.getResponseBody(), justification);
        return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, true);
    }

    static {
        advice$doWebPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$postProcessPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        DATE_TIME_PATTERN = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm");
    }
}

