/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.manageexemption;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.manageexemption.TreasuryExemptionTypeController$callable$createTreasuryExemptionType;
import org.fenixedu.treasury.ui.document.manageexemption.TreasuryExemptionTypeController$callable$deleteTreasuryExemptionType;
import org.fenixedu.treasury.ui.document.manageexemption.TreasuryExemptionTypeController$callable$updateTreasuryExemptionType;
import org.fenixedu.treasury.util.Constants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.document.manageExemptionType", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/document/manageexemption/treasuryexemptiontype"})
public class TreasuryExemptionTypeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/manageexemption/treasuryexemptiontype";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/document/manageexemption/treasuryexemptiontype/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/document/manageexemption/treasuryexemptiontype/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/document/manageexemption/treasuryexemptiontype/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/document/manageexemption/treasuryexemptiontype/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/document/manageexemption/treasuryexemptiontype/delete/";
    private static final String SEARCH_VIEW_URI = "/search/view/";
    public static final String SEARCH_VIEW_URL = "/treasury/document/manageexemption/treasuryexemptiontype/search/view/";
    public static final Advice advice$deleteTreasuryExemptionType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createTreasuryExemptionType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateTreasuryExemptionType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/document/manageexemption/treasuryexemptiontype/";
    }

    private TreasuryExemptionType getTreasuryExemptionType(Model model) {
        return (TreasuryExemptionType)((Object)model.asMap().get("treasuryExemptionType"));
    }

    private void setTreasuryExemptionType(TreasuryExemptionType treasuryExemptionType, Model model) {
        model.addAttribute("treasuryExemptionType", (Object)treasuryExemptionType);
    }

    public void deleteTreasuryExemptionType(TreasuryExemptionType treasuryExemptionType) {
        Object object = advice$deleteTreasuryExemptionType.perform((Callable)new TreasuryExemptionTypeController$callable$deleteTreasuryExemptionType(this, treasuryExemptionType));
    }

    static /* synthetic */ void advised$deleteTreasuryExemptionType(TreasuryExemptionTypeController this_, TreasuryExemptionType treasuryExemptionType) {
        treasuryExemptionType.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="discountrate", required=false) BigDecimal discountRate, Model model) {
        List<TreasuryExemptionType> searchtreasuryexemptiontypeResultsDataSet = this.filterSearchTreasuryExemptionType(code, name, discountRate);
        model.addAttribute("searchtreasuryexemptiontypeResultsDataSet", searchtreasuryexemptiontypeResultsDataSet);
        return "treasury/document/manageexemption/treasuryexemptiontype/search";
    }

    private List<TreasuryExemptionType> getSearchUniverseSearchtreasuryExemptionTypeDataSet() {
        return TreasuryExemptionType.findAll().collect(Collectors.toList());
    }

    private List<TreasuryExemptionType> filterSearchTreasuryExemptionType(String code, LocalizedString name, BigDecimal discountRate) {
        return this.getSearchUniverseSearchtreasuryExemptionTypeDataSet().stream().filter(treasuryExemptionType -> code == null || code.length() == 0 || treasuryExemptionType.getCode() != null && treasuryExemptionType.getCode().length() > 0 && treasuryExemptionType.getCode().toLowerCase().contains(code.toLowerCase())).filter(treasuryExemptionType -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> treasuryExemptionType.getName().getContent(locale) != null && treasuryExemptionType.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).filter(treasuryExemptionType -> discountRate == null || discountRate.equals(treasuryExemptionType.getDefaultExemptionPercentage())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") TreasuryExemptionType treasuryExemptionType, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + treasuryExemptionType.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") TreasuryExemptionType treasuryExemptionType, Model model) {
        this.setTreasuryExemptionType(treasuryExemptionType, model);
        return "treasury/document/manageexemption/treasuryexemptiontype/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") TreasuryExemptionType treasuryExemptionType, Model model, RedirectAttributes redirectAttributes) {
        this.setTreasuryExemptionType(treasuryExemptionType, model);
        try {
            this.assertUserIsFrontOfficeMember(model);
            this.deleteTreasuryExemptionType(treasuryExemptionType);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getTreasuryExemptionType(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/document/manageexemption/treasuryexemptiontype/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="defaultexemptionpercentage", required=false) BigDecimal defaultExemptionPercentage, Model model, RedirectAttributes redirectAttributes) {
        try {
            TreasuryExemptionType treasuryExemptionType = TreasuryExemptionType.create(code, name, defaultExemptionPercentage, true);
            model.addAttribute("treasuryExemptionType", (Object)treasuryExemptionType);
            return this.redirect(READ_URL + this.getTreasuryExemptionType(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public TreasuryExemptionType createTreasuryExemptionType(String string, LocalizedString localizedString, BigDecimal bigDecimal) {
        return (TreasuryExemptionType)((Object)advice$createTreasuryExemptionType.perform((Callable)new TreasuryExemptionTypeController$callable$createTreasuryExemptionType(this, string, localizedString, bigDecimal)));
    }

    static /* synthetic */ TreasuryExemptionType advised$createTreasuryExemptionType(TreasuryExemptionTypeController this_, String code, LocalizedString name, BigDecimal discountRate) {
        TreasuryExemptionType treasuryExemptionType = TreasuryExemptionType.create(code, name, discountRate, true);
        return treasuryExemptionType;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") TreasuryExemptionType treasuryExemptionType, Model model) {
        this.setTreasuryExemptionType(treasuryExemptionType, model);
        return "treasury/document/manageexemption/treasuryexemptiontype/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") TreasuryExemptionType treasuryExemptionType, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="defaultexemptionpercentage", required=false) BigDecimal defaultExemptionPercentage, Model model, RedirectAttributes redirectAttributes) {
        this.setTreasuryExemptionType(treasuryExemptionType, model);
        try {
            this.getTreasuryExemptionType(model).edit(code, name, defaultExemptionPercentage, true);
            return this.redirect(READ_URL + this.getTreasuryExemptionType(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(treasuryExemptionType, model);
    }

    public void updateTreasuryExemptionType(String string, LocalizedString localizedString, BigDecimal bigDecimal, Model model) {
        Object object = advice$updateTreasuryExemptionType.perform((Callable)new TreasuryExemptionTypeController$callable$updateTreasuryExemptionType(this, string, localizedString, bigDecimal, model));
    }

    static /* synthetic */ void advised$updateTreasuryExemptionType(TreasuryExemptionTypeController this_, String code, LocalizedString name, BigDecimal discountRate, Model m) {
        this_.getTreasuryExemptionType(m).edit(code, name, discountRate, true);
    }
}

