/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.forwardpayments.implementations;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PaylineImplementation;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.forwardpayments.IForwardPaymentController;
import org.fenixedu.treasury.ui.document.forwardpayments.implementations.PaylineController$callable$rejectPayment;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.paylineReturnForwardPayment", accessGroup="logged")
@RequestMapping(value={"/treasury/document/forwardpayments/payline"})
public class PaylineController
extends TreasuryBaseController
implements IForwardPaymentController {
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/payline";
    private static final String JSP_PATH = "/treasury/document/forwardpayments/forwardpayment/implementations/payline";
    private static final String RETURN_FORWARD_PAYMENT_URI = "/returnforwardpayment";
    public static final String RETURN_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/payline/returnforwardpayment";
    public static final Advice advice$rejectPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @Override
    public String processforwardpayment(ForwardPayment forwardPayment, Model model, HttpServletResponse response, HttpSession session) {
        try {
            PaylineImplementation paylineImplementation = (PaylineImplementation)forwardPayment.getForwardPaymentConfiguration().implementation();
            boolean paylineSucess = paylineImplementation.doWebPayment(forwardPayment, this.readReturnForwardPaymentUrl(), session);
            if (!paylineSucess) {
                return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
            }
            return "redirect:" + forwardPayment.getPaylineRedirectUrl();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.rejectPayment(forwardPayment, e.getMessage(), e.getLocalizedMessage());
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
    }

    protected String readReturnForwardPaymentUrl() {
        return RETURN_FORWARD_PAYMENT_URL;
    }

    @RequestMapping(value={"/returnforwardpayment/{forwardPaymentId}/{action}/{urlChecksum}"}, method={RequestMethod.GET})
    public String returnforwardpayment(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, @PathVariable(value="action") String action, @PathVariable(value="urlChecksum") String urlChecksum, @RequestParam Map<String, String> responseData, Model model, HttpServletResponse response) {
        try {
            if (Strings.isNullOrEmpty((String)urlChecksum) || !forwardPayment.getReturnForwardPaymentUrlChecksum().equals(urlChecksum)) {
                this.rejectPayment(forwardPayment, "INVALID_CHECKSUM", "Invalid checksum");
                return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
            }
            PaylineImplementation paylineImplementation = (PaylineImplementation)forwardPayment.getForwardPaymentConfiguration().implementation();
            boolean success = paylineImplementation.processPayment(forwardPayment, action);
            if (success) {
                return String.format("redirect:%s", forwardPayment.getForwardPaymentSuccessUrl());
            }
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void rejectPayment(ForwardPayment forwardPayment, String string, String string2) {
        Object object = advice$rejectPayment.perform((Callable)new PaylineController$callable$rejectPayment(this, forwardPayment, string, string2));
    }

    static /* synthetic */ void advised$rejectPayment(PaylineController this_, ForwardPayment forwardPayment, String code, String message) {
        forwardPayment.reject(code, message, "", "");
    }

    private String jspPage(String page) {
        return "/treasury/document/forwardpayments/forwardpayment/implementations/payline/" + page;
    }
}

