/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.forwardpayments;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.ReportGenerationException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.services.reports.DocumentPrinter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.ui.document.forwardpayments.ForwardPaymentController$callable$processForwardPaymentCreation;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/document/forwardpayments/forwardpayment"})
public class ForwardPaymentController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/forwardpayment";
    private static final String JSP_PATH = "/treasury/document/forwardpayments/forwardpayment";
    private static final String CHOOSE_INVOICE_ENTRIES_URI = "/chooseInvoiceEntries/";
    public static final String CHOOSE_INVOICE_ENTRIES_URL = "/treasury/document/forwardpayments/forwardpayment/chooseInvoiceEntries/";
    private static final String SUMMARY_URI = "/summary/";
    public static final String SUMMARY_URL = "/treasury/document/forwardpayments/forwardpayment/summary/";
    private static final String PROCESS_FORWARD_PAYMENT_URI = "/processforwardpayment";
    public static final String PROCESS_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/forwardpayment/processforwardpayment";
    private static final String FORWARD_PAYMENT_SUCCESS_URI = "/forwardpaymentsuccess";
    public static final String FORWARD_PAYMENT_SUCCESS_URL = "/treasury/document/forwardpayments/forwardpayment/forwardpaymentsuccess";
    private static final String FORWARD_PAYMENT_INSUCCESS_URI = "/forwardpaymentinsuccess";
    public static final String FORWARD_PAYMENT_INSUCCESS_URL = "/treasury/document/forwardpayments/forwardpayment/forwardpaymentinsuccess";
    private static final String PRINT_SETTLEMENT_NOTE_URI = "/printsettlementnote";
    public static final String PRINT_SETTLEMENT_NOTE_URL = "/treasury/document/forwardpayments/forwardpayment/printsettlementnote";
    public static final Advice advice$processForwardPaymentCreation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private void setSettlementNoteBean(SettlementNoteBean bean, Model model) {
        IForwardPaymentImplementation implementation = ForwardPaymentConfiguration.find(bean.getDebtAccount().getFinantialInstitution()).get().implementation();
        model.addAttribute("settlementNoteBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("settlementNoteBean", (Object)bean);
        model.addAttribute("logosPage", (Object)implementation.getLogosJspPage());
        model.addAttribute("warningBeforeRedirectionPage", (Object)implementation.getWarningBeforeRedirectionJspPage());
        model.addAttribute("localeCode", (Object)I18N.getLocale().getLanguage());
        model.addAttribute("chooseInvoiceEntriesUrl", (Object)this.readChooseInvoiceEntriesUrl());
        model.addAttribute("summaryUrl", (Object)this.readSummaryUrl());
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl());
    }

    protected String readChooseInvoiceEntriesUrl() {
        return CHOOSE_INVOICE_ENTRIES_URL;
    }

    protected void checkPermissions(DebtAccount debtAccount, Model model) {
        this.assertUserIsAllowToModifySettlements(debtAccount.getFinantialInstitution(), model);
    }

    @RequestMapping(value={"/chooseInvoiceEntries/{debtAccountId}"}, method={RequestMethod.GET})
    public String chooseInvoiceEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) SettlementNoteBean bean, Model model) {
        this.checkPermissions(debtAccount, model);
        if (bean == null) {
            bean = new SettlementNoteBean(debtAccount, false, true);
        }
        this.setSettlementNoteBean(bean, model);
        return this.jspPage("chooseInvoiceEntries");
    }

    @RequestMapping(value={"/chooseInvoiceEntries/"}, method={RequestMethod.POST})
    public String chooseInvoiceEntries(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model) {
        int n;
        BigDecimal debitSum = BigDecimal.ZERO;
        BigDecimal creditSum = BigDecimal.ZERO;
        boolean error = false;
        this.checkPermissions(bean.getDebtAccount(), model);
        for (int i = 0; i < bean.getDebitEntries().size(); ++i) {
            SettlementNoteBean.DebitEntryBean debitEntryBean = bean.getDebitEntries().get(i);
            if (debitEntryBean.isIncluded()) {
                if (debitEntryBean.getDebtAmountWithVat().compareTo(BigDecimal.ZERO) == 0) {
                    debitEntryBean.setNotValid(true);
                    error = true;
                    this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.DebitEntry.debtAmount.equal.zero", (String[])new String[]{Integer.toString(i + 1)}), model);
                } else if (debitEntryBean.getDebtAmountWithVat().compareTo(debitEntryBean.getDebitEntry().getOpenAmount()) > 0) {
                    debitEntryBean.setNotValid(true);
                    error = true;
                    this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.DebitEntry.exceeded.openAmount", (String[])new String[]{Integer.toString(i + 1)}), model);
                } else {
                    debitEntryBean.setNotValid(false);
                }
                debitSum = debitSum.add(debitEntryBean.getDebtAmountWithVat());
                continue;
            }
            debitEntryBean.setNotValid(false);
        }
        for (SettlementNoteBean.CreditEntryBean creditEntryBean : bean.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            creditSum = creditSum.add(creditEntryBean.getCreditAmountWithVat());
        }
        if (bean.isReimbursementNote() && creditSum.compareTo(debitSum) < 0) {
            error = true;
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.SettlementNote.positive.payment.value", (String[])new String[0]), model);
        }
        if (!bean.isReimbursementNote() && creditSum.compareTo(debitSum) > 0) {
            error = true;
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.SettlementNote.negative.payment.value", (String[])new String[0]), model);
        }
        if (bean.isReimbursementNote() && creditSum.compareTo(BigDecimal.ZERO) == 0) {
            error = true;
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.CreditEntry.no.creditEntries.selected", (String[])new String[0]), model);
        }
        if (!bean.isReimbursementNote() && debitSum.compareTo(BigDecimal.ZERO) == 0) {
            error = true;
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.DebiEntry.no.debitEntries.selected", (String[])new String[0]), model);
        }
        if (bean.getDate().isAfter((ReadablePartial)new LocalDate())) {
            error = true;
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.SettlementNote.date.is.after", (String[])new String[0]), model);
        }
        if (error) {
            this.setSettlementNoteBean(bean, model);
            return this.jspPage("chooseInvoiceEntries");
        }
        bean.setInterestEntries(new ArrayList<SettlementNoteBean.InterestEntryBean>());
        ArrayList debitEntriesToIterate = Lists.newArrayList(bean.getDebitEntries());
        for (SettlementNoteBean.DebitEntryBean debitEntryBean : debitEntriesToIterate) {
            Object debitInterest;
            if (!debitEntryBean.isIncluded() || !Constants.isEqual(debitEntryBean.getDebitEntry().getOpenAmount(), debitEntryBean.getDebtAmount()) || ((InterestRateBean)(debitInterest = debitEntryBean.getDebitEntry().calculateUndebitedInterestValue(bean.getDate()))).getInterestAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            SettlementNoteBean.InterestEntryBean interestEntryBean = new SettlementNoteBean.InterestEntryBean(debitEntryBean.getDebitEntry(), (InterestRateBean)debitInterest);
            bean.getInterestEntries().add(interestEntryBean);
            interestEntryBean.setIncluded(true);
        }
        for (SettlementNoteBean.DebitEntryBean debitEntryBean : debitEntriesToIterate) {
            if (!debitEntryBean.isIncluded() || !Constants.isEqual(debitEntryBean.getDebitEntry().getOpenAmount(), debitEntryBean.getDebtAmount())) continue;
            for (DebitEntry interestDebitEntry : debitEntryBean.getDebitEntry().getInterestDebitEntriesSet()) {
                if (!interestDebitEntry.isInDebt()) continue;
                SettlementNoteBean settlementNoteBean = bean;
                settlementNoteBean.getClass();
                SettlementNoteBean.DebitEntryBean interestDebitEntryBean = settlementNoteBean.new SettlementNoteBean.DebitEntryBean(interestDebitEntry);
                interestDebitEntryBean.setIncluded(true);
                debitEntryBean.setDebtAmount(interestDebitEntry.getOpenAmount());
                bean.getDebitEntries().add(interestDebitEntryBean);
            }
        }
        this.setSettlementNoteBean(bean, model);
        boolean bl = false;
        for (int i = 0; i < bean.getDebitEntries().size(); ++i) {
            SettlementNoteBean.DebitEntryBean debitEntryBean = bean.getDebitEntries().get(i);
            if (!debitEntryBean.isIncluded()) continue;
            n |= this.hasForwardPaymentInStateOfPostPaymentAndPayedOnPlatform(debitEntryBean.getDebitEntry());
        }
        model.addAttribute("paymentInStateOfPostPaymentAndPayedOnPlatformWarningMessage", (Object)(n != 0));
        return this.jspPage("summary");
    }

    private boolean hasForwardPaymentInStateOfPostPaymentAndPayedOnPlatform(DebitEntry debitEntry) {
        for (ForwardPayment forwardPayment : debitEntry.getForwardPaymentsSet()) {
            IForwardPaymentImplementation implementation;
            ForwardPaymentStatusBean paymentStatusBean;
            if (!forwardPayment.getCurrentState().isInStateToPostProcessPayment() || !(paymentStatusBean = (implementation = forwardPayment.getForwardPaymentConfiguration().implementation()).paymentStatus(forwardPayment)).isInPayedState()) continue;
            return true;
        }
        return false;
    }

    protected String readSummaryUrl() {
        return SUMMARY_URL;
    }

    @RequestMapping(value={"/summary/"}, method={RequestMethod.POST})
    public String summary(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.checkPermissions(bean.getDebtAccount(), model);
            ForwardPayment forwardPayment = this.processForwardPaymentCreation(bean);
            return this.redirect(this.readProcessForwardPaymentUrl() + "/" + forwardPayment.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
            this.setSettlementNoteBean(bean, model);
            return this.jspPage("summary");
        }
    }

    public String readProcessForwardPaymentUrl() {
        return PROCESS_FORWARD_PAYMENT_URL;
    }

    @RequestMapping(value={"/processforwardpayment/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String processforwardpayment(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, Model model, HttpServletResponse response, HttpSession session) {
        return forwardPayment.getForwardPaymentConfiguration().getForwardPaymentController(forwardPayment).processforwardpayment(forwardPayment, model, response, session);
    }

    private ForwardPayment processForwardPaymentCreation(SettlementNoteBean settlementNoteBean) {
        return (ForwardPayment)((Object)advice$processForwardPaymentCreation.perform((Callable)new ForwardPaymentController$callable$processForwardPaymentCreation(this, settlementNoteBean)));
    }

    static /* synthetic */ ForwardPayment advised$processForwardPaymentCreation(ForwardPaymentController this_, SettlementNoteBean bean) {
        DebtAccount debtAccount = bean.getDebtAccount();
        ForwardPaymentConfiguration forwardPaymentConfiguration = (ForwardPaymentConfiguration)((Object)bean.getDebtAccount().getFinantialInstitution().getForwardPaymentConfigurationsSet().iterator().next());
        HashSet debitEntriesToPay = Sets.newHashSet();
        for (SettlementNoteBean.DebitEntryBean debitEntryBean : bean.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            debitEntriesToPay.add(debitEntryBean.getDebitEntry());
        }
        ForwardPayment forwardPayment = ForwardPayment.create(forwardPaymentConfiguration, debtAccount, debitEntriesToPay);
        forwardPayment.setForwardPaymentSuccessUrl(this_.forwardPaymentSuccessUrl(forwardPayment));
        forwardPayment.setForwardPaymentInsuccessUrl(this_.forwardPaymentInsuccessUrl(forwardPayment));
        return forwardPayment;
    }

    protected String forwardPaymentInsuccessUrl(ForwardPayment forwardPayment) {
        return "/treasury/document/forwardpayments/forwardpayment/forwardpaymentinsuccess/" + forwardPayment.getExternalId();
    }

    protected String forwardPaymentSuccessUrl(ForwardPayment forwardPayment) {
        return "/treasury/document/forwardpayments/forwardpayment/forwardpaymentsuccess/" + forwardPayment.getExternalId();
    }

    @RequestMapping(value={"/forwardpaymentsuccess/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String forwardpaymentsuccess(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, Model model) {
        model.addAttribute("forwardPayment", (Object)forwardPayment);
        model.addAttribute("settlementNote", (Object)forwardPayment.getSettlementNote());
        model.addAttribute("logosPage", (Object)forwardPayment.getForwardPaymentConfiguration().implementation().getLogosJspPage());
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl());
        model.addAttribute("printSettlementNoteUrl", (Object)this.readPrintSettlementNoteUrl());
        return this.jspPage("paymentSuccess");
    }

    @RequestMapping(value={"/forwardpaymentinsuccess/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String forwardpaymentinsuccess(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, Model model) {
        model.addAttribute("forwardPayment", (Object)forwardPayment);
        model.addAttribute("logosPage", (Object)forwardPayment.getForwardPaymentConfiguration().implementation().getLogosJspPage());
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl());
        return this.jspPage("paymentInsuccess");
    }

    protected String readPrintSettlementNoteUrl() {
        return PRINT_SETTLEMENT_NOTE_URL;
    }

    protected String readDebtAccountUrl() {
        return "/treasury/accounting/managecustomer/debtaccount/read/";
    }

    @RequestMapping(value={"/printsettlementnote/{forwardPaymentId}"}, produces={"application/pdf"})
    @ResponseBody
    public Object printsettlementnote(@PathVariable(value="forwardPaymentId") ForwardPayment forwardPayment, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (!forwardPayment.isInPayedState()) {
                throw new TreasuryDomainException("error.ForwardPayment.print.not.possible.not.in.payed.state", new String[0]);
            }
            byte[] report = DocumentPrinter.printFinantialDocument((FinantialDocument)((Object)forwardPayment.getSettlementNote()), "application/pdf");
            return new ResponseEntity((Object)report, HttpStatus.OK);
        }
        catch (ReportGenerationException rex) {
            this.addErrorMessage(rex.getLocalizedMessage(), model);
            this.addErrorMessage(rex.getCause().getLocalizedMessage(), model);
            return this.redirect(this.readDebtAccountUrl() + forwardPayment.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(this.readDebtAccountUrl() + forwardPayment.getExternalId(), model, redirectAttributes);
        }
    }

    private String jspPage(String page) {
        return "/treasury/document/forwardpayments/forwardpayment/" + page;
    }
}

