/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managepaymentmethod;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.managepaymentmethod.PaymentMethodController$callable$createPaymentMethod;
import org.fenixedu.treasury.ui.administration.base.managepaymentmethod.PaymentMethodController$callable$deletePaymentMethod;
import org.fenixedu.treasury.ui.administration.base.managepaymentmethod.PaymentMethodController$callable$updatePaymentMethod;
import org.fenixedu.treasury.util.Constants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.managePaymentMethod", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/managepaymentmethod/paymentmethod"})
public class PaymentMethodController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managepaymentmethod/paymentmethod";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/managepaymentmethod/paymentmethod/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/managepaymentmethod/paymentmethod/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/managepaymentmethod/paymentmethod/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managepaymentmethod/paymentmethod/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/managepaymentmethod/paymentmethod/delete/";
    private static final String SEARCH_VIEW_URI = "/search/view/";
    public static final String SEARCH_VIEW_URL = "/treasury/administration/base/managepaymentmethod/paymentmethod/search/view/";
    public static final Advice advice$deletePaymentMethod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createPaymentMethod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updatePaymentMethod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/managepaymentmethod/paymentmethod/";
    }

    private PaymentMethod getPaymentMethod(Model m) {
        return (PaymentMethod)((Object)m.asMap().get("paymentMethod"));
    }

    private void setPaymentMethod(PaymentMethod paymentMethod, Model m) {
        m.addAttribute("paymentMethod", (Object)paymentMethod);
    }

    public void deletePaymentMethod(PaymentMethod paymentMethod) {
        Object object = advice$deletePaymentMethod.perform((Callable)new PaymentMethodController$callable$deletePaymentMethod(this, paymentMethod));
    }

    static /* synthetic */ void advised$deletePaymentMethod(PaymentMethodController this_, PaymentMethod paymentMethod) {
        paymentMethod.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model) {
        List<PaymentMethod> searchpaymentmethodResultsDataSet = this.filterSearchPaymentMethod(code, name);
        model.addAttribute("searchpaymentmethodResultsDataSet", searchpaymentmethodResultsDataSet);
        return "treasury/administration/base/managepaymentmethod/paymentmethod/search";
    }

    private Stream<PaymentMethod> getSearchUniverseSearchPaymentMethodDataSet() {
        return PaymentMethod.findAll();
    }

    private List<PaymentMethod> filterSearchPaymentMethod(String code, LocalizedString name) {
        return this.getSearchUniverseSearchPaymentMethodDataSet().filter(paymentMethod -> code == null || code.length() == 0 || paymentMethod.getCode() != null && paymentMethod.getCode().length() > 0 && paymentMethod.getCode().toLowerCase().contains(code.toLowerCase())).filter(paymentMethod -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> paymentMethod.getName().getContent(locale) != null && paymentMethod.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") PaymentMethod paymentMethod, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + paymentMethod.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") PaymentMethod paymentMethod, Model model) {
        this.setPaymentMethod(paymentMethod, model);
        return "treasury/administration/base/managepaymentmethod/paymentmethod/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") PaymentMethod paymentMethod, Model model, RedirectAttributes redirectAttributes) {
        this.setPaymentMethod(paymentMethod, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deletePaymentMethod(paymentMethod);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getPaymentMethod(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/base/managepaymentmethod/paymentmethod/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="availableForPaymentInApplication") boolean availableForPaymentInApplication, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            PaymentMethod paymentMethod = this.createPaymentMethod(code, name, availableForPaymentInApplication);
            model.addAttribute("paymentMethod", (Object)paymentMethod);
            return this.redirect(READ_URL + this.getPaymentMethod(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public PaymentMethod createPaymentMethod(String string, LocalizedString localizedString, boolean bl) {
        return (PaymentMethod)((Object)advice$createPaymentMethod.perform((Callable)new PaymentMethodController$callable$createPaymentMethod(this, string, localizedString, bl)));
    }

    static /* synthetic */ PaymentMethod advised$createPaymentMethod(PaymentMethodController this_, String code, LocalizedString name, boolean availableForPaymentInApplication) {
        PaymentMethod paymentMethod = PaymentMethod.create(code, name, availableForPaymentInApplication);
        return paymentMethod;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") PaymentMethod paymentMethod, Model model) {
        this.setPaymentMethod(paymentMethod, model);
        return "treasury/administration/base/managepaymentmethod/paymentmethod/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") PaymentMethod paymentMethod, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="availableForPaymentInApplication") boolean availableForPaymentInApplication, Model model, RedirectAttributes redirectAttributes) {
        this.setPaymentMethod(paymentMethod, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updatePaymentMethod(code, name, availableForPaymentInApplication, model);
            return this.redirect(READ_URL + this.getPaymentMethod(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(paymentMethod, model);
    }

    public void updatePaymentMethod(String string, LocalizedString localizedString, boolean bl, Model model) {
        Object object = advice$updatePaymentMethod.perform((Callable)new PaymentMethodController$callable$updatePaymentMethod(this, string, localizedString, bl, model));
    }

    static /* synthetic */ void advised$updatePaymentMethod(PaymentMethodController this_, String code, LocalizedString name, boolean availableForPaymentInApplication, Model m) {
        this_.getPaymentMethod(m).edit(code, name, availableForPaymentInApplication);
    }
}

